/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.security;

import java.net.PasswordAuthentication;
import java.net.URL;
import java.security.KeyStore;
import java.security.cert.Certificate;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;
import org.gudy.azureus2.core3.security.SECertificateListener;
import org.gudy.azureus2.core3.security.SEKeyDetails;
import org.gudy.azureus2.core3.security.SEPasswordListener;
import org.gudy.azureus2.core3.security.impl.SESecurityManagerImpl;

public class SESecurityManager {
    public static final String SSL_CERTS = ".certs";
    public static final String SSL_KEYS = ".keystore";
    public static final String SSL_PASSWORD = "changeit";
    public static final String DEFAULT_ALIAS = "Azureus";

    public static void initialise() {
        SESecurityManagerImpl.getSingleton().initialise();
    }

    public static void exitVM(int n) {
        SESecurityManagerImpl.getSingleton().exitVM(n);
    }

    public static void stopThread(Thread thread) {
        SESecurityManagerImpl.getSingleton().stopThread(thread);
    }

    public static void installAuthenticator() {
        SESecurityManagerImpl.getSingleton().installAuthenticator();
    }

    public static String getKeystoreName() {
        return SESecurityManagerImpl.getSingleton().getKeystoreName();
    }

    public static String getKeystorePassword() {
        return SESecurityManagerImpl.getSingleton().getKeystorePassword();
    }

    public static SSLServerSocketFactory getSSLServerSocketFactory() throws Exception {
        return SESecurityManagerImpl.getSingleton().getSSLServerSocketFactory();
    }

    public static SSLSocketFactory getSSLSocketFactory() {
        return SESecurityManagerImpl.getSingleton().getSSLSocketFactory();
    }

    public static SSLSocketFactory installServerCertificates(URL uRL) {
        return SESecurityManagerImpl.getSingleton().installServerCertificates(uRL);
    }

    public static SSLSocketFactory installServerCertificates(String string, String string2, int n) {
        return SESecurityManagerImpl.getSingleton().installServerCertificates(string, string2, n);
    }

    public static Certificate createSelfSignedCertificate(String string, String string2, int n) throws Exception {
        return SESecurityManagerImpl.getSingleton().createSelfSignedCertificate(string, string2, n);
    }

    public static SEKeyDetails getKeyDetails(String string) throws Exception {
        return SESecurityManagerImpl.getSingleton().getKeyDetails(string);
    }

    public static KeyStore getKeyStore() throws Exception {
        return SESecurityManagerImpl.getSingleton().getKeyStore();
    }

    public static KeyStore getTrustStore() throws Exception {
        return SESecurityManagerImpl.getSingleton().getTrustStore();
    }

    public static PasswordAuthentication getPasswordAuthentication(String string, URL uRL) {
        return SESecurityManagerImpl.getSingleton().getPasswordAuthentication(string, uRL);
    }

    public static void setPasswordAuthenticationOutcome(String string, URL uRL, boolean bl) {
        SESecurityManagerImpl.getSingleton().setPasswordAuthenticationOutcome(string, uRL, bl);
    }

    public static void addPasswordListener(SEPasswordListener sEPasswordListener) {
        SESecurityManagerImpl.getSingleton().addPasswordListener(sEPasswordListener);
    }

    public static void removePasswordListener(SEPasswordListener sEPasswordListener) {
        SESecurityManagerImpl.getSingleton().removePasswordListener(sEPasswordListener);
    }

    public static void clearPasswords() {
        SESecurityManagerImpl.getSingleton().clearPasswords();
    }

    public static void setThreadPasswordHandler(SEPasswordListener sEPasswordListener) {
        SESecurityManagerImpl.getSingleton().setThreadPasswordHandler(sEPasswordListener);
    }

    public static void unsetThreadPasswordHandler() {
        SESecurityManagerImpl.getSingleton().unsetThreadPasswordHandler();
    }

    public static void setPasswordHandler(URL uRL, SEPasswordListener sEPasswordListener) {
        SESecurityManagerImpl.getSingleton().setPasswordHandler(uRL, sEPasswordListener);
    }

    public static void addCertificateListener(SECertificateListener sECertificateListener) {
        SESecurityManagerImpl.getSingleton().addCertificateListener(sECertificateListener);
    }

    public static void setCertificateHandler(URL uRL, SECertificateListener sECertificateListener) {
        SESecurityManagerImpl.getSingleton().setCertificateHandler(uRL, sECertificateListener);
    }

    public static void removeCertificateListener(SECertificateListener sECertificateListener) {
        SESecurityManagerImpl.getSingleton().removeCertificateListener(sECertificateListener);
    }

    public static Class[] getClassContext() {
        return SESecurityManagerImpl.getSingleton().getClassContext();
    }
}

