/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.peer.impl;

import com.aelitis.azureus.core.peermanager.piecepicker.PiecePicker;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.gudy.azureus2.core3.disk.DiskManagerPiece;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.peer.PEPiece;
import org.gudy.azureus2.core3.peer.impl.PEPieceWriteImpl;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.SystemTime;

public class PEPieceImpl
implements PEPiece {
    private static final LogIDs LOGID = LogIDs.PIECES;
    private final DiskManagerPiece dmPiece;
    private final PEPeerManager manager;
    private final int nbBlocks;
    private long creationTime = SystemTime.getCurrentTime();
    private final String[] requested;
    private boolean fully_requested;
    private final boolean[] downloaded;
    private boolean fully_downloaded;
    private long time_last_download;
    private final String[] writers;
    private List writes;
    private String reservedBy;
    private int speed;
    private int resumePriority;
    private Object real_time_data;
    protected static final AEMonitor class_mon = new AEMonitor("PEPiece:class");

    public PEPieceImpl(PEPeerManager pEPeerManager, DiskManagerPiece diskManagerPiece, int n) {
        this.manager = pEPeerManager;
        this.dmPiece = diskManagerPiece;
        this.speed = n;
        this.nbBlocks = this.dmPiece.getNbBlocks();
        this.requested = new String[this.nbBlocks];
        boolean[] blArray = this.dmPiece.getWritten();
        this.downloaded = blArray == null ? new boolean[this.nbBlocks] : (boolean[])blArray.clone();
        this.writers = new String[this.nbBlocks];
        this.writes = new ArrayList(0);
    }

    @Override
    public DiskManagerPiece getDMPiece() {
        return this.dmPiece;
    }

    @Override
    public long getCreationTime() {
        long l = SystemTime.getCurrentTime();
        if (l >= this.creationTime && this.creationTime > 0L) {
            return this.creationTime;
        }
        this.creationTime = l;
        return l;
    }

    @Override
    public long getTimeSinceLastActivity() {
        long l = SystemTime.getCurrentTime();
        long l2 = this.getLastDownloadTime(l);
        if (this.time_last_download > 0L && l >= this.time_last_download) {
            return l - this.time_last_download;
        }
        if (this.creationTime > 0L && l >= this.creationTime) {
            return l - this.creationTime;
        }
        this.creationTime = l;
        return 0L;
    }

    @Override
    public long getLastDownloadTime(long l) {
        if (this.time_last_download <= l) {
            return this.time_last_download;
        }
        this.time_last_download = l;
        return this.time_last_download;
    }

    @Override
    public boolean isRequested(int n) {
        return this.requested[n] != null;
    }

    @Override
    public boolean isDownloaded(int n) {
        return this.downloaded[n];
    }

    @Override
    public void setDownloaded(int n) {
        this.time_last_download = SystemTime.getCurrentTime();
        this.downloaded[n / 16384] = true;
        for (int i = 0; i < this.nbBlocks; ++i) {
            if (this.downloaded[i]) continue;
            return;
        }
        this.fully_downloaded = true;
        this.fully_requested = false;
    }

    @Override
    public void clearDownloaded(int n) {
        this.downloaded[n / 16384] = false;
        this.fully_downloaded = false;
    }

    @Override
    public boolean isDownloaded() {
        return this.fully_downloaded;
    }

    @Override
    public boolean[] getDownloaded() {
        return this.downloaded;
    }

    @Override
    public boolean hasUndownloadedBlock() {
        for (int i = 0; i < this.nbBlocks; ++i) {
            if (this.downloaded[i]) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setWritten(PEPeer pEPeer, int n) {
        this.writers[n] = pEPeer.getIp();
        this.dmPiece.setWritten(n);
    }

    @Override
    public void clearRequested(int n) {
        this.requested[n] = this.downloaded[n] ? this.writers[n] : null;
        this.fully_requested = false;
    }

    @Override
    public boolean isRequested() {
        return this.fully_requested;
    }

    @Override
    public void setRequested() {
        this.fully_requested = true;
    }

    public void checkRequests() {
        if (this.getTimeSinceLastActivity() < 30000L) {
            return;
        }
        int n = 0;
        for (int i = 0; i < this.nbBlocks; ++i) {
            String string;
            if (this.downloaded[i] || this.dmPiece.isWritten(i) || (string = this.requested[i]) == null || this.manager.requestExists(string, this.getPieceNumber(), i * 16384, this.getBlockSize(i))) continue;
            this.clearRequested(i);
            ++n;
        }
        if (n > 0) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)this.dmPiece.getManager().getTorrent(), LOGID, 1, "checkRequests(): piece #" + this.getPieceNumber() + " cleared " + n + " requests"));
            }
        } else if (this.fully_requested && this.getNbUnrequested() > 0) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)this.dmPiece.getManager().getTorrent(), LOGID, 1, "checkRequests(): piece #" + this.getPieceNumber() + " reset fully requested"));
            }
            this.fully_requested = false;
        }
    }

    @Override
    public boolean hasUnrequestedBlock() {
        boolean[] blArray = this.dmPiece.getWritten();
        for (int i = 0; i < this.nbBlocks; ++i) {
            if (this.downloaded[i] || this.requested[i] != null || blArray != null && blArray[i]) continue;
            return true;
        }
        return false;
    }

    @Override
    public int[] getAndMarkBlocks(PEPeer pEPeer, int n, boolean bl) {
        int[] nArray;
        String string = pEPeer.getIp();
        boolean[] blArray = this.dmPiece.getWritten();
        int n2 = 0;
        if (bl && (nArray = pEPeer.getRequestHint()) != null && nArray[0] == this.dmPiece.getPieceNumber()) {
            int n3 = nArray[1] / 16384;
            int n4 = (nArray[2] + 16384 - 1) / 16384;
            for (int i = n3; i < this.nbBlocks && i < n3 + n4; ++i) {
                while (!(n2 >= n || i + n2 >= this.nbBlocks || this.downloaded[i + n2] || this.requested[i + n2] != null || blArray != null && blArray[i])) {
                    this.requested[i + n2] = string;
                    ++n2;
                }
                if (n2 <= 0) continue;
                return new int[]{i, n2};
            }
        }
        for (int i = 0; i < this.nbBlocks; ++i) {
            while (!(n2 >= n || i + n2 >= this.nbBlocks || this.downloaded[i + n2] || this.requested[i + n2] != null || blArray != null && blArray[i])) {
                this.requested[i + n2] = string;
                ++n2;
            }
            if (n2 <= 0) continue;
            return new int[]{i, n2};
        }
        return new int[]{-1, 0};
    }

    @Override
    public void getAndMarkBlock(PEPeer pEPeer, int n) {
        this.requested[n] = pEPeer.getIp();
        if (this.getNbUnrequested() <= 0) {
            this.setRequested();
        }
    }

    @Override
    public int getNbRequests() {
        int n = 0;
        for (int i = 0; i < this.nbBlocks; ++i) {
            if (this.downloaded[i] || this.requested[i] == null) continue;
            ++n;
        }
        return n;
    }

    @Override
    public int getNbUnrequested() {
        int n = 0;
        boolean[] blArray = this.dmPiece.getWritten();
        for (int i = 0; i < this.nbBlocks; ++i) {
            if (this.downloaded[i] || this.requested[i] != null || blArray != null && blArray[i]) continue;
            ++n;
        }
        return n;
    }

    @Override
    public boolean setRequested(PEPeer pEPeer, int n) {
        if (!this.downloaded[n]) {
            this.requested[n] = pEPeer.getIp();
            return true;
        }
        return false;
    }

    @Override
    public boolean isRequestable() {
        return this.dmPiece.isDownloadable() && !this.fully_downloaded && !this.fully_requested;
    }

    @Override
    public int getBlockSize(int n) {
        int n2;
        if (n == this.nbBlocks - 1 && (n2 = this.dmPiece.getLength()) % 16384 != 0) {
            return n2 % 16384;
        }
        return 16384;
    }

    @Override
    public int getBlockNumber(int n) {
        return n / 16384;
    }

    @Override
    public int getNbBlocks() {
        return this.nbBlocks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getPieceWrites() {
        ArrayList arrayList;
        try {
            class_mon.enter();
            arrayList = new ArrayList(this.writes);
        }
        finally {
            class_mon.exit();
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getPieceWrites(int n) {
        ArrayList arrayList;
        try {
            class_mon.enter();
            arrayList = new ArrayList(this.writes);
        }
        finally {
            class_mon.exit();
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            PEPieceWriteImpl pEPieceWriteImpl = (PEPieceWriteImpl)iterator.next();
            if (pEPieceWriteImpl.getBlockNumber() == n) continue;
            iterator.remove();
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getPieceWrites(PEPeer pEPeer) {
        ArrayList arrayList;
        try {
            class_mon.enter();
            arrayList = new ArrayList(this.writes);
        }
        finally {
            class_mon.exit();
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            PEPieceWriteImpl pEPieceWriteImpl = (PEPieceWriteImpl)iterator.next();
            if (pEPeer != null && pEPeer.getIp().equals(pEPieceWriteImpl.getSender())) continue;
            iterator.remove();
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getPieceWrites(String string) {
        ArrayList arrayList;
        try {
            class_mon.enter();
            arrayList = new ArrayList(this.writes);
        }
        finally {
            class_mon.exit();
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            PEPieceWriteImpl pEPieceWriteImpl = (PEPieceWriteImpl)iterator.next();
            if (pEPieceWriteImpl.getSender().equals(string)) continue;
            iterator.remove();
        }
        return arrayList;
    }

    @Override
    public void reset() {
        this.dmPiece.reset();
        for (int i = 0; i < this.nbBlocks; ++i) {
            this.requested[i] = null;
            this.downloaded[i] = false;
            this.writers[i] = null;
        }
        this.fully_downloaded = false;
        this.time_last_download = 0L;
        this.reservedBy = null;
        this.real_time_data = null;
    }

    @Override
    public Object getRealTimeData() {
        return this.real_time_data;
    }

    @Override
    public void setRealTimeData(Object object) {
        this.real_time_data = object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addWrite(PEPieceWriteImpl pEPieceWriteImpl) {
        try {
            class_mon.enter();
            this.writes.add(pEPieceWriteImpl);
        }
        finally {
            class_mon.exit();
        }
    }

    @Override
    public void addWrite(int n, String string, byte[] byArray, boolean bl) {
        this.addWrite(new PEPieceWriteImpl(n, string, byArray, bl));
    }

    @Override
    public String[] getWriters() {
        return this.writers;
    }

    @Override
    public int getSpeed() {
        return this.speed;
    }

    @Override
    public void setSpeed(int n) {
        this.speed = n;
    }

    @Override
    public void setLastRequestedPeerSpeed(int n) {
        if (n > this.speed) {
            ++this.speed;
        }
    }

    @Override
    public PEPeerManager getManager() {
        return this.manager;
    }

    @Override
    public void setReservedBy(String string) {
        this.reservedBy = string;
    }

    @Override
    public String getReservedBy() {
        return this.reservedBy;
    }

    public void reDownloadBlock(int n) {
        this.downloaded[n] = false;
        this.requested[n] = null;
        this.fully_downloaded = false;
        this.writers[n] = null;
        this.dmPiece.reDownloadBlock(n);
    }

    public void reDownloadBlocks(String string) {
        for (int i = 0; i < this.writers.length; ++i) {
            String string2 = this.writers[i];
            if (string2 == null || !string2.equals(string)) continue;
            this.reDownloadBlock(i);
        }
    }

    @Override
    public void setResumePriority(int n) {
        this.resumePriority = n;
    }

    @Override
    public int getResumePriority() {
        return this.resumePriority;
    }

    @Override
    public int getAvailability() {
        return this.manager.getAvailability(this.dmPiece.getPieceNumber());
    }

    @Override
    public int getNbWritten() {
        return this.dmPiece.getNbWritten();
    }

    public boolean[] getWritten() {
        return this.dmPiece.getWritten();
    }

    @Override
    public boolean isWritten() {
        return this.dmPiece.isWritten();
    }

    @Override
    public boolean isWritten(int n) {
        return this.dmPiece.isWritten(n);
    }

    @Override
    public int getPieceNumber() {
        return this.dmPiece.getPieceNumber();
    }

    @Override
    public int getLength() {
        return this.dmPiece.getLength();
    }

    public void setRequestable() {
        this.fully_downloaded = false;
        this.fully_requested = false;
        this.dmPiece.setDownloadable();
    }

    @Override
    public String getString() {
        String string = "";
        PiecePicker piecePicker = this.manager.getPiecePicker();
        string = string + (this.isRequestable() ? "reqable," : "");
        string = string + "req=" + this.getNbRequests() + ",";
        string = string + (this.isRequested() ? "reqstd," : "");
        string = string + (this.isDownloaded() ? "downed," : "");
        string = string + (this.getReservedBy() != null ? "resrv," : "");
        string = string + "speed=" + this.getSpeed() + ",";
        if ((string = string + (piecePicker == null ? "pri=" + this.getResumePriority() : piecePicker.getPieceString(this.dmPiece.getPieceNumber()))).endsWith(",")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }
}

