/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.ipchecker.natchecker;

import com.aelitis.azureus.core.networkmanager.NetworkConnection;
import com.aelitis.azureus.core.networkmanager.NetworkManager;
import com.aelitis.azureus.core.networkmanager.Transport;
import com.aelitis.azureus.core.networkmanager.impl.TransportHelper;
import com.aelitis.azureus.core.networkmanager.impl.http.HTTPNetworkManager;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPNetworkManager;
import com.aelitis.azureus.core.peermanager.messaging.MessageStreamDecoder;
import com.aelitis.azureus.core.peermanager.messaging.MessageStreamEncoder;
import com.aelitis.azureus.core.peermanager.messaging.MessageStreamFactory;
import com.aelitis.azureus.core.peermanager.messaging.azureus.AZMessageDecoder;
import com.aelitis.azureus.core.peermanager.messaging.azureus.AZMessageEncoder;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.HashMap;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;

public class NatCheckerServer
extends AEThread {
    private static final LogIDs LOGID = LogIDs.NET;
    private static final String incoming_handshake = "NATCHECK_HANDSHAKE";
    private final InetAddress bind_ip;
    private boolean bind_ip_set;
    private final String check;
    private final boolean http_test;
    private ServerSocket server;
    private volatile boolean bContinue = true;
    private final boolean use_incoming_router;
    private NetworkManager.ByteMatcher matcher;

    public NatCheckerServer(InetAddress inetAddress, int n, String string, boolean bl) throws Exception {
        super("Nat Checker Server");
        Object object;
        this.bind_ip = inetAddress;
        this.check = string;
        this.http_test = bl;
        if (this.http_test) {
            object = HTTPNetworkManager.getSingleton();
            this.use_incoming_router = ((HTTPNetworkManager)object).isHTTPListenerEnabled() ? n == ((HTTPNetworkManager)object).getHTTPListeningPortNumber() : false;
            if (this.use_incoming_router && !((HTTPNetworkManager)object).isEffectiveBindAddress(this.bind_ip)) {
                ((HTTPNetworkManager)object).setExplicitBindAddress(this.bind_ip);
                this.bind_ip_set = true;
            }
        } else {
            object = TCPNetworkManager.getSingleton();
            this.use_incoming_router = ((TCPNetworkManager)object).isTCPListenerEnabled() ? n == ((TCPNetworkManager)object).getTCPListeningPortNumber() : false;
            if (this.use_incoming_router) {
                if (!((TCPNetworkManager)object).isEffectiveBindAddress(this.bind_ip)) {
                    ((TCPNetworkManager)object).setExplicitBindAddress(this.bind_ip);
                    this.bind_ip_set = true;
                }
                this.matcher = new NetworkManager.ByteMatcher(){

                    @Override
                    public int matchThisSizeOrBigger() {
                        return this.maxSize();
                    }

                    @Override
                    public int maxSize() {
                        return NatCheckerServer.incoming_handshake.getBytes().length;
                    }

                    @Override
                    public int minSize() {
                        return this.maxSize();
                    }

                    @Override
                    public Object matches(TransportHelper transportHelper, ByteBuffer byteBuffer, int n) {
                        int n2 = byteBuffer.limit();
                        byteBuffer.limit(byteBuffer.position() + this.maxSize());
                        boolean bl = byteBuffer.equals(ByteBuffer.wrap(NatCheckerServer.incoming_handshake.getBytes()));
                        byteBuffer.limit(n2);
                        return bl ? "" : null;
                    }

                    @Override
                    public Object minMatches(TransportHelper transportHelper, ByteBuffer byteBuffer, int n) {
                        return this.matches(transportHelper, byteBuffer, n);
                    }

                    @Override
                    public byte[][] getSharedSecrets() {
                        return null;
                    }

                    @Override
                    public int getSpecificPort() {
                        return -1;
                    }
                };
                NetworkManager.getSingleton().requestIncomingConnectionRouting(this.matcher, new NetworkManager.RoutingListener(){

                    @Override
                    public void connectionRouted(NetworkConnection networkConnection, Object object) {
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(LOGID, "Incoming connection from [" + networkConnection + "] successfully routed to NAT CHECKER"));
                        }
                        try {
                            ByteBuffer byteBuffer = NatCheckerServer.this.getMessage();
                            Transport transport = networkConnection.getTransport();
                            long l = SystemTime.getCurrentTime();
                            while (byteBuffer.hasRemaining()) {
                                transport.write(new ByteBuffer[]{byteBuffer}, 0, 1);
                                if (!byteBuffer.hasRemaining()) continue;
                                long l2 = SystemTime.getCurrentTime();
                                if (l2 < l) {
                                    l = l2;
                                } else if (l2 - l > 30000L) {
                                    throw new Exception("Timeout");
                                }
                                Thread.sleep(50L);
                            }
                        }
                        catch (Throwable throwable) {
                            Debug.out("Nat check write failed", throwable);
                        }
                        networkConnection.close();
                    }

                    @Override
                    public boolean autoCryptoFallback() {
                        return true;
                    }
                }, new MessageStreamFactory(){

                    @Override
                    public MessageStreamEncoder createEncoder() {
                        return new AZMessageEncoder(0);
                    }

                    @Override
                    public MessageStreamDecoder createDecoder() {
                        return new AZMessageDecoder();
                    }
                });
            }
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "NAT tester using central routing for server socket"));
            }
        }
        if (!this.use_incoming_router) {
            try {
                this.server = new ServerSocket();
                this.server.setReuseAddress(true);
                object = this.bind_ip != null ? new InetSocketAddress(this.bind_ip, n) : new InetSocketAddress(n);
                this.server.bind((SocketAddress)object);
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "NAT tester server socket bound to " + object));
                }
            }
            catch (Exception exception) {
                Logger.log(new LogEvent(LOGID, "NAT tester failed to setup listener socket", exception));
                throw exception;
            }
        }
    }

    protected ByteBuffer getMessage() throws IOException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("check", this.check);
        byte[] byArray = BEncoder.encode(hashMap);
        ByteBuffer byteBuffer = ByteBuffer.allocate(4 + byArray.length);
        byteBuffer.putInt(byArray.length);
        byteBuffer.put(byArray);
        byteBuffer.flip();
        return byteBuffer;
    }

    @Override
    public void runSupport() {
        while (this.bContinue) {
            try {
                if (this.use_incoming_router) {
                    Thread.sleep(20L);
                    continue;
                }
                Socket socket = this.server.accept();
                socket.getOutputStream().write(this.getMessage().array());
                socket.close();
            }
            catch (Exception exception) {
                this.bContinue = false;
            }
        }
    }

    public void stopIt() {
        this.bContinue = false;
        if (this.use_incoming_router) {
            if (this.http_test) {
                if (this.bind_ip_set) {
                    HTTPNetworkManager.getSingleton().clearExplicitBindAddress();
                }
            } else {
                NetworkManager.getSingleton().cancelIncomingConnectionRouting(this.matcher);
                if (this.bind_ip_set) {
                    TCPNetworkManager.getSingleton().clearExplicitBindAddress();
                }
            }
        } else if (this.server != null) {
            try {
                this.server.close();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }
}

