/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.internat;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.util.Arrays;
import org.gudy.azureus2.core3.internat.LocaleUtilDecoder;
import org.gudy.azureus2.core3.util.Debug;

public class LocaleUtilDecoderReal
implements LocaleUtilDecoder {
    protected CharsetDecoder decoder;
    protected int index;

    protected LocaleUtilDecoderReal(int n, CharsetDecoder charsetDecoder) {
        this.index = n;
        this.decoder = charsetDecoder;
    }

    @Override
    public String getName() {
        return this.decoder.charset().name();
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public String tryDecode(byte[] byArray, boolean bl) {
        try {
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            CharBuffer charBuffer = CharBuffer.allocate(byArray.length);
            CoderResult coderResult = this.decoder.decode(byteBuffer, charBuffer, true);
            if (!coderResult.isError()) {
                charBuffer.flip();
                String string = charBuffer.toString();
                if (bl) {
                    return string;
                }
                byte[] byArray2 = string.getBytes(this.getName());
                if (Arrays.equals(byArray, byArray2)) {
                    return string;
                }
            }
            return null;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    @Override
    public String decodeString(byte[] byArray) throws UnsupportedEncodingException {
        if (byArray == null) {
            return null;
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        CharBuffer charBuffer = CharBuffer.allocate(byArray.length);
        CoderResult coderResult = this.decoder.decode(byteBuffer, charBuffer, true);
        try {
            if (!coderResult.isError()) {
                charBuffer.flip();
                String string = charBuffer.toString();
                byte[] byArray2 = string.getBytes(this.decoder.charset().name());
                if (Arrays.equals(byArray, byArray2)) {
                    return string;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            return new String(byArray, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Debug.printStackTrace(unsupportedEncodingException);
            return new String(byArray);
        }
    }
}

