/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.global.impl;

import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.global.GlobalManagerStats;
import org.gudy.azureus2.core3.global.impl.GlobalManagerImpl;
import org.gudy.azureus2.core3.util.Average;

public class GlobalManagerStatsImpl
implements GlobalManagerStats {
    private GlobalManagerImpl manager;
    private long total_data_bytes_received;
    private long total_protocol_bytes_received;
    private long totalDiscarded;
    private long total_data_bytes_sent;
    private long total_protocol_bytes_sent;
    private int data_send_speed_at_close;
    private Average data_receive_speed = Average.getInstance(1000, 10);
    private Average protocol_receive_speed = Average.getInstance(1000, 10);
    private Average data_receive_speed_no_lan = Average.getInstance(1000, 10);
    private Average protocol_receive_speed_no_lan = Average.getInstance(1000, 10);
    private Average data_send_speed = Average.getInstance(1000, 10);
    private Average protocol_send_speed = Average.getInstance(1000, 10);
    private Average data_send_speed_no_lan = Average.getInstance(1000, 10);
    private Average protocol_send_speed_no_lan = Average.getInstance(1000, 10);

    protected GlobalManagerStatsImpl(GlobalManagerImpl globalManagerImpl) {
        this.manager = globalManagerImpl;
        this.load();
    }

    protected void load() {
        this.data_send_speed_at_close = COConfigurationManager.getIntParameter("globalmanager.stats.send.speed.at.close", 0);
    }

    protected void save() {
        COConfigurationManager.setParameter("globalmanager.stats.send.speed.at.close", this.getDataSendRate());
    }

    @Override
    public int getDataSendRateAtClose() {
        return this.data_send_speed_at_close;
    }

    @Override
    public void discarded(int n) {
        this.totalDiscarded += (long)n;
    }

    @Override
    public void dataBytesReceived(int n, boolean bl) {
        this.total_data_bytes_received += (long)n;
        if (!bl) {
            this.data_receive_speed_no_lan.addValue(n);
        }
        this.data_receive_speed.addValue(n);
    }

    @Override
    public void protocolBytesReceived(int n, boolean bl) {
        this.total_protocol_bytes_received += (long)n;
        if (!bl) {
            this.protocol_receive_speed_no_lan.addValue(n);
        }
        this.protocol_receive_speed.addValue(n);
    }

    @Override
    public void dataBytesSent(int n, boolean bl) {
        this.total_data_bytes_sent += (long)n;
        if (!bl) {
            this.data_send_speed_no_lan.addValue(n);
        }
        this.data_send_speed.addValue(n);
    }

    @Override
    public void protocolBytesSent(int n, boolean bl) {
        this.total_protocol_bytes_sent += (long)n;
        if (!bl) {
            this.protocol_send_speed_no_lan.addValue(n);
        }
        this.protocol_send_speed.addValue(n);
    }

    @Override
    public int getDataReceiveRate() {
        return (int)this.data_receive_speed.getAverage();
    }

    @Override
    public int getDataReceiveRateNoLAN() {
        return (int)this.data_receive_speed_no_lan.getAverage();
    }

    @Override
    public int getDataReceiveRateNoLAN(int n) {
        return (int)(n <= 0 ? this.data_receive_speed_no_lan.getAverage() : this.data_receive_speed_no_lan.getAverage(n));
    }

    @Override
    public int getProtocolReceiveRate() {
        return (int)this.protocol_receive_speed.getAverage();
    }

    @Override
    public int getProtocolReceiveRateNoLAN() {
        return (int)this.protocol_receive_speed_no_lan.getAverage();
    }

    @Override
    public int getProtocolReceiveRateNoLAN(int n) {
        return (int)(n <= 0 ? this.protocol_receive_speed_no_lan.getAverage() : this.protocol_receive_speed_no_lan.getAverage(n));
    }

    @Override
    public int getDataAndProtocolReceiveRate() {
        return (int)(this.protocol_receive_speed.getAverage() + this.data_receive_speed.getAverage());
    }

    @Override
    public int getDataSendRate() {
        return (int)this.data_send_speed.getAverage();
    }

    @Override
    public int getDataSendRateNoLAN() {
        return (int)this.data_send_speed_no_lan.getAverage();
    }

    @Override
    public int getDataSendRateNoLAN(int n) {
        return (int)(n <= 0 ? this.data_send_speed_no_lan.getAverage() : this.data_send_speed_no_lan.getAverage(n));
    }

    @Override
    public int getProtocolSendRate() {
        return (int)this.protocol_send_speed.getAverage();
    }

    @Override
    public int getProtocolSendRateNoLAN() {
        return (int)this.protocol_send_speed_no_lan.getAverage();
    }

    @Override
    public int getProtocolSendRateNoLAN(int n) {
        return (int)(n <= 0 ? this.protocol_send_speed_no_lan.getAverage() : this.protocol_send_speed_no_lan.getAverage(n));
    }

    @Override
    public int getDataAndProtocolSendRate() {
        return (int)(this.protocol_send_speed.getAverage() + this.data_send_speed.getAverage());
    }

    @Override
    public long getTotalDataBytesSent() {
        return this.total_data_bytes_sent;
    }

    @Override
    public long getTotalProtocolBytesSent() {
        return this.total_protocol_bytes_sent;
    }

    @Override
    public long getTotalDataBytesReceived() {
        return this.total_data_bytes_received;
    }

    @Override
    public long getTotalProtocolBytesReceived() {
        return this.total_protocol_bytes_received;
    }

    public long getTotalDiscardedRaw() {
        return this.totalDiscarded;
    }

    @Override
    public long getTotalSwarmsPeerRate(boolean bl, boolean bl2) {
        return this.manager.getTotalSwarmsPeerRate(bl, bl2);
    }
}

