/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.selectedcontent;

import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.ui.selectedcontent.DownloadUrlInfo;
import com.aelitis.azureus.ui.selectedcontent.ISelectedContent;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.HashWrapper;

public class SelectedContent
implements ISelectedContent {
    private String hash;
    private DownloadManager dm;
    private int file_index = -1;
    private TOTorrent torrent;
    private String displayName;
    private DownloadUrlInfo downloadInfo;

    public SelectedContent(DownloadManager downloadManager) {
        this.setDownloadManager(downloadManager);
    }

    public SelectedContent(DownloadManager downloadManager, int n) {
        this.setDownloadManager(downloadManager);
        this.file_index = n;
    }

    public SelectedContent(String string, String string2) {
        this.hash = string;
        this.displayName = string2;
    }

    public SelectedContent() {
    }

    @Override
    public String getHash() {
        return this.hash;
    }

    @Override
    public void setHash(String string) {
        this.hash = string;
    }

    @Override
    public DownloadManager getDownloadManager() {
        if (this.dm == null && this.hash != null) {
            try {
                GlobalManager globalManager = AzureusCoreFactory.getSingleton().getGlobalManager();
                return globalManager.getDownloadManager(new HashWrapper(Base32.decode(this.hash)));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.dm;
    }

    @Override
    public void setDownloadManager(DownloadManager downloadManager) {
        this.dm = downloadManager;
        if (this.dm != null) {
            this.setTorrent(this.dm.getTorrent());
            this.setDisplayName(this.dm.getDisplayName());
        }
    }

    @Override
    public int getFileIndex() {
        return this.file_index;
    }

    @Override
    public TOTorrent getTorrent() {
        return this.torrent;
    }

    @Override
    public void setTorrent(TOTorrent tOTorrent) {
        this.torrent = tOTorrent;
        if (this.torrent != null) {
            try {
                this.hash = this.torrent.getHashWrapper().toBase32String();
            }
            catch (Exception exception) {
                this.hash = null;
            }
        }
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public void setDisplayName(String string) {
        this.displayName = string;
    }

    @Override
    public DownloadUrlInfo getDownloadInfo() {
        return this.downloadInfo;
    }

    @Override
    public void setDownloadInfo(DownloadUrlInfo downloadUrlInfo) {
        this.downloadInfo = downloadUrlInfo;
    }
}

