/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.upnp;

import com.aelitis.azureus.plugins.upnp.UPnPMappingListener;
import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.internat.MessageText;

public class UPnPMapping {
    public static final int PT_DEFAULT = 1;
    public static final int PT_PERSISTENT = 2;
    public static final int PT_TRANSIENT = 3;
    protected String resource_name;
    protected boolean tcp;
    protected int port;
    protected boolean enabled;
    protected int persistent = 1;
    protected List listeners = new ArrayList();

    protected UPnPMapping(String string, boolean bl, int n, boolean bl2) {
        this.resource_name = string;
        this.tcp = bl;
        this.port = n;
        this.enabled = bl2;
    }

    public void setPersistent(int n) {
        this.persistent = n;
    }

    public int getPersistent() {
        return this.persistent;
    }

    public boolean isTCP() {
        return this.tcp;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n) {
        if (this.port != n) {
            this.port = n;
            this.changed();
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        if (this.enabled != bl) {
            this.enabled = bl;
            this.changed();
        }
    }

    public String getString() {
        return this.getString(this.getPort());
    }

    public String getString(int n) {
        String string = MessageText.keyExists(this.resource_name) ? MessageText.getString(this.resource_name) : this.resource_name;
        return string + " (" + (this.isTCP() ? "TCP" : "UDP") + "/" + n + ")";
    }

    public void destroy() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((UPnPMappingListener)this.listeners.get(i)).mappingDestroyed(this);
        }
    }

    protected void changed() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((UPnPMappingListener)this.listeners.get(i)).mappingChanged(this);
        }
    }

    public void addListener(UPnPMappingListener uPnPMappingListener) {
        this.listeners.add(uPnPMappingListener);
    }

    public void removeListener(UPnPMappingListener uPnPMappingListener) {
        this.listeners.remove(uPnPMappingListener);
    }
}

