/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.net.buddy;

import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.plugins.net.buddy.BuddyPlugin;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginAZ2ChatListener;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginAZ2Listener;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginAZ2TrackerListener;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginAdapter;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginBuddy;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginBuddyReplyListener;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginBuddyRequestListener;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.RandomUtils;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.torrent.Torrent;

public class BuddyPluginAZ2 {
    public static final int RT_AZ2_REQUEST_MESSAGE = 1;
    public static final int RT_AZ2_REPLY_MESSAGE = 2;
    public static final int RT_AZ2_REQUEST_SEND_TORRENT = 3;
    public static final int RT_AZ2_REPLY_SEND_TORRENT = 4;
    public static final int RT_AZ2_REQUEST_CHAT = 5;
    public static final int RT_AZ2_REPLY_CHAT = 6;
    public static final int RT_AZ2_REQUEST_TRACK = 7;
    public static final int RT_AZ2_REPLY_TRACK = 8;
    public static final int RT_AZ2_REQUEST_RSS = 9;
    public static final int RT_AZ2_REPLY_RSS = 10;
    public static final int CHAT_MSG_TYPE_TEXT = 1;
    public static final int CHAT_MSG_TYPE_PARTICIPANTS_ADDED = 2;
    public static final int CHAT_MSG_TYPE_PARTICIPANTS_REMOVED = 3;
    private static final int SEND_TIMEOUT = 120000;
    private BuddyPlugin plugin;
    private Map chats = new HashMap();
    private CopyOnWriteList listeners = new CopyOnWriteList();
    private CopyOnWriteList track_listeners = new CopyOnWriteList();

    protected BuddyPluginAZ2(BuddyPlugin buddyPlugin) {
        this.plugin = buddyPlugin;
        this.plugin.addRequestListener(new BuddyPluginBuddyRequestListener(){

            @Override
            public Map requestReceived(BuddyPluginBuddy buddyPluginBuddy, int n, Map map) throws BuddyPluginException {
                if (n == 1) {
                    if (!buddyPluginBuddy.isAuthorised()) {
                        throw new BuddyPluginException("Unauthorised");
                    }
                    return BuddyPluginAZ2.this.processAZ2Request(buddyPluginBuddy, map);
                }
                return null;
            }

            @Override
            public void pendingMessages(BuddyPluginBuddy[] buddyPluginBuddyArray) {
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map processAZ2Request(final BuddyPluginBuddy buddyPluginBuddy, Map map) throws BuddyPluginException {
        this.logMessage("AZ2 request received: " + buddyPluginBuddy.getString() + " -> " + map);
        int n = ((Long)map.get("type")).intValue();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (n == 1) {
            try {
                String string = new String((byte[])map.get("msg"), "UTF8");
                buddyPluginBuddy.setLastMessageReceived(string);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            hashMap.put("type", new Long(2L));
        } else {
            if (n == 3) {
                try {
                    final Torrent torrent = this.plugin.getPluginInterface().getTorrentManager().createFromBEncodedData((byte[])map.get("torrent"));
                    new AEThread2("torrentAdder", true){

                        @Override
                        public void run() {
                            PluginInterface pluginInterface = BuddyPluginAZ2.this.plugin.getPluginInterface();
                            String string = pluginInterface.getUtilities().getLocaleUtilities().getLocalisedMessageText("azbuddy.addtorrent.msg", new String[]{buddyPluginBuddy.getName(), torrent.getName()});
                            long l = pluginInterface.getUIManager().showMessageBox("azbuddy.addtorrent.title", "!" + string + "!", 12L);
                            if (l == 4L) {
                                pluginInterface.getUIManager().openTorrent(torrent);
                            }
                        }
                    }.start();
                    hashMap.put("type", new Long(4L));
                }
                catch (Throwable throwable) {
                    throw new BuddyPluginException("Torrent receive failed " + n);
                }
            }
            if (n == 5) {
                chatInstance chatInstance2;
                Map map2 = (Map)map.get("msg");
                String string = new String((byte[])map2.get("id"));
                boolean bl = false;
                Map map3 = this.chats;
                synchronized (map3) {
                    chatInstance2 = (chatInstance)this.chats.get(string);
                    if (chatInstance2 == null) {
                        if (this.chats.size() > 32) {
                            throw new BuddyPluginException("Too many chats");
                        }
                        chatInstance2 = new chatInstance(string);
                        this.chats.put(string, chatInstance2);
                        bl = true;
                    }
                }
                if (bl) {
                    this.informCreated(chatInstance2);
                }
                chatInstance2.addParticipant(buddyPluginBuddy);
                chatInstance2.process(buddyPluginBuddy, map2);
                hashMap.put("type", new Long(6L));
            } else if (n == 7) {
                Map map4 = (Map)map.get("msg");
                Iterator iterator = this.track_listeners.iterator();
                boolean bl = false;
                while (iterator.hasNext()) {
                    try {
                        Map map5 = ((BuddyPluginAZ2TrackerListener)iterator.next()).messageReceived(buddyPluginBuddy, map4);
                        if (map5 == null) continue;
                        hashMap.put("msg", map5);
                        hashMap.put("type", new Long(8L));
                        bl = true;
                        break;
                    }
                    catch (Throwable throwable) {
                        Debug.printStackTrace(throwable);
                    }
                }
                if (!bl) {
                    throw new BuddyPluginException("Unhandled request type " + n);
                }
            } else if (n == 9) {
                try {
                    HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
                    hashMap.put("msg", hashMap2);
                    hashMap.put("type", new Long(10L));
                    Map map6 = (Map)map.get("msg");
                    String string = new String((byte[])map6.get("cat"), "UTF-8");
                    byte[] byArray = (byte[])map6.get("hash");
                    if (byArray == null) {
                        byte[] byArray2 = (byte[])map6.get("if_mod");
                        BuddyPlugin.feedDetails feedDetails2 = this.plugin.getRSS(buddyPluginBuddy, string, byArray2 == null ? null : new String(byArray2, "UTF-8"));
                        hashMap2.put("rss", feedDetails2.getContent());
                        hashMap2.put("last_mod", feedDetails2.getLastModified());
                    }
                    hashMap2.put("torrent", this.plugin.getRSSTorrent(buddyPluginBuddy, string, byArray));
                }
                catch (BuddyPluginException buddyPluginException) {
                    throw buddyPluginException;
                }
                catch (Throwable throwable) {
                    throw new BuddyPluginException("Failed to handle rss", throwable);
                }
            } else {
                throw new BuddyPluginException("Unrecognised request type " + n);
            }
        }
        this.logMessage("AZ2 reply sent: " + buddyPluginBuddy.getString() + " <- " + hashMap);
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public chatInstance createChat(BuddyPluginBuddy[] buddyPluginBuddyArray) {
        chatInstance chatInstance2;
        byte[] byArray = new byte[20];
        RandomUtils.SECURE_RANDOM.nextBytes(byArray);
        String string = Base32.encode(byArray);
        Map map = this.chats;
        synchronized (map) {
            chatInstance2 = new chatInstance(string);
            this.chats.put(string, chatInstance2);
        }
        this.logMessage("Chat " + chatInstance2.getID() + " created");
        this.informCreated(chatInstance2);
        chatInstance2.addParticipants(buddyPluginBuddyArray, true);
        return chatInstance2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroyChat(chatInstance chatInstance2) {
        Map map = this.chats;
        synchronized (map) {
            this.chats.remove(chatInstance2.getID());
        }
        this.logMessage("Chat " + chatInstance2.getID() + " destroyed");
        this.informDestroyed(chatInstance2);
    }

    protected void informCreated(chatInstance chatInstance2) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((BuddyPluginAZ2Listener)iterator.next()).chatCreated(chatInstance2);
        }
    }

    protected void informDestroyed(chatInstance chatInstance2) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((BuddyPluginAZ2Listener)iterator.next()).chatDestroyed(chatInstance2);
        }
    }

    public void sendAZ2Message(BuddyPluginBuddy buddyPluginBuddy, String string) {
        try {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("type", new Long(1L));
            hashMap.put("msg", string.getBytes());
            this.sendMessage(buddyPluginBuddy, hashMap);
        }
        catch (Throwable throwable) {
            this.logMessageAndPopup("Send message failed", throwable);
        }
    }

    protected void sendAZ2Chat(BuddyPluginBuddy buddyPluginBuddy, Map map) {
        try {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("type", new Long(5L));
            hashMap.put("msg", map);
            this.sendMessage(buddyPluginBuddy, hashMap);
        }
        catch (Throwable throwable) {
            this.logMessageAndPopup("Send message failed", throwable);
        }
    }

    public void sendAZ2Torrent(Torrent torrent, BuddyPluginBuddy buddyPluginBuddy) {
        try {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("type", new Long(3L));
            hashMap.put("torrent", torrent.writeToBEncodedData());
            this.sendMessage(buddyPluginBuddy, hashMap);
        }
        catch (Throwable throwable) {
            this.logMessageAndPopup("Send torrent failed", throwable);
        }
    }

    public void sendAZ2TrackerMessage(BuddyPluginBuddy buddyPluginBuddy, Map map, final BuddyPluginAZ2TrackerListener buddyPluginAZ2TrackerListener) {
        this.logMessage("AZ2 request sent: " + buddyPluginBuddy.getString() + " <- " + map);
        try {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("type", new Long(7L));
            hashMap.put("msg", map);
            buddyPluginBuddy.sendMessage(1, hashMap, 120000, new BuddyPluginBuddyReplyListener(){

                @Override
                public void replyReceived(BuddyPluginBuddy buddyPluginBuddy, Map map) {
                    int n = ((Long)map.get("type")).intValue();
                    if (n != 8) {
                        this.sendFailed(buddyPluginBuddy, new BuddyPluginException("Mismatched reply type"));
                    }
                    buddyPluginAZ2TrackerListener.messageReceived(buddyPluginBuddy, (Map)map.get("msg"));
                }

                @Override
                public void sendFailed(BuddyPluginBuddy buddyPluginBuddy, BuddyPluginException buddyPluginException) {
                    buddyPluginAZ2TrackerListener.messageFailed(buddyPluginBuddy, buddyPluginException);
                }
            });
        }
        catch (Throwable throwable) {
            this.logMessageAndPopup("Send message failed", throwable);
        }
    }

    public void sendAZ2RSSMessage(BuddyPluginBuddy buddyPluginBuddy, Map map, final BuddyPluginAZ2TrackerListener buddyPluginAZ2TrackerListener) {
        this.logMessage("AZ2 request sent: " + buddyPluginBuddy.getString() + " <- " + map);
        try {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("type", new Long(9L));
            hashMap.put("msg", map);
            buddyPluginBuddy.sendMessage(1, hashMap, 120000, new BuddyPluginBuddyReplyListener(){

                @Override
                public void replyReceived(BuddyPluginBuddy buddyPluginBuddy, Map map) {
                    int n = ((Long)map.get("type")).intValue();
                    if (n != 10) {
                        this.sendFailed(buddyPluginBuddy, new BuddyPluginException("Mismatched reply type"));
                    }
                    buddyPluginAZ2TrackerListener.messageReceived(buddyPluginBuddy, (Map)map.get("msg"));
                }

                @Override
                public void sendFailed(BuddyPluginBuddy buddyPluginBuddy, BuddyPluginException buddyPluginException) {
                    buddyPluginAZ2TrackerListener.messageFailed(buddyPluginBuddy, buddyPluginException);
                }
            });
        }
        catch (Throwable throwable) {
            this.logMessage("Send message failed", throwable);
        }
    }

    protected void sendMessage(BuddyPluginBuddy buddyPluginBuddy, Map map) throws BuddyPluginException {
        this.logMessage("AZ2 request sent: " + buddyPluginBuddy.getString() + " <- " + map);
        buddyPluginBuddy.getMessageHandler().queueMessage(1, map, 120000);
    }

    public void addListener(BuddyPluginAZ2Listener buddyPluginAZ2Listener) {
        this.listeners.add(buddyPluginAZ2Listener);
    }

    public void removeListener(BuddyPluginAZ2Listener buddyPluginAZ2Listener) {
        this.listeners.remove(buddyPluginAZ2Listener);
    }

    public void addTrackerListener(BuddyPluginAZ2TrackerListener buddyPluginAZ2TrackerListener) {
        this.track_listeners.add(buddyPluginAZ2TrackerListener);
    }

    public void removeTrackerListener(BuddyPluginAZ2TrackerListener buddyPluginAZ2TrackerListener) {
        this.track_listeners.remove(buddyPluginAZ2TrackerListener);
    }

    protected void logMessageAndPopup(String string, Throwable throwable) {
        this.logMessageAndPopup(string + ": " + Debug.getNestedExceptionMessage(throwable));
    }

    protected void logMessageAndPopup(String string) {
        this.logMessage(string);
        this.plugin.getPluginInterface().getUIManager().showMessageBox("azbuddy.msglog.title", "!" + string + "!", 1L);
    }

    protected void logMessage(String string) {
        this.plugin.logMessage(string);
    }

    protected void logMessage(String string, Throwable throwable) {
        this.plugin.logMessage(string + ": " + Debug.getNestedExceptionMessage(throwable));
    }

    public class chatMessage {
        private String nick;
        private Map map;

        protected chatMessage(String string, Map map) {
            this.nick = string;
            this.map = map;
        }

        public String getNickName() {
            return this.nick;
        }

        public Map getMessage() {
            return this.map;
        }
    }

    public class chatParticipant {
        private BuddyPluginBuddy buddy;
        private String public_key;

        protected chatParticipant(BuddyPluginBuddy buddyPluginBuddy) {
            this.buddy = buddyPluginBuddy;
        }

        protected chatParticipant(String string) {
            this.public_key = string;
        }

        public boolean isAuthorised() {
            return this.buddy != null;
        }

        public BuddyPluginBuddy getBuddy() {
            return this.buddy;
        }

        public String getPublicKey() {
            if (this.buddy != null) {
                return this.buddy.getPublicKey();
            }
            return this.public_key;
        }

        public String getName() {
            if (this.buddy != null) {
                return this.buddy.getName();
            }
            return this.public_key;
        }
    }

    public class chatInstance
    extends BuddyPluginAdapter {
        private String id;
        private Map participants = new HashMap();
        private CopyOnWriteList listeners = new CopyOnWriteList();
        private List history = new ArrayList();

        protected chatInstance(String string) {
            this.id = string;
            BuddyPluginAZ2.this.plugin.addListener(this);
        }

        public String getID() {
            return this.id;
        }

        @Override
        public void buddyAdded(BuddyPluginBuddy buddyPluginBuddy) {
            this.buddyChanged(buddyPluginBuddy);
        }

        @Override
        public void buddyRemoved(BuddyPluginBuddy buddyPluginBuddy) {
            chatParticipant chatParticipant2 = this.getParticipant(buddyPluginBuddy);
            if (chatParticipant2 != null) {
                Iterator iterator = this.listeners.iterator();
                while (iterator.hasNext()) {
                    try {
                        ((BuddyPluginAZ2ChatListener)iterator.next()).participantRemoved(chatParticipant2);
                    }
                    catch (Throwable throwable) {
                        Debug.printStackTrace(throwable);
                    }
                }
            }
        }

        @Override
        public void buddyChanged(BuddyPluginBuddy buddyPluginBuddy) {
            chatParticipant chatParticipant2 = this.getParticipant(buddyPluginBuddy);
            if (chatParticipant2 != null) {
                Iterator iterator = this.listeners.iterator();
                while (iterator.hasNext()) {
                    try {
                        ((BuddyPluginAZ2ChatListener)iterator.next()).participantChanged(chatParticipant2);
                    }
                    catch (Throwable throwable) {
                        Debug.printStackTrace(throwable);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void process(BuddyPluginBuddy buddyPluginBuddy, Map map) {
            block9: {
                int n;
                block8: {
                    chatParticipant chatParticipant2 = this.getOrAddParticipant(buddyPluginBuddy);
                    n = ((Long)map.get("type")).intValue();
                    if (n != 1) break block8;
                    Iterator iterator = this.listeners.iterator();
                    List list = this.history;
                    synchronized (list) {
                        this.history.add(new chatMessage(chatParticipant2.getName(), map));
                        if (this.history.size() > 128) {
                            this.history.remove(0);
                        }
                    }
                    while (iterator.hasNext()) {
                        try {
                            ((BuddyPluginAZ2ChatListener)iterator.next()).messageReceived(chatParticipant2, map);
                        }
                        catch (Throwable throwable) {
                            Debug.printStackTrace(throwable);
                        }
                    }
                    break block9;
                }
                if (n != 2) break block9;
                List list = (List)map.get("p");
                for (int i = 0; i < list.size(); ++i) {
                    Map map2 = (Map)list.get(i);
                    String string = new String((byte[])map2.get("pk"));
                    if (string.equals(BuddyPluginAZ2.this.plugin.getPublicKey())) continue;
                    this.addParticipant(string);
                }
            }
        }

        public void sendMessage(Map map) {
            map.put("type", new Long(1L));
            this.sendMessageBase(map);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void sendMessageBase(Map map) {
            HashMap hashMap;
            Map map2 = this.participants;
            synchronized (map2) {
                hashMap = new HashMap(this.participants);
            }
            map.put("id", this.id);
            for (chatParticipant chatParticipant2 : hashMap.values()) {
                if (!chatParticipant2.isAuthorised()) continue;
                BuddyPluginAZ2.this.sendAZ2Chat(chatParticipant2.getBuddy(), map);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public chatMessage[] getHistory() {
            List list = this.history;
            synchronized (list) {
                chatMessage[] chatMessageArray = new chatMessage[this.history.size()];
                this.history.toArray(chatMessageArray);
                return chatMessageArray;
            }
        }

        protected chatParticipant getOrAddParticipant(BuddyPluginBuddy buddyPluginBuddy) {
            return this.addParticipant(buddyPluginBuddy);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public chatParticipant addParticipant(String string) {
            chatParticipant chatParticipant2;
            BuddyPluginBuddy buddyPluginBuddy = BuddyPluginAZ2.this.plugin.getBuddyFromPublicKey(string);
            Object object = this.participants;
            synchronized (object) {
                chatParticipant2 = (chatParticipant)this.participants.get(string);
                if (chatParticipant2 != null) {
                    return chatParticipant2;
                }
                chatParticipant2 = buddyPluginBuddy == null ? new chatParticipant(string) : new chatParticipant(buddyPluginBuddy);
                this.participants.put(string, chatParticipant2);
            }
            object = this.listeners.iterator();
            while (object.hasNext()) {
                try {
                    ((BuddyPluginAZ2ChatListener)object.next()).participantAdded(chatParticipant2);
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
            }
            return chatParticipant2;
        }

        public chatParticipant addParticipant(BuddyPluginBuddy buddyPluginBuddy) {
            return this.addParticipant(buddyPluginBuddy.getPublicKey());
        }

        public void addParticipants(BuddyPluginBuddy[] buddyPluginBuddyArray, boolean bl) {
            for (int i = 0; i < buddyPluginBuddyArray.length; ++i) {
                this.addParticipant(buddyPluginBuddyArray[i]);
            }
            if (bl) {
                HashMap<String, Serializable> hashMap = new HashMap<String, Serializable>();
                hashMap.put("type", new Long(2L));
                ArrayList arrayList = new ArrayList();
                hashMap.put("p", arrayList);
                for (int i = 0; i < buddyPluginBuddyArray.length; ++i) {
                    HashMap<String, String> hashMap2 = new HashMap<String, String>();
                    hashMap2.put("pk", buddyPluginBuddyArray[i].getPublicKey());
                    arrayList.add(hashMap2);
                }
                this.sendMessageBase(hashMap);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected chatParticipant getParticipant(BuddyPluginBuddy buddyPluginBuddy) {
            String string = buddyPluginBuddy.getPublicKey();
            Map map = this.participants;
            synchronized (map) {
                chatParticipant chatParticipant2 = (chatParticipant)this.participants.get(string);
                if (chatParticipant2 != null) {
                    return chatParticipant2;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public chatParticipant[] getParticipants() {
            Map map = this.participants;
            synchronized (map) {
                chatParticipant[] chatParticipantArray = new chatParticipant[this.participants.size()];
                this.participants.values().toArray(chatParticipantArray);
                return chatParticipantArray;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void removeParticipant(chatParticipant chatParticipant2) {
            boolean bl;
            Object object = this.participants;
            synchronized (object) {
                bl = this.participants.remove(chatParticipant2.getPublicKey()) != null;
            }
            if (bl) {
                object = this.listeners.iterator();
                while (object.hasNext()) {
                    try {
                        ((BuddyPluginAZ2ChatListener)object.next()).participantRemoved(chatParticipant2);
                    }
                    catch (Throwable throwable) {
                        Debug.printStackTrace(throwable);
                    }
                }
            }
        }

        public void destroy() {
            BuddyPluginAZ2.this.plugin.removeListener(this);
            BuddyPluginAZ2.this.destroyChat(this);
        }

        public void addListener(BuddyPluginAZ2ChatListener buddyPluginAZ2ChatListener) {
            this.listeners.add(buddyPluginAZ2ChatListener);
        }

        public void removeListener(BuddyPluginAZ2ChatListener buddyPluginAZ2ChatListener) {
            this.listeners.remove(buddyPluginAZ2ChatListener);
        }
    }
}

