/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.util.average;

import com.aelitis.azureus.core.util.average.Average;

public class MovingAverage
implements Average {
    private final int periods;
    private double[] data;
    private int pos = 0;

    public MovingAverage(int n) {
        this.periods = n;
        this.data = new double[n];
        this.reset();
    }

    @Override
    public void reset() {
        this.pos = 0;
        for (int i = 0; i < this.periods; ++i) {
            this.data[i] = 0.0;
        }
    }

    @Override
    public double update(double d) {
        this.data[this.pos] = d;
        ++this.pos;
        if (this.pos == this.periods) {
            this.pos = 0;
        }
        return this.calculateAve();
    }

    @Override
    public double getAverage() {
        return this.calculateAve();
    }

    private double calculateAve() {
        double d = 0.0;
        for (int i = 0; i < this.periods; ++i) {
            d += this.data[i];
        }
        return d / (double)this.periods;
    }
}

