/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.FileUtil;

public class HTTPUtils {
    public static final String NL = "\r\n";
    private static final String default_type = "application/octet-stream";
    private static final Map file_types = new HashMap();
    private static final Set compression = new HashSet();

    public static String guessContentTypeFromFileType(String string) {
        String string2;
        if (string != null && (string2 = (String)file_types.get(string.toLowerCase(Constants.LOCALE_ENGLISH))) != null) {
            return string2;
        }
        return default_type;
    }

    public static boolean canGZIP(String string) {
        int n;
        boolean bl = false;
        if (string != null && (n = (string = string.toLowerCase(Constants.LOCALE_ENGLISH)).indexOf("gzip")) != -1) {
            bl = true;
            if (string.length() - n >= 8) {
                char c;
                char[] cArray = string.toCharArray();
                boolean bl2 = false;
                for (int i = n + 4; i < cArray.length && (c = cArray[i]) != ','; ++i) {
                    if (c == '=') {
                        bl2 = true;
                        bl = false;
                        continue;
                    }
                    if (!bl2 || c == ' ' || c == '0' || c == '.') continue;
                    bl = true;
                    break;
                }
            }
        }
        return bl;
    }

    public static boolean useCompressionForFileType(String string) {
        return compression.contains(string);
    }

    public static InputStream decodeChunkedEncoding(Socket socket) throws IOException {
        byte[] byArray;
        InputStream inputStream = socket.getInputStream();
        String string = "";
        do {
            if (inputStream.read(byArray = new byte[1]) > 0) continue;
            throw new IOException("Premature end of input stream");
        } while (!(string = string + (char)byArray[0]).endsWith("\r\n\r\n"));
        int n = string.indexOf(NL);
        String string2 = string.substring(0, n).trim();
        if (string2.indexOf("200") == -1) {
            String string3 = null;
            try {
                int n2 = socket.getSoTimeout();
                socket.setSoTimeout(500);
                string3 = FileUtil.readInputStreamAsStringWithTruncation(inputStream, 512);
                socket.setSoTimeout(n2);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            String string4 = "HTTP request failed: " + string2;
            if (string3 != null) {
                string4 = string4 + " - " + string3;
            }
            throw new IOException(string4);
        }
        String string5 = string.toLowerCase(Constants.LOCALE_ENGLISH);
        int n3 = string5.indexOf("transfer-encoding");
        if (n3 != -1) {
            String string6 = string5.substring(n3);
            if ((string6 = string6.substring(string6.indexOf(58) + 1, string6.indexOf(NL)).trim()).equals("chunked")) {
                int n4;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                String string7 = "";
                int n5 = 0;
                while ((n4 = inputStream.read()) != -1) {
                    int n6;
                    int n7;
                    if (!(string7 = string7 + (char)n4).endsWith(NL) || string7.length() <= 2) continue;
                    int n8 = string7.indexOf(59);
                    if (n8 != -1) {
                        string7 = string7.substring(0, n8);
                    }
                    if ((n7 = Integer.parseInt(string7 = string7.trim(), 16)) <= 0) break;
                    if ((n5 += n7) > 0x100000) {
                        throw new IOException("Chunk size " + n7 + " too large");
                    }
                    byte[] byArray2 = new byte[n7];
                    int n9 = 0;
                    for (int i = n7; i > 0; i -= n6) {
                        n6 = inputStream.read(byArray2, n9, i);
                        if (n6 <= 0) {
                            throw new IOException("Premature end of stream");
                        }
                        n9 += n6;
                    }
                    byteArrayOutputStream.write(byArray2);
                    string7 = "";
                }
                return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            }
        }
        return inputStream;
    }

    static {
        file_types.put("html", "text/html");
        file_types.put("htm", "text/html");
        file_types.put("css", "text/css");
        file_types.put("js", "text/javascript");
        file_types.put("xml", "text/xml");
        file_types.put("xsl", "text/xml");
        file_types.put("jpg", "image/jpeg");
        file_types.put("jpeg", "image/jpeg");
        file_types.put("gif", "image/gif");
        file_types.put("tiff", "image/tiff");
        file_types.put("bmp", "image/bmp");
        file_types.put("png", "image/png");
        file_types.put("torrent", "application/x-bittorrent");
        file_types.put("tor", "application/x-bittorrent");
        file_types.put("vuze", "application/x-vuze");
        file_types.put("vuz", "application/x-vuze");
        file_types.put("zip", "application/zip");
        file_types.put("txt", "text/plain");
        file_types.put("jar", "application/java-archive");
        file_types.put("jnlp", "application/x-java-jnlp-file");
        file_types.put("mp3", "audio/x-mpeg");
        file_types.put("flv", "video/x-flv");
        file_types.put("swf", "application/x-shockwave-flash");
        file_types.put("mkv", "video/x-matroska");
        file_types.put("mp4", "video/mp4");
        file_types.put("mov", "video/quicktime");
        file_types.put("avi", "video/avi");
        file_types.put("xap", "application/x-silverlight-app");
        compression.add("text/html");
        compression.add("text/css");
        compression.add("text/xml");
        compression.add("text/plain");
        compression.add("text/javascript");
    }
}

