/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.speedmanager.impl.v2;

import com.aelitis.azureus.core.speedmanager.impl.v2.SaturatedMode;
import com.aelitis.azureus.core.speedmanager.impl.v2.SpeedManagerLogger;
import org.gudy.azureus2.core3.util.SystemTime;

public class TransferMode {
    private State mode = State.DOWNLOADING;
    private long lastTimeDownloadDetected = SystemTime.getCurrentTime();
    private static final long WAIT_TIME_FOR_SEEDING_MODE = 60000L;

    public void updateStatus(SaturatedMode saturatedMode) {
        if (this.isConfTestingLimits()) {
            if (this.mode == State.DOWNLOAD_LIMIT_SEARCH) {
                this.lastTimeDownloadDetected = SystemTime.getCurrentTime();
            }
            return;
        }
        if (saturatedMode.compareTo(SaturatedMode.LOW) <= 0) {
            long l = SystemTime.getCurrentTime();
            if (l > this.lastTimeDownloadDetected + 60000L) {
                this.mode = State.SEEDING;
            }
        } else {
            this.mode = State.DOWNLOADING;
            this.lastTimeDownloadDetected = SystemTime.getCurrentTime();
        }
    }

    public String getString() {
        return this.mode.getString();
    }

    public State getMode() {
        return this.mode;
    }

    public void setMode(State state) {
        SpeedManagerLogger.trace(" setting transfer mode to: " + state.getString());
        this.mode = state;
    }

    public boolean isDownloadMode() {
        return this.mode == State.DOWNLOADING;
    }

    public boolean isConfTestingLimits() {
        return this.mode == State.DOWNLOAD_LIMIT_SEARCH || this.mode == State.UPLOAD_LIMIT_SEARCH;
    }

    static class State {
        public static final State DOWNLOADING = new State("downloading");
        public static final State SEEDING = new State("seeding");
        public static final State DOWNLOAD_LIMIT_SEARCH = new State("download limit search");
        public static final State UPLOAD_LIMIT_SEARCH = new State("upload limit search");
        String mode;

        private State(String string) {
            this.mode = string;
        }

        public String getString() {
            return this.mode;
        }
    }
}

