/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.speedmanager.impl.v2;

import com.aelitis.azureus.core.speedmanager.SpeedManagerLimitEstimate;

public class SMConst {
    public static final int START_DOWNLOAD_RATE_MAX = 61440;
    public static final int START_UPLOAD_RATE_MAX = 30720;
    public static final int MIN_UPLOAD_BYTES_PER_SEC = 5120;
    public static final int MIN_DOWNLOAD_BYTES_PER_SEC = 20480;
    public static final int RATE_UNLIMITED = 0;

    private SMConst() {
    }

    public static int checkForMinUploadValue(int n) {
        if (n < 5120) {
            return 5120;
        }
        return n;
    }

    public static int checkForMinDownloadValue(int n) {
        if (n < 20480) {
            return 20480;
        }
        return n;
    }

    public static int calculateMinUpload(int n) {
        int n2 = n / 10;
        return SMConst.checkForMinUploadValue(n2);
    }

    public static int calculateMinDownload(int n) {
        int n2 = n / 10;
        return SMConst.checkForMinDownloadValue(n2);
    }

    public static SpeedManagerLimitEstimate filterEstimate(SpeedManagerLimitEstimate speedManagerLimitEstimate, int n) {
        int n2 = SMConst.filterLimit(speedManagerLimitEstimate.getBytesPerSec(), n);
        return new FilteredLimitEstimate(n2, speedManagerLimitEstimate.getEstimateType(), speedManagerLimitEstimate.getMetricRating(), speedManagerLimitEstimate.getWhen(), speedManagerLimitEstimate.getString());
    }

    public static int filterLimit(int n, int n2) {
        int n3 = Math.max(n, n2);
        if (n == 0) {
            return n;
        }
        return n3;
    }

    static class FilteredLimitEstimate
    implements SpeedManagerLimitEstimate {
        int bytesPerSec;
        float type;
        float metric;
        long when;
        String name;

        public FilteredLimitEstimate(int n, float f, float f2, long l, String string) {
            this.bytesPerSec = n;
            this.type = f;
            this.metric = f2;
            this.when = l;
            this.name = string;
        }

        @Override
        public int getBytesPerSec() {
            return this.bytesPerSec;
        }

        @Override
        public float getEstimateType() {
            return this.type;
        }

        @Override
        public float getMetricRating() {
            return this.metric;
        }

        @Override
        public int[][] getSegments() {
            return new int[0][];
        }

        @Override
        public long getWhen() {
            return this.when;
        }

        @Override
        public String getString() {
            return this.name;
        }
    }
}

