/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.speedmanager.impl;

import com.aelitis.azureus.core.speedmanager.SpeedManagerLimitEstimate;
import com.aelitis.azureus.core.speedmanager.SpeedManagerPingMapper;
import com.aelitis.azureus.core.speedmanager.SpeedManagerPingZone;
import com.aelitis.azureus.core.speedmanager.impl.SpeedManagerImpl;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Random;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.SystemTime;

class SpeedManagerPingMapperImpl
implements SpeedManagerPingMapper {
    static final int VARIANCE_GOOD_VALUE = 50;
    static final int VARIANCE_BAD_VALUE = 150;
    static final int VARIANCE_MAX = 1500;
    static final int RTT_BAD_MIN = 350;
    static final int RTT_BAD_MAX = 500;
    static final int RTT_MAX = 30000;
    static final int MAX_BAD_LIMIT_HISTORY = 16;
    static final int SPEED_DIVISOR = 256;
    private static final int SPEED_HISTORY_PERIOD = 180000;
    private static final int SPEED_HISTORY_COUNT = 60;
    private SpeedManagerImpl speed_manager;
    private String name;
    private boolean variance;
    private boolean trans;
    private int ping_count;
    private pingValue[] pings;
    private int max_pings;
    private pingValue prev_ping;
    private int[] x_speeds = new int[60];
    private int[] y_speeds = new int[60];
    private int speeds_next;
    private LinkedList regions;
    private int last_x;
    private int last_y;
    private int[] recent_metrics = new int[3];
    private int recent_metrics_next;
    private limitEstimate up_estimate;
    private limitEstimate down_estimate;
    private LinkedList last_bad_ups;
    private LinkedList last_bad_downs;
    private static final int BAD_PROGRESS_COUNTDOWN = 5;
    private limitEstimate last_bad_up;
    private int bad_up_in_progress_count;
    private limitEstimate last_bad_down;
    private int bad_down_in_progress_count;
    private limitEstimate best_good_up;
    private limitEstimate best_good_down;
    private limitEstimate up_capacity = this.getNullLimit();
    private limitEstimate down_capacity = this.getNullLimit();
    private File history_file;

    protected SpeedManagerPingMapperImpl(SpeedManagerImpl speedManagerImpl, String string, int n, boolean bl, boolean bl2) {
        this.speed_manager = speedManagerImpl;
        this.name = string;
        this.max_pings = n;
        this.variance = bl;
        this.trans = bl2;
        this.init();
    }

    protected void init() {
        this.pings = new pingValue[this.max_pings];
        this.ping_count = 0;
        this.regions = new LinkedList();
        this.up_estimate = this.getNullLimit();
        this.down_estimate = this.getNullLimit();
        this.last_bad_ups = new LinkedList();
        this.last_bad_downs = new LinkedList();
        this.last_bad_up = null;
        this.bad_up_in_progress_count = 0;
        this.last_bad_down = null;
        this.bad_down_in_progress_count = 0;
        this.best_good_up = null;
        this.best_good_down = null;
        this.up_capacity = this.getNullLimit();
        this.down_capacity = this.getNullLimit();
        this.prev_ping = null;
        this.recent_metrics_next = 0;
    }

    protected synchronized void loadHistory(File file) {
        try {
            if (this.history_file != null && this.history_file.equals(file)) {
                return;
            }
            if (this.history_file != null) {
                this.saveHistory();
            }
            this.history_file = file;
            this.init();
            if (this.history_file.exists()) {
                Map map = FileUtil.readResilientFile(this.history_file.getParentFile(), this.history_file.getName(), false, false);
                List list = (List)map.get("pings");
                if (list != null) {
                    for (int i = 0; i < list.size(); ++i) {
                        Map map2 = (Map)list.get(i);
                        int n = ((Long)map2.get("x")).intValue();
                        int n2 = ((Long)map2.get("y")).intValue();
                        int n3 = ((Long)map2.get("m")).intValue();
                        if (i == 0) {
                            this.last_x = 0;
                            this.last_y = 0;
                        }
                        if (this.variance) {
                            if (n3 > 1500) {
                                n3 = 1500;
                            }
                        } else if (n3 > 30000) {
                            n3 = 30000;
                        }
                        this.addPingSupport(n, n2, -1, n3);
                    }
                }
                this.last_bad_ups = this.loadLimits(map, "lbus");
                this.last_bad_downs = this.loadLimits(map, "lbds");
                if (this.last_bad_ups.size() > 0) {
                    this.last_bad_up = (limitEstimate)this.last_bad_ups.get(this.last_bad_ups.size() - 1);
                }
                if (this.last_bad_downs.size() > 0) {
                    this.last_bad_down = (limitEstimate)this.last_bad_downs.get(this.last_bad_downs.size() - 1);
                }
                this.best_good_up = this.loadLimit((Map)map.get("bgu"));
                this.best_good_down = this.loadLimit((Map)map.get("bgd"));
                this.up_capacity = this.loadLimit((Map)map.get("upcap"));
                this.down_capacity = this.loadLimit((Map)map.get("downcap"));
                this.log("Loaded " + this.ping_count + " entries from " + this.history_file + ": bad_up=" + this.getLimitString(this.last_bad_ups) + ", bad_down=" + this.getLimitString(this.last_bad_downs));
            }
            this.prev_ping = null;
            this.recent_metrics_next = 0;
            this.updateLimitEstimates();
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
        }
    }

    protected synchronized void saveHistory() {
        try {
            if (this.history_file == null) {
                return;
            }
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            ArrayList arrayList = new ArrayList(this.ping_count);
            hashMap.put("pings", arrayList);
            for (int i = 0; i < this.ping_count; ++i) {
                pingValue pingValue2 = this.pings[i];
                HashMap<String, Long> hashMap2 = new HashMap<String, Long>();
                arrayList.add(hashMap2);
                hashMap2.put("x", new Long(pingValue2.getX()));
                hashMap2.put("y", new Long(pingValue2.getY()));
                hashMap2.put("m", new Long(pingValue2.getMetric()));
            }
            this.saveLimits(hashMap, "lbus", this.last_bad_ups);
            this.saveLimits(hashMap, "lbds", this.last_bad_downs);
            if (this.best_good_up != null) {
                hashMap.put("bgu", this.saveLimit(this.best_good_up));
            }
            if (this.best_good_down != null) {
                hashMap.put("bgd", this.saveLimit(this.best_good_down));
            }
            hashMap.put("upcap", this.saveLimit(this.up_capacity));
            hashMap.put("downcap", this.saveLimit(this.down_capacity));
            FileUtil.writeResilientFile(this.history_file, hashMap);
            this.log("Saved " + arrayList.size() + " entries to " + this.history_file);
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
        }
    }

    protected LinkedList loadLimits(Map map, String string) {
        LinkedList<limitEstimate> linkedList = new LinkedList<limitEstimate>();
        List list = (List)map.get(string);
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                Map map2 = (Map)list.get(i);
                linkedList.add(this.loadLimit(map2));
            }
        }
        return linkedList;
    }

    protected limitEstimate loadLimit(Map map) {
        if (map == null) {
            return this.getNullLimit();
        }
        int n = ((Long)map.get("s")).intValue();
        double d = Double.parseDouble(new String((byte[])map.get("m")));
        int n2 = ((Long)map.get("h")).intValue();
        long l = (Long)map.get("w");
        byte[] byArray = (byte[])map.get("t");
        double d2 = byArray == null ? 0.0 : Double.parseDouble(new String(byArray));
        return new limitEstimate(n, d2, d, n2, l, new int[0][]);
    }

    protected void saveLimits(Map map, String string, List list) {
        ArrayList<Map> arrayList = new ArrayList<Map>();
        for (int i = 0; i < list.size(); ++i) {
            limitEstimate limitEstimate2 = (limitEstimate)list.get(i);
            Map map2 = this.saveLimit(limitEstimate2);
            arrayList.add(map2);
        }
        map.put(string, arrayList);
    }

    protected Map saveLimit(limitEstimate limitEstimate2) {
        if (limitEstimate2 == null) {
            limitEstimate2 = this.getNullLimit();
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("s", new Long(limitEstimate2.getBytesPerSec()));
        hashMap.put("m", String.valueOf(limitEstimate2.getMetricRating()));
        hashMap.put("t", String.valueOf(limitEstimate2.getEstimateType()));
        hashMap.put("h", new Long(limitEstimate2.getHits()));
        hashMap.put("w", new Long(limitEstimate2.getWhen()));
        return hashMap;
    }

    @Override
    public boolean isActive() {
        return this.variance;
    }

    protected limitEstimate getNullLimit() {
        return new limitEstimate(0, -0.1f, 0.0, 0, 0L, new int[0][]);
    }

    protected String getLimitString(List list) {
        String string = "";
        for (int i = 0; i < list.size(); ++i) {
            string = string + (i == 0 ? "" : ",") + ((limitEstimate)list.get(i)).getString();
        }
        return string;
    }

    protected void log(String string) {
        if (this.speed_manager != null) {
            this.speed_manager.log(string);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected synchronized void addSpeed(int n, int n2) {
        n2 /= 256;
        if ((n /= 256) > 65535) {
            n = 65535;
        }
        if (n2 > 65535) {
            n2 = 65535;
        }
        this.addSpeedSupport(n, n2);
    }

    protected synchronized void addSpeedSupport(int n, int n2) {
        this.x_speeds[this.speeds_next] = n;
        this.y_speeds[this.speeds_next] = n2;
        this.speeds_next = (this.speeds_next + 1) % 60;
        int n3 = Integer.MAX_VALUE;
        int n4 = Integer.MAX_VALUE;
        for (int i = 0; i < 60; ++i) {
            n3 = Math.min(n3, this.x_speeds[i]);
            n4 = Math.min(n4, this.y_speeds[i]);
        }
        n4 *= 256;
        if (this.up_capacity.getEstimateType() != 1.0f && (n3 *= 256) > this.up_capacity.getBytesPerSec()) {
            this.up_capacity.setBytesPerSec(n3);
            this.up_capacity.setMetricRating(0.0f);
            this.up_capacity.setEstimateType(0.0f);
            this.speed_manager.informUpCapChanged();
        }
        if (this.down_capacity.getEstimateType() != 1.0f && n4 > this.down_capacity.getBytesPerSec()) {
            this.down_capacity.setBytesPerSec(n4);
            this.down_capacity.setMetricRating(0.0f);
            this.down_capacity.setEstimateType(0.0f);
            this.speed_manager.informDownCapChanged();
        }
    }

    protected synchronized void addPing(int n, int n2, int n3, boolean bl) {
        int n4;
        n2 /= 256;
        if ((n /= 256) > 65535) {
            n = 65535;
        }
        if (n2 > 65535) {
            n2 = 65535;
        }
        if (n3 > 65535) {
            int n5 = n3 = this.variance ? 1500 : 30000;
        }
        if (n3 == 0) {
            n3 = 1;
        }
        int n6 = (n + this.last_x) / 2;
        int n7 = (n2 + this.last_y) / 2;
        this.last_x = n;
        this.last_y = n2;
        n = n6;
        n2 = n7;
        if (this.variance) {
            if (bl) {
                this.log("Re-based variance");
                this.recent_metrics_next = 0;
            }
            this.recent_metrics[this.recent_metrics_next++ % this.recent_metrics.length] = n3;
            int n8 = 0;
            int n9 = 0;
            if (this.recent_metrics_next > 1) {
                int n10;
                int n11;
                int n12;
                int n13 = Math.min(this.recent_metrics_next, this.recent_metrics.length);
                int n14 = 0;
                for (n12 = 0; n12 < n13; ++n12) {
                    n14 += this.recent_metrics[n12];
                }
                n12 = n14 / n13;
                int n15 = 0;
                for (n11 = 0; n11 < n13; ++n11) {
                    n10 = this.recent_metrics[n11] - n12;
                    n15 += n10 * n10;
                }
                n8 = (int)Math.sqrt(n15);
                if (n13 == this.recent_metrics.length) {
                    n11 = 0;
                    for (n10 = 0; n10 < n13; ++n10) {
                        n11 += this.recent_metrics[n10];
                    }
                    n10 = n11 / this.recent_metrics.length;
                    if (n10 >= 500) {
                        n9 = 150;
                    } else if (n10 > 350) {
                        int n16 = 150;
                        int n17 = n10 - 350;
                        n9 = 50 + 100 * n17 / n16;
                    }
                }
            }
            if ((n4 = Math.max(n8, n9)) < 150) {
                this.addSpeedSupport(n, n2);
            } else {
                this.addSpeedSupport(0, 0);
            }
        } else {
            n4 = n3;
        }
        region region2 = this.addPingSupport(n, n2, n3, n4);
        this.updateLimitEstimates();
        if (this.variance) {
            String string = this.getShortString(this.getEstimatedUploadLimit(false)) + "," + this.getShortString(this.getEstimatedUploadLimit(true)) + "," + this.getShortString(this.getEstimatedUploadCapacityBytesPerSec());
            String string2 = this.getShortString(this.getEstimatedDownloadLimit(false)) + "," + this.getShortString(this.getEstimatedDownloadLimit(true)) + "," + this.getShortString(this.getEstimatedDownloadCapacityBytesPerSec());
            this.log("Ping: rtt=" + n3 + ",x=" + n + ",y=" + n2 + ",m=" + n4 + (region2 == null ? "" : ",region=" + region2.getString()) + ",mr=" + this.getCurrentMetricRating() + ",up=[" + string + (this.best_good_up == null ? "" : ":" + this.getShortString(this.best_good_up)) + "],down=[" + string2 + (this.best_good_down == null ? "" : ":" + this.getShortString(this.best_good_down)) + "]" + ",bu=" + this.getLimitStr(this.last_bad_ups, true) + ",bd=" + this.getLimitStr(this.last_bad_downs, true));
        }
    }

    protected region addPingSupport(int n, int n2, int n3, int n4) {
        if (this.ping_count == this.pings.length) {
            int n5 = this.pings.length / 10;
            if (n5 < 3) {
                n5 = 3;
            }
            this.ping_count = this.pings.length - n5;
            System.arraycopy(this.pings, n5, this.pings, 0, this.ping_count);
            for (int i = 0; i < n5; ++i) {
                this.regions.removeFirst();
            }
        }
        pingValue pingValue2 = new pingValue(n, n2, n4);
        this.pings[this.ping_count++] = pingValue2;
        region region2 = null;
        if (this.prev_ping != null) {
            region2 = new region(this.prev_ping, pingValue2);
            this.regions.add(region2);
        }
        this.prev_ping = pingValue2;
        return region2;
    }

    @Override
    public synchronized int[][] getHistory() {
        int[][] nArrayArray = new int[this.ping_count][];
        for (int i = 0; i < this.ping_count; ++i) {
            pingValue pingValue2 = this.pings[i];
            nArrayArray[i] = new int[]{256 * pingValue2.getX(), 256 * pingValue2.getY(), pingValue2.getMetric()};
        }
        return nArrayArray;
    }

    @Override
    public synchronized SpeedManagerPingZone[] getZones() {
        return this.regions.toArray(new SpeedManagerPingZone[this.regions.size()]);
    }

    @Override
    public synchronized SpeedManagerLimitEstimate getEstimatedUploadLimit(boolean bl) {
        return this.adjustForPersistence(this.up_estimate, this.best_good_up, this.last_bad_up, bl);
    }

    @Override
    public synchronized SpeedManagerLimitEstimate getEstimatedDownloadLimit(boolean bl) {
        return this.adjustForPersistence(this.down_estimate, this.best_good_down, this.last_bad_down, bl);
    }

    @Override
    public SpeedManagerLimitEstimate getLastBadUploadLimit() {
        return this.last_bad_up;
    }

    @Override
    public SpeedManagerLimitEstimate getLastBadDownloadLimit() {
        return this.last_bad_down;
    }

    @Override
    public synchronized SpeedManagerLimitEstimate[] getBadUploadHistory() {
        return this.last_bad_ups.toArray(new SpeedManagerLimitEstimate[this.last_bad_ups.size()]);
    }

    @Override
    public synchronized SpeedManagerLimitEstimate[] getBadDownloadHistory() {
        return this.last_bad_downs.toArray(new SpeedManagerLimitEstimate[this.last_bad_downs.size()]);
    }

    protected SpeedManagerLimitEstimate adjustForPersistence(limitEstimate limitEstimate2, limitEstimate limitEstimate3, limitEstimate limitEstimate4, boolean bl) {
        if (limitEstimate2 == null) {
            return null;
        }
        if (bl) {
            if (limitEstimate2.getMetricRating() == -1.0f) {
                return limitEstimate2;
            }
            limitEstimate limitEstimate5 = null;
            if (limitEstimate3 != null && limitEstimate4 != null) {
                limitEstimate5 = limitEstimate4.getWhen() > limitEstimate3.getWhen() ? limitEstimate4 : (limitEstimate3.getBytesPerSec() > limitEstimate4.getBytesPerSec() ? limitEstimate3 : limitEstimate4);
            } else if (limitEstimate3 != null) {
                limitEstimate5 = limitEstimate3;
            } else if (limitEstimate4 != null) {
                limitEstimate5 = limitEstimate4;
            }
            if (limitEstimate5 == null) {
                return limitEstimate2;
            }
            if (limitEstimate2.getBytesPerSec() > limitEstimate5.getBytesPerSec()) {
                return limitEstimate2;
            }
            limitEstimate limitEstimate6 = limitEstimate2.getClone();
            limitEstimate6.setBytesPerSec(limitEstimate5.getBytesPerSec());
            return limitEstimate6;
        }
        return limitEstimate2;
    }

    protected void updateLimitEstimates() {
        double d;
        double d2 = this.getCurrentMetricRating();
        this.up_estimate = this.getEstimatedLimit(true);
        if (this.up_estimate != null) {
            d = this.up_estimate.getMetricRating();
            if (d == -1.0) {
                if (this.bad_up_in_progress_count == 0 && (this.last_bad_up == null || this.last_bad_up.getBytesPerSec() != this.up_estimate.getBytesPerSec())) {
                    this.bad_up_in_progress_count = 5;
                    this.last_bad_ups.addLast(this.up_estimate);
                    if (this.last_bad_ups.size() > 16) {
                        this.last_bad_ups.removeFirst();
                    }
                    this.checkCapacityDecrease(true, this.up_capacity, this.last_bad_ups);
                }
                this.last_bad_up = this.up_estimate;
            } else if (d == 1.0) {
                if (this.best_good_up == null) {
                    this.best_good_up = this.up_estimate;
                } else if (this.best_good_up.getBytesPerSec() < this.up_estimate.getBytesPerSec()) {
                    this.best_good_up = this.up_estimate;
                }
            }
            if (this.bad_up_in_progress_count > 0) {
                if (d2 == -1.0) {
                    this.bad_up_in_progress_count = 5;
                } else if (d2 == 1.0) {
                    --this.bad_up_in_progress_count;
                }
            }
        }
        this.down_estimate = this.getEstimatedLimit(false);
        if (this.down_estimate != null) {
            d = this.down_estimate.getMetricRating();
            if (d == -1.0) {
                if (this.bad_down_in_progress_count == 0 && (this.last_bad_down == null || this.last_bad_down.getBytesPerSec() != this.down_estimate.getBytesPerSec())) {
                    this.bad_down_in_progress_count = 5;
                    this.last_bad_downs.addLast(this.down_estimate);
                    if (this.last_bad_downs.size() > 16) {
                        this.last_bad_downs.removeFirst();
                    }
                    this.checkCapacityDecrease(false, this.down_capacity, this.last_bad_downs);
                }
                this.last_bad_down = this.down_estimate;
            } else if (d == 1.0) {
                if (this.best_good_down == null) {
                    this.best_good_down = this.down_estimate;
                } else if (this.best_good_down.getBytesPerSec() < this.down_estimate.getBytesPerSec()) {
                    this.best_good_down = this.down_estimate;
                }
            }
            if (this.bad_down_in_progress_count > 0) {
                if (d2 == -1.0) {
                    this.bad_down_in_progress_count = 5;
                } else if (d2 == 1.0) {
                    --this.bad_down_in_progress_count;
                }
            }
        }
    }

    protected void checkCapacityDecrease(boolean bl, limitEstimate limitEstimate2, LinkedList linkedList) {
        int n;
        int n2;
        int n3;
        int n4;
        if (limitEstimate2.getEstimateType() == 1.0f) {
            return;
        }
        if (linkedList.size() < 16) {
            return;
        }
        int n5 = limitEstimate2.getBytesPerSec();
        if (n5 > 0 && n5 < 10240) {
            return;
        }
        ArrayList arrayList = new ArrayList(linkedList);
        Collections.sort(arrayList, new Comparator(){

            public int compare(Object object, Object object2) {
                limitEstimate limitEstimate2 = (limitEstimate)object;
                limitEstimate limitEstimate3 = (limitEstimate)object2;
                return limitEstimate2.getBytesPerSec() - limitEstimate3.getBytesPerSec();
            }
        });
        int n6 = 4;
        int n7 = 16 - n6;
        int n8 = 0;
        int n9 = 0;
        for (n4 = n6; n4 < n7; ++n4) {
            n3 = ((limitEstimate)arrayList.get(n4)).getBytesPerSec();
            n8 += n3;
            ++n9;
        }
        n4 = n8 / n9;
        if (n5 > 0 && n4 >= n5) {
            this.log("Not reducing " + (bl ? "up" : "down") + " capacity - average=" + DisplayFormatters.formatByteCountToKiBEtcPerSec(n4) + ",capacity=" + DisplayFormatters.formatByteCountToKiBEtcPerSec(n5));
            return;
        }
        n3 = 0;
        for (n2 = n6; n2 < n7; ++n2) {
            n = ((limitEstimate)arrayList.get(n2)).getBytesPerSec();
            int n10 = n - n4;
            n3 += n10 * n10;
        }
        n2 = (int)Math.sqrt(n3 / n9);
        if (n5 <= 0 || n2 < n5 / 2 && n4 < n5) {
            this.log("Reducing " + (bl ? "up" : "down") + " capacity from " + n5 + " to " + n4 + " due to frequent lower chokes (deviation=" + DisplayFormatters.formatByteCountToKiBEtcPerSec(n2) + ")");
            limitEstimate2.setBytesPerSec(n4);
            limitEstimate2.setEstimateType(0.5f);
            for (n = 0; n < n6; ++n) {
                linkedList.removeFirst();
            }
        } else {
            this.log("Not reducing " + (bl ? "up" : "down") + " capacity - deviation=" + DisplayFormatters.formatByteCountToKiBEtcPerSec(n2) + ",capacity=" + DisplayFormatters.formatByteCountToKiBEtcPerSec(n5));
        }
    }

    protected synchronized limitEstimate getEstimatedLimit(boolean bl) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        if (!this.variance) {
            return this.getNullLimit();
        }
        int n11 = this.regions.size();
        if (n11 == 0) {
            return this.getNullLimit();
        }
        Iterator iterator = this.regions.iterator();
        int n12 = 0;
        while (iterator.hasNext()) {
            region region2 = (region)iterator.next();
            int n13 = (bl ? region2.getUploadEndBytesPerSec() : region2.getDownloadEndBytesPerSec()) / 256;
            if (n13 <= n12) continue;
            n12 = n13;
        }
        int n14 = n12 + 1;
        int[] nArray = new int[n14];
        short[] sArray = new short[n14];
        short[] sArray2 = new short[n14];
        ListIterator listIterator = this.regions.listIterator(0);
        while (listIterator.hasNext()) {
            int n15;
            region region3 = (region)listIterator.next();
            n10 = (bl ? region3.getUploadStartBytesPerSec() : region3.getDownloadStartBytesPerSec()) / 256;
            n9 = (bl ? region3.getUploadEndBytesPerSec() : region3.getDownloadEndBytesPerSec()) / 256;
            n8 = region3.getMetric();
            if (n8 < 50) {
                n7 = 0;
                n15 = n9;
                n6 = 0;
            } else if (n8 < 150) {
                n7 = n10;
                n15 = n9;
                n6 = 50;
            } else {
                n7 = n10;
                n15 = n12;
                n6 = 150;
            }
            n5 = n7;
            while (n5 <= n15) {
                if (n6 == 150 && sArray2[n5] <= n6) {
                    nArray[n5] = 0;
                    sArray[n5] = 0;
                    sArray2[n5] = n6;
                }
                int n16 = n5;
                nArray[n16] = nArray[n16] + n8;
                int n17 = n5++;
                sArray[n17] = (short)(sArray[n17] + 1);
            }
        }
        for (n4 = 0; n4 < n14; ++n4) {
            n10 = sArray[n4];
            if (n10 <= 0) continue;
            nArray[n4] = n9 = nArray[n4] / n10;
            sArray2[n4] = n9 < 50 ? 0 : (n9 < 150 ? 50 : 150);
        }
        n4 = -1;
        n10 = 0;
        n9 = 0;
        n8 = 0;
        n7 = 0;
        ArrayList<int[]> arrayList = new ArrayList<int[]>(nArray.length);
        for (n6 = 0; n6 < n14; ++n6) {
            n5 = sArray2[n6];
            n3 = sArray[n6];
            if (n5 > n7) {
                n7 = n5;
            }
            int n18 = nArray[n6];
            if (n6 == 0) {
                n4 = n18;
                continue;
            }
            if (n4 != n18) {
                arrayList.add(new int[]{n4, n10 * 256, (n6 - 1) * 256, n9, n8});
                n4 = n18;
                n10 = n6;
                n9 = n5;
                n8 = n3;
                continue;
            }
            n9 = Math.max(n5, n9);
            n8 = Math.max(n3, n8);
        }
        if (n10 != n14 - 1) {
            arrayList.add(new int[]{n4, n10 * 256, (n14 - 1) * 256, n9, n8});
        }
        int[] nArray2 = null;
        n5 = 0;
        if (n7 == 150) {
            for (n3 = arrayList.size() - 1; n3 >= 0; --n3) {
                int[] nArray3 = (int[])arrayList.get(n3);
                n2 = nArray3[3];
                if (n2 < n7) continue;
                nArray2 = nArray3;
                n5 = n2;
            }
        } else {
            for (n3 = 0; n3 < arrayList.size(); ++n3) {
                int[] nArray4 = (int[])arrayList.get(n3);
                n2 = nArray4[3];
                if (n2 < n7) continue;
                nArray2 = nArray4;
                n5 = n2;
            }
        }
        if (nArray2 == null) {
            n3 = -1;
            n = 0;
        } else {
            n3 = -1;
            n3 = n7 == 0 ? nArray2[2] : (n7 == 50 ? (nArray2[1] + nArray2[2]) / 2 : nArray2[1]);
            n = nArray2[4];
        }
        if (n3 < 5120) {
            n5 = 50;
            if (n3 <= 0) {
                n3 = 1;
            }
        }
        limitEstimate limitEstimate2 = new limitEstimate(n3, 0.0, this.convertMetricToRating(n5), n, SystemTime.getCurrentTime(), (int[][])arrayList.toArray((T[])new int[arrayList.size()][]));
        return limitEstimate2;
    }

    @Override
    public synchronized double getCurrentMetricRating() {
        if (this.ping_count == 0) {
            return 0.0;
        }
        int n = this.pings[this.ping_count - 1].getMetric();
        if (this.variance) {
            return this.convertMetricToRating(n);
        }
        return 0.0;
    }

    public SpeedManagerLimitEstimate getEstimatedUploadCapacityBytesPerSec() {
        return this.up_capacity;
    }

    public void setEstimatedDownloadCapacityBytesPerSec(int n, float f) {
        if (this.down_capacity.getBytesPerSec() != n || this.down_capacity.getEstimateType() != f) {
            this.down_capacity.setBytesPerSec(n);
            this.down_capacity.setEstimateType(f);
            this.speed_manager.informDownCapChanged();
        }
    }

    public SpeedManagerLimitEstimate getEstimatedDownloadCapacityBytesPerSec() {
        return this.down_capacity;
    }

    public void setEstimatedUploadCapacityBytesPerSec(int n, float f) {
        if (this.up_capacity.getBytesPerSec() != n || this.up_capacity.getEstimateType() != f) {
            this.up_capacity.setBytesPerSec(n);
            this.up_capacity.setEstimateType(f);
            this.speed_manager.informUpCapChanged();
        }
    }

    protected synchronized void reset() {
        this.setEstimatedDownloadCapacityBytesPerSec(0, -0.1f);
        this.setEstimatedUploadCapacityBytesPerSec(0, -0.1f);
        this.ping_count = 0;
        this.regions.clear();
        this.last_bad_down = null;
        this.last_bad_downs.clear();
        this.last_bad_up = null;
        this.last_bad_ups.clear();
        this.saveHistory();
    }

    protected double convertMetricToRating(int n) {
        if (n < 50) {
            return 1.0;
        }
        if (n >= 150) {
            return -1.0;
        }
        double d = 1.0 - ((double)n - 50.0) / 50.0;
        if (d < -1.0) {
            d = -1.0;
        } else if (d > 1.0) {
            d = 1.0;
        }
        return d;
    }

    protected String getLimitStr(List list, boolean bl) {
        String string = "";
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                string = string + (string.length() == 0 ? "" : ",");
                limitEstimate limitEstimate2 = (limitEstimate)iterator.next();
                if (bl) {
                    string = string + this.getShortString(limitEstimate2);
                    continue;
                }
                string = string + limitEstimate2.getString();
            }
        }
        return string;
    }

    protected String getShortString(SpeedManagerLimitEstimate speedManagerLimitEstimate) {
        return DisplayFormatters.formatByteCountToKiBEtcPerSec(speedManagerLimitEstimate.getBytesPerSec());
    }

    protected void generateEvidence(IndentWriter indentWriter) {
        indentWriter.println("up_cap=" + this.up_capacity.getString());
        indentWriter.println("down_cap=" + this.down_capacity.getString());
        indentWriter.println("bad_up=" + this.getLimitStr(this.last_bad_ups, false));
        indentWriter.println("bad_down=" + this.getLimitStr(this.last_bad_downs, false));
        if (this.best_good_up != null) {
            indentWriter.println("best_up=" + this.best_good_up.getString());
        }
        if (this.best_good_down != null) {
            indentWriter.println("best_down=" + this.best_good_down.getString());
        }
    }

    @Override
    public void destroy() {
        if (this.trans) {
            this.speed_manager.destroy(this);
        } else {
            Debug.out("Attempt to destroy non-transient mapper!");
        }
    }

    public static void main(String[] stringArray) {
        SpeedManagerPingMapperImpl speedManagerPingMapperImpl = new SpeedManagerPingMapperImpl(null, "test", 100, true, false);
        Random random = new Random();
        int[][] nArrayArray = new int[][]{{50, 0, 100000, 50}, {50, 100000, 200000, 200}, {50, 50000, 50000, 200}, {50, 0, 100000, 50}};
        for (int i = 0; i < nArrayArray.length; ++i) {
            int[] nArray = nArrayArray[i];
            System.out.println("**** phase " + i);
            for (int j = 0; j < nArray[0]; ++j) {
                int n = nArray[1];
                int n2 = nArray[2];
                int n3 = nArray[3];
                speedManagerPingMapperImpl.addPing(n + random.nextInt(n2), n + random.nextInt(n2), random.nextInt(n3), false);
                SpeedManagerLimitEstimate speedManagerLimitEstimate = speedManagerPingMapperImpl.getEstimatedUploadLimit(false);
                SpeedManagerLimitEstimate speedManagerLimitEstimate2 = speedManagerPingMapperImpl.getEstimatedDownloadLimit(false);
                if (speedManagerLimitEstimate == null || speedManagerLimitEstimate2 == null) continue;
                System.out.println(speedManagerLimitEstimate.getString() + "," + speedManagerLimitEstimate2.getString());
            }
        }
    }

    class limitEstimate
    implements SpeedManagerLimitEstimate,
    Cloneable {
        private int speed;
        private float estimate_type;
        private float metric_rating;
        private long when;
        private int hits;
        private int[][] segs;

        protected limitEstimate(int n, double d, double d2, int n2, long l, int[][] nArray) {
            this.speed = n;
            this.estimate_type = (float)d;
            this.metric_rating = (float)d2;
            this.hits = n2;
            this.when = l;
            this.segs = nArray;
            if (this.metric_rating < -1.0f) {
                this.metric_rating = -1.0f;
            } else if (this.metric_rating > 1.0f) {
                this.metric_rating = 1.0f;
            }
        }

        @Override
        public int getBytesPerSec() {
            return this.speed;
        }

        protected void setBytesPerSec(int n) {
            this.speed = n;
        }

        @Override
        public float getEstimateType() {
            return this.estimate_type;
        }

        public void setEstimateType(float f) {
            this.estimate_type = f;
        }

        @Override
        public float getMetricRating() {
            return this.metric_rating;
        }

        protected void setMetricRating(float f) {
            this.metric_rating = f;
        }

        @Override
        public int[][] getSegments() {
            return this.segs;
        }

        protected int getHits() {
            return this.hits;
        }

        @Override
        public long getWhen() {
            return this.when;
        }

        public limitEstimate getClone() {
            try {
                return (limitEstimate)this.clone();
            }
            catch (Throwable throwable) {
                return null;
            }
        }

        @Override
        public String getString() {
            return "speed=" + DisplayFormatters.formatByteCountToKiBEtc(this.speed) + ",metric=" + this.metric_rating + ",segs=" + this.segs.length + ",hits=" + this.hits + ",when=" + this.when;
        }
    }

    class region
    implements SpeedManagerPingZone {
        private short x1;
        private short y1;
        private short x2;
        private short y2;
        private short metric;

        protected region(pingValue pingValue2, pingValue pingValue3) {
            short s;
            this.x1 = (short)pingValue2.getX();
            this.y1 = (short)pingValue2.getY();
            this.x2 = (short)pingValue3.getX();
            this.y2 = (short)pingValue3.getY();
            if (this.x2 < this.x1) {
                s = this.x1;
                this.x1 = this.x2;
                this.x2 = s;
            }
            if (this.y2 < this.y1) {
                s = this.y1;
                this.y1 = this.y2;
                this.y2 = s;
            }
            this.metric = (short)((pingValue2.getMetric() + pingValue3.getMetric()) / 2);
        }

        public int getX1() {
            return this.x1 & 0xFFFF;
        }

        public int getY1() {
            return this.y1 & 0xFFFF;
        }

        public int getX2() {
            return this.x2 & 0xFFFF;
        }

        public int getY2() {
            return this.y2 & 0xFFFF;
        }

        @Override
        public int getUploadStartBytesPerSec() {
            return this.getX1() * 256;
        }

        @Override
        public int getUploadEndBytesPerSec() {
            return this.getX2() * 256 + 255;
        }

        @Override
        public int getDownloadStartBytesPerSec() {
            return this.getY1() * 256;
        }

        @Override
        public int getDownloadEndBytesPerSec() {
            return this.getY2() * 256 + 255;
        }

        @Override
        public int getMetric() {
            return this.metric & 0xFFFF;
        }

        public String getString() {
            return "x=" + this.getX1() + ",y=" + this.getY1() + ",w=" + (this.getX2() - this.getX1() + 1) + ",h=" + (this.getY2() - this.getY1() + 1);
        }
    }

    class pingValue {
        private short x;
        private short y;
        private short metric;

        protected pingValue(int n, int n2, int n3) {
            this.x = (short)n;
            this.y = (short)n2;
            this.metric = (short)n3;
        }

        protected int getX() {
            return this.x & 0xFFFF;
        }

        protected int getY() {
            return this.y & 0xFFFF;
        }

        protected int getMetric() {
            return this.metric & 0xFFFF;
        }

        protected String getString() {
            return "x=" + this.getX() + ",y=" + this.getY() + ",m=" + this.getMetric();
        }
    }
}

