/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.proxy.socks.impl;

import com.aelitis.azureus.core.networkmanager.admin.NetworkAdmin;
import com.aelitis.azureus.core.proxy.AEProxyConnection;
import com.aelitis.azureus.core.proxy.socks.AESocksProxy;
import com.aelitis.azureus.core.proxy.socks.AESocksProxyAddress;
import com.aelitis.azureus.core.proxy.socks.AESocksProxyConnection;
import com.aelitis.azureus.core.proxy.socks.AESocksProxyPlugableConnection;
import com.aelitis.azureus.core.proxy.socks.impl.AESocksProxyState;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.DirectByteBufferPool;

public class AESocksProxyPlugableConnectionDefault
implements AESocksProxyPlugableConnection {
    protected AESocksProxyConnection socks_connection;
    protected AEProxyConnection connection;
    protected SocketChannel source_channel;
    protected SocketChannel target_channel;
    protected proxyStateRelayData relay_data_state;

    public AESocksProxyPlugableConnectionDefault(AESocksProxyConnection aESocksProxyConnection) {
        this.socks_connection = aESocksProxyConnection;
        this.connection = this.socks_connection.getConnection();
        this.source_channel = this.connection.getSourceChannel();
    }

    @Override
    public String getName() {
        if (this.target_channel != null) {
            return this.target_channel.socket().getInetAddress() + ":" + this.target_channel.socket().getPort();
        }
        return "";
    }

    @Override
    public InetAddress getLocalAddress() {
        return this.target_channel.socket().getInetAddress();
    }

    @Override
    public int getLocalPort() {
        return this.target_channel.socket().getPort();
    }

    @Override
    public void connect(AESocksProxyAddress aESocksProxyAddress) throws IOException {
        if (aESocksProxyAddress.getAddress() == null) {
            throw new IOException("DNS lookup of '" + aESocksProxyAddress.getUnresolvedAddress() + "' fails");
        }
        new proxyStateRelayConnect(new InetSocketAddress(aESocksProxyAddress.getAddress(), aESocksProxyAddress.getPort()));
    }

    @Override
    public void relayData() throws IOException {
        new proxyStateRelayData();
    }

    @Override
    public void close() {
        if (this.target_channel != null) {
            try {
                this.connection.cancelReadSelect(this.target_channel);
                this.connection.cancelWriteSelect(this.target_channel);
                this.target_channel.close();
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
        if (this.relay_data_state != null) {
            this.relay_data_state.destroy();
        }
    }

    protected class proxyStateRelayData
    extends AESocksProxyState {
        protected DirectByteBuffer source_buffer;
        protected DirectByteBuffer target_buffer;
        protected long outward_bytes;
        protected long inward_bytes;

        protected proxyStateRelayData() throws IOException {
            super(AESocksProxyPlugableConnectionDefault.this.socks_connection);
            this.outward_bytes = 0L;
            this.inward_bytes = 0L;
            this.source_buffer = DirectByteBufferPool.getBuffer((byte)11, 1024);
            this.target_buffer = DirectByteBufferPool.getBuffer((byte)11, 1024);
            AESocksProxyPlugableConnectionDefault.this.relay_data_state = this;
            if (AESocksProxyPlugableConnectionDefault.this.connection.isClosed()) {
                this.destroy();
                throw new IOException("connection closed");
            }
            AESocksProxyPlugableConnectionDefault.this.connection.setReadState(this);
            AESocksProxyPlugableConnectionDefault.this.connection.setWriteState(this);
            AESocksProxyPlugableConnectionDefault.this.connection.requestReadSelect(AESocksProxyPlugableConnectionDefault.this.source_channel);
            AESocksProxyPlugableConnectionDefault.this.connection.requestReadSelect(AESocksProxyPlugableConnectionDefault.this.target_channel);
            AESocksProxyPlugableConnectionDefault.this.connection.setConnected();
        }

        protected void destroy() {
            if (this.source_buffer != null) {
                this.source_buffer.returnToPool();
                this.source_buffer = null;
            }
            if (this.target_buffer != null) {
                this.target_buffer.returnToPool();
                this.target_buffer = null;
            }
        }

        @Override
        protected boolean readSupport(SocketChannel socketChannel) throws IOException {
            AESocksProxyPlugableConnectionDefault.this.connection.setTimeStamp();
            SocketChannel socketChannel2 = socketChannel;
            SocketChannel socketChannel3 = socketChannel == AESocksProxyPlugableConnectionDefault.this.source_channel ? AESocksProxyPlugableConnectionDefault.this.target_channel : AESocksProxyPlugableConnectionDefault.this.source_channel;
            DirectByteBuffer directByteBuffer = socketChannel == AESocksProxyPlugableConnectionDefault.this.source_channel ? this.source_buffer : this.target_buffer;
            int n = directByteBuffer.read((byte)10, socketChannel2);
            if (n == -1) {
                AESocksProxyPlugableConnectionDefault.this.connection.close();
            } else if (directByteBuffer.position((byte)10) > 0) {
                directByteBuffer.flip((byte)10);
                int n2 = directByteBuffer.write((byte)10, socketChannel3);
                if (socketChannel2 == AESocksProxyPlugableConnectionDefault.this.source_channel) {
                    this.outward_bytes += (long)n2;
                } else {
                    this.inward_bytes += (long)n2;
                }
                if (directByteBuffer.hasRemaining((byte)10)) {
                    AESocksProxyPlugableConnectionDefault.this.connection.cancelReadSelect(socketChannel2);
                    AESocksProxyPlugableConnectionDefault.this.connection.requestWriteSelect(socketChannel3);
                } else {
                    directByteBuffer.position((byte)10, 0);
                    directByteBuffer.limit((byte)10, directByteBuffer.capacity((byte)10));
                }
            }
            return n > 0;
        }

        @Override
        protected boolean writeSupport(SocketChannel socketChannel) throws IOException {
            SocketChannel socketChannel2 = socketChannel;
            SocketChannel socketChannel3 = socketChannel == AESocksProxyPlugableConnectionDefault.this.source_channel ? AESocksProxyPlugableConnectionDefault.this.target_channel : AESocksProxyPlugableConnectionDefault.this.source_channel;
            DirectByteBuffer directByteBuffer = socketChannel == AESocksProxyPlugableConnectionDefault.this.source_channel ? this.target_buffer : this.source_buffer;
            int n = directByteBuffer.write((byte)10, socketChannel2);
            if (socketChannel2 == AESocksProxyPlugableConnectionDefault.this.target_channel) {
                this.outward_bytes += (long)n;
            } else {
                this.inward_bytes += (long)n;
            }
            if (directByteBuffer.hasRemaining((byte)10)) {
                AESocksProxyPlugableConnectionDefault.this.connection.requestWriteSelect(socketChannel2);
            } else {
                directByteBuffer.position((byte)10, 0);
                directByteBuffer.limit((byte)10, directByteBuffer.capacity((byte)10));
                AESocksProxyPlugableConnectionDefault.this.connection.requestReadSelect(socketChannel3);
            }
            return n > 0;
        }

        @Override
        public String getStateName() {
            String string = this.getClass().getName();
            int n = string.indexOf("$");
            string = string.substring(n + 1);
            return string + " [out=" + this.outward_bytes + ",in=" + this.inward_bytes + "] " + this.source_buffer + " / " + this.target_buffer;
        }
    }

    protected class proxyStateRelayConnect
    extends AESocksProxyState {
        protected InetSocketAddress address;

        protected proxyStateRelayConnect(InetSocketAddress inetSocketAddress) throws IOException {
            super(AESocksProxyPlugableConnectionDefault.this.socks_connection);
            this.address = inetSocketAddress;
            AESocksProxyPlugableConnectionDefault.this.connection.cancelReadSelect(AESocksProxyPlugableConnectionDefault.this.source_channel);
            AESocksProxyPlugableConnectionDefault.this.connection.setConnectState(this);
            AESocksProxyPlugableConnectionDefault.this.target_channel = SocketChannel.open();
            InetAddress inetAddress = NetworkAdmin.getSingleton().getMultiHomedOutgoingRoundRobinBindAddress(this.address.getAddress());
            if (inetAddress != null) {
                AESocksProxyPlugableConnectionDefault.this.target_channel.socket().bind(new InetSocketAddress(inetAddress, 0));
            }
            AESocksProxyPlugableConnectionDefault.this.target_channel.configureBlocking(false);
            AESocksProxyPlugableConnectionDefault.this.target_channel.connect(this.address);
            AESocksProxyPlugableConnectionDefault.this.connection.requestConnectSelect(AESocksProxyPlugableConnectionDefault.this.target_channel);
        }

        @Override
        protected boolean connectSupport(SocketChannel socketChannel) throws IOException {
            if (!socketChannel.finishConnect()) {
                throw new IOException("finishConnect returned false");
            }
            AESocksProxy aESocksProxy = AESocksProxyPlugableConnectionDefault.this.socks_connection.getProxy();
            if (aESocksProxy.getNextSOCKSProxyHost() != null) {
                // empty if block
            }
            AESocksProxyPlugableConnectionDefault.this.socks_connection.connected();
            return true;
        }
    }
}

