/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.uploadslots;

import com.aelitis.azureus.core.peermanager.uploadslots.UploadHelper;
import com.aelitis.azureus.core.peermanager.uploadslots.UploadSession;
import com.aelitis.azureus.core.peermanager.uploadslots.UploadSessionPicker;
import com.aelitis.azureus.core.peermanager.uploadslots.UploadSlot;
import java.util.LinkedList;

public class UploadSlotManager {
    private static final int EXPIRE_NORMAL = 1;
    private static final int EXPIRE_OPTIMISTIC = 3;
    private static final int EXPIRE_SEED = 6;
    public static final boolean AUTO_SLOT_ENABLE = false;
    private long last_process_time;
    private static final UploadSlotManager instance = new UploadSlotManager();
    private final UploadSessionPicker picker = new UploadSessionPicker();
    private final UploadSlot[] slots = new UploadSlot[]{new UploadSlot(1), new UploadSlot(0), new UploadSlot(0), new UploadSlot(0)};
    private long current_round = 0L;
    int count = 0;

    public static UploadSlotManager getSingleton() {
        return instance;
    }

    private UploadSlotManager() {
    }

    public void registerHelper(UploadHelper uploadHelper) {
    }

    public void deregisterHelper(UploadHelper uploadHelper) {
    }

    public void updateHelper(UploadHelper uploadHelper) {
    }

    private void process() {
    }

    private UploadSession getNextBestSession(LinkedList linkedList) {
        ++this.count;
        System.out.print("getNextBestSession [" + this.count + "] best.size=" + linkedList.size() + "  ");
        if (!linkedList.isEmpty()) {
            UploadSession uploadSession = (UploadSession)linkedList.removeFirst();
            if (!this.isAlreadySlotted(uploadSession)) {
                System.out.println("OK found session [" + uploadSession.getStatsTrace() + "]");
                return uploadSession;
            }
            System.out.println("FAIL already-slotted session [" + uploadSession.getStatsTrace() + "]");
            return this.getNextBestSession(linkedList);
        }
        return null;
    }

    private UploadSession pickOptSession() {
        int n = this.picker.getHelperCount();
        for (int i = 0; i < n; ++i) {
            UploadSession uploadSession = this.picker.pickNextOptimisticSession();
            if (uploadSession == null || this.isAlreadySlotted(uploadSession)) continue;
            return uploadSession;
        }
        return null;
    }

    private boolean isAlreadySlotted(UploadSession uploadSession) {
        for (int i = 0; i < this.slots.length; ++i) {
            UploadSession uploadSession2 = this.slots[i].getSession();
            if (uploadSession2 == null || !uploadSession2.isSameSession(uploadSession)) continue;
            return true;
        }
        return false;
    }

    private void printSlotStats() {
        System.out.println("\nUPLOAD SLOTS [" + this.current_round + "x]:");
        for (int i = 0; i < this.slots.length; ++i) {
            UploadSlot uploadSlot = this.slots[i];
            System.out.print("[" + i + "]: ");
            String string = uploadSlot.getSlotType() == 0 ? "NORM" : "OPTI";
            long l = uploadSlot.getExpireRound() - this.current_round;
            String string2 = l < 0L ? "" : " [" + l + "]rr";
            String string3 = uploadSlot.getSession() == null ? "EMPTY" : uploadSlot.getSession().getStatsTrace();
            System.out.println(string + string2 + " : " + string3);
        }
    }
}

