/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.uploadslots;

import com.aelitis.azureus.core.peermanager.uploadslots.DownloadingRanker;
import com.aelitis.azureus.core.peermanager.uploadslots.SeedingRanker;
import com.aelitis.azureus.core.peermanager.uploadslots.UploadHelper;
import com.aelitis.azureus.core.peermanager.uploadslots.UploadSession;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.RandomUtils;

public class UploadSessionPicker {
    private final LinkedList next_optimistics = new LinkedList();
    private final AEMonitor next_optimistics_mon = new AEMonitor("UploadSessionPicker");
    private final LinkedList helpers = new LinkedList();
    private final DownloadingRanker down_ranker = new DownloadingRanker();
    private final SeedingRanker seed_ranker = new SeedingRanker();

    protected UploadSessionPicker() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerHelper(UploadHelper uploadHelper) {
        try {
            this.next_optimistics_mon.enter();
            this.helpers.add(uploadHelper);
            int n = uploadHelper.getPriority();
            for (int i = 0; i < n; ++i) {
                this.insertHelper(uploadHelper);
            }
        }
        finally {
            this.next_optimistics_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deregisterHelper(UploadHelper uploadHelper) {
        try {
            this.next_optimistics_mon.enter();
            this.helpers.remove(uploadHelper);
            boolean bl = this.next_optimistics.removeAll(Collections.singleton(uploadHelper));
            if (!bl) {
                Debug.out("!rem");
            }
        }
        finally {
            this.next_optimistics_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateHelper(UploadHelper uploadHelper) {
        try {
            this.next_optimistics_mon.enter();
            int n = uploadHelper.getPriority();
            int n2 = 0;
            Iterator iterator = this.next_optimistics.iterator();
            while (iterator.hasNext()) {
                UploadHelper uploadHelper2 = (UploadHelper)iterator.next();
                if (uploadHelper2 != uploadHelper || ++n2 <= n) continue;
                iterator.remove();
            }
            if (n2 < n) {
                for (int i = n2; i < n; ++i) {
                    this.insertHelper(uploadHelper);
                }
            }
        }
        finally {
            this.next_optimistics_mon.exit();
        }
    }

    private void insertHelper(UploadHelper uploadHelper) {
        int n = RandomUtils.nextInt(this.next_optimistics.size() + 1);
        this.next_optimistics.add(n, uploadHelper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getHelperCount() {
        try {
            this.next_optimistics_mon.enter();
            int n = this.next_optimistics.size();
            return n;
        }
        finally {
            this.next_optimistics_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected UploadSession pickNextOptimisticSession() {
        try {
            UploadHelper uploadHelper;
            this.next_optimistics_mon.enter();
            HashSet<UploadHelper> hashSet = null;
            for (int i = this.next_optimistics.size(); i > 0; --i) {
                uploadHelper = (UploadHelper)this.next_optimistics.removeFirst();
                this.next_optimistics.addLast(uploadHelper);
                if (hashSet != null && hashSet.contains(uploadHelper)) continue;
                PEPeer pEPeer = uploadHelper.isSeeding() ? this.seed_ranker.getNextOptimisticPeer(uploadHelper.getAllPeers()) : this.down_ranker.getNextOptimisticPeer(uploadHelper.getAllPeers());
                if (pEPeer == null) {
                    if (hashSet == null) {
                        hashSet = new HashSet<UploadHelper>();
                    }
                    hashSet.add(uploadHelper);
                    continue;
                }
                UploadSession uploadSession = new UploadSession(pEPeer, uploadHelper.isSeeding() ? 1 : 0);
                return uploadSession;
            }
            uploadHelper = null;
            return uploadHelper;
        }
        finally {
            this.next_optimistics_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<PEPeer> globalGetAllDownloadPeers() {
        try {
            this.next_optimistics_mon.enter();
            ArrayList<PEPeer> arrayList = new ArrayList<PEPeer>();
            for (UploadHelper uploadHelper : this.helpers) {
                if (uploadHelper.isSeeding()) continue;
                arrayList.addAll(uploadHelper.getAllPeers());
            }
            ArrayList<PEPeer> arrayList2 = arrayList;
            return arrayList2;
        }
        finally {
            this.next_optimistics_mon.exit();
        }
    }

    protected LinkedList<UploadSession> pickBestDownloadSessions(int n) {
        ArrayList<PEPeer> arrayList = this.globalGetAllDownloadPeers();
        if (arrayList.isEmpty()) {
            return new LinkedList<UploadSession>();
        }
        ArrayList<PEPeer> arrayList2 = this.down_ranker.rankPeers(n, arrayList);
        if (arrayList2.size() != n) {
            Debug.outNoStack("best.size()[" + arrayList2.size() + "] != max_sessions[" + n + "]");
        }
        if (arrayList2.isEmpty()) {
            return new LinkedList<UploadSession>();
        }
        LinkedList<UploadSession> linkedList = new LinkedList<UploadSession>();
        for (PEPeer pEPeer : arrayList2) {
            UploadSession uploadSession = new UploadSession(pEPeer, 0);
            linkedList.add(uploadSession);
        }
        return linkedList;
    }
}

