/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.messaging.bittorrent.ltep;

import com.aelitis.azureus.core.peermanager.messaging.Message;
import com.aelitis.azureus.core.peermanager.messaging.MessageException;
import com.aelitis.azureus.core.peermanager.messaging.MessagingUtil;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.ltep.LTMessage;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.DirectByteBufferPool;

public class UTMetadata
implements LTMessage {
    public static final boolean ENABLED = true;
    private static final LogIDs LOGID = LogIDs.NET;
    public static final int REQUEST_MESSAGE_TYPE_ID = 0;
    public static final int DATA_MESSAGE_TYPE_ID = 1;
    public static final int REJECT_MESSAGE_TYPE_ID = 2;
    private final int msg_type;
    private final int piece;
    private final int total_size;
    private final byte[] metadata;
    private final byte version;
    private DirectByteBuffer buffer = null;
    private String description = null;

    public UTMetadata(int n, int n2, int n3, byte[] byArray, byte by) {
        this.msg_type = n;
        this.piece = n2;
        this.total_size = n3;
        this.metadata = byArray;
        this.version = by;
    }

    public int getMessageType() {
        return this.msg_type;
    }

    public int getPiece() {
        return this.piece;
    }

    public int getTotalSize() {
        return this.total_size;
    }

    public byte[] getMetadata() {
        return this.metadata;
    }

    @Override
    public String getID() {
        return "ut_metadata";
    }

    @Override
    public byte[] getIDBytes() {
        return LTMessage.ID_UT_METADATA_BYTES;
    }

    @Override
    public String getFeatureID() {
        return "LT1";
    }

    @Override
    public int getFeatureSubID() {
        return 3;
    }

    @Override
    public byte getVersion() {
        return this.version;
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public String getDescription() {
        if (this.description == null) {
            this.description = this.getID().toUpperCase() + "(msg_type=" + this.msg_type + ", piece=" + this.piece + ")";
        }
        return this.description;
    }

    @Override
    public DirectByteBuffer[] getData() {
        try {
            if (this.buffer == null) {
                if (this.msg_type == 0) {
                    HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
                    hashMap.put("msg_type", this.msg_type);
                    hashMap.put("piece", this.piece);
                    this.buffer = MessagingUtil.convertPayloadToBencodedByteStream(hashMap, (byte)34);
                } else if (this.msg_type == 1) {
                    HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
                    hashMap.put("msg_type", this.msg_type);
                    hashMap.put("piece", this.piece);
                    hashMap.put("total_size", this.total_size);
                    byte[] byArray = BEncoder.encode(hashMap);
                    this.buffer = DirectByteBufferPool.getBuffer((byte)34, byArray.length + this.metadata.length);
                    this.buffer.put((byte)11, byArray);
                    this.buffer.put((byte)11, this.metadata);
                    this.buffer.flip((byte)11);
                } else if (this.msg_type == 2) {
                    HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
                    hashMap.put("msg_type", this.msg_type);
                    hashMap.put("piece", this.piece);
                    this.buffer = MessagingUtil.convertPayloadToBencodedByteStream(hashMap, (byte)34);
                } else {
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, 3, "METADATA (UT): No valid msg_type=" + this.msg_type));
                    }
                    return null;
                }
            }
            return new DirectByteBuffer[]{this.buffer};
        }
        catch (Throwable throwable) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, 3, "METADATA (UT)", throwable));
            }
            return new DirectByteBuffer[0];
        }
    }

    @Override
    public Message deserialize(DirectByteBuffer directByteBuffer, byte by) throws MessageException {
        try {
            int n = directByteBuffer.position((byte)11);
            byte[] byArray = new byte[directByteBuffer.remaining((byte)11)];
            directByteBuffer.get((byte)11, byArray);
            directByteBuffer.position((byte)11, n);
            Map map = MessagingUtil.convertBencodedByteStreamToPayload(directByteBuffer, 2, this.getID());
            int n2 = ((Long)map.get("msg_type")).intValue();
            int n3 = ((Long)map.get("piece")).intValue();
            if (n2 == 0) {
                return new UTMetadata(n2, n3, 0, null, 1);
            }
            if (n2 == 1) {
                int n4 = ((Long)map.get("total_size")).intValue();
                int n5 = BEncoder.encode(map).length;
                byte[] byArray2 = new byte[byArray.length - n5];
                System.arraycopy(byArray, n5, byArray2, 0, byArray2.length);
                return new UTMetadata(n2, n3, n4, byArray2, 1);
            }
            if (n2 == 2) {
                return new UTMetadata(n2, n3, 0, null, 1);
            }
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, 3, "METADATA (UT): No valid msg_type=" + n2));
            }
            return null;
        }
        catch (Throwable throwable) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, 3, "METADATA (UT)", throwable));
            }
            return null;
        }
    }

    @Override
    public void destroy() {
        if (this.buffer != null) {
            this.buffer.returnToPool();
        }
    }
}

