/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.messaging.azureus;

import com.aelitis.azureus.core.peermanager.messaging.Message;
import com.aelitis.azureus.core.peermanager.messaging.MessageException;
import com.aelitis.azureus.core.peermanager.messaging.MessagingUtil;
import com.aelitis.azureus.core.peermanager.messaging.azureus.AZMessage;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.util.DirectByteBuffer;

public class AZRequestHint
implements AZMessage {
    private final byte version;
    private DirectByteBuffer buffer = null;
    private int piece_number;
    private int offset;
    private int length;
    private int life;

    public AZRequestHint(int n, int n2, int n3, int n4, byte by) {
        this.piece_number = n;
        this.offset = n2;
        this.length = n3;
        this.life = n4;
        this.version = by;
    }

    @Override
    public String getID() {
        return "AZ_REQUEST_HINT";
    }

    @Override
    public byte[] getIDBytes() {
        return AZMessage.ID_AZ_REQUEST_HINT_BYTES;
    }

    @Override
    public String getFeatureID() {
        return "AZ1";
    }

    @Override
    public int getFeatureSubID() {
        return 3;
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public byte getVersion() {
        return this.version;
    }

    @Override
    public String getDescription() {
        return this.getID() + " piece #" + this.piece_number + ":" + this.offset + "->" + (this.offset + this.length - 1) + "/" + this.life;
    }

    public int getPieceNumber() {
        return this.piece_number;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public int getLife() {
        return this.life;
    }

    @Override
    public DirectByteBuffer[] getData() {
        if (this.buffer == null) {
            HashMap<String, Long> hashMap = new HashMap<String, Long>();
            hashMap.put("piece", new Long(this.piece_number));
            hashMap.put("offset", new Long(this.offset));
            hashMap.put("length", new Long(this.length));
            hashMap.put("life", new Long(this.life));
            this.buffer = MessagingUtil.convertPayloadToBencodedByteStream(hashMap, (byte)12);
        }
        return new DirectByteBuffer[]{this.buffer};
    }

    @Override
    public Message deserialize(DirectByteBuffer directByteBuffer, byte by) throws MessageException {
        Map map = MessagingUtil.convertBencodedByteStreamToPayload(directByteBuffer, 1, this.getID());
        int n = ((Long)map.get("piece")).intValue();
        int n2 = ((Long)map.get("offset")).intValue();
        int n3 = ((Long)map.get("length")).intValue();
        int n4 = ((Long)map.get("life")).intValue();
        return new AZRequestHint(n, n2, n3, n4, by);
    }

    @Override
    public void destroy() {
        if (this.buffer != null) {
            this.buffer.returnToPool();
        }
    }
}

