/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl.udp;

import com.aelitis.azureus.core.networkmanager.impl.TransportHelper;
import com.aelitis.azureus.core.networkmanager.impl.udp.UDPConnection;
import com.aelitis.azureus.core.networkmanager.impl.udp.UDPConnectionManager;
import com.aelitis.azureus.core.networkmanager.impl.udp.UDPNetworkManager;
import com.aelitis.azureus.core.networkmanager.impl.udp.UDPSelector;
import com.aelitis.azureus.core.networkmanager.impl.udp.UDPTransport;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.util.Debug;

public class UDPTransportHelper
implements TransportHelper {
    public static final int READ_TIMEOUT = 30000;
    public static final int CONNECT_TIMEOUT = 60000;
    private UDPConnectionManager manager;
    private UDPSelector selector;
    private InetSocketAddress address;
    private UDPTransport transport;
    private boolean incoming;
    private UDPConnection connection;
    private TransportHelper.selectListener read_listener;
    private Object read_attachment;
    private boolean read_selects_paused;
    private TransportHelper.selectListener write_listener;
    private Object write_attachment;
    private boolean write_selects_paused = true;
    private boolean closed;
    private IOException failed;
    private ByteBuffer[] pending_partial_writes;
    private Map user_data;

    public UDPTransportHelper(UDPConnectionManager uDPConnectionManager, InetSocketAddress inetSocketAddress, UDPTransport uDPTransport) throws IOException {
        this.manager = uDPConnectionManager;
        this.address = inetSocketAddress;
        this.transport = uDPTransport;
        this.incoming = false;
        this.connection = this.manager.registerOutgoing(this);
        this.selector = this.connection.getSelector();
    }

    public UDPTransportHelper(UDPConnectionManager uDPConnectionManager, InetSocketAddress inetSocketAddress, UDPConnection uDPConnection) {
        this.manager = uDPConnectionManager;
        this.address = inetSocketAddress;
        this.connection = uDPConnection;
        this.incoming = true;
        this.selector = this.connection.getSelector();
    }

    protected void setTransport(UDPTransport uDPTransport) {
        this.transport = uDPTransport;
    }

    protected UDPTransport getTransport() {
        return this.transport;
    }

    protected int getMss() {
        if (this.transport == null) {
            return UDPNetworkManager.getUdpMssSize();
        }
        return this.transport.getMssSize();
    }

    @Override
    public boolean minimiseOverheads() {
        return true;
    }

    @Override
    public int getConnectTimeout() {
        return 60000;
    }

    @Override
    public int getReadTimeout() {
        return 30000;
    }

    @Override
    public InetSocketAddress getAddress() {
        return this.address;
    }

    @Override
    public String getName(boolean bl) {
        return "UDP";
    }

    public boolean isIncoming() {
        return this.incoming;
    }

    protected UDPConnection getConnection() {
        return this.connection;
    }

    @Override
    public boolean delayWrite(ByteBuffer byteBuffer) {
        if (this.pending_partial_writes == null) {
            this.pending_partial_writes = new ByteBuffer[]{byteBuffer};
            return true;
        }
        return false;
    }

    @Override
    public boolean hasDelayedWrite() {
        return this.pending_partial_writes != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(ByteBuffer byteBuffer, boolean bl) throws IOException {
        int n;
        int n2;
        UDPTransportHelper uDPTransportHelper = this;
        synchronized (uDPTransportHelper) {
            if (this.failed != null) {
                throw this.failed;
            }
            if (this.closed) {
                throw new IOException("Transport closed");
            }
        }
        int n3 = byteBuffer.remaining();
        if (bl && n3 < 128) {
            if (this.pending_partial_writes == null) {
                this.pending_partial_writes = new ByteBuffer[1];
                ByteBuffer byteBuffer2 = ByteBuffer.allocate(n3);
                byteBuffer2.put(byteBuffer);
                byteBuffer2.position(0);
                this.pending_partial_writes[0] = byteBuffer2;
                return n3;
            }
            n2 = 0;
            for (n = 0; n < this.pending_partial_writes.length; ++n) {
                n2 += this.pending_partial_writes[n].remaining();
            }
            if (n2 + n3 <= 512) {
                ByteBuffer[] byteBufferArray = new ByteBuffer[this.pending_partial_writes.length + 1];
                for (int i = 0; i < this.pending_partial_writes.length; ++i) {
                    byteBufferArray[i] = this.pending_partial_writes[i];
                }
                ByteBuffer byteBuffer3 = ByteBuffer.allocate(n3);
                byteBuffer3.put(byteBuffer);
                byteBuffer3.position(0);
                byteBufferArray[this.pending_partial_writes.length] = byteBuffer3;
                this.pending_partial_writes = byteBufferArray;
                return n3;
            }
        }
        if (this.pending_partial_writes != null) {
            int n4;
            n2 = this.pending_partial_writes.length;
            n = 0;
            ByteBuffer[] byteBufferArray = new ByteBuffer[n2 + 1];
            for (n4 = 0; n4 < n2; ++n4) {
                byteBufferArray[n4] = this.pending_partial_writes[n4];
                n += byteBufferArray[n4].remaining();
            }
            byteBufferArray[n2] = byteBuffer;
            try {
                n4 = this.connection.write(byteBufferArray, 0, byteBufferArray.length);
                if (n4 >= n) {
                    int n5 = n4 - n;
                    return n5;
                }
                int n6 = 0;
                return n6;
            }
            finally {
                n = 0;
                for (int i = 0; i < n2; ++i) {
                    n += byteBufferArray[i].remaining();
                }
                if (n == 0) {
                    this.pending_partial_writes = null;
                }
            }
        }
        return this.connection.write(new ByteBuffer[]{byteBuffer}, 0, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long write(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        UDPTransportHelper uDPTransportHelper = this;
        synchronized (uDPTransportHelper) {
            if (this.failed != null) {
                throw this.failed;
            }
            if (this.closed) {
                throw new IOException("Transport closed");
            }
        }
        if (this.pending_partial_writes != null) {
            int n3;
            int n4;
            int n5 = this.pending_partial_writes.length;
            int n6 = 0;
            ByteBuffer[] byteBufferArray2 = new ByteBuffer[n2 + n5];
            for (n4 = 0; n4 < n5; ++n4) {
                byteBufferArray2[n4] = this.pending_partial_writes[n4];
                n6 += byteBufferArray2[n4].remaining();
            }
            n4 = n5;
            for (n3 = n; n3 < n + n2; ++n3) {
                byteBufferArray2[n4++] = byteBufferArray[n3];
            }
            try {
                n3 = this.connection.write(byteBufferArray2, 0, byteBufferArray2.length);
                if (n3 >= n6) {
                    long l = n3 - n6;
                    return l;
                }
                long l = 0L;
                return l;
            }
            finally {
                n6 = 0;
                for (int i = 0; i < n5; ++i) {
                    n6 += byteBufferArray2[i].remaining();
                }
                if (n6 == 0) {
                    this.pending_partial_writes = null;
                }
            }
        }
        return this.connection.write(byteBufferArray, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        UDPTransportHelper uDPTransportHelper = this;
        synchronized (uDPTransportHelper) {
            if (this.failed != null) {
                throw this.failed;
            }
            if (this.closed) {
                throw new IOException("Transport closed");
            }
        }
        return this.connection.read(byteBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long read(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        UDPTransportHelper uDPTransportHelper = this;
        synchronized (uDPTransportHelper) {
            if (this.failed != null) {
                throw this.failed;
            }
            if (this.closed) {
                throw new IOException("Transport closed");
            }
        }
        long l = 0L;
        for (int i = n; i < n + n2; ++i) {
            ByteBuffer byteBuffer = byteBufferArray[i];
            int n3 = byteBuffer.remaining();
            int n4 = this.connection.read(byteBuffer);
            l += (long)n4;
            if (n4 < n3) break;
        }
        return l;
    }

    protected void canRead() {
        this.fireReadSelect();
    }

    protected void canWrite() {
        this.fireWriteSelect();
    }

    @Override
    public synchronized void pauseReadSelects() {
        if (this.read_listener != null) {
            this.selector.cancel(this, this.read_listener);
        }
        this.read_selects_paused = true;
    }

    @Override
    public synchronized void pauseWriteSelects() {
        if (this.write_listener != null) {
            this.selector.cancel(this, this.write_listener);
        }
        this.write_selects_paused = true;
    }

    @Override
    public synchronized void resumeReadSelects() {
        this.read_selects_paused = false;
        this.fireReadSelect();
    }

    @Override
    public synchronized void resumeWriteSelects() {
        this.write_selects_paused = false;
        this.fireWriteSelect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerForReadSelects(TransportHelper.selectListener selectListener2, Object object) {
        UDPTransportHelper uDPTransportHelper = this;
        synchronized (uDPTransportHelper) {
            this.read_listener = selectListener2;
            this.read_attachment = object;
        }
        this.resumeReadSelects();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerForWriteSelects(TransportHelper.selectListener selectListener2, Object object) {
        UDPTransportHelper uDPTransportHelper = this;
        synchronized (uDPTransportHelper) {
            this.write_listener = selectListener2;
            this.write_attachment = object;
        }
        this.resumeWriteSelects();
    }

    @Override
    public synchronized void cancelReadSelects() {
        this.selector.cancel(this, this.read_listener);
        this.read_selects_paused = true;
        this.read_listener = null;
        this.read_attachment = null;
    }

    @Override
    public synchronized void cancelWriteSelects() {
        this.selector.cancel(this, this.write_listener);
        this.write_selects_paused = true;
        this.write_listener = null;
        this.write_attachment = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireReadSelect() {
        UDPTransportHelper uDPTransportHelper = this;
        synchronized (uDPTransportHelper) {
            if (this.read_listener != null && !this.read_selects_paused) {
                if (this.failed != null) {
                    this.selector.ready(this, this.read_listener, this.read_attachment, this.failed);
                } else if (this.closed) {
                    this.selector.ready(this, this.read_listener, this.read_attachment, new Throwable("Transport closed"));
                } else if (this.connection.canRead()) {
                    this.selector.ready(this, this.read_listener, this.read_attachment);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireWriteSelect() {
        UDPTransportHelper uDPTransportHelper = this;
        synchronized (uDPTransportHelper) {
            if (this.write_listener != null && !this.write_selects_paused) {
                if (this.failed != null) {
                    this.write_selects_paused = true;
                    this.selector.ready(this, this.write_listener, this.write_attachment, this.failed);
                } else if (this.closed) {
                    this.write_selects_paused = true;
                    this.selector.ready(this, this.write_listener, this.write_attachment, new Throwable("Transport closed"));
                } else if (this.connection.canWrite()) {
                    this.write_selects_paused = true;
                    this.selector.ready(this, this.write_listener, this.write_attachment);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void failed(Throwable throwable) {
        UDPTransportHelper uDPTransportHelper = this;
        synchronized (uDPTransportHelper) {
            this.failed = throwable instanceof IOException ? (IOException)throwable : new IOException(Debug.getNestedExceptionMessageAndStack(throwable));
            this.fireReadSelect();
            this.fireWriteSelect();
        }
        this.connection.failedSupport(throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(String string) {
        UDPTransportHelper uDPTransportHelper = this;
        synchronized (uDPTransportHelper) {
            this.closed = true;
            this.fireReadSelect();
            this.fireWriteSelect();
        }
        this.connection.closeSupport(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void poll() {
        UDPTransportHelper uDPTransportHelper = this;
        synchronized (uDPTransportHelper) {
            this.fireReadSelect();
            this.fireWriteSelect();
        }
    }

    @Override
    public synchronized void setUserData(Object object, Object object2) {
        if (this.user_data == null) {
            this.user_data = new HashMap();
        }
        this.user_data.put(object, object2);
    }

    @Override
    public synchronized Object getUserData(Object object) {
        if (this.user_data == null) {
            return null;
        }
        return this.user_data.get(object);
    }

    @Override
    public void setTrace(boolean bl) {
    }

    @Override
    public void setScatteringMode(long l) {
    }
}

