/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl.test;

import com.aelitis.azureus.core.networkmanager.VirtualChannelSelector;
import com.aelitis.azureus.core.networkmanager.VirtualServerChannelSelector;
import com.aelitis.azureus.core.networkmanager.VirtualServerChannelSelectorFactory;
import com.aelitis.azureus.core.networkmanager.impl.ProtocolDecoder;
import com.aelitis.azureus.core.networkmanager.impl.ProtocolDecoderAdapter;
import com.aelitis.azureus.core.networkmanager.impl.ProtocolDecoderInitial;
import com.aelitis.azureus.core.networkmanager.impl.TransportHelperFilter;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPNetworkManager;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPTransportHelper;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.Debug;

public class PHETester {
    private final VirtualChannelSelector connect_selector = new VirtualChannelSelector("PHETester", 8, true);
    private byte[] TEST_HEADER = "TestHeader".getBytes();
    private static boolean OUTGOING_PLAIN = false;
    private static byte[] shared_secret = "sdsjdksjdkj".getBytes();

    public PHETester() {
        ProtocolDecoder.addSecrets(new byte[][]{shared_secret});
        VirtualServerChannelSelector virtualServerChannelSelector = VirtualServerChannelSelectorFactory.createNonBlocking(new InetSocketAddress(8765), 0, new VirtualServerChannelSelector.SelectListener(){

            @Override
            public void newConnectionAccepted(ServerSocketChannel serverSocketChannel, SocketChannel socketChannel) {
                PHETester.this.incoming(socketChannel);
            }
        });
        virtualServerChannelSelector.start();
        new Thread(){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            PHETester.this.connect_selector.select(100L);
                        }
                    }
                    catch (Throwable throwable) {
                        Debug.out("connnectSelectLoop() EXCEPTION: ", throwable);
                        continue;
                    }
                    break;
                }
            }
        }.start();
        this.outgoings();
    }

    protected void incoming(SocketChannel socketChannel) {
        try {
            TCPTransportHelper tCPTransportHelper = new TCPTransportHelper(socketChannel);
            ProtocolDecoderInitial protocolDecoderInitial = new ProtocolDecoderInitial(tCPTransportHelper, null, false, null, new ProtocolDecoderAdapter(){

                @Override
                public void decodeComplete(ProtocolDecoder protocolDecoder, ByteBuffer byteBuffer) {
                    System.out.println("incoming decode complete: " + protocolDecoder.getFilter().getName(false));
                    PHETester.this.readStream("incoming", protocolDecoder.getFilter());
                    PHETester.this.writeStream("ten fat monkies", protocolDecoder.getFilter());
                }

                @Override
                public void decodeFailed(ProtocolDecoder protocolDecoder, Throwable throwable) {
                    System.out.println("incoming decode failed: " + Debug.getNestedExceptionMessage(throwable));
                }

                @Override
                public void gotSecret(byte[] byArray) {
                }

                @Override
                public int getMaximumPlainHeaderLength() {
                    return PHETester.this.TEST_HEADER.length;
                }

                @Override
                public int matchPlainHeader(ByteBuffer byteBuffer) {
                    int n = byteBuffer.position();
                    int n2 = byteBuffer.limit();
                    byteBuffer.flip();
                    boolean bl = byteBuffer.compareTo(ByteBuffer.wrap(PHETester.this.TEST_HEADER)) == 0;
                    byteBuffer.position(n);
                    byteBuffer.limit(n2);
                    System.out.println("Match - " + bl);
                    return bl ? 2 : 1;
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    protected void outgoings() {
        while (true) {
            this.outgoing();
            try {
                Thread.sleep(1000000L);
            }
            catch (Throwable throwable) {
            }
        }
    }

    protected void outgoing() {
        try {
            final SocketChannel socketChannel = SocketChannel.open();
            socketChannel.configureBlocking(false);
            if (socketChannel.connect(new InetSocketAddress("localhost", 8765))) {
                this.outgoing(socketChannel);
            } else {
                this.connect_selector.register(socketChannel, new VirtualChannelSelector.VirtualSelectorListener(){

                    @Override
                    public boolean selectSuccess(VirtualChannelSelector virtualChannelSelector, SocketChannel socketChannel2, Object object) {
                        try {
                            if (socketChannel.finishConnect()) {
                                PHETester.this.outgoing(socketChannel);
                                return true;
                            }
                            throw new IOException("finishConnect failed");
                        }
                        catch (Throwable throwable) {
                            throwable.printStackTrace();
                            return false;
                        }
                    }

                    @Override
                    public void selectFailure(VirtualChannelSelector virtualChannelSelector, SocketChannel socketChannel2, Object object, Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }, null);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    protected void outgoing(SocketChannel socketChannel) {
        try {
            if (OUTGOING_PLAIN) {
                this.writeStream(this.TEST_HEADER, socketChannel);
                this.writeStream("two jolly porkers".getBytes(), socketChannel);
            } else {
                TCPTransportHelper tCPTransportHelper = new TCPTransportHelper(socketChannel);
                ProtocolDecoderInitial protocolDecoderInitial = new ProtocolDecoderInitial(tCPTransportHelper, new byte[][]{shared_secret}, true, null, new ProtocolDecoderAdapter(){

                    @Override
                    public void decodeComplete(ProtocolDecoder protocolDecoder, ByteBuffer byteBuffer) {
                        System.out.println("outgoing decode complete: " + protocolDecoder.getFilter().getName(false));
                        PHETester.this.readStream("incoming", protocolDecoder.getFilter());
                        PHETester.this.writeStream(PHETester.this.TEST_HEADER, protocolDecoder.getFilter());
                        PHETester.this.writeStream("two jolly porkers", protocolDecoder.getFilter());
                    }

                    @Override
                    public void decodeFailed(ProtocolDecoder protocolDecoder, Throwable throwable) {
                        System.out.println("outgoing decode failed: " + Debug.getNestedExceptionMessage(throwable));
                    }

                    @Override
                    public void gotSecret(byte[] byArray) {
                    }

                    @Override
                    public int getMaximumPlainHeaderLength() {
                        throw new RuntimeException();
                    }

                    @Override
                    public int matchPlainHeader(ByteBuffer byteBuffer) {
                        throw new RuntimeException();
                    }
                });
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    protected void readStream(final String string, final TransportHelperFilter transportHelperFilter) {
        try {
            TCPNetworkManager.getSingleton().getReadSelector().register(((TCPTransportHelper)transportHelperFilter.getHelper()).getSocketChannel(), new VirtualChannelSelector.VirtualSelectorListener(){

                @Override
                public boolean selectSuccess(VirtualChannelSelector virtualChannelSelector, SocketChannel socketChannel, Object object) {
                    ByteBuffer byteBuffer = ByteBuffer.allocate(1024);
                    try {
                        long l = transportHelperFilter.read(new ByteBuffer[]{byteBuffer}, 0, 1);
                        byte[] byArray = new byte[byteBuffer.position()];
                        byteBuffer.flip();
                        byteBuffer.get(byArray);
                        System.out.println(string + ": " + new String(byArray));
                        return l > 0L;
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                        return false;
                    }
                }

                @Override
                public void selectFailure(VirtualChannelSelector virtualChannelSelector, SocketChannel socketChannel, Object object, Throwable throwable) {
                    throwable.printStackTrace();
                }
            }, null);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    protected void writeStream(String string, TransportHelperFilter transportHelperFilter) {
        this.writeStream(string.getBytes(), transportHelperFilter);
    }

    protected void writeStream(byte[] byArray, TransportHelperFilter transportHelperFilter) {
        try {
            transportHelperFilter.write(new ByteBuffer[]{ByteBuffer.wrap(byArray)}, 0, 1);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    protected void writeStream(byte[] byArray, SocketChannel socketChannel) {
        try {
            socketChannel.write(new ByteBuffer[]{ByteBuffer.wrap(byArray)}, 0, 1);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        AEDiagnostics.startup(false);
        COConfigurationManager.setParameter("network.transport.encrypted.require", true);
        COConfigurationManager.setParameter("network.transport.encrypted.min_level", "Plain");
        new PHETester();
        try {
            Thread.sleep(10000000L);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

