/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl.tcp;

import com.aelitis.azureus.core.networkmanager.ConnectionEndpoint;
import com.aelitis.azureus.core.networkmanager.VirtualServerChannelSelector;
import com.aelitis.azureus.core.networkmanager.VirtualServerChannelSelectorFactory;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdmin;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminPropertyChangeListener;
import com.aelitis.azureus.core.networkmanager.impl.IncomingConnectionManager;
import com.aelitis.azureus.core.networkmanager.impl.ProtocolDecoder;
import com.aelitis.azureus.core.networkmanager.impl.TransportCryptoManager;
import com.aelitis.azureus.core.networkmanager.impl.TransportHelperFilter;
import com.aelitis.azureus.core.networkmanager.impl.tcp.ProtocolEndpointTCP;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPTransportHelper;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPTransportImpl;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.RandomUtils;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;

public class IncomingSocketChannelManager {
    private static final LogIDs LOGID = LogIDs.NWMAN;
    private final String port_config_key;
    private final String port_enable_config_key;
    private int tcp_listen_port;
    private int so_rcvbuf_size = COConfigurationManager.getIntParameter("network.tcp.socket.SO_RCVBUF");
    private InetAddress[] default_bind_addresses = NetworkAdmin.getSingleton().getMultiHomedServiceBindAddresses(true);
    private InetAddress explicit_bind_address;
    private boolean explicit_bind_address_set;
    private VirtualServerChannelSelector[] serverSelectors = new VirtualServerChannelSelector[0];
    private int[] listenFailCounts = new int[0];
    private IncomingConnectionManager incoming_manager = IncomingConnectionManager.getSingleton();
    protected AEMonitor this_mon = new AEMonitor("IncomingSocketChannelManager");
    private long last_non_local_connection_time;
    private final VirtualServerChannelSelector.SelectListener selectListener = new TcpSelectListener();

    public IncomingSocketChannelManager(String string, String string2) {
        this.port_config_key = string;
        this.port_enable_config_key = string2;
        this.tcp_listen_port = COConfigurationManager.getIntParameter(this.port_config_key);
        COConfigurationManager.addParameterListener(this.port_config_key, new ParameterListener(){

            @Override
            public void parameterChanged(String string) {
                int n = COConfigurationManager.getIntParameter(IncomingSocketChannelManager.this.port_config_key);
                if (n != IncomingSocketChannelManager.this.tcp_listen_port) {
                    IncomingSocketChannelManager.this.tcp_listen_port = n;
                    IncomingSocketChannelManager.this.restart();
                }
            }
        });
        COConfigurationManager.addParameterListener(this.port_enable_config_key, new ParameterListener(){

            @Override
            public void parameterChanged(String string) {
                IncomingSocketChannelManager.this.restart();
            }
        });
        COConfigurationManager.addParameterListener("network.tcp.socket.SO_RCVBUF", new ParameterListener(){

            @Override
            public void parameterChanged(String string) {
                int n = COConfigurationManager.getIntParameter("network.tcp.socket.SO_RCVBUF");
                if (n != IncomingSocketChannelManager.this.so_rcvbuf_size) {
                    IncomingSocketChannelManager.this.so_rcvbuf_size = n;
                    IncomingSocketChannelManager.this.restart();
                }
            }
        });
        NetworkAdmin.getSingleton().addPropertyChangeListener(new NetworkAdminPropertyChangeListener(){

            @Override
            public void propertyChanged(String string) {
                Object[] objectArray;
                if (string == "Default Bind IP" && !Arrays.equals(objectArray = NetworkAdmin.getSingleton().getMultiHomedServiceBindAddresses(true), IncomingSocketChannelManager.this.default_bind_addresses)) {
                    IncomingSocketChannelManager.access$402(IncomingSocketChannelManager.this, (InetAddress[])objectArray);
                    IncomingSocketChannelManager.this.restart();
                }
            }
        });
        this.start();
        SimpleTimer.addPeriodicEvent("IncomingSocketChannelManager:concheck", 60000L, new TimerEventPerformer(){

            @Override
            public void perform(TimerEvent timerEvent2) {
                COConfigurationManager.setParameter("network.tcp.port." + IncomingSocketChannelManager.this.tcp_listen_port + ".last.nonlocal.incoming", IncomingSocketChannelManager.this.last_non_local_connection_time);
                for (int i = 0; i < IncomingSocketChannelManager.this.serverSelectors.length; ++i) {
                    VirtualServerChannelSelector virtualServerChannelSelector = IncomingSocketChannelManager.this.serverSelectors[i];
                    if (virtualServerChannelSelector == null || !virtualServerChannelSelector.isRunning()) continue;
                    long l = SystemTime.getCurrentTime() - virtualServerChannelSelector.getTimeOfLastAccept();
                    if (l > 600000L) {
                        InetAddress inetAddress = virtualServerChannelSelector.getBoundToAddress();
                        try {
                            if (inetAddress == null) {
                                inetAddress = InetAddress.getByName("127.0.0.1");
                            }
                            Socket socket = new Socket(inetAddress, IncomingSocketChannelManager.this.tcp_listen_port, inetAddress, 0);
                            socket.close();
                            ((IncomingSocketChannelManager)IncomingSocketChannelManager.this).listenFailCounts[i] = 0;
                        }
                        catch (Throwable throwable) {
                            try {
                                Socket socket = new Socket(InetAddress.getByName("127.0.0.1"), IncomingSocketChannelManager.this.tcp_listen_port);
                                socket.close();
                                ((IncomingSocketChannelManager)IncomingSocketChannelManager.this).listenFailCounts[i] = 0;
                            }
                            catch (Throwable throwable2) {
                                int[] nArray = IncomingSocketChannelManager.this.listenFailCounts;
                                int n = i;
                                nArray[n] = nArray[n] + 1;
                                Debug.out(new Date() + ": listen port on [" + inetAddress + ": " + IncomingSocketChannelManager.this.tcp_listen_port + "] seems CLOSED [" + IncomingSocketChannelManager.this.listenFailCounts[i] + "x]");
                                if (IncomingSocketChannelManager.this.listenFailCounts[i] <= 4) continue;
                                String string = throwable.getMessage() == null ? "<null>" : throwable.getMessage();
                                String string2 = "Listen server socket on [" + inetAddress + ": " + IncomingSocketChannelManager.this.tcp_listen_port + "] does not appear to be accepting inbound connections.\n[" + string + "]\nAuto-repairing listen service....\n";
                                Logger.log(new LogAlert(false, 1, string2));
                                IncomingSocketChannelManager.this.restart();
                                ((IncomingSocketChannelManager)IncomingSocketChannelManager.this).listenFailCounts[i] = 0;
                            }
                        }
                        continue;
                    }
                    ((IncomingSocketChannelManager)IncomingSocketChannelManager.this).listenFailCounts[i] = 0;
                }
            }
        });
    }

    public boolean isEnabled() {
        return COConfigurationManager.getBooleanParameter(this.port_enable_config_key);
    }

    public int getTCPListeningPortNumber() {
        return this.tcp_listen_port;
    }

    public void setExplicitBindAddress(InetAddress inetAddress) {
        this.explicit_bind_address = inetAddress;
        this.explicit_bind_address_set = true;
        this.restart();
    }

    public void clearExplicitBindAddress() {
        this.explicit_bind_address = null;
        this.explicit_bind_address_set = false;
        this.restart();
    }

    protected InetAddress[] getEffectiveBindAddresses() {
        if (this.explicit_bind_address_set) {
            return new InetAddress[]{this.explicit_bind_address};
        }
        return this.default_bind_addresses;
    }

    public boolean isEffectiveBindAddress(InetAddress inetAddress) {
        InetAddress[] inetAddressArray = this.getEffectiveBindAddresses();
        return Arrays.asList(inetAddressArray).contains(inetAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void start() {
        try {
            Object object;
            this.this_mon.enter();
            if (this.tcp_listen_port < 0 || this.tcp_listen_port > 65535 || this.tcp_listen_port == 6880) {
                object = "Invalid incoming TCP listen port configured, " + this.tcp_listen_port + ". Port reset to default. Please check your config!";
                Debug.out((String)object);
                Logger.log(new LogAlert(false, 3, (String)object));
                this.tcp_listen_port = RandomUtils.generateRandomNetworkListenPort();
                COConfigurationManager.setParameter(this.port_config_key, this.tcp_listen_port);
            }
            if (COConfigurationManager.getBooleanParameter(this.port_enable_config_key)) {
                this.last_non_local_connection_time = COConfigurationManager.getLongParameter("network.tcp.port." + this.tcp_listen_port + ".last.nonlocal.incoming", 0L);
                if (this.last_non_local_connection_time > SystemTime.getCurrentTime()) {
                    this.last_non_local_connection_time = SystemTime.getCurrentTime();
                }
                if (this.serverSelectors.length == 0) {
                    InetAddress[] inetAddressArray = this.getEffectiveBindAddresses();
                    ArrayList<VirtualServerChannelSelector> arrayList = new ArrayList<VirtualServerChannelSelector>(inetAddressArray.length);
                    this.listenFailCounts = new int[inetAddressArray.length];
                    for (int i = 0; i < inetAddressArray.length; ++i) {
                        InetAddress inetAddress = inetAddressArray[i];
                        if (!NetworkAdmin.getSingleton().hasIPV6Potential(true) && inetAddress instanceof Inet6Address) continue;
                        object = inetAddress != null ? new InetSocketAddress(inetAddress, this.tcp_listen_port) : new InetSocketAddress(this.tcp_listen_port);
                        VirtualServerChannelSelector virtualServerChannelSelector = inetAddressArray.length == 1 ? VirtualServerChannelSelectorFactory.createBlocking((InetSocketAddress)object, this.so_rcvbuf_size, this.selectListener) : VirtualServerChannelSelectorFactory.createNonBlocking((InetSocketAddress)object, this.so_rcvbuf_size, this.selectListener);
                        virtualServerChannelSelector.start();
                        arrayList.add(virtualServerChannelSelector);
                    }
                    if (arrayList.size() == 0) {
                        Logger.log(new LogAlert(true, 1, MessageText.getString("network.bindError")));
                    }
                    this.serverSelectors = arrayList.toArray(new VirtualServerChannelSelector[arrayList.size()]);
                }
            } else {
                Logger.log(new LogEvent(LOGID, "Not starting TCP listener on port " + this.tcp_listen_port + " as protocol disabled"));
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected void process(int n, TransportHelperFilter transportHelperFilter) {
        Object object;
        SocketChannel socketChannel = ((TCPTransportHelper)transportHelperFilter.getHelper()).getSocketChannel();
        try {
            int n2 = COConfigurationManager.getIntParameter("network.tcp.socket.SO_SNDBUF");
            if (n2 > 0) {
                socketChannel.socket().setSendBufferSize(n2);
            }
            if (((String)(object = COConfigurationManager.getStringParameter("network.tcp.socket.IPDiffServ"))).length() > 0) {
                socketChannel.socket().setTrafficClass(Integer.decode((String)object));
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        InetSocketAddress inetSocketAddress = new InetSocketAddress(socketChannel.socket().getInetAddress(), socketChannel.socket().getPort());
        object = new ConnectionEndpoint(inetSocketAddress);
        ProtocolEndpointTCP protocolEndpointTCP = new ProtocolEndpointTCP((ConnectionEndpoint)object, inetSocketAddress);
        TCPTransportImpl tCPTransportImpl = new TCPTransportImpl(protocolEndpointTCP, transportHelperFilter);
        this.incoming_manager.addConnection(n, transportHelperFilter, tCPTransportImpl);
    }

    protected long getLastNonLocalConnectionTime() {
        return this.last_non_local_connection_time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restart() {
        try {
            this.this_mon.enter();
            for (int i = 0; i < this.serverSelectors.length; ++i) {
                this.serverSelectors[i].stop();
            }
            this.serverSelectors = new VirtualServerChannelSelector[0];
        }
        finally {
            this.this_mon.exit();
        }
        try {
            Thread.sleep(1000L);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        this.start();
    }

    static /* synthetic */ InetAddress[] access$402(IncomingSocketChannelManager incomingSocketChannelManager, InetAddress[] inetAddressArray) {
        incomingSocketChannelManager.default_bind_addresses = inetAddressArray;
        return inetAddressArray;
    }

    private final class TcpSelectListener
    implements VirtualServerChannelSelector.SelectListener {
        private TcpSelectListener() {
        }

        @Override
        public void newConnectionAccepted(final ServerSocketChannel serverSocketChannel, SocketChannel socketChannel) {
            InetAddress inetAddress = socketChannel.socket().getInetAddress();
            if (!(inetAddress.isLoopbackAddress() || inetAddress.isLinkLocalAddress() || inetAddress.isSiteLocalAddress())) {
                IncomingSocketChannelManager.this.last_non_local_connection_time = SystemTime.getCurrentTime();
            }
            final TCPTransportHelper tCPTransportHelper = new TCPTransportHelper(socketChannel);
            TransportCryptoManager.getSingleton().manageCrypto(tCPTransportHelper, null, true, null, new TransportCryptoManager.HandshakeListener(){

                @Override
                public void handshakeSuccess(ProtocolDecoder protocolDecoder, ByteBuffer byteBuffer) {
                    IncomingSocketChannelManager.this.process(serverSocketChannel.socket().getLocalPort(), protocolDecoder.getFilter());
                }

                @Override
                public void handshakeFailure(Throwable throwable) {
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, "incoming crypto handshake failure: " + Debug.getNestedExceptionMessage(throwable)));
                    }
                    tCPTransportHelper.close("Handshake failure: " + Debug.getNestedExceptionMessage(throwable));
                }

                @Override
                public void gotSecret(byte[] byArray) {
                }

                @Override
                public int getMaximumPlainHeaderLength() {
                    return IncomingSocketChannelManager.this.incoming_manager.getMaxMinMatchBufferSize();
                }

                @Override
                public int matchPlainHeader(ByteBuffer byteBuffer) {
                    Object[] objectArray = IncomingSocketChannelManager.this.incoming_manager.checkForMatch(tCPTransportHelper, serverSocketChannel.socket().getLocalPort(), byteBuffer, true);
                    if (objectArray == null) {
                        return 1;
                    }
                    IncomingConnectionManager.MatchListener matchListener = (IncomingConnectionManager.MatchListener)objectArray[0];
                    if (matchListener.autoCryptoFallback()) {
                        return 3;
                    }
                    return 2;
                }
            });
        }
    }
}

