/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl;

import java.util.Map;
import java.util.TreeMap;
import org.gudy.azureus2.core3.util.Timer;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;

public class TransportStats {
    private static final int PRINT_INTERVAL = 60000;
    private static final int GRANULARITY = 10;
    private final TreeMap read_sizes = new TreeMap();
    private final TreeMap write_sizes = new TreeMap();
    private long total_reads = 0L;
    private long total_writes = 0L;

    public TransportStats() {
        Timer timer = new Timer("TransportStats:Printer");
        timer.addPeriodicEvent(60000L, new TimerEventPerformer(){

            @Override
            public void perform(TimerEvent timerEvent2) {
                TransportStats.this.printStats();
            }
        });
    }

    public void bytesRead(int n) {
        ++this.total_reads;
        this.updateSizes(this.read_sizes, n);
    }

    public void bytesWritten(int n) {
        ++this.total_writes;
        this.updateSizes(this.write_sizes, n);
    }

    private void updateSizes(TreeMap treeMap, int n) {
        Integer n2 = n == 0 ? new Integer(0) : new Integer(n / 10 + 1);
        Long l = (Long)treeMap.get(n2);
        if (l == null) {
            treeMap.put(n2, new Long(1L));
        } else {
            treeMap.put(n2, new Long(l + 1L));
        }
    }

    private void printStats() {
        System.out.println("\n------------------------------");
        System.out.println("***** TCP SOCKET READ SIZE STATS *****");
        this.printSizes(this.read_sizes, this.total_reads);
        System.out.println("\n***** TCP SOCKET WRITE SIZE STATS *****");
        this.printSizes(this.write_sizes, this.total_writes);
        System.out.println("------------------------------");
    }

    private void printSizes(TreeMap treeMap, long l) {
        int n = 1;
        for (Map.Entry entry : treeMap.entrySet()) {
            int n2 = (Integer)entry.getKey();
            long l2 = (Long)entry.getValue();
            long l3 = l2 * 100L / l;
            if (n2 == 0) {
                if (l3 <= 3L) continue;
                System.out.println("[0 bytes]= x" + l3 + "%");
                continue;
            }
            int n3 = n2 * 10;
            if (l3 > 3L) {
                System.out.println("[" + n + "-" + (n3 - 1) + " bytes]= x" + l3 + "%");
            }
            n = n3;
        }
    }
}

