/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl;

import com.aelitis.azureus.core.networkmanager.EventWaiter;
import com.aelitis.azureus.core.networkmanager.NetworkConnectionBase;
import com.aelitis.azureus.core.networkmanager.RateHandler;
import com.aelitis.azureus.core.networkmanager.impl.RateControlledEntity;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;

public class MultiPeerDownloader2
implements RateControlledEntity {
    private static final int MOVE_TO_IDLE_TIME = 500;
    private static final Object ADD_ACTION = new Object();
    private static final Object REMOVE_ACTION = new Object();
    private volatile ArrayList connections_cow = new ArrayList();
    private final AEMonitor connections_mon = new AEMonitor("MultiPeerDownloader");
    private final RateHandler main_handler;
    private List pending_actions;
    private connectionList active_connections = new connectionList();
    private connectionList idle_connections = new connectionList();
    private long last_idle_check;

    public MultiPeerDownloader2(RateHandler rateHandler) {
        this.main_handler = rateHandler;
    }

    @Override
    public RateHandler getRateHandler() {
        return this.main_handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPeerConnection(NetworkConnectionBase networkConnectionBase) {
        try {
            this.connections_mon.enter();
            ArrayList<NetworkConnectionBase> arrayList = new ArrayList<NetworkConnectionBase>(this.connections_cow.size() + 1);
            arrayList.addAll(this.connections_cow);
            arrayList.add(networkConnectionBase);
            this.connections_cow = arrayList;
            if (this.pending_actions == null) {
                this.pending_actions = new ArrayList();
            }
            this.pending_actions.add(new Object[]{ADD_ACTION, networkConnectionBase});
        }
        finally {
            this.connections_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removePeerConnection(NetworkConnectionBase networkConnectionBase) {
        try {
            this.connections_mon.enter();
            ArrayList arrayList = new ArrayList(this.connections_cow);
            boolean bl = arrayList.remove(networkConnectionBase);
            if (!bl) {
                boolean bl2 = false;
                return bl2;
            }
            this.connections_cow = arrayList;
            if (this.pending_actions == null) {
                this.pending_actions = new ArrayList();
            }
            this.pending_actions.add(new Object[]{REMOVE_ACTION, networkConnectionBase});
            boolean bl3 = true;
            return bl3;
        }
        finally {
            this.connections_mon.exit();
        }
    }

    @Override
    public boolean canProcess(EventWaiter eventWaiter) {
        return this.main_handler.getCurrentNumBytesAllowed() >= 1;
    }

    @Override
    public long getBytesReadyToWrite() {
        return 0L;
    }

    @Override
    public int getConnectionCount() {
        return this.connections_cow.size();
    }

    @Override
    public int getReadyConnectionCount(EventWaiter eventWaiter) {
        int n = 0;
        for (NetworkConnectionBase networkConnectionBase : this.connections_cow) {
            if (networkConnectionBase.getTransportBase().isReadyForRead(eventWaiter) != 0L) continue;
            ++n;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int doProcessing(EventWaiter eventWaiter, int n) {
        int n2;
        Object object;
        long l;
        Object object2;
        int n3 = this.main_handler.getCurrentNumBytesAllowed();
        if (n3 < 1) {
            return 0;
        }
        if (n > 0 && n < n3) {
            n3 = n;
        }
        if (this.pending_actions != null) {
            try {
                this.connections_mon.enter();
                for (int i = 0; i < this.pending_actions.size(); ++i) {
                    Object[] objectArray = (Object[])this.pending_actions.get(i);
                    object2 = (NetworkConnectionBase)objectArray[1];
                    if (objectArray[0] == ADD_ACTION) {
                        this.active_connections.add((NetworkConnectionBase)object2);
                        continue;
                    }
                    this.active_connections.remove((NetworkConnectionBase)object2);
                    this.idle_connections.remove((NetworkConnectionBase)object2);
                }
                this.pending_actions = null;
            }
            finally {
                this.connections_mon.exit();
            }
        }
        if ((l = SystemTime.getSteppedMonotonousTime()) - this.last_idle_check > 500L) {
            this.last_idle_check = l;
            object2 = this.idle_connections.head();
            while (object2 != null) {
                object = ((connectionEntry)object2).connection;
                connectionEntry connectionEntry2 = ((connectionEntry)object2).next;
                if (object.getTransportBase().isReadyForRead(eventWaiter) == 0L) {
                    this.idle_connections.remove((connectionEntry)object2);
                    this.active_connections.addToStart((connectionEntry)object2);
                }
                object2 = connectionEntry2;
            }
        }
        int n4 = n3;
        object = this.active_connections.head();
        int n5 = this.active_connections.size();
        for (n2 = 0; n2 < n5 && object != null && n4 > 0; ++n2) {
            NetworkConnectionBase networkConnectionBase = ((connectionEntry)object).connection;
            connectionEntry connectionEntry3 = ((connectionEntry)object).next;
            long l2 = networkConnectionBase.getTransportBase().isReadyForRead(eventWaiter);
            if (l2 == 0L) {
                int n6 = networkConnectionBase.getMssSize();
                int n7 = n4 > n6 ? n6 : n4;
                int n8 = 0;
                try {
                    n8 = networkConnectionBase.getIncomingMessageQueue().receiveFromTransport(n7);
                }
                catch (Throwable throwable) {
                    if (!(throwable instanceof IOException)) {
                        Debug.printStackTrace(throwable);
                    }
                    networkConnectionBase.notifyOfException(throwable);
                }
                n4 -= n8;
                this.active_connections.moveToEnd((connectionEntry)object);
            } else if (l2 > 500L) {
                this.active_connections.remove((connectionEntry)object);
                this.idle_connections.addToEnd((connectionEntry)object);
            }
            object = connectionEntry3;
        }
        n2 = n3 - n4;
        if (n2 > 0) {
            this.main_handler.bytesProcessed(n2);
            return n2;
        }
        return 0;
    }

    @Override
    public int getPriority() {
        return 1;
    }

    @Override
    public boolean getPriorityBoost() {
        return false;
    }

    @Override
    public String getString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("MPD (" + this.connections_cow.size() + "/" + this.active_connections.size() + "/" + this.idle_connections.size() + ": ");
        int n = 0;
        for (NetworkConnectionBase networkConnectionBase : this.connections_cow) {
            if (n++ > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(networkConnectionBase.getString());
        }
        return stringBuffer.toString();
    }

    protected static class connectionEntry {
        private connectionEntry next;
        private connectionEntry prev;
        private NetworkConnectionBase connection;

        protected connectionEntry(NetworkConnectionBase networkConnectionBase) {
            this.connection = networkConnectionBase;
        }
    }

    protected static class connectionList {
        private int size;
        private connectionEntry head;
        private connectionEntry tail;

        protected connectionList() {
        }

        protected connectionEntry add(NetworkConnectionBase networkConnectionBase) {
            connectionEntry connectionEntry2 = new connectionEntry(networkConnectionBase);
            if (this.head == null) {
                this.head = this.tail = connectionEntry2;
            } else {
                this.tail.next = connectionEntry2;
                connectionEntry2.prev = this.tail;
                this.tail = connectionEntry2;
            }
            ++this.size;
            return connectionEntry2;
        }

        protected void addToEnd(connectionEntry connectionEntry2) {
            connectionEntry2.next = null;
            connectionEntry2.prev = this.tail;
            if (this.tail == null) {
                this.head = this.tail = connectionEntry2;
            } else {
                this.tail.next = connectionEntry2;
                this.tail = connectionEntry2;
            }
            ++this.size;
        }

        protected void addToStart(connectionEntry connectionEntry2) {
            connectionEntry2.next = this.head;
            connectionEntry2.prev = null;
            if (this.head == null) {
                this.head = this.tail = connectionEntry2;
            } else {
                this.head.prev = connectionEntry2;
                this.head = connectionEntry2;
            }
            ++this.size;
        }

        protected void moveToEnd(connectionEntry connectionEntry2) {
            if (connectionEntry2 != this.tail) {
                connectionEntry connectionEntry3 = connectionEntry2.prev;
                connectionEntry connectionEntry4 = connectionEntry2.next;
                if (connectionEntry3 == null) {
                    this.head = connectionEntry4;
                } else {
                    connectionEntry3.next = connectionEntry4;
                }
                connectionEntry4.prev = connectionEntry3;
                connectionEntry2.prev = this.tail;
                connectionEntry2.next = null;
                this.tail.next = connectionEntry2;
                this.tail = connectionEntry2;
            }
        }

        protected connectionEntry remove(NetworkConnectionBase networkConnectionBase) {
            connectionEntry connectionEntry2 = this.head;
            while (connectionEntry2 != null) {
                if (connectionEntry2.connection == networkConnectionBase) {
                    this.remove(connectionEntry2);
                    return connectionEntry2;
                }
                connectionEntry2 = connectionEntry2.next;
            }
            return null;
        }

        protected void remove(connectionEntry connectionEntry2) {
            connectionEntry connectionEntry3 = connectionEntry2.prev;
            connectionEntry connectionEntry4 = connectionEntry2.next;
            if (connectionEntry3 == null) {
                this.head = connectionEntry4;
            } else {
                connectionEntry3.next = connectionEntry4;
            }
            if (connectionEntry4 == null) {
                this.tail = connectionEntry3;
            } else {
                connectionEntry4.prev = connectionEntry3;
            }
            --this.size;
        }

        protected int size() {
            return this.size;
        }

        protected connectionEntry head() {
            return this.head;
        }
    }
}

