/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.admin.impl;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.instancemanager.AZInstance;
import com.aelitis.azureus.core.instancemanager.AZInstanceManager;
import com.aelitis.azureus.core.instancemanager.AZInstanceManagerListener;
import com.aelitis.azureus.core.instancemanager.AZInstanceTracked;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdmin;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminASN;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminASNListener;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminException;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminHTTPProxy;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminNATDevice;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminNetworkInterface;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminNetworkInterfaceAddress;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminNode;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminPropertyChangeListener;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminProtocol;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminRouteListener;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminRoutesListener;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminSocksProxy;
import com.aelitis.azureus.core.networkmanager.admin.impl.NetworkAdminASNImpl;
import com.aelitis.azureus.core.networkmanager.admin.impl.NetworkAdminASNLookupImpl;
import com.aelitis.azureus.core.networkmanager.admin.impl.NetworkAdminHTTPProxyImpl;
import com.aelitis.azureus.core.networkmanager.admin.impl.NetworkAdminNATDeviceImpl;
import com.aelitis.azureus.core.networkmanager.admin.impl.NetworkAdminProtocolImpl;
import com.aelitis.azureus.core.networkmanager.admin.impl.NetworkAdminSocksProxyImpl;
import com.aelitis.azureus.core.networkmanager.admin.impl.NetworkAdminSpeedTestSchedulerImpl;
import com.aelitis.azureus.core.networkmanager.impl.http.HTTPNetworkManager;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPNetworkManager;
import com.aelitis.azureus.core.networkmanager.impl.udp.UDPNetworkManager;
import com.aelitis.azureus.core.proxy.socks.AESocksProxyFactory;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.plugins.upnp.UPnPPlugin;
import com.aelitis.azureus.plugins.upnp.UPnPPluginService;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.Authenticator;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.PasswordAuthentication;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.UnsupportedAddressTypeException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.regex.Pattern;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsEvidenceGenerator;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.AddressUtils;
import org.gudy.azureus2.core3.util.AsyncDispatcher;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.platform.PlatformManager;
import org.gudy.azureus2.platform.PlatformManagerCapabilities;
import org.gudy.azureus2.platform.PlatformManagerFactory;
import org.gudy.azureus2.platform.PlatformManagerPingCallback;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.platform.PlatformManagerException;
import org.gudy.azureus2.plugins.utils.Utilities;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;

public class NetworkAdminImpl
extends NetworkAdmin
implements AEDiagnosticsEvidenceGenerator {
    private static final LogIDs LOGID = LogIDs.NWMAN;
    private static final boolean FULL_INTF_PROBE = false;
    private static InetAddress anyLocalAddress;
    private static InetAddress anyLocalAddressIPv4;
    private static InetAddress anyLocalAddressIPv6;
    private static InetAddress localhostV4;
    private static InetAddress localhostV6;
    private Set<NetworkInterface> old_network_interfaces;
    private InetAddress[] currentBindIPs = new InetAddress[]{null};
    private boolean supportsIPv6withNIO = true;
    private boolean supportsIPv6 = true;
    private boolean supportsIPv4 = true;
    private boolean IPv6_enabled;
    private int roundRobinCounterV4;
    private int roundRobinCounterV6;
    private CopyOnWriteList listeners;
    private NetworkAdminRouteListener trace_route_listener;
    private static final int ASN_MIN_CHECK = 1800000;
    private long last_asn_lookup_time;
    private List asn_ips_checked;
    private List as_history;
    private AsyncDispatcher async_asn_dispacher;
    private static final int MAX_ASYNC_ASN_LOOKUPS = 1024;
    private Map<InetAddress, NetworkAdminASN> async_asn_history;
    private boolean initialised;

    public NetworkAdminImpl() {
        COConfigurationManager.addAndFireParameterListener("IPV6 Enable Support", new ParameterListener(){

            @Override
            public void parameterChanged(String string) {
                NetworkAdminImpl.this.setIPv6Enabled(COConfigurationManager.getBooleanParameter("IPV6 Enable Support"));
            }
        });
        this.roundRobinCounterV4 = 0;
        this.roundRobinCounterV6 = 0;
        this.listeners = new CopyOnWriteList();
        this.trace_route_listener = new NetworkAdminRouteListener(){
            private int node_count = 0;

            @Override
            public boolean foundNode(NetworkAdminNode networkAdminNode, int n, int n2) {
                ++this.node_count;
                return true;
            }

            @Override
            public boolean timeout(int n) {
                return n != 3 || this.node_count != 0;
            }
        };
        this.asn_ips_checked = new ArrayList(0);
        this.as_history = new ArrayList();
        this.async_asn_dispacher = new AsyncDispatcher();
        this.async_asn_history = new LinkedHashMap<InetAddress, NetworkAdminASN>(256, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<InetAddress, NetworkAdminASN> entry) {
                return this.size() > 256;
            }
        };
        COConfigurationManager.addParameterListener(new String[]{"Bind IP", "Enforce Bind IP"}, new ParameterListener(){

            @Override
            public void parameterChanged(String string) {
                NetworkAdminImpl.this.checkDefaultBindAddress(false);
            }
        });
        SimpleTimer.addPeriodicEvent("NetworkAdmin:checker", 15000L, new TimerEventPerformer(){

            @Override
            public void perform(TimerEvent timerEvent2) {
                NetworkAdminImpl.this.checkNetworkInterfaces(false, false);
            }
        });
        this.checkNetworkInterfaces(true, true);
        this.checkDefaultBindAddress(true);
        AEDiagnostics.addEvidenceGenerator(this);
        this.initialised = true;
    }

    protected void setIPv6Enabled(boolean bl) {
        this.IPv6_enabled = bl;
        this.supportsIPv6withNIO = bl;
        this.supportsIPv6 = bl;
        if (this.initialised) {
            this.checkNetworkInterfaces(false, true);
            this.checkDefaultBindAddress(false);
        }
    }

    protected void checkNetworkInterfaces(boolean bl, boolean bl2) {
        block20: {
            try {
                Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
                boolean bl3 = false;
                if (enumeration != null || this.old_network_interfaces != null) {
                    HashSet<NetworkInterface> hashSet;
                    if (enumeration == null) {
                        this.old_network_interfaces = null;
                        bl3 = true;
                    } else if (this.old_network_interfaces == null) {
                        hashSet = new HashSet<NetworkInterface>();
                        while (enumeration.hasMoreElements()) {
                            hashSet.add(enumeration.nextElement());
                        }
                        this.old_network_interfaces = hashSet;
                        bl3 = true;
                    } else {
                        hashSet = new HashSet();
                        while (enumeration.hasMoreElements()) {
                            NetworkInterface networkInterface2 = enumeration.nextElement();
                            if (!this.old_network_interfaces.contains(networkInterface2)) {
                                bl3 = true;
                            }
                            hashSet.add(networkInterface2);
                        }
                        if (this.old_network_interfaces.size() != hashSet.size()) {
                            bl3 = true;
                        }
                        this.old_network_interfaces = hashSet;
                    }
                }
                if (!bl3 && !bl2) break block20;
                boolean bl4 = false;
                boolean bl5 = false;
                Set<NetworkInterface> set = this.old_network_interfaces;
                if (set != null) {
                    for (NetworkInterface networkInterface3 : set) {
                        Enumeration<InetAddress> enumeration2 = networkInterface3.getInetAddresses();
                        while (enumeration2.hasMoreElements()) {
                            InetAddress inetAddress = enumeration2.nextElement();
                            if (inetAddress.isLoopbackAddress()) continue;
                            if (inetAddress instanceof Inet6Address && !inetAddress.isLinkLocalAddress()) {
                                if (!this.IPv6_enabled) continue;
                                bl4 = true;
                                continue;
                            }
                            if (!(inetAddress instanceof Inet4Address)) continue;
                            bl5 = true;
                        }
                    }
                }
                this.supportsIPv4 = bl5;
                this.supportsIPv6 = bl4;
                Logger.log(new LogEvent(LOGID, "NetworkAdmin: ipv4 supported: " + this.supportsIPv4 + "; ipv6: " + this.supportsIPv6 + "; probing v6+nio functionality"));
                if (bl4) {
                    ServerSocketChannel serverSocketChannel = ServerSocketChannel.open();
                    try {
                        serverSocketChannel.configureBlocking(false);
                        serverSocketChannel.socket().bind(new InetSocketAddress(anyLocalAddressIPv6, 0));
                        Logger.log(new LogEvent(LOGID, "NetworkAdmin: testing nio + ipv6 bind successful"));
                        this.supportsIPv6withNIO = true;
                    }
                    catch (Exception exception) {
                        Logger.log(new LogEvent(LOGID, 1, "nio + ipv6 test failed", (Throwable)exception));
                        this.supportsIPv6withNIO = false;
                    }
                    serverSocketChannel.close();
                } else {
                    this.supportsIPv6withNIO = false;
                }
                if (!bl) {
                    Logger.log(new LogEvent(LOGID, "NetworkAdmin: network interfaces have changed"));
                }
                this.firePropertyChange("Network Interfaces");
                this.checkDefaultBindAddress(bl);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public InetAddress getMultiHomedOutgoingRoundRobinBindAddress(InetAddress inetAddress) {
        InetAddress[] inetAddressArray = this.currentBindIPs;
        boolean bl = inetAddress instanceof Inet6Address;
        int n = (bl ? this.roundRobinCounterV6 : this.roundRobinCounterV4) % inetAddressArray.length;
        InetAddress inetAddress2 = null;
        int n2 = n;
        do {
            ++n2;
            if (inetAddress == null || bl && inetAddressArray[n2 %= inetAddressArray.length] instanceof Inet6Address || !bl && inetAddressArray[n2] instanceof Inet4Address) {
                inetAddress2 = inetAddressArray[n2];
                break;
            }
            if (bl || !inetAddressArray[n2].isAnyLocalAddress()) continue;
            inetAddress2 = anyLocalAddressIPv4;
            break;
        } while (n2 != n);
        if (bl) {
            this.roundRobinCounterV6 = n2;
        } else {
            this.roundRobinCounterV4 = n2;
        }
        return inetAddress2 != null ? inetAddress2 : (bl ? localhostV6 : localhostV4);
    }

    @Override
    public InetAddress[] getMultiHomedServiceBindAddresses(boolean bl) {
        InetAddress[] inetAddressArray = this.currentBindIPs;
        for (int i = 0; i < inetAddressArray.length; ++i) {
            if (!inetAddressArray[i].isAnyLocalAddress()) continue;
            return new InetAddress[]{bl && !this.supportsIPv6withNIO && inetAddressArray[i] instanceof Inet6Address ? anyLocalAddressIPv4 : inetAddressArray[i]};
        }
        return inetAddressArray;
    }

    @Override
    public InetAddress getSingleHomedServiceBindAddress(int n) {
        InetAddress[] inetAddressArray = this.currentBindIPs;
        if (n == 0) {
            return inetAddressArray[0];
        }
        for (InetAddress inetAddress : inetAddressArray) {
            if ((n != 1 || !(inetAddress instanceof Inet4Address)) && !inetAddress.isAnyLocalAddress() && (n != 2 || !(inetAddress instanceof Inet6Address))) continue;
            if (inetAddress.isAnyLocalAddress()) {
                if (n == 1) {
                    return anyLocalAddressIPv4;
                }
                return anyLocalAddressIPv6;
            }
            return inetAddress;
        }
        throw new UnsupportedAddressTypeException();
    }

    @Override
    public InetAddress[] getAllBindAddresses(boolean bl) {
        InetAddress[] inetAddressArray;
        if (bl) {
            return this.currentBindIPs;
        }
        ArrayList<InetAddress> arrayList = new ArrayList<InetAddress>();
        for (InetAddress inetAddress : inetAddressArray = this.currentBindIPs) {
            if (inetAddress.isAnyLocalAddress()) continue;
            arrayList.add(inetAddress);
        }
        return arrayList.toArray(new InetAddress[arrayList.size()]);
    }

    private InetAddress[] calcBindAddresses(String string, boolean bl) {
        ArrayList<InetAddress> arrayList = new ArrayList<InetAddress>();
        Pattern pattern = Pattern.compile(";");
        Pattern pattern2 = Pattern.compile("[\\]\\[]");
        String[] stringArray = pattern.split(string);
        block8: for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if ((string2 = string2.trim()).length() == 0) continue;
            InetAddress inetAddress = null;
            try {
                if (string2.indexOf(46) != -1 || string2.indexOf(58) != -1) {
                    inetAddress = InetAddress.getByName(string2);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (inetAddress != null) {
                block19: {
                    try {
                        if (!(inetAddress.isAnyLocalAddress() && arrayList.size() <= 0 || NetworkInterface.getByInetAddress(inetAddress) != null)) {
                        }
                        break block19;
                    }
                    catch (SocketException socketException) {
                        Debug.printStackTrace(socketException);
                    }
                    continue;
                }
                arrayList.add(inetAddress);
                continue;
            }
            String[] stringArray2 = pattern2.split(string2);
            NetworkInterface networkInterface2 = null;
            try {
                networkInterface2 = NetworkInterface.getByName(stringArray2[0]);
            }
            catch (SocketException socketException) {
                socketException.printStackTrace();
            }
            if (networkInterface2 == null) continue;
            Enumeration<InetAddress> enumeration = networkInterface2.getInetAddresses();
            if (stringArray2.length != 2) {
                while (enumeration.hasMoreElements()) {
                    arrayList.add(enumeration.nextElement());
                }
                continue;
            }
            int n = 0;
            try {
                n = Integer.parseInt(stringArray2[1]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            int n2 = 0;
            while (enumeration.hasMoreElements()) {
                if (n2 == n) {
                    arrayList.add(enumeration.nextElement());
                    continue block8;
                }
                ++n2;
                enumeration.nextElement();
            }
        }
        if (!this.IPv6_enabled) {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                if (!(iterator.next() instanceof Inet6Address)) continue;
                iterator.remove();
            }
        }
        if (arrayList.size() < 1) {
            return new InetAddress[]{bl ? localhostV4 : (this.hasIPV6Potential() ? anyLocalAddressIPv6 : anyLocalAddressIPv4)};
        }
        return arrayList.toArray(new InetAddress[arrayList.size()]);
    }

    protected void checkDefaultBindAddress(boolean bl) {
        boolean bl2;
        boolean bl3 = false;
        String string = COConfigurationManager.getStringParameter("Bind IP", "").trim();
        Object[] objectArray = this.calcBindAddresses(string, bl2 = COConfigurationManager.getBooleanParameter("Enforce Bind IP"));
        boolean bl4 = bl3 = !Arrays.equals(this.currentBindIPs, objectArray);
        if (bl3) {
            this.currentBindIPs = objectArray;
            if (!bl) {
                String string2 = "NetworkAdmin: default bind ip has changed to '";
                for (int i = 0; i < objectArray.length; ++i) {
                    string2 = string2 + (objectArray[i] == null ? "none" : ((InetAddress)objectArray[i]).getHostAddress()) + (i < objectArray.length ? ";" : "");
                }
                string2 = string2 + "'";
                Logger.log(new LogEvent(LOGID, string2));
            }
            this.firePropertyChange("Default Bind IP");
        }
    }

    @Override
    public String getNetworkInterfacesAsString() {
        Set<NetworkInterface> set = this.old_network_interfaces;
        if (set == null) {
            return "";
        }
        Iterator<NetworkInterface> iterator = set.iterator();
        String string = "";
        while (iterator.hasNext()) {
            NetworkInterface networkInterface2 = iterator.next();
            Enumeration<InetAddress> enumeration = networkInterface2.getInetAddresses();
            string = string + networkInterface2.getName() + "\t(" + networkInterface2.getDisplayName() + ")\n";
            int n = 0;
            while (enumeration.hasMoreElements()) {
                InetAddress inetAddress = enumeration.nextElement();
                string = string + "\t" + networkInterface2.getName() + "[" + n++ + "]\t" + inetAddress.getHostAddress() + "\n";
            }
        }
        return string;
    }

    @Override
    public boolean hasIPV4Potential() {
        return this.supportsIPv4;
    }

    @Override
    public boolean hasIPV6Potential(boolean bl) {
        return bl ? this.supportsIPv6withNIO : this.supportsIPv6;
    }

    @Override
    public InetAddress[] getBindableAddresses() {
        NetworkAdminNetworkInterface[] networkAdminNetworkInterfaceArray;
        ArrayList<InetAddress> arrayList = new ArrayList<InetAddress>();
        for (NetworkAdminNetworkInterface networkAdminNetworkInterface : networkAdminNetworkInterfaceArray = NetworkAdmin.getSingleton().getInterfaces()) {
            NetworkAdminNetworkInterfaceAddress[] networkAdminNetworkInterfaceAddressArray;
            for (NetworkAdminNetworkInterfaceAddress networkAdminNetworkInterfaceAddress : networkAdminNetworkInterfaceAddressArray = networkAdminNetworkInterface.getAddresses()) {
                InetAddress inetAddress = networkAdminNetworkInterfaceAddress.getAddress();
                if (!this.canBind(inetAddress)) continue;
                arrayList.add(inetAddress);
            }
        }
        return arrayList.toArray(new InetAddress[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean canBind(InetAddress inetAddress) {
        ServerSocketChannel serverSocketChannel = null;
        try {
            serverSocketChannel = ServerSocketChannel.open();
            serverSocketChannel.socket().bind(new InetSocketAddress(inetAddress, 0), 16);
            boolean bl = true;
            return bl;
        }
        catch (Throwable throwable) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (serverSocketChannel != null) {
                try {
                    serverSocketChannel.close();
                }
                catch (Throwable throwable) {
                    Debug.out(throwable);
                }
            }
        }
    }

    @Override
    public int getBindablePort(int n) throws IOException {
        Random random = new Random();
        for (int i = 1; i <= 1024; ++i) {
            int n2 = i == 1 && n != 0 ? n : (i == 1024 ? 0 : random.nextInt(20000) + 40000);
            ServerSocketChannel serverSocketChannel = null;
            try {
                serverSocketChannel = ServerSocketChannel.open();
                serverSocketChannel.socket().setReuseAddress(true);
                this.bind(serverSocketChannel, null, n2);
                n2 = serverSocketChannel.socket().getLocalPort();
                serverSocketChannel.close();
                return n2;
            }
            catch (Throwable throwable) {
                if (serverSocketChannel == null) continue;
                try {
                    serverSocketChannel.close();
                }
                catch (Throwable throwable2) {
                    Debug.printStackTrace(throwable);
                }
                serverSocketChannel = null;
                continue;
            }
        }
        throw new IOException("No bindable ports found");
    }

    protected void bind(ServerSocketChannel serverSocketChannel, InetAddress inetAddress, int n) throws IOException {
        if (inetAddress == null) {
            serverSocketChannel.socket().bind(new InetSocketAddress(n), 1024);
        } else {
            serverSocketChannel.socket().bind(new InetSocketAddress(inetAddress, n), 1024);
        }
    }

    @Override
    public InetAddress guessRoutableBindAddress() {
        try {
            Object object;
            InetAddress[] inetAddressArray;
            Object object2;
            ArrayList<InetAddress> arrayList = new ArrayList<InetAddress>();
            ArrayList<InetAddress> arrayList2 = new ArrayList<InetAddress>();
            try {
                object2 = this.getInterfaces();
                inetAddressArray = new ArrayList();
                for (int i = 0; i < ((Object[])object2).length; ++i) {
                    Object object3 = object2[i];
                    object = object3.getAddresses();
                    for (int j = 0; j < ((NetworkAdminNetworkInterfaceAddress[])object).length; ++j) {
                        NetworkAdminNetworkInterfaceAddress networkAdminNetworkInterfaceAddress = object[j];
                        InetAddress inetAddress = networkAdminNetworkInterfaceAddress.getAddress();
                        if (inetAddress.isLoopbackAddress()) continue;
                        if (inetAddress.isLinkLocalAddress() || inetAddress.isSiteLocalAddress()) {
                            arrayList.add(inetAddress);
                        } else {
                            arrayList2.add(inetAddress);
                        }
                        if ((!this.hasIPV4Potential() || !(inetAddress instanceof Inet4Address)) && (!this.hasIPV6Potential() || !(inetAddress instanceof Inet6Address))) continue;
                        inetAddressArray.add(inetAddress);
                    }
                }
                if (inetAddressArray.size() == 1) {
                    return (InetAddress)inetAddressArray.get(0);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                object2 = this.getSocksProxies();
                if (((Object[])object2).length > 0) {
                    return this.mapAddressToBindIP(InetAddress.getByName(object2[0].getHost()));
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                object2 = this.getNATDevices(AzureusCoreFactory.getSingleton());
                if (((Object[])object2).length > 0) {
                    return this.mapAddressToBindIP(object2[0].getAddress());
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                object2 = new AESemaphore("NA:conTest");
                inetAddressArray = new InetAddress[]{null};
                for (int i = 0; i < arrayList.size(); ++i) {
                    object = (InetAddress)arrayList.get(i);
                    new AEThread2("NA:conTest", true, (InetAddress)object, inetAddressArray, (AESemaphore)object2){
                        final /* synthetic */ InetAddress val$address;
                        final /* synthetic */ InetAddress[] val$can_connect;
                        final /* synthetic */ AESemaphore val$sem;
                        {
                            this.val$address = inetAddress;
                            this.val$can_connect = inetAddressArray;
                            this.val$sem = aESemaphore;
                            super(string, bl);
                        }

                        @Override
                        public void run() {
                            if (NetworkAdminImpl.this.canConnectWithBind(this.val$address, 10000)) {
                                this.val$can_connect[0] = this.val$address;
                                this.val$sem.release();
                            }
                        }
                    }.start();
                }
                if (((AESemaphore)object2).reserve(10000L)) {
                    return inetAddressArray[0];
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (arrayList2.size() > 0) {
                return this.guessAddress(arrayList2);
            }
            if (arrayList.size() > 0) {
                return this.guessAddress(arrayList);
            }
            return null;
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean canConnectWithBind(InetAddress inetAddress, int n) {
        boolean bl;
        Socket socket = null;
        try {
            socket = new Socket();
            socket.bind(new InetSocketAddress(inetAddress, 0));
            socket.setSoTimeout(n);
            socket.connect(new InetSocketAddress("www.google.com", 80), n);
            bl = true;
            if (socket == null) return bl;
        }
        catch (Throwable throwable) {
            try {
                boolean bl2 = false;
                return bl2;
            }
            catch (Throwable throwable2) {
                throw throwable2;
            }
            finally {
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (Throwable throwable3) {}
                }
            }
        }
        try {
            socket.close();
            return bl;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return bl;
    }

    protected InetAddress mapAddressToBindIP(InetAddress inetAddress) {
        boolean[] blArray = this.bytesToBits(inetAddress.getAddress());
        NetworkAdminNetworkInterface[] networkAdminNetworkInterfaceArray = this.getInterfaces();
        InetAddress inetAddress2 = null;
        int n = 0;
        for (int i = 0; i < networkAdminNetworkInterfaceArray.length; ++i) {
            NetworkAdminNetworkInterface networkAdminNetworkInterface = networkAdminNetworkInterfaceArray[i];
            NetworkAdminNetworkInterfaceAddress[] networkAdminNetworkInterfaceAddressArray = networkAdminNetworkInterface.getAddresses();
            for (int j = 0; j < networkAdminNetworkInterfaceAddressArray.length; ++j) {
                NetworkAdminNetworkInterfaceAddress networkAdminNetworkInterfaceAddress = networkAdminNetworkInterfaceAddressArray[j];
                InetAddress inetAddress3 = networkAdminNetworkInterfaceAddress.getAddress();
                byte[] byArray = inetAddress3.getAddress();
                if (blArray.length != byArray.length) continue;
                boolean[] blArray2 = this.bytesToBits(byArray);
                for (int k = 0; k < blArray2.length && blArray[k] == blArray2[k]; ++k) {
                    if (k <= n) continue;
                    n = k;
                    inetAddress2 = inetAddress3;
                }
            }
        }
        return inetAddress2;
    }

    protected boolean[] bytesToBits(byte[] byArray) {
        boolean[] blArray = new boolean[byArray.length * 8];
        for (int i = 0; i < byArray.length; ++i) {
            byte by = byArray[i];
            for (int j = 0; j < 8; ++j) {
                blArray[i * 8 + j] = (by & (byte)(1 << 7 - j)) != 0;
            }
        }
        return blArray;
    }

    protected InetAddress guessAddress(List list) {
        InetAddress inetAddress;
        int n;
        for (n = 0; n < list.size(); ++n) {
            inetAddress = (InetAddress)list.get(n);
            String string = inetAddress.getHostAddress();
            if (!string.startsWith("192.168.0.") && !string.startsWith("192.168.1.")) continue;
            return inetAddress;
        }
        for (n = 0; n < list.size(); ++n) {
            inetAddress = (InetAddress)list.get(n);
            if (!(inetAddress instanceof Inet4Address)) continue;
            return inetAddress;
        }
        for (n = 0; n < list.size(); ++n) {
            inetAddress = (InetAddress)list.get(n);
            if (!(inetAddress instanceof Inet6Address)) continue;
            return inetAddress;
        }
        if (list.size() > 0) {
            return (InetAddress)list.get(0);
        }
        return null;
    }

    @Override
    public InetAddress getDefaultPublicAddress() {
        Utilities utilities = PluginInitializer.getDefaultInterface().getUtilities();
        InetAddress inetAddress = utilities.getPublicAddress();
        if (inetAddress != null) {
            return inetAddress;
        }
        return utilities.getPublicAddress(true);
    }

    @Override
    public InetAddress getDefaultPublicAddressV6() {
        if (!this.supportsIPv6) {
            return null;
        }
        for (InetAddress inetAddress : this.currentBindIPs) {
            if (AddressUtils.isGlobalAddressV6(inetAddress)) {
                return inetAddress;
            }
            if (!(inetAddress instanceof Inet6Address) || !inetAddress.isAnyLocalAddress()) continue;
            ArrayList<InetAddress> arrayList = new ArrayList<InetAddress>();
            for (NetworkInterface networkInterface2 : this.old_network_interfaces) {
                arrayList.addAll(Collections.list(networkInterface2.getInetAddresses()));
            }
            return AddressUtils.pickBestGlobalV6Address(arrayList);
        }
        return null;
    }

    @Override
    public boolean hasDHTIPV6() {
        if (this.hasIPV6Potential(false)) {
            InetAddress inetAddress = this.getDefaultPublicAddressV6();
            return inetAddress != null && !AddressUtils.isTeredo(inetAddress);
        }
        return false;
    }

    protected void firePropertyChange(String string) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            try {
                ((NetworkAdminPropertyChangeListener)iterator.next()).propertyChanged(string);
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    @Override
    public NetworkAdminNetworkInterface[] getInterfaces() {
        Set<NetworkInterface> set = this.old_network_interfaces;
        if (set == null) {
            return new NetworkAdminNetworkInterface[0];
        }
        NetworkAdminNetworkInterface[] networkAdminNetworkInterfaceArray = new NetworkAdminNetworkInterface[set.size()];
        Iterator<NetworkInterface> iterator = set.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            NetworkInterface networkInterface2 = iterator.next();
            networkAdminNetworkInterfaceArray[n++] = new networkInterface(networkInterface2);
        }
        return networkAdminNetworkInterfaceArray;
    }

    @Override
    public NetworkAdminProtocol[] getOutboundProtocols(AzureusCore azureusCore) {
        NetworkAdminProtocol[] networkAdminProtocolArray = new NetworkAdminProtocol[]{new NetworkAdminProtocolImpl(azureusCore, 1), new NetworkAdminProtocolImpl(azureusCore, 2), new NetworkAdminProtocolImpl(azureusCore, 3)};
        return networkAdminProtocolArray;
    }

    @Override
    public NetworkAdminProtocol[] getInboundProtocols(AzureusCore azureusCore) {
        HTTPNetworkManager hTTPNetworkManager;
        int n;
        ArrayList<NetworkAdminProtocolImpl> arrayList = new ArrayList<NetworkAdminProtocolImpl>();
        TCPNetworkManager tCPNetworkManager = TCPNetworkManager.getSingleton();
        if (tCPNetworkManager.isTCPListenerEnabled()) {
            arrayList.add(new NetworkAdminProtocolImpl(azureusCore, 2, tCPNetworkManager.getTCPListeningPortNumber()));
        }
        UDPNetworkManager uDPNetworkManager = UDPNetworkManager.getSingleton();
        int n2 = -1;
        if (uDPNetworkManager.isUDPListenerEnabled()) {
            n2 = uDPNetworkManager.getUDPListeningPortNumber();
            arrayList.add(new NetworkAdminProtocolImpl(azureusCore, 3, n2));
        }
        if (uDPNetworkManager.isUDPNonDataListenerEnabled() && (n = uDPNetworkManager.getUDPNonDataListeningPortNumber()) != n2) {
            n2 = uDPNetworkManager.getUDPNonDataListeningPortNumber();
            arrayList.add(new NetworkAdminProtocolImpl(azureusCore, 3, n2));
        }
        if ((hTTPNetworkManager = HTTPNetworkManager.getSingleton()).isHTTPListenerEnabled()) {
            arrayList.add(new NetworkAdminProtocolImpl(azureusCore, 1, hTTPNetworkManager.getHTTPListeningPortNumber()));
        }
        return arrayList.toArray(new NetworkAdminProtocol[arrayList.size()]);
    }

    @Override
    public InetAddress testProtocol(NetworkAdminProtocol networkAdminProtocol) throws NetworkAdminException {
        return networkAdminProtocol.test(null);
    }

    @Override
    public NetworkAdminSocksProxy[] getSocksProxies() {
        String string = System.getProperty("socksProxyHost", "").trim();
        String string2 = System.getProperty("socksProxyPort", "").trim();
        String string3 = System.getProperty("java.net.socks.username", "").trim();
        String string4 = System.getProperty("java.net.socks.password", "").trim();
        ArrayList<NetworkAdminSocksProxyImpl> arrayList = new ArrayList<NetworkAdminSocksProxyImpl>();
        NetworkAdminSocksProxyImpl networkAdminSocksProxyImpl = new NetworkAdminSocksProxyImpl(string, string2, string3, string4);
        if (networkAdminSocksProxyImpl.isConfigured()) {
            arrayList.add(networkAdminSocksProxyImpl);
        }
        if (COConfigurationManager.getBooleanParameter("Proxy.Data.Enable") && !COConfigurationManager.getBooleanParameter("Proxy.Data.Same")) {
            NetworkAdminSocksProxyImpl networkAdminSocksProxyImpl2;
            string = COConfigurationManager.getStringParameter("Proxy.Data.Host");
            string2 = COConfigurationManager.getStringParameter("Proxy.Data.Port");
            string3 = COConfigurationManager.getStringParameter("Proxy.Data.Username");
            if (string3.trim().equalsIgnoreCase("<none>")) {
                string3 = "";
            }
            if ((networkAdminSocksProxyImpl2 = new NetworkAdminSocksProxyImpl(string, string2, string3, string4 = COConfigurationManager.getStringParameter("Proxy.Data.Password"))).isConfigured()) {
                arrayList.add(networkAdminSocksProxyImpl2);
            }
        }
        return arrayList.toArray(new NetworkAdminSocksProxy[arrayList.size()]);
    }

    @Override
    public NetworkAdminHTTPProxy getHTTPProxy() {
        NetworkAdminHTTPProxyImpl networkAdminHTTPProxyImpl = new NetworkAdminHTTPProxyImpl();
        if (!networkAdminHTTPProxyImpl.isConfigured()) {
            networkAdminHTTPProxyImpl = null;
        }
        return networkAdminHTTPProxyImpl;
    }

    @Override
    public NetworkAdminNATDevice[] getNATDevices(AzureusCore azureusCore) {
        ArrayList<NetworkAdminNATDeviceImpl> arrayList = new ArrayList<NetworkAdminNATDeviceImpl>();
        try {
            PluginInterface pluginInterface = azureusCore.getPluginManager().getPluginInterfaceByClass(UPnPPlugin.class);
            if (pluginInterface != null) {
                UPnPPluginService[] uPnPPluginServiceArray;
                UPnPPlugin uPnPPlugin = (UPnPPlugin)pluginInterface.getPlugin();
                for (UPnPPluginService uPnPPluginService : uPnPPluginServiceArray = uPnPPlugin.getServices()) {
                    NetworkAdminNATDeviceImpl networkAdminNATDeviceImpl = new NetworkAdminNATDeviceImpl(uPnPPluginService);
                    boolean bl = false;
                    for (NetworkAdminNATDeviceImpl networkAdminNATDeviceImpl2 : arrayList) {
                        if (!networkAdminNATDeviceImpl2.sameAs(networkAdminNATDeviceImpl)) continue;
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                    arrayList.add(networkAdminNATDeviceImpl);
                }
            }
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
        }
        return arrayList.toArray(new NetworkAdminNATDevice[arrayList.size()]);
    }

    @Override
    public NetworkAdminASN getCurrentASN() {
        Object object;
        List list = COConfigurationManager.getListParameter("ASN Details", new ArrayList());
        if (list.size() == 0) {
            object = "";
            String string = "";
            String string2 = "";
            try {
                object = COConfigurationManager.getStringParameter("ASN AS");
                string = COConfigurationManager.getStringParameter("ASN ASN");
                string2 = COConfigurationManager.getStringParameter("ASN BGP");
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
            COConfigurationManager.removeParameter("ASN AS");
            COConfigurationManager.removeParameter("ASN ASN");
            COConfigurationManager.removeParameter("ASN BGP");
            COConfigurationManager.removeParameter("ASN Autocheck Performed Time");
            list.add(this.ASNToMap(new NetworkAdminASNImpl((String)object, string, string2)));
            COConfigurationManager.setParameter("ASN Details", list);
        }
        if (list.size() > 0) {
            object = (Map)list.get(0);
            return this.ASNFromMap((Map)object);
        }
        return new NetworkAdminASNImpl("", "", "");
    }

    protected Map ASNToMap(NetworkAdminASNImpl networkAdminASNImpl) {
        HashMap<String, byte[]> hashMap = new HashMap<String, byte[]>();
        byte[] byArray = new byte[]{};
        byte[] byArray2 = new byte[]{};
        byte[] byArray3 = new byte[]{};
        try {
            byArray = networkAdminASNImpl.getAS().getBytes("UTF-8");
            byArray2 = networkAdminASNImpl.getASName().getBytes("UTF-8");
            byArray3 = networkAdminASNImpl.getBGPPrefix().getBytes("UTF-8");
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
        }
        hashMap.put("as", byArray);
        hashMap.put("name", byArray2);
        hashMap.put("bgp", byArray3);
        return hashMap;
    }

    protected NetworkAdminASNImpl ASNFromMap(Map map) {
        String string = "";
        String string2 = "";
        String string3 = "";
        try {
            string = new String((byte[])map.get("as"), "UTF-8");
            string2 = new String((byte[])map.get("name"), "UTF-8");
            string3 = new String((byte[])map.get("bgp"), "UTF-8");
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
        }
        return new NetworkAdminASNImpl(string, string2, string3);
    }

    @Override
    public NetworkAdminASN lookupCurrentASN(InetAddress inetAddress) throws NetworkAdminException {
        Object object;
        NetworkAdminASN networkAdminASN = this.getCurrentASN();
        if (networkAdminASN.matchesCIDR(inetAddress)) {
            return networkAdminASN;
        }
        List list = COConfigurationManager.getListParameter("ASN Details", new ArrayList());
        for (int i = 0; i < list.size(); ++i) {
            Map map = (Map)list.get(i);
            object = this.ASNFromMap(map);
            if (!object.matchesCIDR(inetAddress)) continue;
            list.remove(i);
            list.add(0, map);
            this.firePropertyChange("AS");
            return object;
        }
        if (this.asn_ips_checked.contains(inetAddress)) {
            return networkAdminASN;
        }
        long l = SystemTime.getCurrentTime();
        if (l < this.last_asn_lookup_time || l - this.last_asn_lookup_time > 1800000L) {
            this.last_asn_lookup_time = l;
            object = new NetworkAdminASNLookupImpl(inetAddress);
            NetworkAdminASNImpl networkAdminASNImpl = ((NetworkAdminASNLookupImpl)object).lookup();
            this.asn_ips_checked.add(inetAddress);
            list.add(0, this.ASNToMap(networkAdminASNImpl));
            this.firePropertyChange("AS");
            return networkAdminASNImpl;
        }
        return networkAdminASN;
    }

    @Override
    public NetworkAdminASN lookupASN(InetAddress inetAddress) throws NetworkAdminException {
        NetworkAdminASN networkAdminASN = this.getFromASHistory(inetAddress);
        if (networkAdminASN != null) {
            return networkAdminASN;
        }
        NetworkAdminASNLookupImpl networkAdminASNLookupImpl = new NetworkAdminASNLookupImpl(inetAddress);
        NetworkAdminASNImpl networkAdminASNImpl = networkAdminASNLookupImpl.lookup();
        this.addToASHistory(networkAdminASNImpl);
        return networkAdminASNImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lookupASN(final InetAddress inetAddress, final NetworkAdminASNListener networkAdminASNListener) {
        Map<InetAddress, NetworkAdminASN> map = this.async_asn_history;
        synchronized (map) {
            NetworkAdminASN networkAdminASN = this.async_asn_history.get(inetAddress);
            if (networkAdminASN != null) {
                networkAdminASNListener.success(networkAdminASN);
            }
        }
        int n = this.async_asn_dispacher.getQueueSize();
        if (n >= 1024) {
            networkAdminASNListener.failed(new NetworkAdminException("Too many outstanding lookups"));
        } else {
            this.async_asn_dispacher.dispatch(new AERunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void runSupport() {
                    NetworkAdminASN networkAdminASN;
                    Object object = NetworkAdminImpl.this.async_asn_history;
                    synchronized (object) {
                        networkAdminASN = (NetworkAdminASN)NetworkAdminImpl.this.async_asn_history.get(inetAddress);
                        if (networkAdminASN != null) {
                            networkAdminASNListener.success(networkAdminASN);
                            return;
                        }
                    }
                    try {
                        object = new NetworkAdminASNLookupImpl(inetAddress);
                        networkAdminASN = ((NetworkAdminASNLookupImpl)object).lookup();
                        Map map = NetworkAdminImpl.this.async_asn_history;
                        synchronized (map) {
                            NetworkAdminImpl.this.async_asn_history.put(inetAddress, networkAdminASN);
                        }
                        networkAdminASNListener.success(networkAdminASN);
                    }
                    catch (NetworkAdminException networkAdminException) {
                        networkAdminASNListener.failed(networkAdminException);
                    }
                    catch (Throwable throwable) {
                        networkAdminASNListener.failed(new NetworkAdminException("lookup failed", throwable));
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addToASHistory(NetworkAdminASN networkAdminASN) {
        List list = this.as_history;
        synchronized (list) {
            boolean bl = false;
            for (int i = 0; i < this.as_history.size(); ++i) {
                NetworkAdminASN networkAdminASN2 = (NetworkAdminASN)this.as_history.get(i);
                if (networkAdminASN.getAS() != networkAdminASN2.getAS()) continue;
                bl = true;
                break;
            }
            if (!bl) {
                this.as_history.add(networkAdminASN);
                if (this.as_history.size() > 256) {
                    this.as_history.remove(0);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NetworkAdminASN getFromASHistory(InetAddress inetAddress) {
        List list = this.as_history;
        synchronized (list) {
            for (int i = 0; i < this.as_history.size(); ++i) {
                NetworkAdminASN networkAdminASN = (NetworkAdminASN)this.as_history.get(i);
                if (!networkAdminASN.matchesCIDR(inetAddress)) continue;
                return networkAdminASN;
            }
        }
        return null;
    }

    @Override
    public void runInitialChecks(AzureusCore azureusCore) {
        NetworkAdminSocksProxy[] networkAdminSocksProxyArray;
        AZInstanceManager aZInstanceManager = azureusCore.getInstanceManager();
        final AZInstance aZInstance = aZInstanceManager.getMyInstance();
        aZInstanceManager.addListener(new AZInstanceManagerListener(){
            private InetAddress external_address;

            @Override
            public void instanceFound(AZInstance aZInstance2) {
            }

            @Override
            public void instanceChanged(AZInstance aZInstance2) {
                if (aZInstance2 == aZInstance) {
                    InetAddress inetAddress = aZInstance2.getExternalAddress();
                    if (this.external_address == null || !this.external_address.equals(inetAddress)) {
                        this.external_address = inetAddress;
                        try {
                            NetworkAdminImpl.this.lookupCurrentASN(inetAddress);
                        }
                        catch (Throwable throwable) {
                            Debug.printStackTrace(throwable);
                        }
                    }
                }
            }

            @Override
            public void instanceLost(AZInstance aZInstance2) {
            }

            @Override
            public void instanceTracked(AZInstanceTracked aZInstanceTracked) {
            }
        });
        if (COConfigurationManager.getBooleanParameter("Proxy.Check.On.Start")) {
            networkAdminSocksProxyArray = this.getSocksProxies();
            for (int i = 0; i < networkAdminSocksProxyArray.length; ++i) {
                NetworkAdminSocksProxy networkAdminSocksProxy = networkAdminSocksProxyArray[i];
                try {
                    networkAdminSocksProxy.getVersionsSupported();
                    continue;
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                    Logger.log(new LogAlert(true, 1, "Socks proxy " + networkAdminSocksProxy.getName() + " check failed: " + Debug.getNestedExceptionMessage(throwable)));
                }
            }
            NetworkAdminHTTPProxy networkAdminHTTPProxy = this.getHTTPProxy();
            if (networkAdminHTTPProxy != null) {
                try {
                    networkAdminHTTPProxy.getDetails();
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                    Logger.log(new LogAlert(true, 1, "HTTP proxy " + networkAdminHTTPProxy.getName() + " check failed: " + Debug.getNestedExceptionMessage(throwable)));
                }
            }
        }
        networkAdminSocksProxyArray = NetworkAdminSpeedTestSchedulerImpl.getInstance();
        networkAdminSocksProxyArray.initialise();
    }

    @Override
    public boolean canTraceRoute() {
        PlatformManager platformManager = PlatformManagerFactory.getPlatformManager();
        return platformManager.hasCapability(PlatformManagerCapabilities.TraceRouteAvailability);
    }

    public NetworkAdminNode[] getRoute(InetAddress inetAddress, InetAddress inetAddress2, final int n, final NetworkAdminRouteListener networkAdminRouteListener) throws NetworkAdminException {
        PlatformManager platformManager = PlatformManagerFactory.getPlatformManager();
        if (!this.canTraceRoute()) {
            throw new NetworkAdminException("No trace-route capability on platform");
        }
        final ArrayList arrayList = new ArrayList();
        try {
            platformManager.traceRoute(inetAddress, inetAddress2, new PlatformManagerPingCallback(){
                private long start_time = SystemTime.getCurrentTime();

                @Override
                public boolean reportNode(int n3, InetAddress inetAddress, int n2) {
                    boolean bl = false;
                    if (n >= 0) {
                        long l = SystemTime.getCurrentTime();
                        if (l < this.start_time) {
                            this.start_time = l;
                        }
                        if (l - this.start_time >= (long)n) {
                            bl = true;
                        }
                    }
                    networkNode networkNode2 = null;
                    if (inetAddress != null) {
                        networkNode2 = new networkNode(inetAddress, n3, n2);
                        arrayList.add(networkNode2);
                    }
                    boolean bl2 = networkAdminRouteListener == null ? true : (networkNode2 == null ? networkAdminRouteListener.timeout(n3) : networkAdminRouteListener.foundNode(networkNode2, n3, n2));
                    return bl2 && !bl;
                }
            });
        }
        catch (PlatformManagerException platformManagerException) {
            throw new NetworkAdminException("trace-route failed", platformManagerException);
        }
        return arrayList.toArray(new NetworkAdminNode[arrayList.size()]);
    }

    @Override
    public boolean canPing() {
        PlatformManager platformManager = PlatformManagerFactory.getPlatformManager();
        return platformManager.hasCapability(PlatformManagerCapabilities.PingAvailability);
    }

    public NetworkAdminNode pingTarget(InetAddress inetAddress, InetAddress inetAddress2, final int n, final NetworkAdminRouteListener networkAdminRouteListener) throws NetworkAdminException {
        PlatformManager platformManager = PlatformManagerFactory.getPlatformManager();
        if (!this.canPing()) {
            throw new NetworkAdminException("No ping capability on platform");
        }
        final NetworkAdminNode[] networkAdminNodeArray = new NetworkAdminNode[]{null};
        try {
            platformManager.ping(inetAddress, inetAddress2, new PlatformManagerPingCallback(){
                private long start_time = SystemTime.getCurrentTime();

                @Override
                public boolean reportNode(int n3, InetAddress inetAddress, int n2) {
                    boolean bl = false;
                    if (n >= 0) {
                        long l = SystemTime.getCurrentTime();
                        if (l < this.start_time) {
                            this.start_time = l;
                        }
                        if (l - this.start_time >= (long)n) {
                            bl = true;
                        }
                    }
                    networkNode networkNode2 = null;
                    if (inetAddress != null) {
                        networkNode2 = new networkNode(inetAddress, n3, n2);
                        networkAdminNodeArray[0] = networkNode2;
                    }
                    boolean bl2 = networkAdminRouteListener == null ? false : (networkNode2 == null ? networkAdminRouteListener.timeout(n3) : networkAdminRouteListener.foundNode(networkNode2, n3, n2));
                    return bl2 && !bl;
                }
            });
        }
        catch (PlatformManagerException platformManagerException) {
            throw new NetworkAdminException("ping failed", platformManagerException);
        }
        return networkAdminNodeArray[0];
    }

    @Override
    public void getRoutes(final InetAddress inetAddress, int n, final NetworkAdminRoutesListener networkAdminRoutesListener) throws NetworkAdminException {
        int n2;
        ArrayList<AESemaphore> arrayList = new ArrayList<AESemaphore>();
        ArrayList arrayList2 = new ArrayList();
        NetworkAdminNetworkInterface[] networkAdminNetworkInterfaceArray = this.getInterfaces();
        for (n2 = 0; n2 < networkAdminNetworkInterfaceArray.length; ++n2) {
            NetworkAdminNetworkInterface networkAdminNetworkInterface = networkAdminNetworkInterfaceArray[n2];
            NetworkAdminNetworkInterfaceAddress[] networkAdminNetworkInterfaceAddressArray = networkAdminNetworkInterface.getAddresses();
            for (int i = 0; i < networkAdminNetworkInterfaceAddressArray.length; ++i) {
                final NetworkAdminNetworkInterfaceAddress networkAdminNetworkInterfaceAddress = networkAdminNetworkInterfaceAddressArray[i];
                InetAddress inetAddress2 = networkAdminNetworkInterfaceAddress.getAddress();
                if (inetAddress2.isLoopbackAddress() || inetAddress2 instanceof Inet6Address) continue;
                final AESemaphore aESemaphore = new AESemaphore("parallelRouter");
                final ArrayList arrayList3 = new ArrayList();
                arrayList.add(aESemaphore);
                arrayList2.add(arrayList3);
                new AEThread2("parallelRouter", true){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            networkAdminNetworkInterfaceAddress.getRoute(inetAddress, 30000, new NetworkAdminRouteListener(){

                                @Override
                                public boolean foundNode(NetworkAdminNode networkAdminNode, int n, int n2) {
                                    arrayList3.add(networkAdminNode);
                                    NetworkAdminNode[] networkAdminNodeArray = new NetworkAdminNode[arrayList3.size()];
                                    arrayList3.toArray(networkAdminNodeArray);
                                    return networkAdminRoutesListener.foundNode(networkAdminNetworkInterfaceAddress, networkAdminNodeArray, n, n2);
                                }

                                @Override
                                public boolean timeout(int n) {
                                    NetworkAdminNode[] networkAdminNodeArray = new NetworkAdminNode[arrayList3.size()];
                                    arrayList3.toArray(networkAdminNodeArray);
                                    return networkAdminRoutesListener.timeout(networkAdminNetworkInterfaceAddress, networkAdminNodeArray, n);
                                }
                            });
                        }
                        catch (Throwable throwable) {
                            throwable.printStackTrace();
                        }
                        finally {
                            aESemaphore.release();
                        }
                    }
                }.start();
            }
        }
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            ((AESemaphore)arrayList.get(n2)).reserve();
        }
    }

    @Override
    public void pingTargets(final InetAddress inetAddress, int n, final NetworkAdminRoutesListener networkAdminRoutesListener) throws NetworkAdminException {
        int n2;
        ArrayList<AESemaphore> arrayList = new ArrayList<AESemaphore>();
        ArrayList arrayList2 = new ArrayList();
        NetworkAdminNetworkInterface[] networkAdminNetworkInterfaceArray = this.getInterfaces();
        for (n2 = 0; n2 < networkAdminNetworkInterfaceArray.length; ++n2) {
            NetworkAdminNetworkInterface networkAdminNetworkInterface = networkAdminNetworkInterfaceArray[n2];
            NetworkAdminNetworkInterfaceAddress[] networkAdminNetworkInterfaceAddressArray = networkAdminNetworkInterface.getAddresses();
            for (int i = 0; i < networkAdminNetworkInterfaceAddressArray.length; ++i) {
                final NetworkAdminNetworkInterfaceAddress networkAdminNetworkInterfaceAddress = networkAdminNetworkInterfaceAddressArray[i];
                InetAddress inetAddress2 = networkAdminNetworkInterfaceAddress.getAddress();
                if (inetAddress2.isLoopbackAddress() || inetAddress2 instanceof Inet6Address) continue;
                final AESemaphore aESemaphore = new AESemaphore("parallelPinger");
                final ArrayList arrayList3 = new ArrayList();
                arrayList.add(aESemaphore);
                arrayList2.add(arrayList3);
                new AEThread2("parallelPinger", true){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            networkAdminNetworkInterfaceAddress.pingTarget(inetAddress, 30000, new NetworkAdminRouteListener(){

                                @Override
                                public boolean foundNode(NetworkAdminNode networkAdminNode, int n, int n2) {
                                    arrayList3.add(networkAdminNode);
                                    NetworkAdminNode[] networkAdminNodeArray = new NetworkAdminNode[arrayList3.size()];
                                    arrayList3.toArray(networkAdminNodeArray);
                                    return networkAdminRoutesListener.foundNode(networkAdminNetworkInterfaceAddress, networkAdminNodeArray, n, n2);
                                }

                                @Override
                                public boolean timeout(int n) {
                                    NetworkAdminNode[] networkAdminNodeArray = new NetworkAdminNode[arrayList3.size()];
                                    arrayList3.toArray(networkAdminNodeArray);
                                    return networkAdminRoutesListener.timeout(networkAdminNetworkInterfaceAddress, networkAdminNodeArray, n);
                                }
                            });
                        }
                        catch (Throwable throwable) {
                            throwable.printStackTrace();
                        }
                        finally {
                            aESemaphore.release();
                        }
                    }
                }.start();
            }
        }
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            ((AESemaphore)arrayList.get(n2)).reserve();
        }
    }

    @Override
    public void addPropertyChangeListener(NetworkAdminPropertyChangeListener networkAdminPropertyChangeListener) {
        this.listeners.add(networkAdminPropertyChangeListener);
    }

    @Override
    public void addAndFirePropertyChangeListener(NetworkAdminPropertyChangeListener networkAdminPropertyChangeListener) {
        this.listeners.add(networkAdminPropertyChangeListener);
        for (int i = 0; i < NetworkAdmin.PR_NAMES.length; ++i) {
            try {
                networkAdminPropertyChangeListener.propertyChanged(PR_NAMES[i]);
                continue;
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    @Override
    public void removePropertyChangeListener(NetworkAdminPropertyChangeListener networkAdminPropertyChangeListener) {
        this.listeners.remove(networkAdminPropertyChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generate(IndentWriter indentWriter) {
        indentWriter.println("Network Admin");
        try {
            Object object;
            Object object2;
            indentWriter.indent();
            try {
                indentWriter.println("Binding Details");
                indentWriter.indent();
                indentWriter.println("bind to: " + this.getString(this.getAllBindAddresses(false)));
                indentWriter.println("bindable: " + this.getString(this.getBindableAddresses()));
                indentWriter.println("ipv6_enabled=" + this.IPv6_enabled);
                indentWriter.println("ipv4_potential=" + this.hasIPV4Potential());
                indentWriter.println("ipv6_potential=" + this.hasIPV6Potential(false) + "/" + this.hasIPV6Potential(true));
                try {
                    indentWriter.println("single homed: " + this.getSingleHomedServiceBindAddress());
                }
                catch (Throwable throwable) {
                    indentWriter.println("single homed: none");
                }
                try {
                    indentWriter.println("single homed (4): " + this.getSingleHomedServiceBindAddress(1));
                }
                catch (Throwable throwable) {
                    indentWriter.println("single homed (4): none");
                }
                try {
                    indentWriter.println("single homed (6): " + this.getSingleHomedServiceBindAddress(2));
                }
                catch (Throwable throwable) {
                    indentWriter.println("single homed (6): none");
                }
                indentWriter.println("multi homed, nio=false: " + this.getString(this.getMultiHomedServiceBindAddresses(false)));
                indentWriter.println("multi homed, nio=true:  " + this.getString(this.getMultiHomedServiceBindAddresses(true)));
            }
            finally {
                indentWriter.exdent();
            }
            NetworkAdminHTTPProxy networkAdminHTTPProxy = this.getHTTPProxy();
            if (networkAdminHTTPProxy == null) {
                indentWriter.println("HTTP proxy: none");
            } else {
                indentWriter.println("HTTP proxy: " + networkAdminHTTPProxy.getName());
                try {
                    object2 = networkAdminHTTPProxy.getDetails();
                    indentWriter.println("    name: " + object2.getServerName());
                    indentWriter.println("    resp: " + object2.getResponse());
                    indentWriter.println("    auth: " + object2.getAuthenticationType());
                }
                catch (NetworkAdminException networkAdminException) {
                    indentWriter.println("    failed: " + networkAdminException.getLocalizedMessage());
                }
            }
            object2 = this.getSocksProxies();
            if (((NetworkAdminSocksProxy[])object2).length == 0) {
                indentWriter.println("Socks proxy: none");
            } else {
                for (int i = 0; i < ((NetworkAdminSocksProxy[])object2).length; ++i) {
                    NetworkAdminSocksProxy networkAdminSocksProxy = object2[i];
                    indentWriter.println("Socks proxy: " + networkAdminSocksProxy.getName());
                    try {
                        object = networkAdminSocksProxy.getVersionsSupported();
                        String string = "";
                        for (int j = 0; j < ((String[])object).length; ++j) {
                            string = string + (j == 0 ? "" : ",") + (String)object[j];
                        }
                        indentWriter.println("   version: " + string);
                        continue;
                    }
                    catch (NetworkAdminException networkAdminException) {
                        indentWriter.println("    failed: " + networkAdminException.getLocalizedMessage());
                    }
                }
            }
            try {
                NetworkAdminNATDevice[] networkAdminNATDeviceArray = this.getNATDevices(AzureusCoreFactory.getSingleton());
                indentWriter.println("NAT Devices: " + networkAdminNATDeviceArray.length);
                for (int i = 0; i < networkAdminNATDeviceArray.length; ++i) {
                    object = networkAdminNATDeviceArray[i];
                    indentWriter.println("    " + object.getName() + ",address=" + object.getAddress().getHostAddress() + ":" + object.getPort() + ",ext=" + object.getExternalAddress());
                }
            }
            catch (Exception exception) {
                indentWriter.println("Nat Devices: Can't get -> " + exception.toString());
            }
            indentWriter.println("Interfaces");
            indentWriter.println("   " + this.getNetworkInterfacesAsString());
        }
        finally {
            indentWriter.exdent();
        }
    }

    private String getString(InetAddress[] inetAddressArray) {
        String string = "";
        for (InetAddress inetAddress : inetAddressArray) {
            string = string + (string.length() == 0 ? "" : ", ") + inetAddress.getHostAddress();
        }
        return string;
    }

    @Override
    public void generateDiagnostics(final IndentWriter indentWriter) {
        Object[] objectArray;
        Object object;
        Object object2;
        HashSet<InetAddress> hashSet = new HashSet<InetAddress>();
        NetworkAdminHTTPProxy networkAdminHTTPProxy = this.getHTTPProxy();
        if (networkAdminHTTPProxy == null) {
            indentWriter.println("HTTP proxy: none");
        } else {
            indentWriter.println("HTTP proxy: " + networkAdminHTTPProxy.getName());
            try {
                object2 = networkAdminHTTPProxy.getDetails();
                indentWriter.println("    name: " + object2.getServerName());
                indentWriter.println("    resp: " + object2.getResponse());
                indentWriter.println("    auth: " + object2.getAuthenticationType());
            }
            catch (NetworkAdminException networkAdminException) {
                indentWriter.println("    failed: " + networkAdminException.getLocalizedMessage());
            }
        }
        object2 = this.getSocksProxies();
        if (((NetworkAdminSocksProxy[])object2).length == 0) {
            indentWriter.println("Socks proxy: none");
        } else {
            for (int i = 0; i < ((NetworkAdminSocksProxy[])object2).length; ++i) {
                NetworkAdminSocksProxy networkAdminSocksProxy = object2[i];
                indentWriter.println("Socks proxy: " + networkAdminSocksProxy.getName());
                try {
                    object = networkAdminSocksProxy.getVersionsSupported();
                    String string = "";
                    for (int j = 0; j < ((String[])object).length; ++j) {
                        string = string + (j == 0 ? "" : ",") + (String)object[j];
                    }
                    indentWriter.println("   version: " + string);
                    continue;
                }
                catch (NetworkAdminException networkAdminException) {
                    indentWriter.println("    failed: " + networkAdminException.getLocalizedMessage());
                }
            }
        }
        try {
            objectArray = this.getNATDevices(AzureusCoreFactory.getSingleton());
            indentWriter.println("NAT Devices: " + objectArray.length);
            for (int i = 0; i < objectArray.length; ++i) {
                object = objectArray[i];
                indentWriter.println("    " + object.getName() + ",address=" + object.getAddress().getHostAddress() + ":" + object.getPort() + ",ext=" + object.getExternalAddress());
                hashSet.add(object.getExternalAddress());
            }
        }
        catch (Exception exception) {
            indentWriter.println("Nat Devices: Can't get -> " + exception.toString());
        }
        indentWriter.println("Interfaces");
        objectArray = this.getInterfaces();
        try {
            this.pingTargets(InetAddress.getByName("www.google.com"), 30000, new NetworkAdminRoutesListener(){
                private int timeouts = 0;

                @Override
                public boolean foundNode(NetworkAdminNetworkInterfaceAddress networkAdminNetworkInterfaceAddress, NetworkAdminNode[] networkAdminNodeArray, int n, int n2) {
                    indentWriter.println(networkAdminNetworkInterfaceAddress.getAddress().getHostAddress() + ": " + networkAdminNodeArray[networkAdminNodeArray.length - 1].getAddress().getHostAddress() + " (" + n + ")");
                    return false;
                }

                @Override
                public boolean timeout(NetworkAdminNetworkInterfaceAddress networkAdminNetworkInterfaceAddress, NetworkAdminNode[] networkAdminNodeArray, int n) {
                    indentWriter.println(networkAdminNetworkInterfaceAddress.getAddress().getHostAddress() + ": timeout (dist=" + n + ")");
                    ++this.timeouts;
                    return this.timeouts < 3;
                }
            });
        }
        catch (Throwable throwable) {
            indentWriter.println("getRoutes failed: " + Debug.getNestedExceptionMessage(throwable));
        }
        indentWriter.println("Inbound protocols: default routing");
        if (AzureusCoreFactory.isCoreRunning()) {
            InetAddress inetAddress;
            int n;
            AzureusCore azureusCore = AzureusCoreFactory.getSingleton();
            object = this.getInboundProtocols(azureusCore);
            for (n = 0; n < ((Object)object).length; ++n) {
                Object object3 = object[n];
                try {
                    inetAddress = this.testProtocol((NetworkAdminProtocol)object3);
                    if (inetAddress != null) {
                        hashSet.add(inetAddress);
                    }
                    indentWriter.println("    " + object3.getName() + " - " + inetAddress);
                    continue;
                }
                catch (NetworkAdminException networkAdminException) {
                    indentWriter.println("    " + object3.getName() + " - " + Debug.getNestedExceptionMessage(networkAdminException));
                }
            }
            indentWriter.println("Outbound protocols: default routing");
            object = this.getOutboundProtocols(azureusCore);
            for (n = 0; n < ((Object)object).length; ++n) {
                Object object4 = object[n];
                try {
                    inetAddress = this.testProtocol((NetworkAdminProtocol)object4);
                    if (inetAddress != null) {
                        hashSet.add(inetAddress);
                    }
                    indentWriter.println("    " + object4.getName() + " - " + inetAddress);
                    continue;
                }
                catch (NetworkAdminException networkAdminException) {
                    indentWriter.println("    " + object4.getName() + " - " + Debug.getNestedExceptionMessage(networkAdminException));
                }
            }
        }
        Iterator iterator = hashSet.iterator();
        indentWriter.println("Public Addresses");
        while (iterator.hasNext()) {
            object = (InetAddress)iterator.next();
            try {
                NetworkAdminASN networkAdminASN = this.lookupCurrentASN((InetAddress)object);
                indentWriter.println("    " + ((InetAddress)object).getHostAddress() + " -> " + networkAdminASN.getAS() + "/" + networkAdminASN.getASName());
            }
            catch (Throwable throwable) {
                indentWriter.println("    " + ((InetAddress)object).getHostAddress() + " -> " + Debug.getNestedExceptionMessage(throwable));
            }
        }
    }

    protected void generateDiagnostics(IndentWriter indentWriter, NetworkAdminProtocol[] networkAdminProtocolArray) {
        for (int i = 0; i < networkAdminProtocolArray.length; ++i) {
            NetworkAdminProtocol networkAdminProtocol = networkAdminProtocolArray[i];
            indentWriter.println("Testing " + networkAdminProtocol.getName());
            try {
                InetAddress inetAddress = this.testProtocol(networkAdminProtocol);
                indentWriter.println("    -> OK, public address=" + inetAddress);
                continue;
            }
            catch (NetworkAdminException networkAdminException) {
                indentWriter.println("    -> Failed: " + Debug.getNestedExceptionMessage(networkAdminException));
            }
        }
    }

    @Override
    public void logNATStatus(IndentWriter indentWriter) {
        if (AzureusCoreFactory.isCoreRunning()) {
            this.generateDiagnostics(indentWriter, this.getInboundProtocols(AzureusCoreFactory.getSingleton()));
        }
    }

    public static void main(String[] stringArray) {
        boolean bl = false;
        boolean bl2 = false;
        try {
            Object object;
            if (bl) {
                object = AESocksProxyFactory.create(4567, 10000L, 10000L);
                object.setAllowExternalConnections(true);
                System.setProperty("socksProxyHost", "localhost");
                System.setProperty("socksProxyPort", "4567");
            }
            if (bl2) {
                System.setProperty("http.proxyHost", "localhost");
                System.setProperty("http.proxyPort", "3128");
                System.setProperty("https.proxyHost", "localhost");
                System.setProperty("https.proxyPort", "3128");
                Authenticator.setDefault(new Authenticator(){

                    @Override
                    protected PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication("fred", "bill".toCharArray());
                    }
                });
            }
            object = new IndentWriter(new PrintWriter(System.out));
            ((IndentWriter)object).setForce(true);
            COConfigurationManager.initialise();
            AzureusCoreFactory.create();
            NetworkAdmin networkAdmin = NetworkAdminImpl.getSingleton();
            networkAdmin.generateDiagnostics((IndentWriter)object);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    static {
        try {
            anyLocalAddressIPv4 = InetAddress.getByAddress(new byte[]{0, 0, 0, 0});
            anyLocalAddressIPv6 = InetAddress.getByAddress(new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
            anyLocalAddress = new InetSocketAddress(0).getAddress();
            localhostV4 = InetAddress.getByAddress(new byte[]{127, 0, 0, 1});
            localhostV6 = InetAddress.getByAddress(new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1});
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
        }
    }

    protected class networkNode
    implements NetworkAdminNode {
        private InetAddress address;
        private int distance;
        private int rtt;

        protected networkNode(InetAddress inetAddress, int n, int n2) {
            this.address = inetAddress;
            this.distance = n;
            this.rtt = n2;
        }

        @Override
        public InetAddress getAddress() {
            return this.address;
        }

        @Override
        public boolean isLocalAddress() {
            return this.address.isLinkLocalAddress() || this.address.isSiteLocalAddress();
        }

        @Override
        public int getDistance() {
            return this.distance;
        }

        @Override
        public int getRTT() {
            return this.rtt;
        }

        protected String getString() {
            if (this.address == null) {
                return "" + this.distance;
            }
            return this.distance + "," + this.address + "[local=" + this.isLocalAddress() + "]," + this.rtt;
        }
    }

    protected class networkInterface
    implements NetworkAdminNetworkInterface {
        private NetworkInterface ni;

        protected networkInterface(NetworkInterface networkInterface2) {
            this.ni = networkInterface2;
        }

        @Override
        public String getDisplayName() {
            return this.ni.getDisplayName();
        }

        @Override
        public String getName() {
            return this.ni.getName();
        }

        @Override
        public NetworkAdminNetworkInterfaceAddress[] getAddresses() {
            Enumeration<InetAddress> enumeration = this.ni.getInetAddresses();
            ArrayList<networkAddress> arrayList = new ArrayList<networkAddress>();
            while (enumeration.hasMoreElements()) {
                InetAddress inetAddress = enumeration.nextElement();
                if (inetAddress instanceof Inet6Address && !NetworkAdminImpl.this.IPv6_enabled) continue;
                arrayList.add(new networkAddress(inetAddress));
            }
            return arrayList.toArray(new NetworkAdminNetworkInterfaceAddress[arrayList.size()]);
        }

        @Override
        public String getString() {
            String string = this.getDisplayName() + "/" + this.getName() + " [";
            NetworkAdminNetworkInterfaceAddress[] networkAdminNetworkInterfaceAddressArray = this.getAddresses();
            for (int i = 0; i < networkAdminNetworkInterfaceAddressArray.length; ++i) {
                networkAddress networkAddress2 = (networkAddress)networkAdminNetworkInterfaceAddressArray[i];
                string = string + (i == 0 ? "" : ",") + networkAddress2.getAddress().getHostAddress();
            }
            return string + "]";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void generateDiagnostics(IndentWriter indentWriter, Set set) {
            indentWriter.println(this.getDisplayName() + "/" + this.getName());
            NetworkAdminNetworkInterfaceAddress[] networkAdminNetworkInterfaceAddressArray = this.getAddresses();
            for (int i = 0; i < networkAdminNetworkInterfaceAddressArray.length; ++i) {
                networkAddress networkAddress2 = (networkAddress)networkAdminNetworkInterfaceAddressArray[i];
                indentWriter.indent();
                try {
                    networkAddress2.generateDiagnostics(indentWriter, set);
                    continue;
                }
                finally {
                    indentWriter.exdent();
                }
            }
        }

        protected class networkAddress
        implements NetworkAdminNetworkInterfaceAddress {
            private InetAddress address;

            protected networkAddress(InetAddress inetAddress) {
                this.address = inetAddress;
            }

            @Override
            public NetworkAdminNetworkInterface getInterface() {
                return networkInterface.this;
            }

            @Override
            public InetAddress getAddress() {
                return this.address;
            }

            @Override
            public boolean isLoopback() {
                return this.address.isLoopbackAddress();
            }

            @Override
            public NetworkAdminNode[] getRoute(InetAddress inetAddress, int n, NetworkAdminRouteListener networkAdminRouteListener) throws NetworkAdminException {
                return NetworkAdminImpl.this.getRoute(this.address, inetAddress, n, networkAdminRouteListener);
            }

            @Override
            public NetworkAdminNode pingTarget(InetAddress inetAddress, int n, NetworkAdminRouteListener networkAdminRouteListener) throws NetworkAdminException {
                return NetworkAdminImpl.this.pingTarget(this.address, inetAddress, n, networkAdminRouteListener);
            }

            @Override
            public InetAddress testProtocol(NetworkAdminProtocol networkAdminProtocol) throws NetworkAdminException {
                return networkAdminProtocol.test(this);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void generateDiagnostics(IndentWriter indentWriter, Set set) {
                block15: {
                    indentWriter.println("" + this.getAddress());
                    try {
                        InetAddress inetAddress;
                        NetworkAdminProtocol networkAdminProtocol;
                        int n;
                        Object object;
                        indentWriter.println("  Trace route");
                        indentWriter.indent();
                        if (this.isLoopback()) {
                            indentWriter.println("Loopback - ignoring");
                            break block15;
                        }
                        try {
                            object = this.getRoute(InetAddress.getByName("www.google.com"), 30000, NetworkAdminImpl.this.trace_route_listener);
                            for (int i = 0; i < ((NetworkAdminNode[])object).length; ++i) {
                                networkNode networkNode2 = (networkNode)object[i];
                                indentWriter.println(networkNode2.getString());
                            }
                        }
                        catch (Throwable throwable) {
                            indentWriter.println("Can't resolve host for route trace - " + throwable.getMessage());
                        }
                        indentWriter.println("Outbound protocols: bound");
                        object = AzureusCoreFactory.getSingleton();
                        NetworkAdminProtocol[] networkAdminProtocolArray = NetworkAdminImpl.this.getOutboundProtocols((AzureusCore)object);
                        for (n = 0; n < networkAdminProtocolArray.length; ++n) {
                            networkAdminProtocol = networkAdminProtocolArray[n];
                            try {
                                inetAddress = this.testProtocol(networkAdminProtocol);
                                if (inetAddress != null) {
                                    set.add(inetAddress);
                                }
                                indentWriter.println("    " + networkAdminProtocol.getName() + " - " + inetAddress);
                                continue;
                            }
                            catch (NetworkAdminException networkAdminException) {
                                indentWriter.println("    " + networkAdminProtocol.getName() + " - " + Debug.getNestedExceptionMessage(networkAdminException));
                            }
                        }
                        indentWriter.println("Inbound protocols: bound");
                        networkAdminProtocolArray = NetworkAdminImpl.this.getInboundProtocols((AzureusCore)object);
                        for (n = 0; n < networkAdminProtocolArray.length; ++n) {
                            networkAdminProtocol = networkAdminProtocolArray[n];
                            try {
                                inetAddress = this.testProtocol(networkAdminProtocol);
                                if (inetAddress != null) {
                                    set.add(inetAddress);
                                }
                                indentWriter.println("    " + networkAdminProtocol.getName() + " - " + inetAddress);
                                continue;
                            }
                            catch (NetworkAdminException networkAdminException) {
                                indentWriter.println("    " + networkAdminProtocol.getName() + " - " + Debug.getNestedExceptionMessage(networkAdminException));
                            }
                        }
                    }
                    finally {
                        indentWriter.exdent();
                    }
                }
            }
        }
    }
}

