/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.messenger.config;

import com.aelitis.azureus.core.messenger.PlatformMessengerException;
import com.aelitis.azureus.core.messenger.config.PlatformMessengerConfig;
import com.aelitis.azureus.core.security.CryptoECCUtils;
import java.security.Signature;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.json.simple.JSONArray;

public class PlatformSubscriptionsMessenger {
    private static final boolean MESSAGING_ENABLED = true;
    private static final PlatformMessengerConfig dispatcher = new PlatformMessengerConfig("subscription", false);
    private static final String OP_CREATE_SUBS = "create-subscription";
    private static final String OP_UPDATE_SUBS = "update-subscription";
    private static final String OP_GET_SUBS_BY_SID = "get-subscriptions";
    private static final String OP_GET_POP_BY_SID = "get-subscription-infos";
    private static final String OP_SET_SELECTED = "set-selected";

    public static void updateSubscription(boolean bl, String string, byte[] byArray, byte[] byArray2, byte[] byArray3, int n, String string2) throws PlatformMessengerException {
        String string3 = bl ? OP_CREATE_SUBS : OP_UPDATE_SUBS;
        PlatformSubscriptionsMessenger.checkEnabled(string3);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        String string4 = Base32.encode(byArray3);
        String string5 = Base32.encode(byArray);
        hashMap.put("name", string);
        hashMap.put("subscription_id", string4);
        hashMap.put("version_number", new Long(n));
        hashMap.put("content", string2);
        if (bl) {
            hashMap.put("public_key", string5);
        }
        try {
            Signature signature = CryptoECCUtils.getSignature(CryptoECCUtils.rawdataToPrivkey(byArray2));
            signature.update((string + string5 + string4 + n + string2).getBytes("UTF-8"));
            byte[] byArray4 = signature.sign();
            hashMap.put("signature", Base32.encode(byArray4));
            dispatcher.syncInvoke(string3, hashMap);
        }
        catch (Throwable throwable) {
            throw new PlatformMessengerException("Failed to create/update subscription", throwable);
        }
    }

    public static subscriptionDetails getSubscriptionBySID(byte[] byArray) throws PlatformMessengerException {
        PlatformSubscriptionsMessenger.checkEnabled(OP_GET_SUBS_BY_SID);
        HashMap<String, JSONArray> hashMap = new HashMap<String, JSONArray>();
        JSONArray jSONArray = new JSONArray();
        jSONArray.add(Base32.encode(byArray));
        hashMap.put("subscription_ids", jSONArray);
        Map map = dispatcher.syncInvoke(OP_GET_SUBS_BY_SID, hashMap);
        for (int i = 0; i < jSONArray.size(); ++i) {
            Map map2 = (Map)map.get((String)jSONArray.get(i));
            if (map2 == null) continue;
            subscriptionDetails subscriptionDetails2 = new subscriptionDetails(map2);
            return subscriptionDetails2;
        }
        throw new PlatformMessengerException("Unknown sid '" + ByteFormatter.encodeString(byArray) + "'");
    }

    public static long getPopularityBySID(byte[] byArray) throws PlatformMessengerException {
        PlatformSubscriptionsMessenger.checkEnabled(OP_GET_POP_BY_SID);
        HashMap<String, JSONArray> hashMap = new HashMap<String, JSONArray>();
        JSONArray jSONArray = new JSONArray();
        jSONArray.add(Base32.encode(byArray));
        hashMap.put("subscription_ids", jSONArray);
        Map map = dispatcher.syncInvoke(OP_GET_POP_BY_SID, hashMap);
        for (int i = 0; i < jSONArray.size(); ++i) {
            Map map2 = (Map)map.get((String)jSONArray.get(i));
            if (map2 == null) continue;
            subscriptionInfo subscriptionInfo2 = new subscriptionInfo(map2);
            return subscriptionInfo2.getPopularity();
        }
        return -1L;
    }

    public static List[] setSelected(List list) throws PlatformMessengerException {
        ArrayList arrayList;
        PlatformSubscriptionsMessenger.checkEnabled(OP_SET_SELECTED);
        HashMap<String, JSONArray> hashMap = new HashMap<String, JSONArray>();
        JSONArray jSONArray = new JSONArray();
        for (int i = 0; i < list.size(); ++i) {
            jSONArray.add(Base32.encode((byte[])list.get(i)));
        }
        hashMap.put("subscription_ids", jSONArray);
        Map map = dispatcher.syncInvoke(OP_SET_SELECTED, hashMap);
        ArrayList<Long> arrayList2 = (ArrayList<Long>)map.get("version_numbers");
        if (arrayList2 == null) {
            arrayList2 = new ArrayList<Long>();
            for (int i = 0; i < list.size(); ++i) {
                arrayList2.add(new Long(1L));
            }
        }
        if ((arrayList = (ArrayList)map.get("popularities")) == null) {
            arrayList = new ArrayList();
            for (int i = 0; i < list.size(); ++i) {
                arrayList2.add(new Long(-1L));
            }
        }
        return new List[]{arrayList2, arrayList};
    }

    protected static void checkEnabled(String string) throws PlatformMessengerException {
    }

    public static class subscriptionDetails {
        private Map details;

        protected subscriptionDetails(Map map) {
            this.details = map;
        }

        public String getName() {
            return this.getString("name");
        }

        public String getContent() {
            return this.getString("content");
        }

        public int getPopularity() {
            Long l = (Long)this.details.get("popularity");
            if (l != null) {
                return l.intValue();
            }
            return -1;
        }

        protected String getString(String string) {
            Object v = this.details.get(string);
            if (v instanceof String) {
                return (String)v;
            }
            if (v instanceof byte[]) {
                byte[] byArray = (byte[])v;
                try {
                    return new String(byArray, "UTF-8");
                }
                catch (Throwable throwable) {
                    return new String(byArray);
                }
            }
            return null;
        }
    }

    public static class subscriptionInfo {
        private Map info;

        protected subscriptionInfo(Map map) {
            this.info = map;
        }

        public long getPopularity() {
            return ((Long)this.info.get("popularity")).intValue();
        }
    }
}

