/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.messenger.config;

import com.aelitis.azureus.core.messenger.PlatformMessengerException;
import com.aelitis.azureus.core.messenger.config.PlatformMessengerConfig;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class PlatformMetaDataMessenger {
    private static final PlatformMessengerConfig dispatcher = new PlatformMessengerConfig("metadata", false);
    private static final String OP_LOOKUP = "lookup";
    private static final String OP_SEARCH = "search";
    private static final String OP_SUBMIT = "submit";

    public static Association getAssociation(String string) throws PlatformMessengerException {
        Map map = dispatcher.syncInvoke(OP_LOOKUP, PlatformMetaDataMessenger.getParameter(string));
        Association association2 = PlatformMetaDataMessenger.getAssociation(map);
        if (association2 == null) {
            throw new PlatformMessengerException("Invalid reply: " + map);
        }
        return association2;
    }

    private static Association getAssociation(Map map) {
        try {
            Map map2 = (Map)map.get("result");
            return PlatformMetaDataMessenger.getAssociationFromMap(map2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static Association getAssociationFromMap(Map map) {
        try {
            String string = (String)map.get("title");
            String string2 = (String)map.get("db");
            String string3 = (String)map.get("db_id");
            String string4 = (String)map.get("hash");
            String string5 = (String)map.get("type");
            if (string5 == null) {
                EmptyAssociation emptyAssociation = new EmptyAssociation();
                emptyAssociation.hash = string4;
                return emptyAssociation;
            }
            if ("movie".equals(string5)) {
                String string6 = (String)map.get("quality");
                String string7 = (String)map.get("language");
                MovieAssociation movieAssociation = new MovieAssociation();
                movieAssociation.db = string2;
                movieAssociation.db_id = string3;
                movieAssociation.title = string;
                movieAssociation.quality = VideoQuality.fromString(string6);
                movieAssociation.language = new Locale(string7);
                movieAssociation.hash = string4;
                return movieAssociation;
            }
            if ("tv".equals(string5)) {
                String string8 = (String)map.get("quality");
                String string9 = (String)map.get("language");
                TvShowAssociation tvShowAssociation = new TvShowAssociation();
                tvShowAssociation.db = string2;
                tvShowAssociation.db_id = string3;
                tvShowAssociation.title = string;
                tvShowAssociation.quality = VideoQuality.fromString(string8);
                tvShowAssociation.language = new Locale(string9);
                tvShowAssociation.hash = string4;
                return tvShowAssociation;
            }
            if ("music".equals(string5)) {
                String string10 = (String)map.get("quality");
                MusicAssociation musicAssociation = new MusicAssociation();
                musicAssociation.db = string2;
                musicAssociation.db_id = string3;
                musicAssociation.title = string;
                musicAssociation.quality = AudioQuality.fromString(string10);
                musicAssociation.hash = string4;
                return musicAssociation;
            }
            return null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static Map<String, Association> getAssociations(Map map) {
        try {
            Map map2 = (Map)map.get("results");
            HashMap<String, Association> hashMap = new HashMap<String, Association>();
            for (String string : map2.keySet()) {
                hashMap.put(string, PlatformMetaDataMessenger.getAssociationFromMap((Map)map2.get(string)));
            }
            return hashMap;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new HashMap<String, Association>();
        }
    }

    public static Map<String, Association> getAssociations(String[] stringArray) throws PlatformMessengerException {
        HashMap<String, Association> hashMap = new HashMap<String, Association>();
        if (stringArray.length == 0) {
            return hashMap;
        }
        Map map = dispatcher.syncInvoke(OP_LOOKUP, PlatformMetaDataMessenger.getParameters(stringArray));
        return PlatformMetaDataMessenger.getAssociations(map);
    }

    public static void addSubmission(Association association2) throws PlatformMessengerException {
        HashMap hashMap = new HashMap();
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        hashMap2.put("hash", association2.hash);
        hashMap2.put("db", association2.db);
        hashMap2.put("db_id", association2.db_id);
        if (association2 instanceof MovieAssociation) {
            hashMap2.put("type", "movie");
            hashMap2.put("quality", ((MovieAssociation)association2).quality.quality);
            hashMap2.put("language", ((MovieAssociation)association2).language.getLanguage());
        }
        if (association2 instanceof TvShowAssociation) {
            hashMap2.put("type", "tv");
            hashMap2.put("quality", ((MovieAssociation)association2).quality.quality);
            hashMap2.put("language", ((MovieAssociation)association2).language.getLanguage());
        }
        if (association2 instanceof MusicAssociation) {
            hashMap2.put("type", "music");
            hashMap2.put("quality", ((MovieAssociation)association2).quality.quality);
        }
        hashMap.put("submission", hashMap2);
        dispatcher.syncInvoke(OP_SUBMIT, hashMap);
    }

    public static SearchResult[] search(String string) throws PlatformMessengerException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("title", string);
        Map map = dispatcher.syncInvoke(OP_SEARCH, hashMap);
        List list = (List)map.get("results");
        SearchResult[] searchResultArray = new SearchResult[list.size()];
        int n = 0;
        for (Map map2 : list) {
            SearchResult searchResult = new SearchResult();
            searchResult.title = (String)map2.get("title");
            searchResult.db = (String)map2.get("db");
            searchResult.db_id = (String)map2.get("db_id");
            searchResultArray[n++] = searchResult;
        }
        return searchResultArray;
    }

    protected static Map getParameter(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("hash", string);
        return hashMap;
    }

    protected static Map getParameters(String[] stringArray) {
        HashMap<String, String[]> hashMap = new HashMap<String, String[]>();
        hashMap.put("hashes", stringArray);
        return hashMap;
    }

    public static void main(String[] stringArray) throws Exception {
        SearchResult[] searchResultArray;
        for (SearchResult searchResult : searchResultArray = PlatformMetaDataMessenger.search("Dark Knight")) {
            System.out.println(searchResult);
        }
        MovieAssociation movieAssociation = new MovieAssociation();
        movieAssociation.db = "tmdb";
        movieAssociation.db_id = "155";
        movieAssociation.hash = "test";
        movieAssociation.quality = VideoQuality.DVD;
        movieAssociation.language = new Locale("en");
        PlatformMetaDataMessenger.addSubmission(movieAssociation);
        Association association2 = PlatformMetaDataMessenger.getAssociation("test");
        System.out.println(association2);
    }

    public static enum AudioQuality {
        LOW("low"),
        HIGH("high"),
        LOSSLESS("lossless");

        String quality;

        private AudioQuality(String string2) {
            this.quality = string2;
        }

        public static AudioQuality fromString(String string) {
            if (AudioQuality.LOW.quality.equals(string = string.toLowerCase())) {
                return LOW;
            }
            if (AudioQuality.HIGH.quality.equals(string)) {
                return HIGH;
            }
            if (AudioQuality.LOSSLESS.quality.equals(string)) {
                return LOSSLESS;
            }
            return null;
        }
    }

    public static enum VideoQuality {
        LOW("low"),
        DVD("dvd"),
        HD_720p("720p"),
        HD_1080p("1080p");

        String quality;

        private VideoQuality(String string2) {
            this.quality = string2;
        }

        public static VideoQuality fromString(String string) {
            if (VideoQuality.LOW.quality.equals(string = string.toLowerCase())) {
                return LOW;
            }
            if (VideoQuality.DVD.quality.equals(string)) {
                return DVD;
            }
            if (VideoQuality.HD_720p.quality.equals(string)) {
                return HD_720p;
            }
            if (VideoQuality.HD_1080p.quality.equals(string)) {
                return HD_1080p;
            }
            return null;
        }
    }

    public static class MusicAssociation
    extends Association {
        public AudioQuality quality;
    }

    public static class TvShowAssociation
    extends VideoAssociation {
    }

    public static class MovieAssociation
    extends VideoAssociation {
    }

    public static abstract class VideoAssociation
    extends Association {
        public VideoQuality quality;
        public Locale language;
    }

    public static class EmptyAssociation
    extends Association {
    }

    public static abstract class Association {
        public String hash;
        public String db;
        public String db_id;
        public String title;

        public String toString() {
            return this.hash + " > " + this.db + "." + this.db_id + " : " + this.title;
        }
    }

    public static class SearchResult {
        String title;
        String db;
        String db_id;

        public String toString() {
            return this.db + "." + this.db_id + " : " + this.title;
        }
    }
}

