/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.messenger.browser;

import com.aelitis.azureus.core.messenger.browser.listeners.MessageCompletionListener;
import com.aelitis.azureus.util.ConstantsVuze;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsLogger;
import org.gudy.azureus2.core3.util.Debug;

public class BrowserMessage {
    public static final String MESSAGE_PREFIX = "AZMSG";
    public static final String MESSAGE_DELIM = ";";
    public static String MESSAGE_DELIM_ENCODED;
    public static final int NO_PARAM = 0;
    public static final int OBJECT_PARAM = 1;
    public static final int ARRAY_PARAM = 2;
    private String listenerId;
    private String operationId;
    private String params;
    private Map decodedParams;
    private ArrayList completionListeners = new ArrayList();
    private boolean completed;
    private boolean completeDelayed;
    private String referer;

    public BrowserMessage(String string, String string2, Map<?, ?> map) {
        this.listenerId = string;
        this.operationId = string2;
        this.decodedParams = map;
    }

    public void addCompletionListener(MessageCompletionListener messageCompletionListener) {
        this.completionListeners.add(messageCompletionListener);
    }

    public void complete(boolean bl, boolean bl2, Object object) {
        if (this.completed || bl && this.completeDelayed) {
            return;
        }
        this.triggerCompletionListeners(bl2, object);
        this.completed = true;
    }

    public void debug(String string) {
        this.debug(string, null);
    }

    public void debug(String string, Throwable throwable) {
        try {
            AEDiagnosticsLogger aEDiagnosticsLogger = AEDiagnostics.getLogger("v3.CMsgr");
            String string2 = "[" + this.getListenerId() + ":" + this.getOperationId() + "] " + string;
            aEDiagnosticsLogger.log(string2);
            if (throwable != null) {
                aEDiagnosticsLogger.log(throwable);
            }
            if (ConstantsVuze.DIAG_TO_STDOUT) {
                System.out.println(string2);
                if (throwable != null) {
                    throwable.printStackTrace();
                }
            }
        }
        catch (Throwable throwable2) {
            Debug.out(throwable2);
        }
    }

    public Map getDecodedMap() {
        return this.decodedParams == null ? Collections.EMPTY_MAP : this.decodedParams;
    }

    public String getListenerId() {
        return this.listenerId;
    }

    public String getOperationId() {
        return this.operationId;
    }

    public String getReferer() {
        return this.referer;
    }

    public void removeCompletionListener(MessageCompletionListener messageCompletionListener) {
        this.completionListeners.remove(messageCompletionListener);
    }

    public void setCompleteDelayed(boolean bl) {
        this.completeDelayed = bl;
    }

    public void setReferer(String string) {
        this.referer = string;
    }

    public String toString() {
        return this.listenerId + "." + this.operationId + "(" + (this.params == null ? this.decodedParams : this.params) + ")";
    }

    private void triggerCompletionListeners(boolean bl, Object object) {
        for (MessageCompletionListener messageCompletionListener : this.completionListeners) {
            try {
                messageCompletionListener.completed(bl, object);
            }
            catch (Throwable throwable) {
                Debug.out(throwable);
            }
        }
    }

    static {
        try {
            MESSAGE_DELIM_ENCODED = URLEncoder.encode(MESSAGE_DELIM, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            MESSAGE_DELIM_ENCODED = MESSAGE_DELIM;
        }
    }
}

