/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.diskmanager.cache.impl;

import com.aelitis.azureus.core.diskmanager.cache.CacheFile;
import com.aelitis.azureus.core.diskmanager.cache.CacheFileManager;
import com.aelitis.azureus.core.diskmanager.cache.CacheFileManagerFactory;
import com.aelitis.azureus.core.diskmanager.cache.CacheFileOwner;
import com.aelitis.azureus.core.diskmanager.cache.impl.CacheFileManagerImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.RandomAccessFile;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.gudy.azureus2.core3.logging.ILogEventListener;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentFactory;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.DirectByteBufferPool;
import org.gudy.azureus2.core3.util.FileUtil;

public class Test {
    public static void main(String[] stringArray) {
        System.setProperty("azureus.log.stdout", "1");
        Logger.addListener(new ILogEventListener(){

            @Override
            public void log(LogEvent logEvent) {
                System.out.println(logEvent.text);
            }
        });
        try {
            CacheFileManagerImpl cacheFileManagerImpl = (CacheFileManagerImpl)CacheFileManagerFactory.getSingleton();
            cacheFileManagerImpl.initialise(true, true, true, 0xA00000L, 1024L);
            new Test().pieceReorderTest(cacheFileManagerImpl);
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pieceReorderTest(CacheFileManagerImpl cacheFileManagerImpl) {
        try {
            int n;
            int n2;
            long l;
            Object object;
            long l2;
            int n3;
            int n4;
            Object object2;
            Object object3;
            File file;
            File file2;
            Random random = new Random(0L);
            int n5 = 100;
            int n6 = 1024;
            int n7 = n6 * 30;
            int n8 = 0;
            int n9 = 1024;
            int n10 = 2;
            int[] nArray = new int[n5];
            for (int i = 0; i < n5; ++i) {
                nArray[i] = random.nextInt(2 * n7) + 1;
            }
            final File file3 = new File("C:\\temp\\filetestcontrol");
            FileUtil.recursiveDelete(file3);
            file3.mkdirs();
            File file4 = new File("C:\\temp\\filetest.torrent");
            file4.delete();
            if (n5 == 1) {
                file2 = new File("C:\\temp\\filetest1.dat");
                file = new File("C:\\temp\\filetest2.dat");
                file2.delete();
                file.delete();
            } else {
                file2 = new File("C:\\temp\\filetest1.dir");
                file = new File("C:\\temp\\filetest2.dir");
                FileUtil.recursiveDelete(file2);
                FileUtil.recursiveDelete(file);
                file2.mkdirs();
                file.mkdirs();
            }
            File[] fileArray = new File[n5];
            File[] fileArray2 = new File[n5];
            RandomAccessFile[] randomAccessFileArray = new RandomAccessFile[n5];
            for (int i = 0; i < n5; ++i) {
                File file5;
                if (n5 == 1) {
                    file5 = file2;
                    object3 = file;
                } else {
                    file5 = new File(file2, "file" + i);
                    object3 = new File(file, "file" + i);
                }
                fileArray[i] = file5;
                fileArray2[i] = object3;
                object2 = new FileOutputStream(file5);
                byte[] byArray = new byte[65536];
                for (n3 = nArray[i]; n3 > 0; n3 -= n4) {
                    random.nextBytes(byArray);
                    n4 = n3 > byArray.length ? byArray.length : n3;
                    ((FileOutputStream)object2).write(byArray, 0, n4);
                }
                ((FileOutputStream)object2).close();
                randomAccessFileArray[i] = new RandomAccessFile(file5, "r");
            }
            TOTorrent tOTorrent = TOTorrentFactory.createFromFileOrDirWithFixedPieceLength(file2, new URL("http://a.b.c/"), n6).create();
            final TOTorrentFile[] tOTorrentFileArray = tOTorrent.getFiles();
            for (int i = 0; i < tOTorrentFileArray.length; ++i) {
                object3 = tOTorrentFileArray[i];
                object2 = object3.getRelativePath();
                boolean bl = false;
                for (n3 = 0; n3 < fileArray.length; ++n3) {
                    if (!fileArray[n3].getName().equals(object2)) continue;
                    bl = true;
                    if (n3 == i) break;
                    n4 = nArray[i];
                    nArray[i] = nArray[n3];
                    nArray[n3] = n4;
                    File file6 = fileArray[i];
                    fileArray[i] = fileArray[n3];
                    fileArray[n3] = file6;
                    file6 = fileArray2[i];
                    fileArray2[i] = fileArray2[n3];
                    fileArray2[n3] = file6;
                    RandomAccessFile randomAccessFile = randomAccessFileArray[i];
                    randomAccessFileArray[i] = randomAccessFileArray[n3];
                    randomAccessFileArray[n3] = randomAccessFile;
                    break;
                }
                if (bl) continue;
                Debug.out("eh?");
                return;
            }
            CacheFile[] cacheFileArray = new CacheFile[tOTorrentFileArray.length];
            for (int i = 0; i < tOTorrentFileArray.length; ++i) {
                final int n11 = i;
                File file7 = fileArray2[i];
                final File file8 = fileArray[i];
                System.out.println("file " + i + ": e_size=" + nArray[i] + ", t_size=" + tOTorrentFileArray[i].getLength() + ", d_size=" + file8.length());
                cacheFileArray[i] = cacheFileManagerImpl.createFile(new CacheFileOwner(){

                    @Override
                    public String getCacheFileOwnerName() {
                        return file8.getAbsolutePath();
                    }

                    @Override
                    public TOTorrentFile getCacheFileTorrentFile() {
                        return tOTorrentFileArray[n11];
                    }

                    @Override
                    public File getCacheFileControlFileDir() {
                        return file3;
                    }

                    @Override
                    public int getCacheMode() {
                        return 2;
                    }
                }, file7, 3);
                cacheFileArray[i].setAccessMode(2);
            }
            ArrayList<Chunk> arrayList = new ArrayList<Chunk>();
            List[] listArray = new List[tOTorrent.getNumberOfPieces()];
            long l3 = 0L;
            n4 = 0;
            long l4 = 0L;
            long l5 = l2 = tOTorrent.getSize();
            while (l5 > 0L) {
                long l6 = n8 != 0 ? (long)n8 : (long)(random.nextInt(n9) + 1);
                if (l5 < l6) {
                    l6 = (int)l5;
                }
                ArrayList<ChunkSlice> arrayList2 = new ArrayList<ChunkSlice>();
                object = new Chunk(l3, l6, arrayList2);
                arrayList.add((Chunk)object);
                while (l6 > 0L) {
                    long l7 = nArray[n4];
                    long l8 = l7 - l4;
                    l = Math.min(l8, l6);
                    if (l > 0L) {
                        int n12 = (int)(l3 / (long)n6);
                        l5 -= l;
                        int n13 = (int)(((l3 += l) - 1L) / (long)n6);
                        arrayList2.add(new ChunkSlice(n4, l4, l, n12, n13));
                    }
                    if ((l6 -= l) > 0L) {
                        l4 = 0L;
                        ++n4;
                        continue;
                    }
                    l4 += l;
                    break;
                }
                int n14 = ((ChunkSlice)arrayList2.get(0)).getPieceStart();
                n2 = ((ChunkSlice)arrayList2.get(arrayList2.size() - 1)).getPieceEnd();
                for (n = n14; n <= n2; ++n) {
                    if (listArray[n] == null) {
                        listArray[n] = new ArrayList();
                    }
                    listArray[n].add(object);
                }
                ((Chunk)object).setPieces(n14, n2);
                System.out.println(((Chunk)object).getString());
            }
            for (int i = 0; i < listArray.length; ++i) {
                System.out.println(i + ": " + listArray[i].size());
            }
            while (arrayList.size() > 0) {
                int n15;
                Chunk chunk = n10 == 0 ? (Chunk)arrayList.remove(0) : (n10 == 1 ? (Chunk)arrayList.remove(arrayList.size() - 1) : (Chunk)arrayList.remove(random.nextInt(arrayList.size())));
                System.out.println("Processing chunk " + chunk.getString());
                ArrayList<ChunkSlice> arrayList3 = new ArrayList<ChunkSlice>(chunk.getSlices());
                if (n10 == 1) {
                    Collections.reverse(arrayList3);
                }
                for (ChunkSlice chunkSlice : arrayList3) {
                    n15 = chunkSlice.getFileIndex();
                    l2 = chunkSlice.getFileOffset();
                    l5 = chunkSlice.getLength();
                    System.out.println("Processing slice " + chunkSlice.getString() + "[file size=" + nArray[n15]);
                    DirectByteBuffer directByteBuffer = DirectByteBufferPool.getBuffer((byte)2, (int)l5);
                    try {
                        RandomAccessFile randomAccessFile = randomAccessFileArray[n15];
                        randomAccessFile.seek(l2);
                        randomAccessFile.getChannel().read(directByteBuffer.getBuffer((byte)1));
                        directByteBuffer.flip((byte)1);
                        cacheFileArray[n15].write(directByteBuffer, l2);
                    }
                    finally {
                        directByteBuffer.returnToPool();
                    }
                }
                chunk.setDone();
                n4 = chunk.getPieceStart();
                int n16 = chunk.getPieceEnd();
                for (n15 = n4; n15 <= n16; ++n15) {
                    List list = listArray[n15];
                    boolean bl = true;
                    for (Chunk chunk2 : list) {
                        if (chunk2.isDone()) continue;
                        bl = false;
                        break;
                    }
                    if (!bl) continue;
                    for (ChunkSlice chunkSlice : arrayList3) {
                        int n17;
                        if (n15 < chunkSlice.getPieceStart() || n15 > chunkSlice.getPieceEnd()) continue;
                        long l9 = n15 * n6;
                        if (n15 < listArray.length - 1) {
                            n17 = n6;
                        } else {
                            long l10 = tOTorrent.getSize();
                            n17 = (int)(l10 - l10 / (long)n6 * (long)n6);
                            if (n17 == 0) {
                                n17 = n6;
                            }
                        }
                        object = DirectByteBufferPool.getBuffer((byte)2, n17);
                        long l11 = 0L;
                        n = 0;
                        int n11 = n17;
                        while (n11 > 0) {
                            l = nArray[n];
                            long l12 = l11 + l;
                            long l6 = l12 - l9;
                            if (l6 > 0L) {
                                int n12 = (int)Math.min(l6, (long)n11);
                                long l7 = l9 - l11;
                                int n13 = ((DirectByteBuffer)object).limit((byte)2);
                                ((DirectByteBuffer)object).limit((byte)2, ((DirectByteBuffer)object).position((byte)2) + n12);
                                cacheFileArray[n].read((DirectByteBuffer)object, l7, (short)0);
                                ((DirectByteBuffer)object).limit((byte)2, n13);
                                l9 += (long)n12;
                                n11 -= n12;
                            }
                            ++n;
                            l11 += l;
                        }
                        try {
                            cacheFileArray[chunkSlice.getFileIndex()].setPieceComplete(n15, (DirectByteBuffer)object);
                        }
                        finally {
                            ((DirectByteBuffer)object).returnToPool();
                        }
                    }
                }
            }
            for (int i = 0; i < n5; ++i) {
                randomAccessFileArray[i].close();
                cacheFileArray[i].close();
                byte[] byArray = new byte[262144];
                byte[] byArray2 = new byte[262144];
                if (fileArray[i].length() != fileArray2[i].length()) {
                    System.err.println("File sizes differ for " + i);
                }
                FileInputStream fileInputStream = new FileInputStream(fileArray[i]);
                FileInputStream fileInputStream2 = new FileInputStream(fileArray2[i]);
                l2 = nArray[i];
                l5 = 0L;
                boolean bl = false;
                while (l2 > 0L) {
                    int n21;
                    int n14 = (int)Math.min(l2, (long)byArray.length);
                    int n23 = fileInputStream.read(byArray, 0, n14);
                    if (n23 != (n21 = fileInputStream2.read(byArray2, 0, n14))) {
                        System.err.println("read lens different: file=" + i + ",pos=" + l5);
                        bl = true;
                        break;
                    }
                    if (Arrays.equals(byArray, byArray2)) {
                        l2 -= (long)n23;
                        l5 += (long)n23;
                        continue;
                    }
                    int n24 = -1;
                    for (n2 = 0; n2 < n14; ++n2) {
                        if (byArray[n2] == byArray2[n2]) continue;
                        n24 = n2;
                        break;
                    }
                    System.err.println("mismatch: file=" + i + ",pos=" + l5 + " + " + n24);
                    bl = true;
                    break;
                }
                if (bl) continue;
                System.out.println("file " + i + ": matched " + l5 + " of " + nArray[i]);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void writeTest(CacheFileManagerImpl cacheFileManagerImpl) {
        try {
            final File file = new File("C:\\temp\\cachetest.dat");
            file.delete();
            CacheFile cacheFile = cacheFileManagerImpl.createFile(new CacheFileOwner(){

                @Override
                public String getCacheFileOwnerName() {
                    return "file " + file.toString();
                }

                @Override
                public TOTorrentFile getCacheFileTorrentFile() {
                    return null;
                }

                @Override
                public File getCacheFileControlFileDir() {
                    return null;
                }

                @Override
                public int getCacheMode() {
                    return 1;
                }
            }, file, 1);
            cacheFile.setAccessMode(2);
            long l = System.currentTimeMillis();
            int n = 10000;
            int n2 = 1024;
            for (int i = 0; i < n; ++i) {
                DirectByteBuffer directByteBuffer = DirectByteBufferPool.getBuffer((byte)2, n2);
                cacheFile.writeAndHandoverBuffer(directByteBuffer, i * n2);
            }
            cacheFile.close();
            long l2 = System.currentTimeMillis();
            long l3 = n * n2;
            long l4 = l2 - l;
            System.out.println("time = " + l4 + ", speed = " + l3 / l4);
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
        }
    }

    public void manualTest(CacheFileManager cacheFileManager) {
        try {
            final File file = new File("C:\\temp\\cachetest.dat");
            file.delete();
            CacheFile cacheFile = cacheFileManager.createFile(new CacheFileOwner(){

                @Override
                public String getCacheFileOwnerName() {
                    return "file " + file.toString();
                }

                @Override
                public TOTorrentFile getCacheFileTorrentFile() {
                    return null;
                }

                @Override
                public File getCacheFileControlFileDir() {
                    return null;
                }

                @Override
                public int getCacheMode() {
                    return 1;
                }
            }, file, 1);
            DirectByteBuffer directByteBuffer = DirectByteBufferPool.getBuffer((byte)2, 512);
            DirectByteBuffer directByteBuffer2 = DirectByteBufferPool.getBuffer((byte)2, 512);
            DirectByteBuffer directByteBuffer3 = DirectByteBufferPool.getBuffer((byte)2, 512);
            cacheFile.writeAndHandoverBuffer(directByteBuffer2, 512L);
            cacheFile.flushCache();
            cacheFile.writeAndHandoverBuffer(directByteBuffer3, 1024L);
            cacheFile.writeAndHandoverBuffer(directByteBuffer, 0L);
            cacheFile.flushCache();
            directByteBuffer = DirectByteBufferPool.getBuffer((byte)2, 512);
            cacheFile.writeAndHandoverBuffer(directByteBuffer, 0L);
            cacheFile.flushCache();
            cacheFile.close();
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
        }
    }

    public void randomTest(CacheFileManager cacheFileManager) {
        try {
            int n;
            int n2;
            CacheFile[] cacheFileArray = new CacheFile[3];
            byte[][] byArrayArray = new byte[3][];
            for (n2 = 0; n2 < cacheFileArray.length; ++n2) {
                n = n2;
                byArrayArray[n2] = new byte[Test.randomInt(200000)];
                cacheFileArray[n2] = cacheFileManager.createFile(new CacheFileOwner(){

                    @Override
                    public String getCacheFileOwnerName() {
                        return "file" + n;
                    }

                    @Override
                    public TOTorrentFile getCacheFileTorrentFile() {
                        return null;
                    }

                    @Override
                    public File getCacheFileControlFileDir() {
                        return null;
                    }

                    @Override
                    public int getCacheMode() {
                        return 1;
                    }
                }, new File("C:\\temp\\cachetest" + n2 + ".dat"), 1);
                cacheFileArray[n2].setAccessMode(2);
                DirectByteBuffer directByteBuffer = DirectByteBufferPool.getBuffer((byte)2, byArrayArray[n2].length);
                directByteBuffer.put((byte)3, byArrayArray[n2]);
                directByteBuffer.position((byte)3, 0);
                cacheFileArray[n2].write(directByteBuffer, 0L);
            }
            n2 = 100;
            n = 1;
            int n3 = 3;
            for (int i = 0; i < 10000000; ++i) {
                DirectByteBuffer directByteBuffer;
                int n4 = Test.randomInt(cacheFileArray.length);
                CacheFile cacheFile = cacheFileArray[n4];
                byte[] byArray = byArrayArray[n4];
                int n5 = Test.randomInt(byArray.length);
                int n6 = Test.randomInt(byArray.length);
                if ((n5 = n5 / n2 * n2) == (n6 = n6 / n2 * n2)) continue;
                int n7 = Math.min(n5, n6);
                int n8 = Math.max(n5, n6) - n7;
                int n9 = Test.randomInt(100);
                if (n9 < 30) {
                    if (n8 > n2 * n3) {
                        n8 = n2 * n3;
                    }
                    directByteBuffer = DirectByteBufferPool.getBuffer((byte)2, n8);
                    System.out.println("read:" + n7 + "/" + n8);
                    cacheFile.read(directByteBuffer, (long)n7, (short)1);
                    directByteBuffer.position((byte)3, 0);
                    byte[] byArray2 = new byte[n8];
                    directByteBuffer.get((byte)3, byArray2);
                    for (int j = 0; j < byArray2.length; ++j) {
                        if (byArray2[j] == byArray[j + n7]) continue;
                        throw new Exception("data read mismatch");
                    }
                    directByteBuffer.returnToPool();
                    continue;
                }
                if (n9 < 80) {
                    if (n8 > n2 * n) {
                        n8 = n2 * n;
                    }
                    System.out.println("write:" + n7 + "/" + n8);
                    directByteBuffer = DirectByteBufferPool.getBuffer((byte)2, n8);
                    for (int j = 0; j < n8; ++j) {
                        byArray[n7 + j] = (byte)Test.randomInt(256);
                        directByteBuffer.put((byte)3, byArray[n7 + j]);
                    }
                    directByteBuffer.position((byte)3, 0);
                    cacheFile.writeAndHandoverBuffer(directByteBuffer, n7);
                    continue;
                }
                if (n9 < 90) {
                    cacheFile.flushCache();
                    continue;
                }
                if (n9 >= 91) continue;
                cacheFile.clearCache();
            }
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
        }
    }

    static int randomInt(int n) {
        return (int)(Math.random() * (double)n);
    }

    protected static class ChunkSlice {
        private int file_index;
        private long file_offset;
        private long length;
        private int piece_start;
        private int piece_end;

        protected ChunkSlice(int n, long l, long l2, int n2, int n3) {
            this.file_index = n;
            this.file_offset = l;
            this.length = l2;
            this.piece_start = n2;
            this.piece_end = n3;
        }

        protected int getFileIndex() {
            return this.file_index;
        }

        protected long getFileOffset() {
            return this.file_offset;
        }

        protected long getLength() {
            return this.length;
        }

        protected int getPieceStart() {
            return this.piece_start;
        }

        protected int getPieceEnd() {
            return this.piece_end;
        }

        protected String getString() {
            return "fi=" + this.file_index + ",fo=" + this.file_offset + ",len=" + this.length + ",ps=" + this.piece_start + ",pe=" + this.piece_end;
        }
    }

    protected static class Chunk {
        private long offset;
        private long length;
        private List<ChunkSlice> slices;
        private int piece_start;
        private int piece_end;
        private boolean is_done;

        protected Chunk(long l, long l2, List<ChunkSlice> list) {
            this.offset = l;
            this.length = l2;
            this.slices = list;
        }

        protected List<ChunkSlice> getSlices() {
            return this.slices;
        }

        protected void setPieces(int n, int n2) {
            this.piece_start = n;
            this.piece_end = n2;
        }

        protected int getPieceStart() {
            return this.piece_start;
        }

        protected int getPieceEnd() {
            return this.piece_end;
        }

        protected void setDone() {
            this.is_done = true;
        }

        protected boolean isDone() {
            return this.is_done;
        }

        protected String getString() {
            String string = "";
            for (ChunkSlice chunkSlice : this.slices) {
                string = string + (string.length() == 0 ? "" : ",") + chunkSlice.getString();
            }
            return "offset=" + this.offset + ",length=" + this.length + ",slices={" + string + "}";
        }
    }
}

