/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.devices.impl;

import com.aelitis.azureus.core.content.AzureusContentDownload;
import com.aelitis.azureus.core.content.AzureusContentFile;
import com.aelitis.azureus.core.content.AzureusContentFilter;
import com.aelitis.azureus.core.devices.DeviceManager;
import com.aelitis.azureus.core.devices.impl.DeviceContentDirectoryImpl;
import com.aelitis.azureus.core.devices.impl.DeviceImpl;
import com.aelitis.azureus.core.devices.impl.DeviceInternetGatewayImpl;
import com.aelitis.azureus.core.devices.impl.DeviceManagerImpl;
import com.aelitis.azureus.core.devices.impl.DeviceMediaRendererImpl;
import com.aelitis.azureus.core.devices.impl.DeviceOfflineDownloaderImpl;
import com.aelitis.azureus.core.devices.impl.DeviceUPnPImpl;
import com.aelitis.azureus.core.util.UUIDGenerator;
import com.aelitis.net.upnp.UPnP;
import com.aelitis.net.upnp.UPnPAdapter;
import com.aelitis.net.upnp.UPnPDevice;
import com.aelitis.net.upnp.UPnPFactory;
import com.aelitis.net.upnp.UPnPListener;
import com.aelitis.net.upnp.UPnPRootDevice;
import com.aelitis.net.upnp.UPnPRootDeviceListener;
import com.aelitis.net.upnp.UPnPService;
import com.aelitis.net.upnp.services.UPnPOfflineDownloader;
import com.aelitis.net.upnp.services.UPnPWANConnection;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.PluginEvent;
import org.gudy.azureus2.plugins.PluginEventListener;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginListener;
import org.gudy.azureus2.plugins.ipc.IPCInterface;
import org.gudy.azureus2.plugins.torrent.TorrentAttribute;
import org.gudy.azureus2.plugins.tracker.web.TrackerWebPageRequest;
import org.gudy.azureus2.plugins.utils.UTTimer;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderFactory;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocument;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocumentException;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.pluginsimpl.local.ipc.IPCInterfaceImpl;

public class DeviceManagerUPnPImpl {
    private static final Object KEY_ROOT_DEVICE = new Object();
    private DeviceManagerImpl manager;
    private PluginInterface plugin_interface;
    private UPnP upnp;
    private TorrentAttribute ta_category;
    private volatile IPCInterface upnpav_ipc;
    private Map<InetAddress, String> unassociated_devices = new HashMap<InetAddress, String>();

    protected DeviceManagerUPnPImpl(DeviceManagerImpl deviceManagerImpl) {
        this.manager = deviceManagerImpl;
    }

    protected void initialise() {
        this.plugin_interface = PluginInitializer.getDefaultInterface();
        this.ta_category = this.plugin_interface.getTorrentManager().getAttribute("Category");
        this.plugin_interface.addListener(new PluginListener(){

            @Override
            public void initializationComplete() {
                new AEThread2("DMUPnPAsyncStart", true){

                    @Override
                    public void run() {
                        DeviceManagerUPnPImpl.this.startUp();
                    }
                }.start();
            }

            @Override
            public void closedownInitiated() {
            }

            @Override
            public void closedownComplete() {
            }
        });
    }

    protected DeviceManagerImpl getManager() {
        return this.manager;
    }

    protected TorrentAttribute getCategoryAttibute() {
        return this.ta_category;
    }

    protected void startUp() {
        UPnPAdapter uPnPAdapter = new UPnPAdapter(){

            @Override
            public SimpleXMLParserDocument parseXML(String string) throws SimpleXMLParserDocumentException {
                return DeviceManagerUPnPImpl.this.plugin_interface.getUtilities().getSimpleXMLParserDocumentFactory().create(string);
            }

            @Override
            public ResourceDownloaderFactory getResourceDownloaderFactory() {
                return DeviceManagerUPnPImpl.this.plugin_interface.getUtilities().getResourceDownloaderFactory();
            }

            @Override
            public UTTimer createTimer(String string) {
                return DeviceManagerUPnPImpl.this.plugin_interface.getUtilities().createTimer(string);
            }

            @Override
            public void createThread(String string, Runnable runnable) {
                DeviceManagerUPnPImpl.this.plugin_interface.getUtilities().createThread(string, runnable);
            }

            @Override
            public Comparator getAlphanumericComparator() {
                return DeviceManagerUPnPImpl.this.plugin_interface.getUtilities().getFormatters().getAlphanumericComparator(true);
            }

            @Override
            public void log(Throwable throwable) {
                Debug.printStackTrace(throwable);
            }

            @Override
            public void trace(String string) {
            }

            @Override
            public void log(String string) {
            }

            @Override
            public String getTraceDir() {
                return DeviceManagerUPnPImpl.this.plugin_interface.getPluginDirectoryName();
            }
        };
        try {
            this.upnp = UPnPFactory.getSingleton(uPnPAdapter, null);
            this.upnp.addRootDeviceListener(new UPnPListener(){

                @Override
                public boolean deviceDiscovered(String string, URL uRL) {
                    return true;
                }

                @Override
                public void rootDeviceFound(UPnPRootDevice uPnPRootDevice) {
                    DeviceManagerUPnPImpl.this.handleDevice(uPnPRootDevice, true);
                }
            });
        }
        catch (Throwable throwable) {
            this.manager.log("UPnP device manager failed", throwable);
        }
        try {
            this.plugin_interface.addEventListener(new PluginEventListener(){

                @Override
                public void handleEvent(PluginEvent pluginEvent) {
                    PluginInterface pluginInterface;
                    int n = pluginEvent.getType();
                    if ((n == 8 || n == 9) && (pluginInterface = (PluginInterface)pluginEvent.getValue()).getPluginID().equals("azupnpav")) {
                        if (n == 8) {
                            DeviceManagerUPnPImpl.this.upnpav_ipc = pluginInterface.getIPC();
                            DeviceManagerUPnPImpl.this.addListener(pluginInterface);
                        } else {
                            DeviceManagerUPnPImpl.this.upnpav_ipc = null;
                        }
                    }
                }
            });
            PluginInterface pluginInterface = this.plugin_interface.getPluginManager().getPluginInterfaceByID("azupnpav");
            if (pluginInterface == null) {
                this.manager.log("No UPnPAV plugin found");
            } else {
                this.upnpav_ipc = pluginInterface.getIPC();
                this.addListener(pluginInterface);
            }
        }
        catch (Throwable throwable) {
            this.manager.log("Failed to hook into UPnPAV", throwable);
        }
        this.manager.UPnPManagerStarted();
    }

    protected void addListener(PluginInterface pluginInterface) {
        try {
            IPCInterfaceImpl iPCInterfaceImpl = new IPCInterfaceImpl(new Object(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Map<String, Object> browseReceived(TrackerWebPageRequest trackerWebPageRequest, Map<String, Object> map) {
                    DeviceImpl[] deviceImplArray;
                    Map map2 = trackerWebPageRequest.getHeaders();
                    String string = (String)map2.get("user-agent");
                    String string2 = (String)map2.get("x-av-client-info");
                    InetSocketAddress inetSocketAddress = trackerWebPageRequest.getClientAddress2();
                    boolean bl = false;
                    if (string != null) {
                        deviceImplArray = string.toLowerCase();
                        if (deviceImplArray.contains("playstation 3")) {
                            DeviceManagerUPnPImpl.this.handlePS3(inetSocketAddress);
                            bl = true;
                        } else if (deviceImplArray.contains("xbox")) {
                            DeviceManagerUPnPImpl.this.handleXBox(inetSocketAddress);
                            bl = true;
                        } else if (deviceImplArray.contains("nintendo wii")) {
                            DeviceManagerUPnPImpl.this.handleWii(inetSocketAddress);
                            bl = true;
                        }
                    }
                    if (string2 != null && (deviceImplArray = string2.toLowerCase()).contains("playstation 3")) {
                        DeviceManagerUPnPImpl.this.handlePS3(inetSocketAddress);
                        bl = true;
                    }
                    if (!bl && (deviceImplArray = (String)map.get("source")) != null && deviceImplArray.equalsIgnoreCase("http")) {
                        DeviceManagerUPnPImpl.this.handleBrowser(inetSocketAddress);
                        bl = true;
                    }
                    deviceImplArray = DeviceManagerUPnPImpl.this.manager.getDevices();
                    final ArrayList<DeviceMediaRendererImpl> arrayList = new ArrayList<DeviceMediaRendererImpl>();
                    for (DeviceImpl deviceImpl : deviceImplArray) {
                        if (!(deviceImpl instanceof DeviceMediaRendererImpl)) continue;
                        DeviceMediaRendererImpl deviceMediaRendererImpl = (DeviceMediaRendererImpl)deviceImpl;
                        InetAddress inetAddress = deviceMediaRendererImpl.getAddress();
                        try {
                            if (inetAddress == null || !inetAddress.equals(inetSocketAddress.getAddress()) || !deviceMediaRendererImpl.canFilterFilesView()) continue;
                            arrayList.add(deviceMediaRendererImpl);
                            deviceMediaRendererImpl.browseReceived();
                        }
                        catch (Throwable throwable) {
                            Debug.out(throwable);
                        }
                    }
                    HashMap hashMap = new HashMap();
                    if (arrayList.size() > 0) {
                        Map map3 = DeviceManagerUPnPImpl.this.unassociated_devices;
                        synchronized (map3) {
                            DeviceManagerUPnPImpl.this.unassociated_devices.remove(inetSocketAddress.getAddress());
                        }
                        hashMap.put("filter", new AzureusContentFilter(){

                            @Override
                            public boolean isVisible(AzureusContentDownload azureusContentDownload, Map<String, Object> map) {
                                boolean bl = false;
                                for (DeviceUPnPImpl deviceUPnPImpl : arrayList) {
                                    if (!deviceUPnPImpl.isVisible(azureusContentDownload)) continue;
                                    bl = true;
                                }
                                return bl;
                            }

                            @Override
                            public boolean isVisible(AzureusContentFile azureusContentFile, Map<String, Object> map) {
                                boolean bl = false;
                                for (DeviceUPnPImpl deviceUPnPImpl : arrayList) {
                                    if (!deviceUPnPImpl.isVisible(azureusContentFile)) continue;
                                    bl = true;
                                }
                                return bl;
                            }
                        });
                    } else if (trackerWebPageRequest.getHeader().substring(0, 4).equalsIgnoreCase("POST")) {
                        Map map4 = DeviceManagerUPnPImpl.this.unassociated_devices;
                        synchronized (map4) {
                            DeviceManagerUPnPImpl.this.unassociated_devices.put(inetSocketAddress.getAddress(), string);
                        }
                    }
                    return hashMap;
                }
            });
            if (this.upnpav_ipc.canInvoke("addBrowseListener", new Object[]{iPCInterfaceImpl})) {
                DeviceImpl[] deviceImplArray;
                this.upnpav_ipc.invoke("addBrowseListener", new Object[]{iPCInterfaceImpl});
                for (DeviceImpl deviceImpl : deviceImplArray = this.manager.getDevices()) {
                    if (!(deviceImpl instanceof DeviceUPnPImpl)) continue;
                    DeviceUPnPImpl deviceUPnPImpl = (DeviceUPnPImpl)deviceImpl;
                    deviceUPnPImpl.resetUPNPAV();
                }
            } else {
                this.manager.log("UPnPAV plugin needs upgrading");
            }
        }
        catch (Throwable throwable) {
            this.manager.log("Failed to hook into UPnPAV", throwable);
        }
    }

    protected void injectDiscoveryCache(Map map) {
        try {
            this.upnp.injectDiscoveryCache(map);
        }
        catch (Throwable throwable) {
            Debug.out(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeviceManager.UnassociatedDevice[] getUnassociatedDevices() {
        ArrayList<6> arrayList = new ArrayList<6>();
        DeviceImpl[] deviceImplArray = this.unassociated_devices;
        synchronized (this.unassociated_devices) {
            HashMap<InetAddress, String> hashMap = new HashMap<InetAddress, String>(this.unassociated_devices);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            deviceImplArray = this.manager.getDevices();
            for (final Map.Entry entry : hashMap.entrySet()) {
                InetAddress inetAddress = (InetAddress)entry.getKey();
                boolean bl = false;
                for (DeviceImpl deviceImpl : deviceImplArray) {
                    if (!(deviceImpl instanceof DeviceMediaRendererImpl)) continue;
                    DeviceMediaRendererImpl deviceMediaRendererImpl = (DeviceMediaRendererImpl)deviceImpl;
                    if (!deviceImpl.isAlive() || !deviceMediaRendererImpl.getAddress().equals(inetAddress)) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                arrayList.add(new DeviceManager.UnassociatedDevice(){

                    @Override
                    public InetAddress getAddress() {
                        return (InetAddress)entry.getKey();
                    }

                    @Override
                    public String getDescription() {
                        return (String)entry.getValue();
                    }
                });
            }
            return arrayList.toArray(new DeviceManager.UnassociatedDevice[arrayList.size()]);
        }
    }

    public PluginInterface getPluginInterface() {
        return this.plugin_interface;
    }

    protected IPCInterface getUPnPAVIPC() {
        return this.upnpav_ipc;
    }

    public void search() {
        if (this.upnp != null) {
            UPnPRootDevice[] uPnPRootDeviceArray = this.upnp.getRootDevices();
            for (UPnPRootDevice uPnPRootDevice : uPnPRootDeviceArray) {
                this.handleDevice(uPnPRootDevice, false);
            }
            Object[] objectArray = new String[]{"upnp:rootdevice", "urn:schemas-upnp-org:device:MediaRenderer:1"};
            this.upnp.search((String[])objectArray);
        }
    }

    protected void handleXBox(InetSocketAddress inetSocketAddress) {
        DeviceImpl[] deviceImplArray = this.manager.getDevices();
        boolean bl = false;
        for (DeviceImpl deviceImpl : deviceImplArray) {
            if (!(deviceImpl instanceof DeviceMediaRendererImpl)) continue;
            DeviceMediaRendererImpl deviceMediaRendererImpl = (DeviceMediaRendererImpl)deviceImpl;
            if (deviceImpl.getRendererSpecies() != 2) continue;
            bl = true;
            if (deviceImpl.isAlive()) continue;
            deviceMediaRendererImpl.setAddress(inetSocketAddress.getAddress());
            deviceImpl.alive();
        }
        if (!bl) {
            this.manager.addDevice(new DeviceMediaRendererImpl(this.manager, "Xbox 360"));
        }
    }

    protected void handlePS3(InetSocketAddress inetSocketAddress) {
        this.handleGeneric(inetSocketAddress, "ps3", "PS3");
    }

    protected void handleWii(InetSocketAddress inetSocketAddress) {
        this.handleGeneric(inetSocketAddress, "wii", "Wii");
    }

    protected void handleBrowser(InetSocketAddress inetSocketAddress) {
        this.handleGeneric(inetSocketAddress, "browser", "Browser");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleGeneric(InetSocketAddress inetSocketAddress, String string, String string2) {
        String string3;
        Object object = this;
        synchronized (object) {
            string3 = COConfigurationManager.getStringParameter("devices.upnp.uid." + string, "");
            if (string3.length() == 0) {
                string3 = UUIDGenerator.generateUUIDString();
                COConfigurationManager.setParameter("devices.upnp.uid." + string, string3);
                COConfigurationManager.save();
            }
        }
        object = new DeviceMediaRendererImpl(this.manager, string3, string2, false);
        object = (DeviceMediaRendererImpl)this.manager.addDevice((DeviceImpl)object);
        ((DeviceUPnPImpl)object).setAddress(inetSocketAddress.getAddress());
        ((DeviceImpl)object).alive();
    }

    protected void handleDevice(UPnPRootDevice uPnPRootDevice, boolean bl) {
        if (!this.manager.getAutoSearch() && !this.manager.isExplicitSearch()) {
            return;
        }
        this.handleDevice(uPnPRootDevice.getDevice(), bl);
    }

    protected void handleDevice(UPnPDevice uPnPDevice, boolean bl) {
        Object object;
        Object object2;
        UPnPService[] uPnPServiceArray = uPnPDevice.getServices();
        ArrayList<DeviceUPnPImpl> arrayList = new ArrayList<DeviceUPnPImpl>();
        ArrayList<UPnPWANConnection> arrayList2 = new ArrayList<UPnPWANConnection>();
        for (UPnPService object3 : uPnPServiceArray) {
            object2 = object3.getServiceType();
            if (((String)object2).equalsIgnoreCase("urn:schemas-upnp-org:service:WANIPConnection:1") || ((String)object2).equalsIgnoreCase("urn:schemas-upnp-org:service:WANPPPConnection:1")) {
                object = (UPnPWANConnection)object3.getSpecificService();
                arrayList2.add((UPnPWANConnection)object);
                continue;
            }
            if (((String)object2).equals("urn:schemas-upnp-org:service:ContentDirectory:1")) {
                arrayList.add(new DeviceContentDirectoryImpl(this.manager, uPnPDevice, object3));
                continue;
            }
            if (!((String)object2).equals("urn:schemas-upnp-org:service:VuzeOfflineDownloaderService:1")) continue;
            try {
                object = this.plugin_interface.getPluginManager().getPluginInterfaceByID("azofflinedownloader");
                if (object != null) {
                    String string = (String)object.getIPC().invoke("getUSN", new Object[0]);
                    String string2 = uPnPDevice.getRootDevice().getUSN();
                    int n = string2.indexOf("::upnp:rootdevice");
                    if (n > 0) {
                        string2 = string2.substring(0, n);
                    }
                    if (string2.equals(string)) {
                        continue;
                    }
                }
            }
            catch (Throwable throwable) {
                Debug.out(throwable);
            }
            object = (UPnPOfflineDownloader)object3.getSpecificService();
            if (object == null) continue;
            arrayList.add(new DeviceOfflineDownloaderImpl(this.manager, uPnPDevice, (UPnPOfflineDownloader)object));
        }
        if (arrayList2.size() > 0) {
            arrayList.add(new DeviceInternetGatewayImpl(this.manager, uPnPDevice, arrayList2));
        }
        if (uPnPDevice.getDeviceType().equals("urn:schemas-upnp-org:device:MediaRenderer:1")) {
            arrayList.add(new DeviceMediaRendererImpl(this.manager, uPnPDevice));
        }
        for (DeviceUPnPImpl deviceUPnPImpl : arrayList) {
            DeviceImpl deviceImpl = this.manager.getDevice(deviceUPnPImpl.getID());
            final DeviceImpl object4 = !bl && deviceImpl != null ? deviceImpl : this.manager.addDevice(deviceUPnPImpl);
            object2 = uPnPDevice.getRootDevice();
            if (object2 == (object = (UPnPRootDevice)object4.getTransientProperty(KEY_ROOT_DEVICE))) continue;
            object4.setTransientProperty(KEY_ROOT_DEVICE, object2);
            object2.addListener(new UPnPRootDeviceListener(){

                @Override
                public void lost(UPnPRootDevice uPnPRootDevice, boolean bl) {
                    if (!bl) {
                        object4.dead();
                    }
                }
            });
        }
        for (UPnPDevice uPnPDevice2 : uPnPDevice.getSubDevices()) {
            this.handleDevice(uPnPDevice2, bl);
        }
    }
}

