/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.content;

import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.plugins.download.Download;

public abstract class RelatedContent {
    private final String title;
    private final byte[] hash;
    private final String tracker;
    private final long size;
    private int date;
    private int seeds_leechers;
    private byte content_network;
    private byte[] related_to_hash;

    protected RelatedContent(byte[] byArray, String string, byte[] byArray2, String string2, long l, int n, int n2, byte by) {
        this.related_to_hash = byArray;
        this.title = string;
        this.hash = byArray2;
        this.tracker = string2;
        this.size = l;
        this.date = n;
        this.seeds_leechers = n2;
        this.content_network = by;
    }

    protected RelatedContent(String string, byte[] byArray, String string2, long l, int n, int n2, byte by) {
        this.title = string;
        this.hash = byArray;
        this.tracker = string2;
        this.size = l;
        this.date = n;
        this.seeds_leechers = n2;
        this.content_network = by;
    }

    protected void setRelatedToHash(byte[] byArray) {
        this.related_to_hash = byArray;
    }

    public byte[] getRelatedToHash() {
        return this.related_to_hash;
    }

    public abstract Download getRelatedToDownload();

    public String getTitle() {
        return this.title;
    }

    public abstract int getRank();

    public byte[] getHash() {
        return this.hash;
    }

    public abstract int getLevel();

    public abstract boolean isUnread();

    public abstract void setUnread(boolean var1);

    public abstract int getLastSeenSecs();

    public String getTracker() {
        return this.tracker;
    }

    public long getSize() {
        return this.size;
    }

    public long getPublishDate() {
        return (long)(this.date * 60 * 60) * 1000L;
    }

    protected int getDateHours() {
        return this.date;
    }

    protected void setDateHours(int n) {
        this.date = n;
    }

    public int getLeechers() {
        if (this.seeds_leechers == -1) {
            return -1;
        }
        return this.seeds_leechers & 0xFFFF;
    }

    public int getSeeds() {
        if (this.seeds_leechers == -1) {
            return -1;
        }
        return this.seeds_leechers >> 16 & 0xFFFF;
    }

    protected int getSeedsLeechers() {
        return this.seeds_leechers;
    }

    protected void setSeedsLeechers(int n) {
        this.seeds_leechers = n;
    }

    public long getContentNetwork() {
        return (this.content_network & 0xFF) == 255 ? -1L : (long)(this.content_network & 0xFF);
    }

    protected void setContentNetwork(long l) {
        this.content_network = (byte)l;
    }

    public abstract void delete();

    public String getString() {
        return "title=" + this.title + ", hash=" + (this.hash == null ? "null" : Base32.encode(this.hash)) + ", tracker=" + this.tracker + ", date=" + this.date + ", sl=" + this.seeds_leechers + ", cnet=" + this.content_network;
    }
}

