/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.clientmessageservice.impl;

import com.aelitis.azureus.core.clientmessageservice.ClientMessageService;
import com.aelitis.azureus.core.clientmessageservice.impl.ClientConnection;
import com.aelitis.azureus.core.clientmessageservice.impl.ClientMessage;
import com.aelitis.azureus.core.clientmessageservice.impl.ClientMessageHandler;
import com.aelitis.azureus.core.clientmessageservice.impl.NonBlockingReadWriteService;
import com.aelitis.azureus.core.networkmanager.ConnectionEndpoint;
import com.aelitis.azureus.core.networkmanager.Transport;
import com.aelitis.azureus.core.networkmanager.impl.tcp.ProtocolEndpointTCP;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPTransportImpl;
import com.aelitis.azureus.core.peermanager.messaging.MessageException;
import com.aelitis.azureus.core.peermanager.messaging.azureus.AZMessageFactory;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Map;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.Debug;

public class AEClientService
implements ClientMessageService {
    private final String address;
    private final int port;
    private final String msg_type_id;
    private final int timeout_secs;
    private int max_message_bytes = -1;
    private ClientConnection conn;
    private final AESemaphore read_block = new AESemaphore("AEClientService:R");
    private final AESemaphore write_block = new AESemaphore("AEClientService:W");
    private final ArrayList received_messages = new ArrayList();
    private final NonBlockingReadWriteService rw_service;
    private volatile Throwable error;

    public AEClientService(String string, int n, String string2) {
        this(string, n, 30, string2);
    }

    public AEClientService(String string, int n, int n2, String string2) {
        this.address = string;
        this.port = n;
        this.timeout_secs = n2;
        this.msg_type_id = string2;
        try {
            AZMessageFactory.registerGenericMapPayloadMessageType(this.msg_type_id);
        }
        catch (MessageException messageException) {
            // empty catch block
        }
        this.rw_service = new NonBlockingReadWriteService(this.msg_type_id, n2, 0, new NonBlockingReadWriteService.ServiceListener(){

            @Override
            public void messageReceived(ClientMessage clientMessage) {
                AEClientService.this.received_messages.add(clientMessage.getPayload());
                AEClientService.this.read_block.release();
            }

            @Override
            public void connectionError(ClientConnection clientConnection, Throwable throwable) {
                AEClientService.this.error = throwable;
                AEClientService.this.read_block.releaseForever();
                AEClientService.this.write_block.releaseForever();
            }
        });
    }

    private void connect() throws IOException {
        InetSocketAddress inetSocketAddress = new InetSocketAddress(this.address, this.port);
        ConnectionEndpoint connectionEndpoint = new ConnectionEndpoint(inetSocketAddress);
        new ProtocolEndpointTCP(connectionEndpoint, inetSocketAddress);
        final AESemaphore aESemaphore = new AESemaphore("AEClientService:C");
        connectionEndpoint.connectOutbound(false, false, null, null, 3, new Transport.ConnectListener(){

            @Override
            public int connectAttemptStarted(int n) {
                return n;
            }

            @Override
            public void connectSuccess(Transport transport, ByteBuffer byteBuffer) {
                AEClientService.this.conn = new ClientConnection((TCPTransportImpl)transport);
                if (AEClientService.this.max_message_bytes != -1) {
                    AEClientService.this.conn.setMaximumMessageSize(AEClientService.this.max_message_bytes);
                }
                aESemaphore.release();
            }

            @Override
            public void connectFailure(Throwable throwable) {
                AEClientService.this.error = throwable;
                aESemaphore.release();
            }
        });
        if (!aESemaphore.reserve(this.timeout_secs * 1000)) {
            throw new IOException("connect op failed: timeout");
        }
        if (this.error != null) {
            this.close();
            throw new IOException("connect op failed: " + this.error.getMessage() == null ? "[]" : this.error.getMessage());
        }
        this.rw_service.addClientConnection(this.conn);
    }

    @Override
    public void sendMessage(Map map) throws IOException {
        if (this.conn == null) {
            this.connect();
        }
        if (this.error != null) {
            this.close();
            throw new IOException("send op failed: " + this.error.getMessage() == null ? "[]" : this.error.getMessage());
        }
        ClientMessage clientMessage = new ClientMessage(this.msg_type_id, this.conn, map, new ClientMessageHandler(){

            @Override
            public String getMessageTypeID() {
                return AEClientService.this.msg_type_id;
            }

            @Override
            public void processMessage(ClientMessage clientMessage) {
                Debug.out("ERROR: should never be called");
            }

            @Override
            public void sendAttemptCompleted(ClientMessage clientMessage) {
                AEClientService.this.write_block.release();
            }

            @Override
            public void sendAttemptFailed(ClientMessage clientMessage, Throwable throwable) {
                AEClientService.this.error = throwable;
                AEClientService.this.write_block.release();
            }
        });
        this.rw_service.sendMessage(clientMessage);
        this.write_block.reserve();
        if (this.error != null) {
            this.close();
            throw new IOException("send op failed: " + this.error.getMessage() == null ? "[]" : this.error.getMessage());
        }
    }

    @Override
    public Map receiveMessage() throws IOException {
        if (this.conn == null) {
            this.connect();
        }
        this.read_block.reserve();
        if (!this.received_messages.isEmpty()) {
            Map map = (Map)this.received_messages.remove(0);
            return map;
        }
        if (this.error == null) {
            this.error = new IOException("receive op inconsistent");
        }
        this.close();
        throw new IOException("receive op failed: " + this.error.getMessage() == null ? "[]" : this.error.getMessage());
    }

    @Override
    public void close() {
        if (this.conn != null) {
            this.rw_service.removeClientConnection(this.conn);
            this.conn.close(new Exception("Connection closed"));
        }
        this.rw_service.destroy();
    }

    @Override
    public void setMaximumMessageSize(int n) {
        this.max_message_bytes = n;
    }
}

