/*
 * Decompiled with CFR 0.152.
 */
package davmail.ui.tray;

import davmail.BundleMessage;
import davmail.DavGateway;
import davmail.Settings;
import davmail.ui.AboutFrame;
import davmail.ui.SettingsFrame;
import davmail.ui.tray.DavGatewayTray;
import davmail.ui.tray.DavGatewayTrayInterface;
import davmail.util.IOUtil;
import java.awt.Image;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.swing.UIManager;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.lf5.LF5Appender;
import org.apache.log4j.lf5.LogLevel;
import org.apache.log4j.lf5.viewer.LogBrokerMonitor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolTip;
import org.eclipse.swt.widgets.Tray;
import org.eclipse.swt.widgets.TrayItem;

public class SwtGatewayTray
implements DavGatewayTrayInterface {
    SettingsFrame settingsFrame;
    AboutFrame aboutFrame;
    private static TrayItem trayItem;
    private static Image awtImage;
    private static org.eclipse.swt.graphics.Image image;
    private static org.eclipse.swt.graphics.Image image2;
    private static org.eclipse.swt.graphics.Image inactiveImage;
    private static Display display;
    private static Shell shell;
    private LogBrokerMonitor logBrokerMonitor;
    private boolean isActive = true;
    private boolean isReady;
    private Error error;
    private boolean firstMessage = true;
    private final Thread mainThread = Thread.currentThread();

    protected SwtGatewayTray() {
    }

    @Override
    public Image getFrameIcon() {
        return awtImage;
    }

    @Override
    public void switchIcon() {
        this.isActive = true;
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                org.eclipse.swt.graphics.Image currentImage = trayItem.getImage();
                if (currentImage != null && currentImage.equals((Object)image)) {
                    trayItem.setImage(image2);
                } else {
                    trayItem.setImage(image);
                }
            }
        });
    }

    @Override
    public void resetIcon() {
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                trayItem.setImage(image);
            }
        });
    }

    @Override
    public void inactiveIcon() {
        this.isActive = false;
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                trayItem.setImage(inactiveImage);
            }
        });
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public void displayMessage(final String message, final Level level) {
        if (trayItem != null) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    int messageType = 0;
                    if (level.equals((Object)Level.INFO)) {
                        messageType = 2;
                    } else if (level.equals((Object)Level.WARN)) {
                        messageType = 8;
                    } else if (level.equals((Object)Level.ERROR)) {
                        messageType = 1;
                    }
                    if (messageType != 0) {
                        ToolTip toolTip = new ToolTip(shell, 0x1000 | messageType);
                        toolTip.setText(BundleMessage.format("UI_DAVMAIL_GATEWAY", new Object[0]));
                        toolTip.setMessage(message);
                        trayItem.setToolTip(toolTip);
                        if (SwtGatewayTray.this.firstMessage) {
                            SwtGatewayTray.this.firstMessage = false;
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                        toolTip.setVisible(true);
                    }
                    trayItem.setToolTipText(BundleMessage.format("UI_DAVMAIL_GATEWAY", new Object[0]) + '\n' + message);
                }
            });
        }
    }

    public static org.eclipse.swt.graphics.Image loadSwtImage(String fileName) {
        org.eclipse.swt.graphics.Image result = null;
        try {
            ClassLoader classloader = DavGatewayTray.class.getClassLoader();
            URL imageUrl = classloader.getResource(fileName);
            if (imageUrl == null) {
                throw new IOException(fileName);
            }
            byte[] imageContent = IOUtil.readFully(imageUrl.openStream());
            result = new org.eclipse.swt.graphics.Image((Device)display, (InputStream)new ByteArrayInputStream(imageContent));
        }
        catch (IOException e) {
            DavGatewayTray.warn(new BundleMessage("LOG_UNABLE_TO_LOAD_IMAGE", new Object[0]), e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void init() {
        try {
            OS.gdk_error_trap_push();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        String systemLookAndFeelClassName = UIManager.getSystemLookAndFeelClassName();
        try {
            if (systemLookAndFeelClassName.contains("gtk")) {
                System.setProperty("swing.defaultlaf", UIManager.getCrossPlatformLookAndFeelClassName());
            } else {
                System.setProperty("swing.defaultlaf", systemLookAndFeelClassName);
            }
        }
        catch (Exception e) {
            DavGatewayTray.warn(new BundleMessage("LOG_UNABLE_TO_SET_LOOK_AND_FEEL", new Object[0]));
        }
        new Thread("SWT"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    display = new Display();
                    shell = new Shell(display);
                    Tray tray = display.getSystemTray();
                    if (tray != null) {
                        trayItem = new TrayItem(tray, 0);
                        trayItem.setToolTipText(BundleMessage.format("UI_DAVMAIL_GATEWAY", new Object[0]));
                        awtImage = DavGatewayTray.loadImage("tray.png");
                        image = SwtGatewayTray.loadSwtImage("tray.png");
                        image2 = SwtGatewayTray.loadSwtImage("tray2.png");
                        inactiveImage = SwtGatewayTray.loadSwtImage("trayinactive.png");
                        trayItem.setImage(image);
                        trayItem.addDisposeListener(new DisposeListener(){

                            public void widgetDisposed(DisposeEvent e) {
                                if (image != null && !image.isDisposed()) {
                                    image.dispose();
                                }
                                if (image2 != null && !image2.isDisposed()) {
                                    image2.dispose();
                                }
                                if (inactiveImage != null && !inactiveImage.isDisposed()) {
                                    inactiveImage.dispose();
                                }
                            }
                        });
                        final Menu popup = new Menu((Decorations)shell, 8);
                        trayItem.addListener(35, new Listener(){

                            public void handleEvent(Event event) {
                                display.asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        popup.setVisible(true);
                                    }
                                });
                            }
                        });
                        MenuItem aboutItem = new MenuItem(popup, 8);
                        aboutItem.setText(BundleMessage.format("UI_ABOUT", new Object[0]));
                        aboutItem.addListener(13, new Listener(){

                            public void handleEvent(Event event) {
                                display.asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (SwtGatewayTray.this.aboutFrame == null) {
                                            SwtGatewayTray.this.aboutFrame = new AboutFrame();
                                        }
                                        SwtGatewayTray.this.aboutFrame.update();
                                        SwtGatewayTray.this.aboutFrame.setVisible(true);
                                        SwtGatewayTray.this.aboutFrame.toFront();
                                        SwtGatewayTray.this.aboutFrame.requestFocus();
                                    }
                                });
                            }
                        });
                        trayItem.addListener(14, new Listener(){

                            public void handleEvent(Event event) {
                                display.asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (SwtGatewayTray.this.settingsFrame == null) {
                                            SwtGatewayTray.this.settingsFrame = new SettingsFrame();
                                        }
                                        SwtGatewayTray.this.settingsFrame.reload();
                                        SwtGatewayTray.this.settingsFrame.setVisible(true);
                                        SwtGatewayTray.this.settingsFrame.toFront();
                                        SwtGatewayTray.this.settingsFrame.requestFocus();
                                    }
                                });
                            }
                        });
                        MenuItem defaultItem = new MenuItem(popup, 8);
                        defaultItem.setText(BundleMessage.format("UI_SETTINGS", new Object[0]));
                        defaultItem.addListener(13, new Listener(){

                            public void handleEvent(Event event) {
                                display.asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (SwtGatewayTray.this.settingsFrame == null) {
                                            SwtGatewayTray.this.settingsFrame = new SettingsFrame();
                                        }
                                        SwtGatewayTray.this.settingsFrame.reload();
                                        SwtGatewayTray.this.settingsFrame.setVisible(true);
                                        SwtGatewayTray.this.settingsFrame.toFront();
                                        SwtGatewayTray.this.settingsFrame.requestFocus();
                                    }
                                });
                            }
                        });
                        MenuItem logItem = new MenuItem(popup, 8);
                        logItem.setText(BundleMessage.format("UI_SHOW_LOGS", new Object[0]));
                        logItem.addListener(13, new Listener(){

                            public void handleEvent(Event event) {
                                display.asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        Logger rootLogger = Logger.getRootLogger();
                                        LF5Appender lf5Appender = (LF5Appender)rootLogger.getAppender("LF5Appender");
                                        if (lf5Appender == null) {
                                            SwtGatewayTray.this.logBrokerMonitor = new LogBrokerMonitor(LogLevel.getLog4JLevels()){

                                                protected void closeAfterConfirm() {
                                                    this.hide();
                                                }
                                            };
                                            lf5Appender = new LF5Appender(SwtGatewayTray.this.logBrokerMonitor);
                                            lf5Appender.setName("LF5Appender");
                                            rootLogger.addAppender((Appender)lf5Appender);
                                        }
                                        lf5Appender.getLogBrokerMonitor().show();
                                    }
                                });
                            }
                        });
                        MenuItem exitItem = new MenuItem(popup, 8);
                        exitItem.setText(BundleMessage.format("UI_EXIT", new Object[0]));
                        exitItem.addListener(13, new Listener(){

                            public void handleEvent(Event event) {
                                DavGateway.stop();
                            }
                        });
                        if (Settings.isFirstStart()) {
                            if (SwtGatewayTray.this.settingsFrame == null) {
                                SwtGatewayTray.this.settingsFrame = new SettingsFrame();
                            }
                            SwtGatewayTray.this.settingsFrame.setVisible(true);
                            SwtGatewayTray.this.settingsFrame.toFront();
                            SwtGatewayTray.this.settingsFrame.requestFocus();
                        }
                        Thread thread = SwtGatewayTray.this.mainThread;
                        synchronized (thread) {
                            SwtGatewayTray.this.isReady = true;
                            SwtGatewayTray.this.mainThread.notifyAll();
                        }
                        while (!shell.isDisposed()) {
                            if (display.readAndDispatch()) continue;
                            display.sleep();
                        }
                    }
                    if (SwtGatewayTray.this.settingsFrame != null) {
                        SwtGatewayTray.this.settingsFrame.dispose();
                    }
                    if (SwtGatewayTray.this.aboutFrame != null) {
                        SwtGatewayTray.this.aboutFrame.dispose();
                    }
                    if (SwtGatewayTray.this.logBrokerMonitor != null) {
                        SwtGatewayTray.this.logBrokerMonitor.dispose();
                    }
                }
                catch (Exception exc) {
                    DavGatewayTray.error(exc);
                }
                catch (Error exc) {
                    SwtGatewayTray.this.error = exc;
                    throw exc;
                }
                System.exit(0);
            }
        }.start();
        while (true) {
            try {
                while (true) {
                    Thread e = this.mainThread;
                    synchronized (e) {
                        if (this.error != null) {
                            throw this.error;
                        }
                        if (this.isReady) {
                            return;
                        }
                        this.mainThread.wait(1000L);
                    }
                }
            }
            catch (InterruptedException e) {
                DavGatewayTray.error(new BundleMessage("LOG_ERROR_WAITING_FOR_SWT_INIT", new Object[0]), e);
                continue;
            }
            break;
        }
    }

    @Override
    public void dispose() {
        shell.dispose();
    }
}

