/*
 * Decompiled with CFR 0.152.
 */
package davmail.ui.tray;

import davmail.BundleMessage;
import davmail.DavGateway;
import davmail.Settings;
import davmail.ui.AboutFrame;
import davmail.ui.SettingsFrame;
import davmail.ui.tray.DavGatewayTray;
import davmail.ui.tray.DavGatewayTrayInterface;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.lf5.LF5Appender;
import org.apache.log4j.lf5.LogLevel;
import org.apache.log4j.lf5.viewer.LogBrokerMonitor;

public class FrameGatewayTray
implements DavGatewayTrayInterface {
    static JFrame mainFrame;
    static AboutFrame aboutFrame;
    static SettingsFrame settingsFrame;
    LogBrokerMonitor logBrokerMonitor;
    private static JEditorPane errorArea;
    private static JLabel errorLabel;
    private static JEditorPane messageArea;
    private static Image image;
    private static Image image2;
    private static Image inactiveImage;
    private boolean isActive = true;

    protected FrameGatewayTray() {
    }

    @Override
    public Image getFrameIcon() {
        return image;
    }

    @Override
    public void switchIcon() {
        this.isActive = true;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Image currentImage = mainFrame.getIconImage();
                if (currentImage != null && currentImage.equals(image)) {
                    mainFrame.setIconImage(image2);
                } else {
                    mainFrame.setIconImage(image);
                }
            }
        });
    }

    @Override
    public void resetIcon() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                mainFrame.setIconImage(image);
            }
        });
    }

    @Override
    public void inactiveIcon() {
        this.isActive = false;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                mainFrame.setIconImage(inactiveImage);
            }
        });
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public void displayMessage(final String message, final Level level) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (errorArea != null && messageArea != null) {
                    if (level.equals((Object)Level.INFO)) {
                        errorLabel.setIcon(UIManager.getIcon("OptionPane.informationIcon"));
                        errorArea.setText(message);
                    } else if (level.equals((Object)Level.WARN)) {
                        errorLabel.setIcon(UIManager.getIcon("OptionPane.warningIcon"));
                        errorArea.setText(message);
                    } else if (level.equals((Object)Level.ERROR)) {
                        errorLabel.setIcon(UIManager.getIcon("OptionPane.errorIcon"));
                        errorArea.setText(message);
                    }
                    messageArea.setText(message);
                }
            }
        });
    }

    public void about() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                aboutFrame.update();
                aboutFrame.setVisible(true);
                aboutFrame.toFront();
                aboutFrame.requestFocus();
            }
        });
    }

    public void preferences() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                settingsFrame.reload();
                settingsFrame.setVisible(true);
                settingsFrame.toFront();
                settingsFrame.repaint();
                settingsFrame.requestFocus();
            }
        });
    }

    public void showLogs() {
        Logger rootLogger = Logger.getRootLogger();
        LF5Appender lf5Appender = (LF5Appender)rootLogger.getAppender("LF5Appender");
        if (lf5Appender == null) {
            this.logBrokerMonitor = new LogBrokerMonitor(LogLevel.getLog4JLevels()){

                protected void closeAfterConfirm() {
                    this.hide();
                }
            };
            lf5Appender = new LF5Appender(this.logBrokerMonitor);
            lf5Appender.setName("LF5Appender");
            rootLogger.addAppender((Appender)lf5Appender);
        }
        lf5Appender.getLogBrokerMonitor().show();
    }

    @Override
    public void init() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FrameGatewayTray.this.createAndShowGUI();
            }
        });
    }

    @Override
    public void dispose() {
        settingsFrame.dispose();
        aboutFrame.dispose();
        if (this.logBrokerMonitor != null) {
            this.logBrokerMonitor.dispose();
        }
    }

    protected void buildMenu() {
        JMenu menu = new JMenu(BundleMessage.format("UI_DAVMAIL_GATEWAY", new Object[0]));
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(menu);
        mainFrame.setJMenuBar(menuBar);
        ActionListener aboutListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameGatewayTray.this.about();
            }
        };
        JMenuItem aboutItem = new JMenuItem(BundleMessage.format("UI_ABOUT", new Object[0]));
        aboutItem.addActionListener(aboutListener);
        menu.add(aboutItem);
        ActionListener settingsListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameGatewayTray.this.preferences();
            }
        };
        JMenuItem defaultItem = new JMenuItem(BundleMessage.format("UI_SETTINGS", new Object[0]));
        defaultItem.addActionListener(settingsListener);
        menu.add(defaultItem);
        JMenuItem logItem = new JMenuItem(BundleMessage.format("UI_SHOW_LOGS", new Object[0]));
        logItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameGatewayTray.this.showLogs();
            }
        });
        menu.add(logItem);
        ActionListener exitListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    DavGateway.stop();
                }
                catch (Exception exc) {
                    DavGatewayTray.error(exc);
                }
                System.exit(0);
            }
        };
        JMenuItem exitItem = new JMenuItem(BundleMessage.format("UI_EXIT", new Object[0]));
        exitItem.addActionListener(exitListener);
        menu.add(exitItem);
    }

    protected void createAndShowGUI() {
        System.setProperty("swing.defaultlaf", UIManager.getSystemLookAndFeelClassName());
        image = DavGatewayTray.loadImage("tray.png");
        image2 = DavGatewayTray.loadImage("tray2.png");
        inactiveImage = DavGatewayTray.loadImage("trayinactive.png");
        mainFrame = new JFrame();
        mainFrame.setDefaultCloseOperation(3);
        mainFrame.setTitle(BundleMessage.format("UI_DAVMAIL_GATEWAY", new Object[0]));
        mainFrame.setIconImage(image);
        JPanel errorPanel = new JPanel();
        errorPanel.setBorder(BorderFactory.createTitledBorder(BundleMessage.format("UI_LAST_MESSAGE", new Object[0])));
        errorPanel.setLayout(new BoxLayout(errorPanel, 0));
        errorArea = new JTextPane();
        errorArea.setEditable(false);
        errorArea.setBackground(mainFrame.getBackground());
        errorLabel = new JLabel();
        errorPanel.add(errorLabel);
        errorPanel.add(errorArea);
        JPanel messagePanel = new JPanel();
        messagePanel.setBorder(BorderFactory.createTitledBorder(BundleMessage.format("UI_LAST_LOG", new Object[0])));
        messagePanel.setLayout(new BoxLayout(messagePanel, 0));
        messageArea = new JTextPane();
        messageArea.setText(BundleMessage.format("LOG_STARTING_DAVMAIL", new Object[0]));
        messageArea.setEditable(false);
        messageArea.setBackground(mainFrame.getBackground());
        messagePanel.add(messageArea);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.add(errorPanel);
        mainPanel.add(messagePanel);
        mainFrame.add(mainPanel);
        aboutFrame = new AboutFrame();
        settingsFrame = new SettingsFrame();
        this.buildMenu();
        mainFrame.setMinimumSize(new Dimension(400, 180));
        mainFrame.pack();
        if (FrameGatewayTray.mainFrame.getSize().width < 400 || FrameGatewayTray.mainFrame.getSize().height < 180) {
            mainFrame.setSize(Math.max(FrameGatewayTray.mainFrame.getSize().width, 400), Math.max(FrameGatewayTray.mainFrame.getSize().height, 180));
        }
        mainFrame.setLocation(FrameGatewayTray.mainFrame.getToolkit().getScreenSize().width / 2 - FrameGatewayTray.mainFrame.getSize().width / 2, FrameGatewayTray.mainFrame.getToolkit().getScreenSize().height / 2 - FrameGatewayTray.mainFrame.getSize().height / 2);
        mainFrame.setVisible(true);
        if (Settings.isFirstStart()) {
            settingsFrame.setVisible(true);
            settingsFrame.toFront();
            settingsFrame.repaint();
            settingsFrame.requestFocus();
        }
    }
}

