/*
 * Decompiled with CFR 0.152.
 */
package davmail.service;

import davmail.BundleMessage;
import davmail.DavGateway;
import davmail.Settings;
import davmail.ui.tray.DavGatewayTray;
import org.boris.winrun4j.AbstractService;
import org.boris.winrun4j.ServiceException;

public class DavService
extends AbstractService {
    protected boolean stopped;

    public int serviceRequest(int control) throws ServiceException {
        switch (control) {
            case 1: 
            case 5: {
                DavGatewayTray.debug(new BundleMessage("LOG_STOPPING_DAVMAIL", new Object[0]));
                DavGateway.stop();
                this.stopped = true;
            }
        }
        return 0;
    }

    public int serviceMain(String[] args) throws ServiceException {
        if (args.length >= 1) {
            Settings.setConfigFilePath(args[0]);
        }
        Settings.load();
        if (!Settings.getBooleanProperty("davmail.server")) {
            Settings.setProperty("davmail.server", "true");
            Settings.updateLoggingConfig();
        }
        DavGateway.start();
        DavGatewayTray.debug(new BundleMessage("LOG_DAVMAIL_STARTED", new Object[0]));
        Thread shutdownListenerThread = new Thread("ShutDownListener"){

            @Override
            public void run() {
                try {
                    while (!DavService.this.stopped) {
                        Thread.sleep(1000L);
                    }
                }
                catch (InterruptedException e) {
                    DavGatewayTray.debug(new BundleMessage("LOG_GATEWAY_INTERRUPTED", new Object[0]));
                    DavGateway.stop();
                    DavGatewayTray.debug(new BundleMessage("LOG_GATEWAY_STOP", new Object[0]));
                }
            }
        };
        shutdownListenerThread.start();
        return 0;
    }
}

