/*
 * Decompiled with CFR 0.152.
 */
package davmail.exchange.ews;

import davmail.BundleMessage;
import davmail.Settings;
import davmail.exchange.XMLStreamUtil;
import davmail.exchange.ews.AttributeOption;
import davmail.exchange.ews.BaseShape;
import davmail.exchange.ews.Disposal;
import davmail.exchange.ews.EWSException;
import davmail.exchange.ews.ElementOption;
import davmail.exchange.ews.FieldOrder;
import davmail.exchange.ews.FieldURI;
import davmail.exchange.ews.FieldUpdate;
import davmail.exchange.ews.FileAttachment;
import davmail.exchange.ews.FolderId;
import davmail.exchange.ews.FolderQueryTraversal;
import davmail.exchange.ews.ItemId;
import davmail.exchange.ews.SearchExpression;
import davmail.http.DavGatewayHttpClientFacade;
import davmail.ui.tray.DavGatewayTray;
import davmail.util.StringUtil;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.codehaus.stax2.typed.TypedXMLStreamReader;

public abstract class EWSMethod
extends PostMethod {
    protected static final Logger LOGGER = Logger.getLogger(EWSMethod.class);
    protected static final int CHUNK_LENGTH = 131072;
    protected FolderQueryTraversal traversal;
    protected BaseShape baseShape;
    protected boolean includeMimeContent;
    protected FolderId folderId;
    protected FolderId savedItemFolderId;
    protected FolderId toFolderId;
    protected FolderId parentFolderId;
    protected ItemId itemId;
    protected List<ItemId> itemIds;
    protected ItemId parentItemId;
    protected Set<FieldURI> additionalProperties;
    protected Disposal deleteType;
    protected Set<AttributeOption> methodOptions;
    protected ElementOption unresolvedEntry;
    protected int maxCount;
    protected int offset;
    protected boolean includesLastItemInRange;
    protected List<FieldUpdate> updates;
    protected FileAttachment attachment;
    protected String attachmentId;
    protected final String itemType;
    protected final String methodName;
    protected final String responseCollectionName;
    protected List<Item> responseItems;
    protected String errorDetail;
    protected String errorDescription;
    protected Item item;
    protected SearchExpression searchExpression;
    protected FieldOrder fieldOrder;
    protected String serverVersion;
    protected String timezoneContext;

    public EWSMethod(String itemType, String methodName) {
        this(itemType, methodName, itemType + 's');
    }

    public EWSMethod(String itemType, String methodName, String responseCollectionName) {
        super("/ews/exchange.asmx");
        this.itemType = itemType;
        this.methodName = methodName;
        this.responseCollectionName = responseCollectionName;
        if (Settings.getBooleanProperty("davmail.acceptEncodingGzip", true) && !Level.DEBUG.toString().equals(Settings.getProperty("log4j.logger.httpclient.wire"))) {
            this.setRequestHeader("Accept-Encoding", "gzip");
        }
        this.setRequestEntity(new RequestEntity(){
            byte[] content;

            public boolean isRepeatable() {
                return true;
            }

            public void writeRequest(OutputStream outputStream) throws IOException {
                boolean firstPass;
                boolean bl = firstPass = this.content == null;
                if (this.content == null) {
                    this.content = EWSMethod.this.generateSoapEnvelope();
                }
                if (this.content.length < 131072) {
                    outputStream.write(this.content);
                } else {
                    for (int i = 0; i < this.content.length; i += 131072) {
                        int length = 131072;
                        if (i + 131072 > this.content.length) {
                            length = this.content.length - i;
                        }
                        outputStream.write(this.content, i, length);
                        if (firstPass) continue;
                        DavGatewayTray.debug(new BundleMessage("LOG_UPLOAD_PROGRESS", String.valueOf((i + length) / 1024), (i + length) * 100 / this.content.length));
                        DavGatewayTray.switchIcon();
                    }
                }
            }

            public long getContentLength() {
                if (this.content == null) {
                    this.content = EWSMethod.this.generateSoapEnvelope();
                }
                return this.content.length;
            }

            public String getContentType() {
                return "text/xml; charset=UTF-8";
            }
        });
    }

    public String getName() {
        return "POST";
    }

    protected void addAdditionalProperty(FieldURI additionalProperty) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashSet<FieldURI>();
        }
        this.additionalProperties.add(additionalProperty);
    }

    protected void addMethodOption(AttributeOption attributeOption) {
        if (this.methodOptions == null) {
            this.methodOptions = new HashSet<AttributeOption>();
        }
        this.methodOptions.add(attributeOption);
    }

    protected void setSearchExpression(SearchExpression searchExpression) {
        this.searchExpression = searchExpression;
    }

    protected void setFieldOrder(FieldOrder fieldOrder) {
        this.fieldOrder = fieldOrder;
    }

    protected void writeShape(Writer writer) throws IOException {
        if (this.baseShape != null) {
            writer.write("<m:");
            writer.write(this.itemType);
            writer.write("Shape>");
            this.baseShape.write(writer);
            if (this.includeMimeContent) {
                writer.write("<t:IncludeMimeContent>true</t:IncludeMimeContent>");
            }
            if (this.additionalProperties != null) {
                writer.write("<t:AdditionalProperties>");
                StringBuilder buffer = new StringBuilder();
                for (FieldURI fieldURI : this.additionalProperties) {
                    fieldURI.appendTo(buffer);
                }
                writer.write(buffer.toString());
                writer.write("</t:AdditionalProperties>");
            }
            writer.write("</m:");
            writer.write(this.itemType);
            writer.write("Shape>");
        }
    }

    protected void writeItemId(Writer writer) throws IOException {
        if (this.itemId != null || this.itemIds != null) {
            if (this.updates == null) {
                writer.write("<m:ItemIds>");
            }
            if (this.itemId != null) {
                this.itemId.write(writer);
            }
            if (this.itemIds != null) {
                for (ItemId localItemId : this.itemIds) {
                    localItemId.write(writer);
                }
            }
            if (this.updates == null) {
                writer.write("</m:ItemIds>");
            }
        }
    }

    protected void writeParentItemId(Writer writer) throws IOException {
        if (this.parentItemId != null) {
            writer.write("<m:ParentItemId Id=\"");
            writer.write(this.parentItemId.id);
            if (this.parentItemId.changeKey != null) {
                writer.write("\" ChangeKey=\"");
                writer.write(this.parentItemId.changeKey);
            }
            writer.write("\"/>");
        }
    }

    protected void writeFolderId(Writer writer) throws IOException {
        if (this.folderId != null) {
            if (this.updates == null) {
                writer.write("<m:FolderIds>");
            }
            this.folderId.write(writer);
            if (this.updates == null) {
                writer.write("</m:FolderIds>");
            }
        }
    }

    protected void writeSavedItemFolderId(Writer writer) throws IOException {
        if (this.savedItemFolderId != null) {
            writer.write("<m:SavedItemFolderId>");
            this.savedItemFolderId.write(writer);
            writer.write("</m:SavedItemFolderId>");
        }
    }

    protected void writeToFolderId(Writer writer) throws IOException {
        if (this.toFolderId != null) {
            writer.write("<m:ToFolderId>");
            this.toFolderId.write(writer);
            writer.write("</m:ToFolderId>");
        }
    }

    protected void writeParentFolderId(Writer writer) throws IOException {
        if (this.parentFolderId != null) {
            writer.write("<m:ParentFolderId");
            if (this.item == null) {
                writer.write("s");
            }
            writer.write(">");
            this.parentFolderId.write(writer);
            writer.write("</m:ParentFolderId");
            if (this.item == null) {
                writer.write("s");
            }
            writer.write(">");
        }
    }

    protected void writeItem(Writer writer) throws IOException {
        if (this.item != null) {
            writer.write("<m:");
            writer.write(this.itemType);
            writer.write("s>");
            this.item.write(writer);
            writer.write("</m:");
            writer.write(this.itemType);
            writer.write("s>");
        }
    }

    protected void writeRestriction(Writer writer) throws IOException {
        if (this.searchExpression != null) {
            writer.write("<m:Restriction>");
            StringBuilder buffer = new StringBuilder();
            this.searchExpression.appendTo(buffer);
            writer.write(buffer.toString());
            writer.write("</m:Restriction>");
        }
    }

    protected void writeSortOrder(Writer writer) throws IOException {
        if (this.fieldOrder != null) {
            writer.write("<m:SortOrder>");
            StringBuilder buffer = new StringBuilder();
            this.fieldOrder.appendTo(buffer);
            writer.write(buffer.toString());
            writer.write("</m:SortOrder>");
        }
    }

    protected void startChanges(Writer writer) throws IOException {
        if (this.updates != null) {
            writer.write("<m:");
            writer.write(this.itemType);
            writer.write("Changes>");
            writer.write("<t:");
            writer.write(this.itemType);
            writer.write("Change>");
        }
    }

    protected void writeUpdates(Writer writer) throws IOException {
        if (this.updates != null) {
            writer.write("<t:Updates>");
            for (FieldUpdate fieldUpdate : this.updates) {
                fieldUpdate.write(this.itemType, writer);
            }
            writer.write("</t:Updates>");
        }
    }

    protected void writeUnresolvedEntry(Writer writer) throws IOException {
        if (this.unresolvedEntry != null) {
            this.unresolvedEntry.write(writer);
        }
    }

    protected void endChanges(Writer writer) throws IOException {
        if (this.updates != null) {
            writer.write("</t:");
            writer.write(this.itemType);
            writer.write("Change>");
            writer.write("</m:");
            writer.write(this.itemType);
            writer.write("Changes>");
        }
    }

    protected byte[] generateSoapEnvelope() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baos, "UTF-8");
            writer.write("<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:t=\"http://schemas.microsoft.com/exchange/services/2006/types\" xmlns:m=\"http://schemas.microsoft.com/exchange/services/2006/messages\">");
            writer.write("<soap:Header>");
            if (this.serverVersion != null) {
                writer.write("<t:RequestServerVersion Version=\"");
                writer.write(this.serverVersion);
                writer.write("\"/>");
            }
            if (this.timezoneContext != null) {
                writer.write("<t:TimeZoneContext><t:TimeZoneDefinition Id=\"");
                writer.write(this.timezoneContext);
                writer.write("\"/></t:TimeZoneContext>");
            }
            writer.write("</soap:Header>");
            writer.write("<soap:Body>");
            writer.write("<m:");
            writer.write(this.methodName);
            if (this.traversal != null) {
                this.traversal.write(writer);
            }
            if (this.deleteType != null) {
                this.deleteType.write(writer);
            }
            if (this.methodOptions != null) {
                for (AttributeOption attributeOption : this.methodOptions) {
                    attributeOption.write(writer);
                }
            }
            writer.write(">");
            this.writeSoapBody(writer);
            writer.write("</m:");
            writer.write(this.methodName);
            writer.write(">");
            writer.write("</soap:Body></soap:Envelope>");
            writer.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return baos.toByteArray();
    }

    protected void writeSoapBody(Writer writer) throws IOException {
        this.startChanges(writer);
        this.writeShape(writer);
        this.writeIndexedPageView(writer);
        this.writeRestriction(writer);
        this.writeSortOrder(writer);
        this.writeParentFolderId(writer);
        this.writeToFolderId(writer);
        this.writeItemId(writer);
        this.writeParentItemId(writer);
        this.writeAttachments(writer);
        this.writeAttachmentId(writer);
        this.writeFolderId(writer);
        this.writeSavedItemFolderId(writer);
        this.writeItem(writer);
        this.writeUpdates(writer);
        this.writeUnresolvedEntry(writer);
        this.endChanges(writer);
    }

    protected void writeIndexedPageView(Writer writer) throws IOException {
        if (this.maxCount > 0) {
            writer.write("<m:IndexedPage" + this.itemType + "View MaxEntriesReturned=\"");
            writer.write(String.valueOf(this.maxCount));
            writer.write("\" Offset=\"");
            writer.write(String.valueOf(this.offset));
            writer.write("\" BasePoint=\"Beginning\"/>");
        }
    }

    protected void writeAttachmentId(Writer writer) throws IOException {
        if (this.attachmentId != null) {
            if ("CreateAttachment".equals(this.methodName)) {
                writer.write("<m:AttachmentShape>");
                writer.write("<t:IncludeMimeContent>true</t:IncludeMimeContent>");
                writer.write("</m:AttachmentShape>");
            }
            writer.write("<m:AttachmentIds>");
            writer.write("<t:AttachmentId Id=\"");
            writer.write(this.attachmentId);
            writer.write("\"/>");
            writer.write("</m:AttachmentIds>");
        }
    }

    protected void writeAttachments(Writer writer) throws IOException {
        if (this.attachment != null) {
            writer.write("<m:Attachments>");
            this.attachment.write(writer);
            writer.write("</m:Attachments>");
        }
    }

    public String getServerVersion() {
        return this.serverVersion;
    }

    public void setServerVersion(String serverVersion) {
        this.serverVersion = serverVersion;
    }

    public void setTimezoneContext(String timezoneContext) {
        this.timezoneContext = timezoneContext;
    }

    public void checkSuccess() throws EWSException {
        if (!(this.errorDetail == null || "ErrorAccessDenied".equals(this.errorDetail) || "ErrorMailRecipientNotFound".equals(this.errorDetail) || "ErrorItemNotFound".equals(this.errorDetail))) {
            try {
                throw new EWSException(this.errorDetail + ' ' + (this.errorDescription != null ? this.errorDescription : "") + "\n request: " + new String(this.generateSoapEnvelope(), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new EWSException(e.getMessage());
            }
        }
        if (this.getStatusCode() == 400 || this.getStatusCode() == 507) {
            throw new EWSException(this.getStatusText());
        }
    }

    public int getStatusCode() {
        if ("ErrorAccessDenied".equals(this.errorDetail)) {
            return 403;
        }
        if ("ErrorItemNotFound".equals(this.errorDetail)) {
            return 404;
        }
        return super.getStatusCode();
    }

    public List<Item> getResponseItems() throws EWSException {
        this.checkSuccess();
        if (this.responseItems != null) {
            return this.responseItems;
        }
        return new ArrayList<Item>();
    }

    public Item getResponseItem() throws EWSException {
        this.checkSuccess();
        if (this.responseItems != null && this.responseItems.size() > 0) {
            return this.responseItems.get(0);
        }
        return null;
    }

    public byte[] getMimeContent() throws EWSException {
        this.checkSuccess();
        Item responseItem = this.getResponseItem();
        if (responseItem != null) {
            return responseItem.mimeContent;
        }
        return null;
    }

    protected String handleTag(XMLStreamReader reader, String localName) throws XMLStreamException {
        String result = null;
        int event = reader.getEventType();
        if (event == 1 && localName.equals(reader.getLocalName())) {
            while (reader.hasNext() && (event != 2 || !localName.equals(reader.getLocalName()))) {
                event = reader.next();
                if (event != 4) continue;
                result = reader.getText();
            }
        }
        return result;
    }

    protected void handleErrors(XMLStreamReader reader) throws XMLStreamException {
        String result = this.handleTag(reader, "ResponseCode");
        String messageText = this.handleTag(reader, "MessageText");
        if (messageText != null) {
            this.errorDescription = messageText;
        }
        if (!(this.errorDetail != null || result == null || "NoError".equals(result) || "ErrorNameResolutionMultipleResults".equals(result) || "ErrorNameResolutionNoResults".equals(result) || "ErrorFolderExists".equals(result))) {
            this.errorDetail = result;
        }
        if (XMLStreamUtil.isStartTag(reader, "faultstring")) {
            this.errorDetail = XMLStreamUtil.getElementText(reader);
        }
    }

    protected Item handleItem(XMLStreamReader reader) throws XMLStreamException {
        Item responseItem = new Item();
        responseItem.type = reader.getLocalName();
        while (reader.hasNext() && !XMLStreamUtil.isEndTag(reader, responseItem.type)) {
            reader.next();
            if (!XMLStreamUtil.isStartTag(reader)) continue;
            String tagLocalName = reader.getLocalName();
            String value = null;
            if ("ExtendedProperty".equals(tagLocalName)) {
                this.addExtendedPropertyValue(reader, responseItem);
                continue;
            }
            if (tagLocalName.endsWith("MimeContent")) {
                this.handleMimeContent(reader, responseItem);
                continue;
            }
            if ("Attachments".equals(tagLocalName)) {
                responseItem.attachments = this.handleAttachments(reader);
                continue;
            }
            if ("EmailAddresses".equals(tagLocalName)) {
                this.handleEmailAddresses(reader, responseItem);
                continue;
            }
            if ("RequiredAttendees".equals(tagLocalName) || "OptionalAttendees".equals(tagLocalName)) {
                this.handleAttendees(reader, responseItem, tagLocalName);
                continue;
            }
            if ("ModifiedOccurrences".equals(tagLocalName)) {
                this.handleModifiedOccurrences(reader, responseItem);
                continue;
            }
            if (tagLocalName.endsWith("Id")) {
                value = this.getAttributeValue(reader, "Id");
                responseItem.put("ChangeKey", this.getAttributeValue(reader, "ChangeKey"));
            }
            if (value == null) {
                value = this.getTagContent(reader);
            }
            if (value == null) continue;
            responseItem.put(tagLocalName, value);
        }
        return responseItem;
    }

    protected void handleEmailAddresses(XMLStreamReader reader, Item item) throws XMLStreamException {
        while (reader.hasNext() && !XMLStreamUtil.isEndTag(reader, "EmailAddresses")) {
            String tagLocalName;
            reader.next();
            if (!XMLStreamUtil.isStartTag(reader) || !"Entry".equals(tagLocalName = reader.getLocalName())) continue;
            item.put(reader.getAttributeValue(null, "Key"), XMLStreamUtil.getElementText(reader));
        }
    }

    protected void handleAttendees(XMLStreamReader reader, Item item, String attendeeType) throws XMLStreamException {
        while (reader.hasNext() && !XMLStreamUtil.isEndTag(reader, attendeeType)) {
            String tagLocalName;
            reader.next();
            if (!XMLStreamUtil.isStartTag(reader) || !"Attendee".equals(tagLocalName = reader.getLocalName())) continue;
            this.handleAttendee(reader, item, attendeeType);
        }
    }

    protected void handleModifiedOccurrences(XMLStreamReader reader, Item item) throws XMLStreamException {
        while (reader.hasNext() && !XMLStreamUtil.isEndTag(reader, "ModifiedOccurrences")) {
            String tagLocalName;
            reader.next();
            if (!XMLStreamUtil.isStartTag(reader) || !"Occurrence".equals(tagLocalName = reader.getLocalName())) continue;
            this.handleOccurrence(reader, item);
        }
    }

    protected void handleOccurrence(XMLStreamReader reader, Item item) throws XMLStreamException {
        Occurrence occurrence = new Occurrence();
        while (reader.hasNext() && !XMLStreamUtil.isEndTag(reader, "Occurrence")) {
            reader.next();
            if (!XMLStreamUtil.isStartTag(reader)) continue;
            String tagLocalName = reader.getLocalName();
            if ("ItemId".equals(tagLocalName)) {
                occurrence.itemId = new ItemId("ItemId", this.getAttributeValue(reader, "Id"), this.getAttributeValue(reader, "ChangeKey"));
            }
            if (!"OriginalStart".equals(tagLocalName)) continue;
            occurrence.originalStart = XMLStreamUtil.getElementText(reader);
        }
        item.addOccurrence(occurrence);
    }

    public static String responseTypeToPartstat(String responseType) {
        if ("Accept".equals(responseType) || "Organizer".equals(responseType)) {
            return "ACCEPTED";
        }
        if ("Tentative".equals(responseType)) {
            return "TENTATIVE";
        }
        if ("Decline".equals(responseType)) {
            return "DECLINED";
        }
        return "NEEDS-ACTION";
    }

    protected void handleAttendee(XMLStreamReader reader, Item item, String attendeeType) throws XMLStreamException {
        Attendee attendee = new Attendee();
        attendee.role = "RequiredAttendees".equals(attendeeType) ? "REQ-PARTICIPANT" : "OPT-PARTICIPANT";
        while (reader.hasNext() && !XMLStreamUtil.isEndTag(reader, "Attendee")) {
            reader.next();
            if (!XMLStreamUtil.isStartTag(reader)) continue;
            String tagLocalName = reader.getLocalName();
            if ("EmailAddress".equals(tagLocalName)) {
                attendee.email = reader.getElementText();
                continue;
            }
            if ("Name".equals(tagLocalName)) {
                attendee.name = XMLStreamUtil.getElementText(reader);
                continue;
            }
            if (!"ResponseType".equals(tagLocalName)) continue;
            String responseType = XMLStreamUtil.getElementText(reader);
            attendee.partstat = EWSMethod.responseTypeToPartstat(responseType);
        }
        item.addAttendee(attendee);
    }

    protected List<FileAttachment> handleAttachments(XMLStreamReader reader) throws XMLStreamException {
        ArrayList<FileAttachment> attachments = new ArrayList<FileAttachment>();
        while (reader.hasNext() && !XMLStreamUtil.isEndTag(reader, "Attachments")) {
            String tagLocalName;
            reader.next();
            if (!XMLStreamUtil.isStartTag(reader) || !"FileAttachment".equals(tagLocalName = reader.getLocalName())) continue;
            attachments.add(this.handleFileAttachment(reader));
        }
        return attachments;
    }

    protected FileAttachment handleFileAttachment(XMLStreamReader reader) throws XMLStreamException {
        FileAttachment fileAttachment = new FileAttachment();
        while (reader.hasNext() && !XMLStreamUtil.isEndTag(reader, "FileAttachment")) {
            reader.next();
            if (!XMLStreamUtil.isStartTag(reader)) continue;
            String tagLocalName = reader.getLocalName();
            if ("AttachmentId".equals(tagLocalName)) {
                fileAttachment.attachmentId = this.getAttributeValue(reader, "Id");
                continue;
            }
            if ("Name".equals(tagLocalName)) {
                fileAttachment.name = this.getTagContent(reader);
                continue;
            }
            if (!"ContentType".equals(tagLocalName)) continue;
            fileAttachment.contentType = this.getTagContent(reader);
        }
        return fileAttachment;
    }

    protected void handleMimeContent(XMLStreamReader reader, Item responseItem) throws XMLStreamException {
        if (reader instanceof TypedXMLStreamReader) {
            responseItem.mimeContent = ((TypedXMLStreamReader)reader).getElementAsBinary();
        } else {
            try {
                responseItem.mimeContent = Base64.decodeBase64(reader.getElementText().getBytes("ASCII"));
            }
            catch (UnsupportedEncodingException e) {
                throw new XMLStreamException(e);
            }
        }
    }

    protected void addExtendedPropertyValue(XMLStreamReader reader, Item item) throws XMLStreamException {
        String propertyTag = null;
        String propertyValue = null;
        while (reader.hasNext() && !XMLStreamUtil.isEndTag(reader, "ExtendedProperty")) {
            reader.next();
            if (!XMLStreamUtil.isStartTag(reader)) continue;
            String tagLocalName = reader.getLocalName();
            if ("ExtendedFieldURI".equals(tagLocalName)) {
                propertyTag = this.getAttributeValue(reader, "PropertyTag");
                if (propertyTag == null) {
                    propertyTag = this.getAttributeValue(reader, "PropertyId");
                }
                if (propertyTag != null) continue;
                propertyTag = this.getAttributeValue(reader, "PropertyName");
                continue;
            }
            if ("Value".equals(tagLocalName)) {
                propertyValue = XMLStreamUtil.getElementText(reader);
                continue;
            }
            if (!"Values".equals(tagLocalName)) continue;
            StringBuilder buffer = new StringBuilder();
            while (reader.hasNext() && !XMLStreamUtil.isEndTag(reader, "Values")) {
                String singleValue;
                reader.next();
                if (!XMLStreamUtil.isStartTag(reader)) continue;
                if (buffer.length() > 0) {
                    buffer.append(',');
                }
                if ((singleValue = XMLStreamUtil.getElementText(reader)) == null) continue;
                buffer.append(singleValue);
            }
            propertyValue = buffer.toString();
        }
        if (propertyTag != null && propertyValue != null) {
            item.put(propertyTag, propertyValue);
        }
    }

    protected String getTagContent(XMLStreamReader reader) throws XMLStreamException {
        String tagLocalName = reader.getLocalName();
        while (reader.hasNext() && reader.getEventType() != 2) {
            reader.next();
            if (reader.getEventType() != 4) continue;
            return reader.getText();
        }
        if (reader.hasNext()) {
            return null;
        }
        throw new XMLStreamException("End element for " + tagLocalName + " not found");
    }

    protected String getAttributeValue(XMLStreamReader reader, String attributeName) {
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            if (!attributeName.equals(reader.getAttributeLocalName(i))) continue;
            return reader.getAttributeValue(i);
        }
        return null;
    }

    protected void processResponseBody(HttpState httpState, HttpConnection httpConnection) {
        Header contentTypeHeader = this.getResponseHeader("Content-Type");
        if (contentTypeHeader != null && "text/xml; charset=utf-8".equals(contentTypeHeader.getValue())) {
            try {
                if (DavGatewayHttpClientFacade.isGzipEncoded((HttpMethod)this)) {
                    this.processResponseStream(new GZIPInputStream(this.getResponseBodyAsStream()));
                } else {
                    this.processResponseStream(this.getResponseBodyAsStream());
                }
            }
            catch (IOException e) {
                LOGGER.error((Object)("Error while parsing soap response: " + e), (Throwable)e);
            }
        }
    }

    protected void processResponseStream(InputStream inputStream) {
        block13: {
            this.responseItems = new ArrayList<Item>();
            XMLStreamReader reader = null;
            try {
                inputStream = new FilterInputStream(inputStream){
                    int totalCount;
                    int lastLogCount;

                    @Override
                    public int read(byte[] buffer, int offset, int length) throws IOException {
                        int count = super.read(buffer, offset, length);
                        this.totalCount += count;
                        if (this.totalCount - this.lastLogCount > 131072) {
                            DavGatewayTray.debug(new BundleMessage("LOG_DOWNLOAD_PROGRESS", String.valueOf(this.totalCount / 1024), EWSMethod.this.getURI()));
                            DavGatewayTray.switchIcon();
                            this.lastLogCount = this.totalCount;
                        }
                        return count;
                    }
                };
                reader = XMLStreamUtil.createXMLStreamReader(inputStream);
                while (reader.hasNext()) {
                    reader.next();
                    this.handleErrors(reader);
                    if (this.serverVersion == null && XMLStreamUtil.isStartTag(reader, "ServerVersionInfo")) {
                        String majorVersion = this.getAttributeValue(reader, "MajorVersion");
                        String minorVersion = this.getAttributeValue(reader, "MinorVersion");
                        if ("15".equals(majorVersion)) {
                            if ("0".equals(minorVersion)) {
                                this.serverVersion = "Exchange2013";
                                continue;
                            }
                            this.serverVersion = "Exchange2013_SP1";
                            continue;
                        }
                        if ("14".equals(majorVersion)) {
                            if ("0".equals(minorVersion)) {
                                this.serverVersion = "Exchange2010";
                                continue;
                            }
                            this.serverVersion = "Exchange2010_SP1";
                            continue;
                        }
                        this.serverVersion = "Exchange2007_SP1";
                        continue;
                    }
                    if (XMLStreamUtil.isStartTag(reader, "RootFolder")) {
                        this.includesLastItemInRange = "true".equals(reader.getAttributeValue(null, "IncludesLastItemInRange"));
                        continue;
                    }
                    if (XMLStreamUtil.isStartTag(reader, this.responseCollectionName)) {
                        this.handleItems(reader);
                        continue;
                    }
                    this.handleCustom(reader);
                }
            }
            catch (XMLStreamException e) {
                LOGGER.error((Object)("Error while parsing soap response: " + e), (Throwable)e);
                if (reader == null) break block13;
                try {
                    LOGGER.error((Object)("Current text: " + reader.getText()));
                }
                catch (IllegalStateException ise) {
                    LOGGER.error((Object)(e + " " + e.getMessage()));
                }
            }
        }
        if (this.errorDetail != null) {
            LOGGER.debug((Object)this.errorDetail);
        }
    }

    protected void handleCustom(XMLStreamReader reader) throws XMLStreamException {
    }

    private void handleItems(XMLStreamReader reader) throws XMLStreamException {
        while (reader.hasNext() && !XMLStreamUtil.isEndTag(reader, this.responseCollectionName)) {
            reader.next();
            if (!XMLStreamUtil.isStartTag(reader)) continue;
            this.responseItems.add(this.handleItem(reader));
        }
    }

    public static class Item
    extends HashMap<String, String> {
        public String type;
        protected byte[] mimeContent;
        protected List<FieldUpdate> fieldUpdates;
        protected List<FileAttachment> attachments;
        protected List<Attendee> attendees;
        protected final List<String> fieldNames = new ArrayList<String>();
        protected List<Occurrence> occurrences;
        protected ItemId referenceItemId;

        @Override
        public String toString() {
            return "type: " + this.type + ' ' + super.toString();
        }

        @Override
        public String put(String key, String value) {
            if (value != null) {
                if (this.get(key) == null) {
                    this.fieldNames.add(key);
                }
                return super.put(key, value);
            }
            return null;
        }

        public void write(Writer writer) throws IOException {
            writer.write("<t:");
            writer.write(this.type);
            writer.write(">");
            if (this.mimeContent != null) {
                writer.write("<t:MimeContent>");
                for (byte c : this.mimeContent) {
                    writer.write(c);
                }
                writer.write("</t:MimeContent>");
            }
            if (this.referenceItemId != null) {
                this.referenceItemId.write(writer);
            }
            Object object = this.fieldNames.iterator();
            while (object.hasNext()) {
                String key = (String)object.next();
                if ("MeetingTimeZone".equals(key)) {
                    writer.write("<t:MeetingTimeZone TimeZoneName=\"");
                    writer.write(StringUtil.xmlEncodeAttribute((String)this.get(key)));
                    writer.write("\"></t:MeetingTimeZone>");
                    continue;
                }
                if ("StartTimeZone".equals(key)) {
                    writer.write("<t:StartTimeZone Id=\"");
                    writer.write(StringUtil.xmlEncodeAttribute((String)this.get(key)));
                    writer.write("\"></t:StartTimeZone>");
                    continue;
                }
                writer.write("<t:");
                writer.write(key);
                writer.write(">");
                writer.write(StringUtil.xmlEncode((String)this.get(key)));
                writer.write("</t:");
                writer.write(key);
                writer.write(">");
            }
            if (this.fieldUpdates != null) {
                for (FieldUpdate fieldUpdate : this.fieldUpdates) {
                    fieldUpdate.write(null, writer);
                }
            }
            writer.write("</t:");
            writer.write(this.type);
            writer.write(">");
        }

        public void setFieldUpdates(List<FieldUpdate> fieldUpdates) {
            this.fieldUpdates = fieldUpdates;
        }

        public int getInt(String key) {
            int result = 0;
            String value = (String)this.get(key);
            if (value != null && value.length() > 0) {
                result = Integer.parseInt(value);
            }
            return result;
        }

        public long getLong(String key) {
            long result = 0L;
            String value = (String)this.get(key);
            if (value != null && value.length() > 0) {
                result = Long.parseLong(value);
            }
            return result;
        }

        public boolean getBoolean(String key) {
            boolean result = false;
            String value = (String)this.get(key);
            if (value != null && value.length() > 0) {
                result = Boolean.parseBoolean(value);
            }
            return result;
        }

        public FileAttachment getAttachmentByName(String attachmentName) {
            FileAttachment result = null;
            if (this.attachments != null) {
                for (FileAttachment fileAttachment : this.attachments) {
                    if (!attachmentName.equals(fileAttachment.name)) continue;
                    result = fileAttachment;
                    break;
                }
            }
            return result;
        }

        public List<Attendee> getAttendees() {
            return this.attendees;
        }

        public void addAttendee(Attendee attendee) {
            if (this.attendees == null) {
                this.attendees = new ArrayList<Attendee>();
            }
            this.attendees.add(attendee);
        }

        public void addOccurrence(Occurrence occurrence) {
            if (this.occurrences == null) {
                this.occurrences = new ArrayList<Occurrence>();
            }
            this.occurrences.add(occurrence);
        }

        public List<Occurrence> getOccurrences() {
            return this.occurrences;
        }
    }

    public static class Occurrence {
        public String originalStart;
        public ItemId itemId;
    }

    public static class Attendee {
        public String role;
        public String email;
        public String partstat;
        public String name;
    }
}

