/*
 * Decompiled with CFR 0.152.
 */
package davmail.exchange.dav;

import davmail.Settings;
import davmail.exchange.dav.PropertyType;
import davmail.exchange.dav.PropertyValue;
import davmail.util.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DefaultDavProperty;
import org.apache.jackrabbit.webdav.property.PropEntry;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.apache.jackrabbit.webdav.xml.XmlSerializable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Field {
    protected static final Map<DistinguishedPropertySetType, String> distinguishedPropertySetMap = new HashMap<DistinguishedPropertySetType, String>();
    protected static final Namespace EMPTY;
    protected static final Namespace XML;
    protected static final Namespace DAV;
    protected static final Namespace URN_SCHEMAS_HTTPMAIL;
    protected static final Namespace URN_SCHEMAS_MAILHEADER;
    protected static final Namespace SCHEMAS_EXCHANGE;
    protected static final Namespace SCHEMAS_MAPI;
    protected static final Namespace SCHEMAS_MAPI_PROPTAG;
    protected static final Namespace SCHEMAS_MAPI_ID;
    protected static final Namespace SCHEMAS_MAPI_STRING;
    protected static final Namespace SCHEMAS_REPL;
    protected static final Namespace URN_SCHEMAS_CONTACTS;
    protected static final Namespace URN_SCHEMAS_CALENDAR;
    protected static final Namespace SCHEMAS_MAPI_STRING_INTERNET_HEADERS;
    protected static final Map<PropertyType, String> propertyTypeMap;
    protected static final Map<String, Field> fieldMap;
    private final DavPropertyName davPropertyName;
    protected final String alias;
    protected final String uri;
    protected final String requestPropertyString;
    protected final DavPropertyName responsePropertyName;
    protected final DavPropertyName updatePropertyName;
    protected final String cast;
    protected final boolean isIntValue;
    protected final boolean isMultivalued;
    protected final boolean isBooleanValue;
    protected final boolean isFloatValue;
    protected final boolean isDateValue;

    protected static String toHexString(int propertyTag) {
        StringBuilder hexValue = new StringBuilder(Integer.toHexString(propertyTag));
        while (hexValue.length() < 4) {
            hexValue.insert(0, '0');
        }
        return hexValue.toString();
    }

    protected static void createField(String alias, int propertyTag, PropertyType propertyType) {
        String name = 'x' + Field.toHexString(propertyTag) + propertyTypeMap.get((Object)propertyType);
        Field field = propertyType == PropertyType.Binary ? new Field(alias, SCHEMAS_MAPI_PROPTAG, name, propertyType, null, "bin.base64", name) : new Field(alias, SCHEMAS_MAPI_PROPTAG, name, propertyType);
        fieldMap.put(field.alias, field);
    }

    protected static void createField(String alias, DistinguishedPropertySetType propertySetType) {
        Field field = new Field(Namespace.getNamespace((String)(SCHEMAS_MAPI_STRING.getURI() + '{' + distinguishedPropertySetMap.get((Object)propertySetType) + "}/")), alias);
        fieldMap.put(field.alias, field);
    }

    protected static void createField(String alias, DistinguishedPropertySetType propertySetType, int propertyTag, String responseAlias) {
        Field.createField(alias, propertySetType, propertyTag, responseAlias, null);
    }

    protected static void createField(String alias, DistinguishedPropertySetType propertySetType, int propertyTag, String responseAlias, PropertyType propertyType) {
        String updateAlias;
        String name;
        if (propertySetType == DistinguishedPropertySetType.Address) {
            name = String.valueOf(propertyTag);
            updateAlias = "_x0030_x" + Field.toHexString(propertyTag);
        } else if (propertySetType == DistinguishedPropertySetType.Task) {
            name = "0x" + Field.toHexString(propertyTag);
            updateAlias = "0x0000" + Field.toHexString(propertyTag);
        } else {
            name = "0x" + Field.toHexString(propertyTag);
            updateAlias = "_x0030_x" + Field.toHexString(propertyTag);
        }
        Field field = new Field(alias, Namespace.getNamespace((String)(SCHEMAS_MAPI_ID.getURI() + '{' + distinguishedPropertySetMap.get((Object)propertySetType) + "}/")), name, propertyType, responseAlias, null, updateAlias);
        fieldMap.put(field.alias, field);
    }

    protected static void createField(Namespace namespace, String name) {
        Field field = new Field(namespace, name);
        fieldMap.put(field.alias, field);
    }

    protected static void createField(String alias, Namespace namespace, String name) {
        Field field = new Field(alias, namespace, name, null);
        fieldMap.put(field.alias, field);
    }

    protected static void createField(String alias, Namespace namespace, String name, PropertyType propertyType) {
        Field field = new Field(alias, namespace, name, propertyType);
        fieldMap.put(field.alias, field);
    }

    protected Field(Namespace namespace, String name) {
        this(name, namespace, name, null);
    }

    protected Field(String alias, Namespace namespace, String name, PropertyType propertyType) {
        this(alias, namespace, name, propertyType, null, null, name);
    }

    protected Field(String alias, Namespace namespace, String name, PropertyType propertyType, String responseAlias, String cast, String updateAlias) {
        this.alias = alias;
        this.davPropertyName = DavPropertyName.create((String)name, (Namespace)namespace);
        this.updatePropertyName = DavPropertyName.create((String)updateAlias, (Namespace)namespace);
        this.isMultivalued = propertyType != null && propertyType.toString().endsWith("Array");
        this.isIntValue = propertyType == PropertyType.Long || propertyType == PropertyType.Integer || propertyType == PropertyType.Short;
        this.isBooleanValue = propertyType == PropertyType.Boolean;
        this.isFloatValue = propertyType == PropertyType.Float || propertyType == PropertyType.Double;
        this.isDateValue = propertyType == PropertyType.SystemTime;
        this.uri = namespace.getURI() + name;
        if (responseAlias == null) {
            this.requestPropertyString = '\"' + this.uri + '\"';
            this.responsePropertyName = this.davPropertyName;
        } else {
            this.requestPropertyString = '\"' + this.uri + "\" as " + responseAlias;
            this.responsePropertyName = DavPropertyName.create((String)responseAlias, (Namespace)EMPTY);
        }
        this.cast = cast;
    }

    public String getUri() {
        return this.uri;
    }

    public boolean isIntValue() {
        return this.isIntValue;
    }

    public static Field get(String alias) {
        Field field = fieldMap.get(alias);
        if (field == null) {
            throw new IllegalArgumentException("Unknown field: " + alias);
        }
        return field;
    }

    public static Field getHeader(String headerName) {
        return new Field(SCHEMAS_MAPI_STRING_INTERNET_HEADERS, headerName);
    }

    public static PropEntry createDavProperty(String alias, String value) {
        Field field = Field.get(alias);
        if (value == null) {
            return field.updatePropertyName;
        }
        if (field.isMultivalued) {
            String[] values;
            ArrayList<1> valueList = new ArrayList<1>();
            for (final String singleValue : values = value.split(",")) {
                valueList.add(new XmlSerializable(){

                    public Element toXml(Document document) {
                        return DomUtil.createElement((Document)document, (String)"v", (Namespace)XML, (String)singleValue);
                    }
                });
            }
            return new DefaultDavProperty(field.updatePropertyName, valueList);
        }
        if (field.isBooleanValue && !"haspicture".equals(alias)) {
            if ("true".equals(value)) {
                return new DefaultDavProperty(field.updatePropertyName, (Object)"1");
            }
            if ("false".equals(value)) {
                return new DefaultDavProperty(field.updatePropertyName, (Object)"0");
            }
            throw new RuntimeException("Invalid value for " + field.alias + ": " + value);
        }
        return new DefaultDavProperty(field.updatePropertyName, (Object)value);
    }

    public static PropertyValue createPropertyValue(String alias, String value) {
        Field field = Field.get(alias);
        DavPropertyName davPropertyName = field.davPropertyName;
        if (value == null) {
            return new PropertyValue(davPropertyName.getNamespace().getURI(), davPropertyName.getName());
        }
        if (field.isMultivalued) {
            String[] values;
            StringBuilder buffer = new StringBuilder();
            for (String singleValue : values = value.split("\n")) {
                buffer.append("<v>");
                buffer.append(StringUtil.xmlEncode(singleValue));
                buffer.append("</v>");
            }
            return new PropertyValue(davPropertyName.getNamespace().getURI(), davPropertyName.getName(), buffer.toString());
        }
        if (field.isBooleanValue) {
            if ("true".equals(value)) {
                return new PropertyValue(davPropertyName.getNamespace().getURI(), davPropertyName.getName(), "1", "boolean");
            }
            if ("false".equals(value)) {
                return new PropertyValue(davPropertyName.getNamespace().getURI(), davPropertyName.getName(), "0", "boolean");
            }
            throw new RuntimeException("Invalid value for " + field.alias + ": " + value);
        }
        if (field.isFloatValue) {
            return new PropertyValue(davPropertyName.getNamespace().getURI(), davPropertyName.getName(), StringUtil.xmlEncode(value), "float");
        }
        if (field.isIntValue) {
            return new PropertyValue(field.updatePropertyName.getNamespace().getURI(), field.updatePropertyName.getName(), StringUtil.xmlEncode(value), "int");
        }
        if (field.isDateValue) {
            return new PropertyValue(field.updatePropertyName.getNamespace().getURI(), field.updatePropertyName.getName(), StringUtil.xmlEncode(value), "dateTime.tz");
        }
        return new PropertyValue(davPropertyName.getNamespace().getURI(), davPropertyName.getName(), StringUtil.xmlEncode(value));
    }

    public static String getRequestPropertyString(String alias) {
        return Field.get((String)alias).requestPropertyString;
    }

    public static DavPropertyName getPropertyName(String alias) {
        return Field.get((String)alias).davPropertyName;
    }

    public static DavPropertyName getResponsePropertyName(String alias) {
        return Field.get((String)alias).responsePropertyName;
    }

    static {
        distinguishedPropertySetMap.put(DistinguishedPropertySetType.Meeting, "6ed8da90-450b-101b-98da-00aa003f1305");
        distinguishedPropertySetMap.put(DistinguishedPropertySetType.Appointment, "00062002-0000-0000-c000-000000000046");
        distinguishedPropertySetMap.put(DistinguishedPropertySetType.Common, "00062008-0000-0000-c000-000000000046");
        distinguishedPropertySetMap.put(DistinguishedPropertySetType.PublicStrings, "00020329-0000-0000-c000-000000000046");
        distinguishedPropertySetMap.put(DistinguishedPropertySetType.Address, "00062004-0000-0000-c000-000000000046");
        distinguishedPropertySetMap.put(DistinguishedPropertySetType.InternetHeaders, "00020386-0000-0000-c000-000000000046");
        distinguishedPropertySetMap.put(DistinguishedPropertySetType.UnifiedMessaging, "4442858e-a9e3-4e80-b900-317a210cc15b");
        distinguishedPropertySetMap.put(DistinguishedPropertySetType.Task, "00062003-0000-0000-c000-000000000046");
        EMPTY = Namespace.getNamespace((String)"");
        XML = Namespace.getNamespace((String)"xml:");
        DAV = Namespace.getNamespace((String)"DAV:");
        URN_SCHEMAS_HTTPMAIL = Namespace.getNamespace((String)"urn:schemas:httpmail:");
        URN_SCHEMAS_MAILHEADER = Namespace.getNamespace((String)"urn:schemas:mailheader:");
        SCHEMAS_EXCHANGE = Namespace.getNamespace((String)"http://schemas.microsoft.com/exchange/");
        SCHEMAS_MAPI = Namespace.getNamespace((String)"http://schemas.microsoft.com/mapi/");
        SCHEMAS_MAPI_PROPTAG = Namespace.getNamespace((String)"http://schemas.microsoft.com/mapi/proptag/");
        SCHEMAS_MAPI_ID = Namespace.getNamespace((String)"http://schemas.microsoft.com/mapi/id/");
        SCHEMAS_MAPI_STRING = Namespace.getNamespace((String)"http://schemas.microsoft.com/mapi/string/");
        SCHEMAS_REPL = Namespace.getNamespace((String)"http://schemas.microsoft.com/repl/");
        URN_SCHEMAS_CONTACTS = Namespace.getNamespace((String)"urn:schemas:contacts:");
        URN_SCHEMAS_CALENDAR = Namespace.getNamespace((String)"urn:schemas:calendar:");
        SCHEMAS_MAPI_STRING_INTERNET_HEADERS = Namespace.getNamespace((String)(SCHEMAS_MAPI_STRING.getURI() + '{' + distinguishedPropertySetMap.get((Object)DistinguishedPropertySetType.InternetHeaders) + "}/"));
        propertyTypeMap = new HashMap<PropertyType, String>();
        propertyTypeMap.put(PropertyType.Integer, "0003");
        propertyTypeMap.put(PropertyType.Boolean, "000b");
        propertyTypeMap.put(PropertyType.SystemTime, "0040");
        propertyTypeMap.put(PropertyType.String, "001f");
        propertyTypeMap.put(PropertyType.Binary, "0102");
        propertyTypeMap.put(PropertyType.Double, "0005");
        fieldMap = new HashMap<String, Field>();
        Field.createField(URN_SCHEMAS_HTTPMAIL, "inbox");
        Field.createField(URN_SCHEMAS_HTTPMAIL, "deleteditems");
        Field.createField(URN_SCHEMAS_HTTPMAIL, "sentitems");
        Field.createField(URN_SCHEMAS_HTTPMAIL, "sendmsg");
        Field.createField(URN_SCHEMAS_HTTPMAIL, "drafts");
        Field.createField(URN_SCHEMAS_HTTPMAIL, "calendar");
        Field.createField(URN_SCHEMAS_HTTPMAIL, "tasks");
        Field.createField(URN_SCHEMAS_HTTPMAIL, "contacts");
        Field.createField(URN_SCHEMAS_HTTPMAIL, "outbox");
        Field.createField("folderclass", SCHEMAS_EXCHANGE, "outlookfolderclass");
        Field.createField(DAV, "hassubs");
        Field.createField(DAV, "nosubs");
        Field.createField("count", DAV, "objectcount");
        Field.createField(URN_SCHEMAS_HTTPMAIL, "unreadcount");
        Field.createField(SCHEMAS_REPL, "contenttag");
        Field.createField("uidNext", 26449, PropertyType.Integer);
        Field.createField("highestUid", 26450, PropertyType.Integer);
        Field.createField(DAV, "isfolder");
        Field.createField(DAV, "uid");
        Field.createField("messageSize", 3592, PropertyType.Integer);
        Field.createField("imapUid", 3619, PropertyType.Integer);
        Field.createField("junk", 4227, PropertyType.Integer);
        Field.createField("flagStatus", 4240, PropertyType.Integer);
        Field.createField("messageFlags", 3591, PropertyType.Integer);
        Field.createField("lastVerbExecuted", 4225, PropertyType.Integer);
        Field.createField("iconIndex", 4224, PropertyType.Integer);
        Field.createField(URN_SCHEMAS_HTTPMAIL, "read");
        if (Settings.getBooleanProperty("davmail.popCommonDeleted", true)) {
            Field.createField("deleted", DistinguishedPropertySetType.Common, 34160, "deleted", PropertyType.String);
        } else {
            Field.createField("deleted", DistinguishedPropertySetType.PublicStrings);
        }
        Field.createField("date", 3590, PropertyType.SystemTime);
        Field.createField(URN_SCHEMAS_MAILHEADER, "bcc");
        Field.createField(URN_SCHEMAS_HTTPMAIL, "datereceived");
        Field.createField("messageFormat", 22793, PropertyType.Integer);
        Field.createField("mailOverrideFormat", 22786, PropertyType.Integer);
        Field.createField(URN_SCHEMAS_HTTPMAIL, "subject");
        Field.createField("body", 4096, PropertyType.String);
        Field.createField("messageheaders", 125, PropertyType.String);
        Field.createField(URN_SCHEMAS_HTTPMAIL, "from");
        Field.createField(URN_SCHEMAS_MAILHEADER, "to");
        Field.createField(URN_SCHEMAS_MAILHEADER, "cc");
        Field.createField(URN_SCHEMAS_MAILHEADER, "message-id");
        Field.createField(URN_SCHEMAS_MAILHEADER, "htmldescription");
        Field.createField("lastmodified", DAV, "getlastmodified");
        Field.createField(DAV, "displayname");
        Field.createField("urlcompname", 4339, PropertyType.String);
        Field.createField("etag", DAV, "getetag");
        Field.createField(SCHEMAS_EXCHANGE, "permanenturl");
        Field.createField(URN_SCHEMAS_CALENDAR, "instancetype");
        Field.createField(URN_SCHEMAS_CALENDAR, "dtstart");
        Field.createField(URN_SCHEMAS_CALENDAR, "dtend");
        Field.createField("calendarversion", URN_SCHEMAS_CALENDAR, "version");
        Field.createField(URN_SCHEMAS_CALENDAR, "method");
        Field.createField("calendarlastmodified", URN_SCHEMAS_CALENDAR, "lastmodified");
        Field.createField(URN_SCHEMAS_CALENDAR, "dtstamp");
        Field.createField("calendaruid", URN_SCHEMAS_CALENDAR, "uid");
        Field.createField(URN_SCHEMAS_CALENDAR, "transparent");
        Field.createField(URN_SCHEMAS_CALENDAR, "organizer");
        Field.createField(URN_SCHEMAS_CALENDAR, "created");
        Field.createField(URN_SCHEMAS_CALENDAR, "alldayevent");
        Field.createField(URN_SCHEMAS_CALENDAR, "rrule");
        Field.createField(URN_SCHEMAS_CALENDAR, "exdate");
        Field.createField(SCHEMAS_MAPI, "reminderset");
        Field.createField(SCHEMAS_MAPI, "reminderdelta");
        Field.createField(SCHEMAS_MAPI, "allattendeesstring");
        Field.createField(SCHEMAS_MAPI, "required_attendees");
        Field.createField(SCHEMAS_MAPI, "apptendtime");
        Field.createField(SCHEMAS_MAPI, "apptstateflags");
        Field.createField(URN_SCHEMAS_CALENDAR, "isorganizer");
        Field.createField(URN_SCHEMAS_CALENDAR, "location");
        Field.createField(URN_SCHEMAS_CALENDAR, "attendeerole");
        Field.createField(URN_SCHEMAS_CALENDAR, "busystatus");
        Field.createField(URN_SCHEMAS_CALENDAR, "exrule");
        Field.createField(URN_SCHEMAS_CALENDAR, "recurrenceidrange");
        Field.createField(URN_SCHEMAS_CALENDAR, "rdate");
        Field.createField(URN_SCHEMAS_CALENDAR, "reminderoffset");
        Field.createField(URN_SCHEMAS_CALENDAR, "timezone");
        Field.createField(SCHEMAS_EXCHANGE, "sensitivity");
        Field.createField(URN_SCHEMAS_CALENDAR, "timezoneid");
        Field.createField("processed", 26088, PropertyType.Boolean);
        Field.createField(DAV, "contentclass");
        Field.createField("internetContent", 26201, PropertyType.Binary);
        Field.createField(SCHEMAS_EXCHANGE, "outlookmessageclass");
        Field.createField(URN_SCHEMAS_HTTPMAIL, "subject");
        Field.createField(URN_SCHEMAS_CONTACTS, "middlename");
        Field.createField(URN_SCHEMAS_CONTACTS, "fileas");
        Field.createField(URN_SCHEMAS_CONTACTS, "homepostaladdress");
        Field.createField(URN_SCHEMAS_CONTACTS, "otherpostaladdress");
        Field.createField(URN_SCHEMAS_CONTACTS, "mailingaddressid");
        Field.createField(URN_SCHEMAS_CONTACTS, "workaddress");
        Field.createField(URN_SCHEMAS_CONTACTS, "alternaterecipient");
        Field.createField(SCHEMAS_EXCHANGE, "extensionattribute1");
        Field.createField(SCHEMAS_EXCHANGE, "extensionattribute2");
        Field.createField(SCHEMAS_EXCHANGE, "extensionattribute3");
        Field.createField(SCHEMAS_EXCHANGE, "extensionattribute4");
        Field.createField(URN_SCHEMAS_CONTACTS, "bday");
        Field.createField("anniversary", URN_SCHEMAS_CONTACTS, "weddinganniversary");
        Field.createField(URN_SCHEMAS_CONTACTS, "businesshomepage");
        Field.createField(URN_SCHEMAS_CONTACTS, "personalHomePage");
        Field.createField(URN_SCHEMAS_CONTACTS, "cn");
        Field.createField(URN_SCHEMAS_CONTACTS, "co");
        Field.createField(URN_SCHEMAS_CONTACTS, "department");
        Field.createField("smtpemail1", DistinguishedPropertySetType.Address, 32900, "smtpemail1");
        Field.createField("smtpemail2", DistinguishedPropertySetType.Address, 32916, "smtpemail2");
        Field.createField("smtpemail3", DistinguishedPropertySetType.Address, 32932, "smtpemail3");
        Field.createField("email1", DistinguishedPropertySetType.Address, 32899, "email1");
        Field.createField("email2", DistinguishedPropertySetType.Address, 32915, "email2");
        Field.createField("email3", DistinguishedPropertySetType.Address, 32931, "email3");
        Field.createField("email1type", DistinguishedPropertySetType.Address, 32898, "email1type");
        Field.createField("email2type", DistinguishedPropertySetType.Address, 32914, "email2type");
        Field.createField("email3type", DistinguishedPropertySetType.Address, 32930, "email3type");
        Field.createField(URN_SCHEMAS_CONTACTS, "facsimiletelephonenumber");
        Field.createField(URN_SCHEMAS_CONTACTS, "givenName");
        Field.createField(URN_SCHEMAS_CONTACTS, "homepostofficebox");
        Field.createField(URN_SCHEMAS_CONTACTS, "homeCity");
        Field.createField(URN_SCHEMAS_CONTACTS, "homeCountry");
        Field.createField(URN_SCHEMAS_CONTACTS, "homePhone");
        Field.createField(URN_SCHEMAS_CONTACTS, "homePostalCode");
        Field.createField(URN_SCHEMAS_CONTACTS, "homeState");
        Field.createField(URN_SCHEMAS_CONTACTS, "homeStreet");
        Field.createField(URN_SCHEMAS_CONTACTS, "l");
        Field.createField(URN_SCHEMAS_CONTACTS, "manager");
        Field.createField(URN_SCHEMAS_CONTACTS, "mobile");
        Field.createField(URN_SCHEMAS_CONTACTS, "namesuffix");
        Field.createField(URN_SCHEMAS_CONTACTS, "nickname");
        Field.createField(URN_SCHEMAS_CONTACTS, "o");
        Field.createField(URN_SCHEMAS_CONTACTS, "pager");
        Field.createField(URN_SCHEMAS_CONTACTS, "personaltitle");
        Field.createField(URN_SCHEMAS_CONTACTS, "postalcode");
        Field.createField(URN_SCHEMAS_CONTACTS, "postofficebox");
        Field.createField(URN_SCHEMAS_CONTACTS, "profession");
        Field.createField(URN_SCHEMAS_CONTACTS, "roomnumber");
        Field.createField(URN_SCHEMAS_CONTACTS, "secretarycn");
        Field.createField(URN_SCHEMAS_CONTACTS, "sn");
        Field.createField(URN_SCHEMAS_CONTACTS, "spousecn");
        Field.createField(URN_SCHEMAS_CONTACTS, "st");
        Field.createField(URN_SCHEMAS_CONTACTS, "street");
        Field.createField(URN_SCHEMAS_CONTACTS, "telephoneNumber");
        Field.createField(URN_SCHEMAS_CONTACTS, "title");
        Field.createField("description", URN_SCHEMAS_HTTPMAIL, "textdescription");
        Field.createField("im", SCHEMAS_MAPI, "InstMsg");
        Field.createField(URN_SCHEMAS_CONTACTS, "othermobile");
        Field.createField(URN_SCHEMAS_CONTACTS, "internationalisdnnumber");
        Field.createField(URN_SCHEMAS_CONTACTS, "otherTelephone");
        Field.createField(URN_SCHEMAS_CONTACTS, "homefax");
        Field.createField(URN_SCHEMAS_CONTACTS, "otherstreet");
        Field.createField(URN_SCHEMAS_CONTACTS, "otherstate");
        Field.createField(URN_SCHEMAS_CONTACTS, "otherpostofficebox");
        Field.createField(URN_SCHEMAS_CONTACTS, "otherpostalcode");
        Field.createField(URN_SCHEMAS_CONTACTS, "othercountry");
        Field.createField(URN_SCHEMAS_CONTACTS, "othercity");
        Field.createField(URN_SCHEMAS_CONTACTS, "gender");
        Field.createField("keywords", SCHEMAS_EXCHANGE, "keywords-utf8", PropertyType.StringArray);
        Field.createField("private", DistinguishedPropertySetType.Common, 34054, "private", PropertyType.Boolean);
        Field.createField("sensitivity", 54, PropertyType.Integer);
        Field.createField("haspicture", DistinguishedPropertySetType.Address, 32789, "haspicture", PropertyType.Boolean);
        Field.createField(URN_SCHEMAS_CALENDAR, "fburl");
        Field.createField("messageclass", 26, PropertyType.String);
        Field.createField("roamingxmlstream", 31752, PropertyType.Binary);
        Field.createField("roamingdictionary", 31751, PropertyType.Binary);
        Field.createField(DAV, "ishidden");
        Field.createField("attachDataBinary", 14081, PropertyType.Binary);
        Field.createField("attachmentContactPhoto", Short.MAX_VALUE, PropertyType.Boolean);
        Field.createField("renderingPosition", 14091, PropertyType.Integer);
        Field.createField("attachExtension", 14083, PropertyType.String);
        Field.createField("xmozlastack", DistinguishedPropertySetType.PublicStrings);
        Field.createField("xmozsnoozetime", DistinguishedPropertySetType.PublicStrings);
        Field.createField("xmozsendinvitations", DistinguishedPropertySetType.PublicStrings);
        Field.createField(URN_SCHEMAS_MAILHEADER, "importance");
        Field.createField("percentcomplete", DistinguishedPropertySetType.Task, 33026, "percentcomplete", PropertyType.Double);
        Field.createField("taskstatus", DistinguishedPropertySetType.Task, 33025, "taskstatus", PropertyType.Integer);
        Field.createField("startdate", DistinguishedPropertySetType.Task, 33028, "startdate", PropertyType.SystemTime);
        Field.createField("duedate", DistinguishedPropertySetType.Task, 33029, "duedate", PropertyType.SystemTime);
        Field.createField("datecompleted", DistinguishedPropertySetType.Task, 33039, "datecompleted", PropertyType.SystemTime);
        Field.createField("iscomplete", DistinguishedPropertySetType.Task, 33052, "iscomplete", PropertyType.Boolean);
        Field.createField("commonstart", DistinguishedPropertySetType.Common, 34070, "commonstart", PropertyType.SystemTime);
        Field.createField("commonend", DistinguishedPropertySetType.Common, 34071, "commonend", PropertyType.SystemTime);
    }

    protected static enum DistinguishedPropertySetType {
        Meeting,
        Appointment,
        Common,
        PublicStrings,
        Address,
        InternetHeaders,
        CalendarAssistant,
        UnifiedMessaging,
        Task;

    }
}

