/*
 * Decompiled with CFR 0.152.
 */
package davmail.exchange;

import davmail.exchange.ICSBufferedWriter;

public class VCardWriter
extends ICSBufferedWriter {
    public void startCard() {
        this.writeLine("BEGIN:VCARD");
        this.writeLine("VERSION:3.0");
    }

    public void appendProperty(String propertyName, String ... propertyValue) {
        boolean hasValue = false;
        for (String value : propertyValue) {
            if (value == null || value.length() <= 0) continue;
            hasValue = true;
            break;
        }
        if (hasValue) {
            boolean first = true;
            StringBuilder lineBuffer = new StringBuilder();
            lineBuffer.append(propertyName);
            lineBuffer.append(':');
            for (String value : propertyValue) {
                if (first) {
                    first = false;
                } else {
                    lineBuffer.append(';');
                }
                this.appendEncodedValue(lineBuffer, value);
            }
            this.writeLine(lineBuffer.toString());
        }
    }

    private void appendEncodedValue(StringBuilder buffer, String value) {
        if (value != null) {
            for (int i = 0; i < value.length(); ++i) {
                char c = value.charAt(i);
                if (c == ',' || c == ';') {
                    buffer.append('\\');
                }
                if (c == '\n') {
                    buffer.append("\\n");
                    continue;
                }
                buffer.append(value.charAt(i));
            }
        }
    }

    public void endCard() {
        this.writeLine("END:VCARD");
    }
}

