/* Ghost In The Mail (gitmail)
 *  Copyright (C) 2004-2006 Clément Plantier <clem38fr at users dot sf.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "history.h"

/* read all the history files */
void readfiles (void) {
	GtkWidget *comboboxentry1 = lookup_widget (mainwindow, "comboboxentry1");
	GtkWidget *comboboxentry2 = lookup_widget (mainwindow, "comboboxentry2");
	GtkWidget *comboboxentry3 = lookup_widget (mainwindow, "comboboxentry3");
	GtkWidget *comboboxentry4 = lookup_widget (mainwindow, "comboboxentry4");
	
	char serverfile[] = "/.gitmail/serverlist";
	char fromfile[] = "/.gitmail/fromlist";
	char namefile[] = "/.gitmail/namelist";
	char tofile[] = "/.gitmail/tolist";
	
	serverlistroot = readfile (serverfile, comboboxentry1);
	fromlistroot = readfile (fromfile, comboboxentry2);
	namelistroot = readfile (namefile, comboboxentry3);
	tolistroot = readfile (tofile, comboboxentry4);
}

/* read a history file */
GSList *readfile (char *file, GtkWidget *comboboxentry) {
	const gchar *home_dir = g_get_home_dir();
	
	char *fulldir = gitm_malloc (strlen(home_dir) + 1 + strlen(file) + 1);
	sprintf (fulldir, "%s%s", home_dir, file);

	struct loaded_file * lfile = loadfile (fulldir);

	free (fulldir);
	
	if (lfile)
		return setcbe(lfile, comboboxentry);
	else
		return NULL;
}

/* fill a combobox from the data found in a history file */
GSList *setcbe (struct loaded_file * lfile, GtkWidget *comboboxentry) {
	GSList *list = NULL;
	if (lfile->data) {
		int j, i = 0;
		while (i < lfile->size) {
			int len = elt_size (lfile->data + i, lfile->size);
			if (len) {
				gchar *new_string = gitm_malloc (len + 1);
				for (j = 0; j < len; j++)
					new_string[j] = lfile->data[i+j];
				new_string[len] = '\0';
				list = g_slist_append (list, new_string);
			}
			i += len + 1;
		}
		g_slist_foreach (list, (GFunc) append_combo_box, GTK_COMBO_BOX(comboboxentry));
	}
	return list;
}

/* write history files */
void writefiles (void) {
	const gchar *home_dir = g_get_home_dir();
	
	char *gmdir = gitm_malloc (strlen (home_dir) + 10);
	sprintf (gmdir, "%s/.gitmail", home_dir);
	
	mkdir (gmdir, S_IRUSR | S_IWUSR | S_IXUSR);
	
	char serverfile[] = "serverlist";
	char fromfile[] = "fromlist";
	char namefile[] = "namelist";
	char tofile[] = "tolist";
	
	char *fullserverfile = gitm_malloc (strlen (gmdir) + strlen (serverfile) + 1);
	char *fullfromfile = gitm_malloc (strlen (gmdir) + strlen (fromfile) + 1);
	char *fullnamefile = gitm_malloc (strlen (gmdir) + strlen (namefile) + 1);
	char *fulltofile = gitm_malloc (strlen (gmdir) + strlen (tofile) + 1);
	
	sprintf (fullserverfile, "%s/%s", gmdir, serverfile);
	sprintf (fullfromfile, "%s/%s", gmdir, fromfile);
	sprintf (fullnamefile, "%s/%s", gmdir, namefile);
	sprintf (fulltofile, "%s/%s", gmdir, tofile);
	
	remove (fullserverfile);
	remove (fullfromfile);
	remove (fullnamefile);
	remove (fulltofile);
	
	int fd0 = creat (fullserverfile, S_IRUSR | S_IWUSR);
	int fd1 = creat (fullfromfile, S_IRUSR | S_IWUSR);
	int fd2 = creat (fullnamefile, S_IRUSR | S_IWUSR);
	int fd3 = creat (fulltofile, S_IRUSR | S_IWUSR);

	g_slist_foreach (serverlistroot, (GFunc) write_list_to_file, &fd0);
	g_slist_foreach (fromlistroot, (GFunc) write_list_to_file, &fd1);
	g_slist_foreach (namelistroot, (GFunc) write_list_to_file, &fd2);
	g_slist_foreach (tolistroot, (GFunc) write_list_to_file, &fd3);
}

/* write data from comboboxes to history files */
void write_list_to_file (gpointer data, int *fd) {
	char *tempbuf = gitm_malloc (sizeof(data) + 1);
	sprintf (tempbuf, "%s\n", (char *)data);
	write (*fd, tempbuf, strlen (tempbuf));
}

/* add an element to a combobox */
void append_combo_box (gpointer data, GtkComboBox *combobox) {
			gtk_combo_box_append_text (combobox, data);
}

/* add a new item to a combobox and the associated list */
GSList * additem (GtkWidget *comboboxentry, GSList *listroot, char *text) {
	if (strlen(text)) {
		if (listroot) {
			if (check_text (listroot, text)) {
				gtk_combo_box_append_text (GTK_COMBO_BOX(comboboxentry), text);
				char *ptext = gitm_malloc (strlen (text) + 1);
				strcpy (ptext, text);
				listroot = g_slist_append (listroot, ptext);
			}
		} else {
			gtk_combo_box_append_text (GTK_COMBO_BOX(comboboxentry), text);
			char *ptext = gitm_malloc (strlen (text) + 1);
			strcpy (ptext, text);
			listroot = g_slist_append (listroot, ptext);
		}
	}
	return listroot;
}

/* check if a new element is into the history */
gboolean check_text (GSList *listroot, char *text) {
	gboolean i = TRUE;
	GSList *list;
	for (list = listroot; list; list = list->next)
		if (!strcmp(text, (char *)list->data))
			i = FALSE;
	return i;
}

/* clean all history lists */
void erase_all_items (void) {
	GtkWidget *comboboxentry1 = lookup_widget (mainwindow, "comboboxentry1");
	GtkWidget *comboboxentry2 = lookup_widget (mainwindow, "comboboxentry2");
	GtkWidget *comboboxentry3 = lookup_widget (mainwindow, "comboboxentry3");
	GtkWidget *comboboxentry4 = lookup_widget (mainwindow, "comboboxentry4");
	
	serverlistroot = erase_list (comboboxentry1, serverlistroot);
	fromlistroot = erase_list (comboboxentry2, fromlistroot);
	namelistroot = erase_list (comboboxentry3, namelistroot);
	tolistroot = erase_list (comboboxentry4, tolistroot);
}

/* clean a specified history list */
GSList * erase_list (GtkWidget *comboboxentry, GSList *listroot) {
	g_slist_free (listroot);
	listroot = NULL;
	gtk_list_store_clear (GTK_LIST_STORE (gtk_combo_box_get_model (GTK_COMBO_BOX(comboboxentry))));
	return listroot;
}
