/* Ghost In The Mail (gitmail)
 *  Copyright (C) 2004-2006 Clément Plantier <clem38fr at users dot sf.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "gui-general.h"

/* set the text of the status bar */
void statusbarsettext (char *text) {
	all_widgets *widgets = lookup_all_widgets();
	
	gdk_threads_enter ();
	gtk_statusbar_pop (GTK_STATUSBAR (widgets->statusbar1), widgets->context);
	if (text != NULL)
		gtk_statusbar_push (GTK_STATUSBAR (widgets->statusbar1), widgets->context, text);
	gdk_threads_leave();
}

/* set the fraction of the progress bar */
void progressbarsetfraction (double frac) {
	all_widgets *widgets = lookup_all_widgets();
	
	gdk_threads_enter ();
	gtk_progress_bar_set_fraction (GTK_PROGRESS_BAR (widgets->progressbar), frac);
	gdk_threads_leave ();
}

/* get the widgets pointers */
all_widgets * lookup_all_widgets () {
	all_widgets *widgets = gitm_malloc (sizeof(all_widgets));
	
	gdk_threads_enter ();
	widgets->button = lookup_widget(mainwindow, "button1");
	widgets->progressbar = lookup_widget (mainwindow, "progressbar1");
	widgets->statusbar1 = lookup_widget (mainwindow, "statusbar1");
	widgets->context = gtk_statusbar_get_context_id (GTK_STATUSBAR (widgets->statusbar1), "sendamail");
	gdk_threads_leave ();
	
	return widgets;
}

/* display an error message located at *text */
void showerror (char *text) {
	all_widgets *widgets = lookup_all_widgets();
	
	gdk_threads_enter ();
	GtkWidget *window3 = create_window3 ();
	GtkWidget *label17 = lookup_widget (window3, "label17");
	gtk_label_set_text (GTK_LABEL (label17), text);
	gtk_widget_set_sensitive (widgets->button, TRUE);
	gtk_widget_show (window3);
	gdk_threads_leave ();
	
	free (widgets);
}

/* display an error message located at *text */
void showerror_inthread (char *text) {
	GtkWidget *window3 = create_window3 ();
	GtkWidget *label17 = lookup_widget (window3, "label17");
	gtk_label_set_text (GTK_LABEL (label17), text);
	gtk_widget_show (window3);
}

/* show success dialog */
void showok () {
	all_widgets *widgets = lookup_all_widgets();
	
	gdk_threads_enter ();
	GtkWidget *window2 = create_window2 ();
	gtk_widget_show (window2);
	gtk_widget_set_sensitive (widgets->button, TRUE);
	gdk_threads_leave ();
	
	free (widgets);
}
