/* Ghost In The Mail (gitmail)
 *  Copyright (C) 2004-2006 Clément Plantier <clem38fr at users dot sf.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "general.h"

struct loaded_file * loadfile (char * filename) {
	struct loaded_file * lfile = NULL;
	FILE *filein = fopen (filename, "r");
		
	if (filein) {
		int i = 0, len;
		int pattern_size = 1024;
		char *buffer = gitm_malloc (1);
			
		do {
			buffer = gitm_realloc (buffer, pattern_size + i + 1);
			len = fread (buffer + i, 1, pattern_size, filein);
			if (len > 0)
				i += len;
		} while (len > 0);
		
		if (!i)
			buffer = NULL;
		else {
			lfile = gitm_malloc (sizeof(struct loaded_file));
			lfile->data = buffer;
			lfile->size = i;
		}
	}
		
	return lfile;
}
