/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.connection.core;

import javax.naming.InvalidNameException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.name.Rdn;
import org.apache.directory.studio.connection.core.Messages;

public class DnUtils {
    public static Dn getPrefixName(Dn dn, Dn suffix) {
        if (suffix.size() < 1) {
            return null;
        }
        try {
            Dn prefix = dn.getDescendantOf(suffix);
            return prefix;
        }
        catch (LdapInvalidDnException lide) {
            return null;
        }
    }

    public static Rdn composeRdn(String[] rdnTypes, String[] rdnValues) throws InvalidNameException {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < rdnTypes.length; ++i) {
            if (i > 0) {
                sb.append('+');
            }
            sb.append(rdnTypes[i]);
            sb.append('=');
            sb.append(Rdn.escapeValue((String)rdnValues[i]));
        }
        String s = sb.toString();
        try {
            if (Dn.isValid((String)s)) {
                Rdn rdn = new Rdn(sb.toString());
                return rdn;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        throw new InvalidNameException(Messages.error__invalid_rdn);
    }
}

