/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.valueeditors.adtime;

import java.util.Calendar;
import org.apache.directory.studio.common.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.valueeditors.ValueEditorsActivator;
import org.apache.directory.studio.valueeditors.adtime.ActiveDirectoryTimeUtils;
import org.apache.directory.studio.valueeditors.adtime.Messages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class ActiveDirectoryTimeValueDialog
extends Dialog {
    private long value;
    private Spinner hoursSpinner;
    private Spinner minutesSpinner;
    private Spinner secondsSpinner;
    private DateTime dateCalendar;
    private Text rawValueText;
    private ModifyListener hoursModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            ActiveDirectoryTimeValueDialog.this.updateValueFromNonRawFields();
            ActiveDirectoryTimeValueDialog.this.removeListeners();
            ActiveDirectoryTimeValueDialog.this.updateRawFields();
            ActiveDirectoryTimeValueDialog.this.addListeners();
        }
    };
    private ModifyListener minutesModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            ActiveDirectoryTimeValueDialog.this.updateValueFromNonRawFields();
            ActiveDirectoryTimeValueDialog.this.removeListeners();
            ActiveDirectoryTimeValueDialog.this.updateRawFields();
            ActiveDirectoryTimeValueDialog.this.addListeners();
        }
    };
    private ModifyListener secondsModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            ActiveDirectoryTimeValueDialog.this.updateValueFromNonRawFields();
            ActiveDirectoryTimeValueDialog.this.removeListeners();
            ActiveDirectoryTimeValueDialog.this.updateRawFields();
            ActiveDirectoryTimeValueDialog.this.addListeners();
        }
    };
    private SelectionListener dateSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            ActiveDirectoryTimeValueDialog.this.updateValueFromNonRawFields();
            ActiveDirectoryTimeValueDialog.this.removeListeners();
            ActiveDirectoryTimeValueDialog.this.updateRawFields();
            ActiveDirectoryTimeValueDialog.this.addListeners();
        }
    };
    private ModifyListener rawValueModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            try {
                ActiveDirectoryTimeValueDialog.this.value = Long.parseLong(ActiveDirectoryTimeValueDialog.this.rawValueText.getText());
                ActiveDirectoryTimeValueDialog.this.removeListeners();
                ActiveDirectoryTimeValueDialog.this.updateNonRawFields();
                ActiveDirectoryTimeValueDialog.this.addListeners();
            }
            catch (NumberFormatException e1) {
                return;
            }
        }
    };
    private VerifyListener rawValueVerifyListener = new VerifyListener(){

        public void verifyText(VerifyEvent e) {
            if (!e.text.matches("(-)?([0-9])*")) {
                e.doit = false;
            }
        }
    };

    public ActiveDirectoryTimeValueDialog(Shell parentShell, long value) {
        this(parentShell);
        this.value = value;
    }

    public ActiveDirectoryTimeValueDialog(Shell parentShell) {
        super(parentShell);
        super.setShellStyle(super.getShellStyle() | 0x10);
        this.value = ActiveDirectoryTimeUtils.convertToActiveDirectoryTime(Calendar.getInstance());
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.getString("ActiveDirectoryTimeValueDialog.DateAndTimeEditor"));
        shell.setImage(ValueEditorsActivator.getDefault().getImage("resources/icons/generalizedtimeeditor.gif"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite dualComposite = BaseWidgetUtils.createColumnContainer((Composite)composite, (int)2, (int)1);
        this.createTimeDialogArea(dualComposite);
        this.createDateDialogArea(dualComposite);
        this.createRawValueDialogArea(dualComposite);
        this.initWithInitialValue();
        this.addListeners();
        ActiveDirectoryTimeValueDialog.applyDialogFont((Control)composite);
        return composite;
    }

    private void createTimeDialogArea(Composite parent) {
        Label timeLabel = new Label(parent, 0);
        timeLabel.setText(Messages.getString("ActiveDirectoryTimeValueDialog.Time"));
        Composite rightComposite = BaseWidgetUtils.createColumnContainer((Composite)parent, (int)5, (int)1);
        this.hoursSpinner = new Spinner(rightComposite, 2048);
        this.hoursSpinner.setMinimum(0);
        this.hoursSpinner.setMaximum(23);
        this.hoursSpinner.setTextLimit(2);
        this.hoursSpinner.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        Label label1 = BaseWidgetUtils.createLabel((Composite)rightComposite, (String)":", (int)1);
        label1.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
        this.minutesSpinner = new Spinner(rightComposite, 2048);
        this.minutesSpinner.setMinimum(0);
        this.minutesSpinner.setMaximum(59);
        this.minutesSpinner.setTextLimit(2);
        this.minutesSpinner.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        Label label2 = BaseWidgetUtils.createLabel((Composite)rightComposite, (String)":", (int)1);
        label2.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
        this.secondsSpinner = new Spinner(rightComposite, 2048);
        this.secondsSpinner.setMinimum(0);
        this.secondsSpinner.setMaximum(59);
        this.secondsSpinner.setTextLimit(2);
        this.secondsSpinner.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
    }

    private void createDateDialogArea(Composite parent) {
        Label dateLabel = BaseWidgetUtils.createLabel((Composite)parent, (String)Messages.getString("ActiveDirectoryTimeValueDialog.Date"), (int)1);
        dateLabel.setLayoutData((Object)new GridData(0, 128, false, false));
        Composite rightComposite = BaseWidgetUtils.createColumnContainer((Composite)parent, (int)1, (int)1);
        this.dateCalendar = new DateTime(rightComposite, 3072);
        this.dateCalendar.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
    }

    private void createRawValueDialogArea(Composite parent) {
        Label separatorLabel = new Label(parent, 258);
        separatorLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        BaseWidgetUtils.createLabel((Composite)parent, (String)Messages.getString("ActiveDirectoryTimeValueDialog.RawValue"), (int)1);
        this.rawValueText = BaseWidgetUtils.createText((Composite)parent, (String)"", (int)1);
    }

    private void initWithInitialValue() {
        this.updateNonRawFields();
        this.updateRawFields();
    }

    private void updateNonRawFields() {
        Calendar calendar = this.getCalendarFromValue();
        this.hoursSpinner.setSelection(calendar.get(11));
        this.minutesSpinner.setSelection(calendar.get(12));
        this.secondsSpinner.setSelection(calendar.get(13));
        this.dateCalendar.setDate(calendar.get(1), calendar.get(2), calendar.get(5));
    }

    private void updateRawFields() {
        this.rawValueText.setText("" + this.value);
    }

    private void addListeners() {
        this.hoursSpinner.addModifyListener(this.hoursModifyListener);
        this.minutesSpinner.addModifyListener(this.minutesModifyListener);
        this.secondsSpinner.addModifyListener(this.secondsModifyListener);
        this.dateCalendar.addSelectionListener(this.dateSelectionListener);
        this.rawValueText.addModifyListener(this.rawValueModifyListener);
        this.rawValueText.addVerifyListener(this.rawValueVerifyListener);
    }

    private void removeListeners() {
        this.hoursSpinner.removeModifyListener(this.hoursModifyListener);
        this.minutesSpinner.removeModifyListener(this.minutesModifyListener);
        this.secondsSpinner.removeModifyListener(this.secondsModifyListener);
        this.dateCalendar.removeSelectionListener(this.dateSelectionListener);
        this.rawValueText.removeModifyListener(this.rawValueModifyListener);
        this.rawValueText.removeVerifyListener(this.rawValueVerifyListener);
    }

    private void updateValueFromNonRawFields() {
        Calendar calendar = this.getCalendarFromValue();
        calendar.set(11, this.hoursSpinner.getSelection());
        calendar.set(12, this.minutesSpinner.getSelection());
        calendar.set(13, this.secondsSpinner.getSelection());
        calendar.set(1, this.dateCalendar.getYear());
        calendar.set(2, this.dateCalendar.getMonth());
        calendar.set(5, this.dateCalendar.getDay());
        this.value = ActiveDirectoryTimeUtils.convertToActiveDirectoryTime(calendar);
    }

    private Calendar getCalendarFromValue() {
        return ActiveDirectoryTimeUtils.convertToCalendar(this.value);
    }

    public long getValue() {
        return this.value;
    }
}

