/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldifeditor.editor.text;

import org.apache.directory.studio.ldifeditor.LdifEditorActivator;
import org.apache.directory.studio.ldifeditor.editor.ILdifEditor;
import org.apache.directory.studio.ldifparser.model.LdifFile;
import org.apache.directory.studio.ldifparser.model.LdifPart;
import org.apache.directory.studio.ldifparser.model.container.LdifChangeModifyRecord;
import org.apache.directory.studio.ldifparser.model.container.LdifContainer;
import org.apache.directory.studio.ldifparser.model.container.LdifModSpec;
import org.apache.directory.studio.ldifparser.model.lines.LdifAttrValLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifModSpecTypeLine;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextUtilities;

public class LdifAutoEditStrategy
implements IAutoEditStrategy {
    private ILdifEditor editor;

    public LdifAutoEditStrategy(ILdifEditor editor) {
        this.editor = editor;
    }

    public void customizeDocumentCommand(IDocument d, DocumentCommand c) {
        boolean autoWrap;
        LdifFile model = this.editor.getLdifModel();
        LdifContainer container = LdifFile.getContainer((LdifFile)model, (int)c.offset);
        LdifModSpec innerContainer = container != null ? LdifFile.getInnerContainer((LdifContainer)container, (int)c.offset) : null;
        LdifPart part = container != null ? LdifFile.getContainerContent((LdifContainer)container, (int)c.offset) : null;
        boolean smartInsertAttributeInModSpec = LdifEditorActivator.getDefault().getPreferenceStore().getBoolean("ldifEditorCodeAssistInsertAttributeInModSpec");
        if (smartInsertAttributeInModSpec && c.length == 0 && c.text != null && TextUtilities.endsWith((String[])d.getLegalLineDelimiters(), (String)c.text) != -1 && container instanceof LdifChangeModifyRecord && innerContainer instanceof LdifModSpec && (part instanceof LdifAttrValLine || part instanceof LdifModSpecTypeLine)) {
            LdifModSpec modSpec = innerContainer;
            String att = modSpec.getModSpecType().getUnfoldedAttributeDescription();
            c.text = c.text + att + ": ";
        }
        if (autoWrap = LdifEditorActivator.getDefault().getPreferenceStore().getBoolean("ldifEditorFormatterAutoWrap")) {
            // empty if block
        }
    }
}

