/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldifeditor.editor;

import java.io.File;
import java.util.ResourceBundle;
import org.apache.directory.studio.common.ui.CommonUIUtils;
import org.apache.directory.studio.common.ui.filesystem.PathEditorInput;
import org.apache.directory.studio.common.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.ConnectionFolder;
import org.apache.directory.studio.connection.core.event.ConnectionEventRegistry;
import org.apache.directory.studio.connection.core.event.ConnectionUpdateListener;
import org.apache.directory.studio.connection.core.event.EventRunner;
import org.apache.directory.studio.connection.ui.ConnectionUIPlugin;
import org.apache.directory.studio.ldapbrowser.common.BrowserCommonConstants;
import org.apache.directory.studio.ldapbrowser.common.actions.ValueEditorPreferencesAction;
import org.apache.directory.studio.ldapbrowser.common.widgets.WidgetModifyEvent;
import org.apache.directory.studio.ldapbrowser.common.widgets.WidgetModifyListener;
import org.apache.directory.studio.ldapbrowser.common.widgets.search.BrowserConnectionWidget;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldifeditor.LdifEditorActivator;
import org.apache.directory.studio.ldifeditor.LdifEditorConstants;
import org.apache.directory.studio.ldifeditor.editor.ExecuteLdifAction;
import org.apache.directory.studio.ldifeditor.editor.ILdifEditor;
import org.apache.directory.studio.ldifeditor.editor.LdifDocumentProvider;
import org.apache.directory.studio.ldifeditor.editor.LdifOutlinePage;
import org.apache.directory.studio.ldifeditor.editor.LdifSourceViewerConfiguration;
import org.apache.directory.studio.ldifeditor.editor.Messages;
import org.apache.directory.studio.ldifeditor.editor.NonExistingLdifEditorInput;
import org.apache.directory.studio.ldifeditor.editor.actions.EditLdifAttributeAction;
import org.apache.directory.studio.ldifeditor.editor.actions.EditLdifRecordAction;
import org.apache.directory.studio.ldifeditor.editor.actions.FormatLdifDocumentAction;
import org.apache.directory.studio.ldifeditor.editor.actions.FormatLdifRecordAction;
import org.apache.directory.studio.ldifeditor.editor.actions.OpenBestValueEditorAction;
import org.apache.directory.studio.ldifeditor.editor.actions.OpenDefaultValueEditorAction;
import org.apache.directory.studio.ldifeditor.editor.actions.OpenValueEditorAction;
import org.apache.directory.studio.ldifparser.model.LdifFile;
import org.apache.directory.studio.utils.ActionUtils;
import org.apache.directory.studio.valueeditors.AbstractDialogValueEditor;
import org.apache.directory.studio.valueeditors.IValueEditor;
import org.apache.directory.studio.valueeditors.ValueEditorManager;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.ContentAssistAction;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class LdifEditor
extends TextEditor
implements ILdifEditor,
ConnectionUpdateListener,
IPartListener2 {
    private ViewForm control;
    private BrowserConnectionWidget browserConnectionWidget;
    private ToolBar actionToolBar;
    private IToolBarManager actionToolBarManager;
    private IBrowserConnection browserConnection;
    private ProjectionSupport projectionSupport;
    protected LdifOutlinePage outlinePage;
    private ValueEditorManager valueEditorManager;
    private OpenBestValueEditorAction openBestValueEditorAction;
    private OpenValueEditorAction[] openValueEditorActions;
    private ValueEditorPreferencesAction valueEditorPreferencesAction;
    protected boolean showToolBar = true;
    private IContextActivation contextActivation;

    public LdifEditor() {
        this.setSourceViewerConfiguration(new LdifSourceViewerConfiguration(this, true));
        this.setDocumentProvider((IDocumentProvider)new LdifDocumentProvider());
        IPreferenceStore editorStore = EditorsUI.getPreferenceStore();
        IPreferenceStore browserStore = LdifEditorActivator.getDefault().getPreferenceStore();
        ChainedPreferenceStore combinedStore = new ChainedPreferenceStore(new IPreferenceStore[]{browserStore, editorStore});
        this.setPreferenceStore((IPreferenceStore)combinedStore);
        this.setHelpContextId(LdifEditorConstants.PLUGIN_ID + "." + "tools_ldif_editor");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        try {
            ISourceViewer sourceViewer = this.getSourceViewer();
            if (sourceViewer == null) {
                return;
            }
            int topIndex = this.getSourceViewer().getTopIndex();
            this.getSourceViewer().getDocument().set(this.getSourceViewer().getDocument().get());
            this.getSourceViewer().setTopIndex(topIndex);
        }
        finally {
            super.handlePreferenceStoreChanged(event);
        }
    }

    protected String[] collectContextMenuPreferencePages() {
        String[] ids = super.collectContextMenuPreferencePages();
        String[] more = new String[ids.length + 4];
        more[0] = LdifEditorConstants.PREFERENCEPAGEID_LDIFEDITOR;
        more[1] = LdifEditorConstants.PREFERENCEPAGEID_LDIFEDITOR_CONTENTASSIST;
        more[2] = LdifEditorConstants.PREFERENCEPAGEID_LDIFEDITOR_SYNTAXCOLORING;
        more[3] = LdifEditorConstants.PREFERENCEPAGEID_LDIFEDITOR_TEMPLATES;
        System.arraycopy(ids, 0, more, 4, ids.length);
        return more;
    }

    public static String getId() {
        return LdifEditorConstants.EDITOR_LDIF_EDITOR;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        long fileLength;
        String className = input.getClass().getName();
        File file = null;
        if (input instanceof IPathEditorInput) {
            IPathEditorInput pei = (IPathEditorInput)input;
            IPath path = pei.getPath();
            file = path.toFile();
        } else if (className.equals("org.eclipse.ui.internal.editors.text.JavaFileEditorInput") || className.equals("org.eclipse.ui.ide.FileStoreEditorInput")) {
            file = new File(input.getToolTipText());
        }
        if (file != null && (fileLength = file.length()) > 0x100000L) {
            MessageDialog.openError((Shell)site.getShell(), (String)Messages.getString("LdifEditor.LDIFFileIsTooBig"), (String)Messages.getString("LdifEditor.LDIFFileIsTooBigDescription"));
            input = new NonExistingLdifEditorInput();
        }
        super.init(site, input);
        ConnectionEventRegistry.addConnectionUpdateListener((ConnectionUpdateListener)this, (EventRunner)ConnectionUIPlugin.getDefault().getEventRunner());
        this.getSite().getPage().addPartListener((IPartListener2)this);
        this.valueEditorManager = new ValueEditorManager((Composite)this.getSite().getShell(), false, false);
    }

    public void dispose() {
        this.valueEditorManager.dispose();
        this.deactivateGlobalActionHandlers();
        ConnectionEventRegistry.removeConnectionUpdateListener((ConnectionUpdateListener)this);
        this.getSite().getPage().removePartListener((IPartListener2)this);
        super.dispose();
    }

    public Object getAdapter(Class required) {
        Object adapter;
        if (IShowInTargetList.class.equals((Object)required)) {
            return new IShowInTargetList(){

                public String[] getShowInTargetIds() {
                    return new String[]{"org.eclipse.ui.views.ResourceNavigator"};
                }
            };
        }
        if (IContentOutlinePage.class.equals((Object)required)) {
            if (this.outlinePage == null || this.outlinePage.getControl() == null || this.outlinePage.getControl().isDisposed()) {
                this.outlinePage = new LdifOutlinePage(this);
            }
            return this.outlinePage;
        }
        if (ISourceViewer.class.equals((Object)required)) {
            return this.getSourceViewer();
        }
        if (IAnnotationHover.class.equals((Object)required) && this.getSourceViewerConfiguration() != null && this.getSourceViewer() != null) {
            return this.getSourceViewerConfiguration().getAnnotationHover(this.getSourceViewer());
        }
        if (ITextHover.class.equals((Object)required) && this.getSourceViewerConfiguration() != null && this.getSourceViewer() != null) {
            return this.getSourceViewerConfiguration().getTextHover(this.getSourceViewer(), null);
        }
        if (IContentAssistProcessor.class.equals((Object)required) && this.getSourceViewerConfiguration() != null && this.getSourceViewer() != null) {
            return this.getSourceViewerConfiguration().getContentAssistant(this.getSourceViewer()).getContentAssistProcessor("__ldif_record");
        }
        if (this.projectionSupport != null && (adapter = this.projectionSupport.getAdapter(this.getSourceViewer(), required)) != null) {
            return adapter;
        }
        return super.getAdapter(required);
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        IContributionItem[] items = menu.getItems();
        for (int i = 0; i < items.length; ++i) {
            if (!(items[i] instanceof ActionContributionItem)) continue;
            ActionContributionItem aci = (ActionContributionItem)items[i];
            if (aci.getAction() == this.getAction("ShiftLeft")) {
                menu.remove(items[i]);
            }
            if (aci.getAction() != this.getAction("ShiftRight")) continue;
            menu.remove(items[i]);
        }
        this.addAction(menu, "group.edit", LdifEditorConstants.ACTION_ID_EDIT_ATTRIBUTE_DESCRIPTION);
        this.addAction(menu, "group.edit", BrowserCommonConstants.ACTION_ID_EDIT_VALUE);
        MenuManager valueEditorMenuManager = new MenuManager(Messages.getString("LdifEditor.EditValueWith"));
        if (this.openBestValueEditorAction.isEnabled()) {
            valueEditorMenuManager.add((IAction)this.openBestValueEditorAction);
            valueEditorMenuManager.add((IContributionItem)new Separator());
        }
        for (int i = 0; i < this.openValueEditorActions.length; ++i) {
            this.openValueEditorActions[i].update();
            if (!this.openValueEditorActions[i].isEnabled() || this.openValueEditorActions[i].getValueEditor().getClass() == this.openBestValueEditorAction.getValueEditor().getClass() || !(this.openValueEditorActions[i].getValueEditor() instanceof AbstractDialogValueEditor)) continue;
            valueEditorMenuManager.add((IAction)this.openValueEditorActions[i]);
        }
        valueEditorMenuManager.add((IContributionItem)new Separator());
        valueEditorMenuManager.add((IAction)this.valueEditorPreferencesAction);
        menu.appendToGroup("group.edit", (IContributionItem)valueEditorMenuManager);
        this.addAction(menu, "group.edit", LdifEditorConstants.ACTION_ID_EDIT_RECORD);
        MenuManager formatMenuManager = new MenuManager(Messages.getString("LdifEditor.Format"));
        this.addAction((IMenuManager)formatMenuManager, LdifEditorConstants.ACTION_ID_FORMAT_LDIF_DOCUMENT);
        this.addAction((IMenuManager)formatMenuManager, LdifEditorConstants.ACTION_ID_FORMAT_LDIF_RECORD);
        menu.appendToGroup("group.edit", (IContributionItem)formatMenuManager);
    }

    protected void createActions() {
        IAction pasteAction;
        IAction copyAction;
        super.createActions();
        ResourceBundle bundle = LdifEditorActivator.getDefault().getResourceBundle();
        ContentAssistAction action = new ContentAssistAction(bundle, "ldifeditor__contentassistproposal_", (ITextEditor)this);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setAction("ContentAssistProposal", (IAction)action);
        if (this.actionToolBarManager != null) {
            ExecuteLdifAction executeLdifAction = new ExecuteLdifAction(this);
            this.actionToolBarManager.add((IAction)executeLdifAction);
            this.setAction(LdifEditorConstants.ACTION_ID_EXECUTE_LDIF, (IAction)executeLdifAction);
            this.actionToolBarManager.update(true);
        }
        EditLdifAttributeAction editLdifAttributeAction = new EditLdifAttributeAction(this);
        this.setAction(BrowserCommonConstants.ACTION_ID_EDIT_ATTRIBUTE_DESCRIPTION, (IAction)editLdifAttributeAction);
        this.openBestValueEditorAction = new OpenBestValueEditorAction(this);
        IValueEditor[] valueEditors = this.valueEditorManager.getAllValueEditors();
        this.openValueEditorActions = new OpenValueEditorAction[valueEditors.length];
        for (int i = 0; i < this.openValueEditorActions.length; ++i) {
            this.openValueEditorActions[i] = new OpenValueEditorAction(this, valueEditors[i]);
        }
        this.valueEditorPreferencesAction = new ValueEditorPreferencesAction();
        OpenDefaultValueEditorAction openDefaultValueEditorAction = new OpenDefaultValueEditorAction(this, this.openBestValueEditorAction);
        this.setAction(BrowserCommonConstants.ACTION_ID_EDIT_VALUE, (IAction)openDefaultValueEditorAction);
        EditLdifRecordAction editRecordAction = new EditLdifRecordAction(this);
        this.setAction(LdifEditorConstants.ACTION_ID_EDIT_RECORD, (IAction)editRecordAction);
        FormatLdifDocumentAction formatDocumentAction = new FormatLdifDocumentAction(this);
        this.setAction(LdifEditorConstants.ACTION_ID_FORMAT_LDIF_DOCUMENT, (IAction)formatDocumentAction);
        FormatLdifRecordAction formatRecordAction = new FormatLdifRecordAction(this);
        this.setAction(LdifEditorConstants.ACTION_ID_FORMAT_LDIF_RECORD, (IAction)formatRecordAction);
        IAction cutAction = this.getAction(ITextEditorActionConstants.CUT);
        if (cutAction != null) {
            cutAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_CUT"));
        }
        if ((copyAction = this.getAction(ITextEditorActionConstants.COPY)) != null) {
            copyAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_COPY"));
        }
        if ((pasteAction = this.getAction(ITextEditorActionConstants.PASTE)) != null) {
            pasteAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_PASTE"));
        }
        this.activateGlobalActionHandlers();
    }

    public void createPartControl(Composite parent) {
        this.setHelpContextId(LdifEditorConstants.PLUGIN_ID + "." + "tools_ldif_editor");
        if (this.showToolBar) {
            Composite composite = new Composite(parent, 0);
            composite.setLayoutData((Object)new GridData(1808));
            GridLayout layout = new GridLayout();
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            layout.verticalSpacing = 0;
            composite.setLayout((Layout)layout);
            this.control = new ViewForm(composite, 0);
            this.control.setLayoutData((Object)new GridData(1808));
            Composite browserConnectionWidgetControl = BaseWidgetUtils.createColumnContainer((Composite)this.control, (int)2, (int)1);
            this.browserConnectionWidget = new BrowserConnectionWidget();
            this.browserConnectionWidget.createWidget(browserConnectionWidgetControl);
            this.connectionUpdated(null);
            this.browserConnectionWidget.addWidgetModifyListener(new WidgetModifyListener(){

                public void widgetModified(WidgetModifyEvent event) {
                    IBrowserConnection browserConnection = LdifEditor.this.browserConnectionWidget.getBrowserConnection();
                    LdifEditor.this.setConnection(browserConnection);
                }
            });
            this.control.setTopLeft((Control)browserConnectionWidgetControl);
            this.actionToolBar = new ToolBar((Composite)this.control, 0x820000);
            this.actionToolBar.setLayoutData((Object)new GridData(0x1000008, 0, true, false));
            this.actionToolBarManager = new ToolBarManager(this.actionToolBar);
            this.control.setTopCenter((Control)this.actionToolBar);
            this.control.setTopRight(null);
            Composite editorComposite = new Composite((Composite)this.control, 0);
            editorComposite.setLayout((Layout)new FillLayout());
            GridData data = new GridData(1808);
            data.widthHint = 450;
            data.heightHint = 250;
            editorComposite.setLayoutData((Object)data);
            super.createPartControl(editorComposite);
            this.control.setContent((Control)editorComposite);
        } else {
            super.createPartControl(parent);
        }
        ProjectionViewer projectionViewer = (ProjectionViewer)this.getSourceViewer();
        this.projectionSupport = new ProjectionSupport(projectionViewer, this.getAnnotationAccess(), this.getSharedColors());
        this.projectionSupport.install();
        projectionViewer.doOperation(19);
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        this.getAnnotationAccess();
        this.getOverviewRuler();
        ProjectionViewer viewer = new ProjectionViewer(parent, ruler, this.getOverviewRuler(), true, styles);
        this.getSourceViewerDecorationSupport((ISourceViewer)viewer);
        return viewer;
    }

    protected void configureSourceViewerDecorationSupport(SourceViewerDecorationSupport support) {
        super.configureSourceViewerDecorationSupport(support);
    }

    @Override
    public LdifFile getLdifModel() {
        IDocumentProvider provider = this.getDocumentProvider();
        if (provider instanceof LdifDocumentProvider) {
            return ((LdifDocumentProvider)provider).getLdifModel();
        }
        return null;
    }

    public void outlinePageClosed() {
        this.projectionSupport.dispose();
        this.outlinePage = null;
    }

    @Override
    public IBrowserConnection getConnection() {
        return this.browserConnection;
    }

    protected void setConnection(IBrowserConnection browserConnection) {
        this.setConnection(browserConnection, false);
    }

    protected void setConnection(IBrowserConnection browserConnection, boolean updateBrowserConnectionWidget) {
        this.browserConnection = browserConnection;
        if (updateBrowserConnectionWidget && this.browserConnectionWidget != null) {
            this.browserConnectionWidget.setBrowserConnection(browserConnection);
        }
    }

    public final void connectionUpdated(Connection connection) {
        if (this.browserConnectionWidget != null) {
            IBrowserConnection browserConnection = this.browserConnectionWidget.getBrowserConnection();
            this.setConnection(browserConnection);
            this.browserConnectionWidget.setBrowserConnection(browserConnection);
        }
    }

    public void connectionAdded(Connection connection) {
        this.connectionUpdated(connection);
    }

    public void connectionRemoved(Connection connection) {
        this.connectionUpdated(connection);
    }

    public void connectionOpened(Connection connection) {
        this.connectionUpdated(connection);
    }

    public void connectionClosed(Connection connection) {
        this.connectionUpdated(connection);
    }

    public void connectionFolderModified(ConnectionFolder connectionFolder) {
    }

    public void connectionFolderAdded(ConnectionFolder connectionFolder) {
    }

    public void connectionFolderRemoved(ConnectionFolder connectionFolder) {
    }

    public void doSave(IProgressMonitor progressMonitor) {
        IEditorInput input = this.getEditorInput();
        if (input instanceof NonExistingLdifEditorInput) {
            super.doSaveAs();
            return;
        }
        super.doSave(progressMonitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performSaveAs(IProgressMonitor progressMonitor) {
        boolean isIDE = CommonUIUtils.isIDEEnvironment();
        if (isIDE) {
            IPreferenceStore store = EditorsUI.getPreferenceStore();
            String key = this.getEditorSite().getId() + ".internal.delegateSaveAs";
            store.setValue(key, true);
            super.performSaveAs(progressMonitor);
        } else {
            MessageDialog overwriteDialog;
            Shell shell = this.getSite().getShell();
            IEditorInput input = this.getEditorInput();
            IDocumentProvider provider = this.getDocumentProvider();
            FileDialog dialog = new FileDialog(shell, 8192);
            String path = dialog.open();
            if (path == null) {
                if (progressMonitor != null) {
                    progressMonitor.setCanceled(true);
                }
                return;
            }
            File externalFile = new File(path);
            if (externalFile.exists() && (overwriteDialog = new MessageDialog(shell, Messages.getString("LdifEditor.Overwrite"), null, Messages.getString("LdifEditor.OverwriteQuestion"), 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 1)).open() != 0 && progressMonitor != null) {
                progressMonitor.setCanceled(true);
                return;
            }
            Path iPath = new Path(path);
            PathEditorInput newInput = new PathEditorInput((IPath)iPath);
            boolean success = false;
            try {
                provider.aboutToChange((Object)newInput);
                provider.saveDocument(progressMonitor, (Object)newInput, provider.getDocument((Object)input), true);
                success = true;
            }
            catch (CoreException x) {
                IStatus status = x.getStatus();
                if (status == null || status.getSeverity() != 8) {
                    String title = Messages.getString("LdifEditor.ErrorInSaveAs");
                    String msg = Messages.getString("LdifEditor.ErrorInSaveAs") + x.getMessage();
                    MessageDialog.openError((Shell)shell, (String)title, (String)msg);
                }
            }
            finally {
                provider.changed((Object)newInput);
                if (success) {
                    this.setInput((IEditorInput)newInput);
                }
            }
            if (progressMonitor != null) {
                progressMonitor.setCanceled(!success);
            }
        }
    }

    public void partDeactivated(IWorkbenchPartReference partRef) {
        if (partRef.getPart(false) == this && this.contextActivation != null) {
            this.deactivateGlobalActionHandlers();
            IContextService contextService = (IContextService)PlatformUI.getWorkbench().getAdapter(IContextService.class);
            contextService.deactivateContext(this.contextActivation);
            this.contextActivation = null;
        }
    }

    public void partActivated(IWorkbenchPartReference partRef) {
        if (partRef.getPart(false) == this) {
            IContextService contextService = (IContextService)PlatformUI.getWorkbench().getAdapter(IContextService.class);
            this.contextActivation = contextService.activateContext(BrowserCommonConstants.CONTEXT_WINDOWS);
            this.activateGlobalActionHandlers();
        }
    }

    public void partBroughtToTop(IWorkbenchPartReference partRef) {
    }

    public void partClosed(IWorkbenchPartReference partRef) {
    }

    public void partHidden(IWorkbenchPartReference partRef) {
    }

    public void partInputChanged(IWorkbenchPartReference partRef) {
    }

    public void partOpened(IWorkbenchPartReference partRef) {
    }

    public void partVisible(IWorkbenchPartReference partRef) {
    }

    public void activateGlobalActionHandlers() {
        IAction elaa = this.getAction(BrowserCommonConstants.ACTION_ID_EDIT_ATTRIBUTE_DESCRIPTION);
        ActionUtils.activateActionHandler((IAction)elaa);
        IAction elva = this.getAction(BrowserCommonConstants.ACTION_ID_EDIT_VALUE);
        ActionUtils.activateActionHandler((IAction)elva);
        IAction elra = this.getAction(LdifEditorConstants.ACTION_ID_EDIT_RECORD);
        ActionUtils.activateActionHandler((IAction)elra);
    }

    public void deactivateGlobalActionHandlers() {
        IAction elaa = this.getAction(BrowserCommonConstants.ACTION_ID_EDIT_ATTRIBUTE_DESCRIPTION);
        ActionUtils.deactivateActionHandler((IAction)elaa);
        IAction elva = this.getAction(BrowserCommonConstants.ACTION_ID_EDIT_VALUE);
        ActionUtils.deactivateActionHandler((IAction)elva);
        IAction elra = this.getAction(LdifEditorConstants.ACTION_ID_EDIT_RECORD);
        ActionUtils.deactivateActionHandler((IAction)elra);
    }

    public ValueEditorManager getValueEditorManager() {
        return this.valueEditorManager;
    }
}

