/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.core.model.impl;

import java.util.ArrayList;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.api.ldap.model.url.LdapUrl;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.ConnectionCorePlugin;
import org.apache.directory.studio.ldapbrowser.core.BrowserCorePlugin;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.IContinuation;
import org.apache.directory.studio.ldapbrowser.core.model.ISearch;
import org.apache.directory.studio.ldapbrowser.core.model.ISearchResult;
import org.apache.directory.studio.ldapbrowser.core.model.SearchParameter;
import org.apache.directory.studio.ldapbrowser.core.model.impl.DummyConnection;
import org.apache.directory.studio.ldapbrowser.core.model.impl.Search;
import org.apache.directory.studio.ldapbrowser.core.model.schema.Schema;

public class SearchContinuation
extends Search
implements IContinuation {
    private static final long serialVersionUID = 9039452279802784225L;
    private LdapUrl searchContinuationURL;
    private IContinuation.State state;
    private DummyConnection dummyConnection;

    public SearchContinuation(ISearch originalSearch, LdapUrl searchContinuationURL) {
        super(null, (SearchParameter)originalSearch.getSearchParameter().clone());
        this.searchContinuationURL = searchContinuationURL;
        this.state = IContinuation.State.UNRESOLVED;
        this.getSearchParameter().setName(searchContinuationURL.toString());
        if (searchContinuationURL.getDn() != null && !searchContinuationURL.getDn().isEmpty()) {
            this.getSearchParameter().setSearchBase(searchContinuationURL.getDn());
        }
        if (searchContinuationURL.getFilter() != null && this.getSearchParameter().getFilter().length() > 0) {
            this.getSearchParameter().setFilter(searchContinuationURL.getFilter());
        }
        if (searchContinuationURL.getScope().getScope() > -1) {
            switch (searchContinuationURL.getScope()) {
                case OBJECT: {
                    this.getSearchParameter().setScope(SearchScope.OBJECT);
                    break;
                }
                case ONELEVEL: {
                    this.getSearchParameter().setScope(SearchScope.ONELEVEL);
                    break;
                }
                case SUBTREE: {
                    this.getSearchParameter().setScope(SearchScope.SUBTREE);
                }
            }
        }
        if (searchContinuationURL.getAttributes() != null && !searchContinuationURL.getAttributes().isEmpty()) {
            this.getSearchParameter().setReturningAttributes(searchContinuationURL.getAttributes().toArray(new String[0]));
        }
    }

    @Override
    public IBrowserConnection getBrowserConnection() {
        if (this.state == IContinuation.State.RESOLVED) {
            return super.getBrowserConnection();
        }
        if (this.dummyConnection == null) {
            this.dummyConnection = new DummyConnection(Schema.DEFAULT_SCHEMA);
        }
        return this.dummyConnection;
    }

    @Override
    public ISearchResult[] getSearchResults() {
        if (this.state == IContinuation.State.RESOLVED) {
            return super.getSearchResults();
        }
        return null;
    }

    @Override
    public IContinuation.State getState() {
        return this.state;
    }

    @Override
    public void resolve() {
        ArrayList<String> urls = new ArrayList<String>();
        urls.add(this.searchContinuationURL.toString());
        Connection referralConnection = ConnectionCorePlugin.getDefault().getReferralHandler().getReferralConnection(urls);
        if (referralConnection == null) {
            this.state = IContinuation.State.CANCELED;
            return;
        }
        this.connection = BrowserCorePlugin.getDefault().getConnectionManager().getBrowserConnection(referralConnection);
        this.state = IContinuation.State.RESOLVED;
    }

    @Override
    public LdapUrl getUrl() {
        return this.searchContinuationURL;
    }

    @Override
    public Object clone() {
        SearchContinuation clone = new SearchContinuation(this, this.getUrl());
        clone.state = this.state;
        clone.dummyConnection = this.dummyConnection;
        clone.connection = this.connection;
        return clone;
    }
}

