/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.core.jobs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.naming.ContextNotEmptyException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.BasicControl;
import javax.naming.ldap.Control;
import javax.naming.ldap.ManageReferralControl;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.studio.common.core.jobs.StudioProgressMonitor;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.StudioControl;
import org.apache.directory.studio.connection.core.io.StudioNamingEnumeration;
import org.apache.directory.studio.connection.core.jobs.StudioConnectionBulkRunnableWithProgress;
import org.apache.directory.studio.ldapbrowser.core.BrowserCoreMessages;
import org.apache.directory.studio.ldapbrowser.core.events.BulkModificationEvent;
import org.apache.directory.studio.ldapbrowser.core.events.EventRegistry;
import org.apache.directory.studio.ldapbrowser.core.events.SearchUpdateEvent;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.ISearch;
import org.apache.directory.studio.ldapbrowser.core.model.ISearchResult;
import org.apache.directory.studio.ldapbrowser.core.utils.JNDIUtils;
import org.eclipse.core.runtime.IProgressMonitor;

public class DeleteEntriesRunnable
implements StudioConnectionBulkRunnableWithProgress {
    private Collection<IEntry> entriesToDelete;
    private Set<IEntry> deletedEntriesSet;
    private Set<ISearch> searchesToUpdateSet;
    private boolean useTreeDeleteControl;

    public DeleteEntriesRunnable(Collection<IEntry> entriesToDelete, boolean useTreeDeleteControl) {
        this.entriesToDelete = entriesToDelete;
        this.useTreeDeleteControl = useTreeDeleteControl;
        this.deletedEntriesSet = new HashSet<IEntry>();
        this.searchesToUpdateSet = new HashSet<ISearch>();
    }

    public Connection[] getConnections() {
        Connection[] connections = new Connection[this.entriesToDelete.size()];
        int i = 0;
        for (IEntry entry : this.entriesToDelete) {
            connections[i] = entry.getBrowserConnection().getConnection();
            ++i;
        }
        return connections;
    }

    public String getName() {
        return this.entriesToDelete.size() == 1 ? BrowserCoreMessages.jobs__delete_entries_name_1 : BrowserCoreMessages.jobs__delete_entries_name_n;
    }

    public Object[] getLockedObjects() {
        ArrayList<IEntry> l = new ArrayList<IEntry>();
        l.addAll(this.entriesToDelete);
        return l.toArray();
    }

    public String getErrorMessage() {
        return this.entriesToDelete.size() == 1 ? BrowserCoreMessages.jobs__delete_entries_error_1 : BrowserCoreMessages.jobs__delete_entries_error_n;
    }

    public void run(StudioProgressMonitor monitor) {
        monitor.beginTask(this.entriesToDelete.size() == 1 ? BrowserCoreMessages.bind((String)BrowserCoreMessages.jobs__delete_entries_task_1, (Object[])new String[]{this.entriesToDelete.iterator().next().getDn().getName()}) : BrowserCoreMessages.bind((String)BrowserCoreMessages.jobs__delete_entries_task_n, (Object[])new String[]{Integer.toString(this.entriesToDelete.size())}), 2 + this.entriesToDelete.size());
        monitor.reportProgress(" ");
        monitor.worked(1);
        int num = 0;
        StudioProgressMonitor dummyMonitor = new StudioProgressMonitor((IProgressMonitor)monitor);
        Iterator<IEntry> iterator = this.entriesToDelete.iterator();
        while (!monitor.isCanceled() && !monitor.errorsReported() && iterator.hasNext()) {
            IEntry entryToDelete = iterator.next();
            IBrowserConnection browserConnection = entryToDelete.getBrowserConnection();
            int errorStatusSize1 = monitor.getErrorStatus("").getChildren().length;
            num = DeleteEntriesRunnable.optimisticDeleteEntryRecursive(browserConnection, entryToDelete.getDn(), entryToDelete.isReferral(), this.useTreeDeleteControl, num, dummyMonitor, monitor);
            int errorStatusSize2 = monitor.getErrorStatus("").getChildren().length;
            if (!monitor.isCanceled()) {
                if (errorStatusSize1 == errorStatusSize2) {
                    this.deletedEntriesSet.add(entryToDelete);
                    entryToDelete.getParententry().setChildrenInitialized(false);
                    entryToDelete.getParententry().deleteChild(entryToDelete);
                    List<ISearch> searches = browserConnection.getSearchManager().getSearches();
                    for (ISearch search : searches) {
                        if (search.getSearchResults() == null) continue;
                        ISearchResult[] searchResults = search.getSearchResults();
                        ArrayList<ISearchResult> searchResultList = new ArrayList<ISearchResult>();
                        searchResultList.addAll(Arrays.asList(searchResults));
                        Iterator it = searchResultList.iterator();
                        while (it.hasNext()) {
                            ISearchResult result = (ISearchResult)it.next();
                            if (!entryToDelete.equals(result.getEntry())) continue;
                            it.remove();
                            this.searchesToUpdateSet.add(search);
                        }
                        if (!this.searchesToUpdateSet.contains(search)) continue;
                        search.setSearchResults(searchResultList.toArray(new ISearchResult[searchResultList.size()]));
                    }
                    browserConnection.uncacheEntryRecursive(entryToDelete);
                }
            } else {
                entryToDelete.setChildrenInitialized(false);
            }
            monitor.worked(1);
        }
    }

    public void runNotification(StudioProgressMonitor monitor) {
        IBrowserConnection browserConnection = this.entriesToDelete.iterator().next().getBrowserConnection();
        EventRegistry.fireEntryUpdated(new BulkModificationEvent(browserConnection), this);
        for (ISearch search : this.searchesToUpdateSet) {
            EventRegistry.fireSearchUpdated(new SearchUpdateEvent(search, SearchUpdateEvent.EventDetail.SEARCH_PERFORMED), this);
        }
    }

    static int optimisticDeleteEntryRecursive(IBrowserConnection browserConnection, Dn dn, boolean useManageDsaItControl, boolean useTreeDeleteControl, int numberOfDeletedEntries, StudioProgressMonitor dummyMonitor, StudioProgressMonitor monitor) {
        dummyMonitor.reset();
        DeleteEntriesRunnable.deleteEntry(browserConnection, dn, useManageDsaItControl, useTreeDeleteControl, dummyMonitor);
        if (!dummyMonitor.errorsReported()) {
            monitor.reportProgress(BrowserCoreMessages.bind((String)BrowserCoreMessages.model__deleted_n_entries, (Object[])new String[]{"" + ++numberOfDeletedEntries}));
        } else if (dummyMonitor.getException() instanceof ContextNotEmptyException) {
            int numberInBatch;
            Connection.AliasDereferencingMethod aliasDereferencingMethod = Connection.AliasDereferencingMethod.NEVER;
            Connection.ReferralHandlingMethod referralsHandlingMethod = Connection.ReferralHandlingMethod.IGNORE;
            dummyMonitor.reset();
            do {
                numberInBatch = 0;
                SearchControls searchControls = new SearchControls();
                searchControls.setCountLimit(1000L);
                searchControls.setReturningAttributes(new String[0]);
                searchControls.setSearchScope(1);
                StudioNamingEnumeration result = browserConnection.getConnection().getConnectionWrapper().search(dn.getName(), "(objectClass=*)", searchControls, aliasDereferencingMethod, referralsHandlingMethod, null, dummyMonitor, null);
                try {
                    while (!dummyMonitor.isCanceled() && !dummyMonitor.errorsReported() && result.hasMore()) {
                        SearchResult sr = (SearchResult)result.next();
                        Dn childDn = JNDIUtils.getDn(sr);
                        numberOfDeletedEntries = DeleteEntriesRunnable.optimisticDeleteEntryRecursive(browserConnection, childDn, false, false, numberOfDeletedEntries, dummyMonitor, monitor);
                        ++numberInBatch;
                    }
                }
                catch (Exception e) {
                    int ldapStatusCode = JNDIUtils.getLdapStatusCode(e);
                    if (ldapStatusCode == 3 || ldapStatusCode == 4 || ldapStatusCode == 11) continue;
                    dummyMonitor.reportError(e);
                    break;
                }
            } while (numberInBatch > 0 && !monitor.isCanceled() && !dummyMonitor.errorsReported());
            if (!dummyMonitor.errorsReported()) {
                DeleteEntriesRunnable.deleteEntry(browserConnection, dn, false, false, dummyMonitor);
            }
            if (!dummyMonitor.errorsReported()) {
                monitor.reportProgress(BrowserCoreMessages.bind((String)BrowserCoreMessages.model__deleted_n_entries, (Object[])new String[]{"" + ++numberOfDeletedEntries}));
            }
        } else {
            Exception exception = dummyMonitor.getException();
            dummyMonitor.reportError(exception);
            monitor.reportError(exception);
        }
        return numberOfDeletedEntries;
    }

    static void deleteEntry(IBrowserConnection browserConnection, Dn dn, boolean useManageDsaItControl, boolean useTreeDeleteControl, StudioProgressMonitor monitor) {
        ArrayList<BasicControl> controlList = new ArrayList<BasicControl>();
        if (useTreeDeleteControl && browserConnection.getRootDSE().isControlSupported(StudioControl.TREEDELETE_CONTROL.getOid())) {
            BasicControl treeDeleteControl = new BasicControl(StudioControl.TREEDELETE_CONTROL.getOid(), StudioControl.TREEDELETE_CONTROL.isCritical(), StudioControl.TREEDELETE_CONTROL.getControlValue());
            controlList.add(treeDeleteControl);
        }
        if (useManageDsaItControl && browserConnection.getRootDSE().isControlSupported(StudioControl.MANAGEDSAIT_CONTROL.getOid())) {
            controlList.add(new ManageReferralControl(false));
        }
        Control[] controls = controlList.toArray(new Control[controlList.size()]);
        if (browserConnection.getConnection() != null) {
            browserConnection.getConnection().getConnectionWrapper().deleteEntry(dn.getName(), controls, monitor, null);
        }
    }
}

