/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.apacheds.configuration.editor.v155;

import java.util.List;
import org.apache.directory.studio.apacheds.configuration.editor.v155.Messages;
import org.apache.directory.studio.apacheds.configuration.editor.v155.PartitionsMasterDetailsBlock;
import org.apache.directory.studio.apacheds.configuration.editor.v155.dialogs.IndexedAttributeDialog;
import org.apache.directory.studio.apacheds.configuration.model.v155.IndexedAttribute;
import org.apache.directory.studio.apacheds.configuration.model.v155.Partition;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class PartitionDetailsPage
implements IDetailsPage {
    private PartitionsMasterDetailsBlock masterDetailsBlock;
    private IManagedForm mform;
    private Partition input;
    private List<IndexedAttribute> indexedAttributes;
    private boolean dirty = false;
    private Text idText;
    private Text cacheSizeText;
    private Text suffixText;
    private Button enableOptimizerCheckbox;
    private Button synchOnWriteCheckbox;
    private TableViewer indexedAttributesTableViewer;
    private Button indexedAttributeAddButton;
    private Button indexedAttributeEditButton;
    private Button indexedAttributeDeleteButton;
    private ModifyListener textModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            PartitionDetailsPage.this.masterDetailsBlock.setEditorDirty();
            PartitionDetailsPage.this.dirty = true;
        }
    };
    private SelectionListener checkboxSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            PartitionDetailsPage.this.masterDetailsBlock.setEditorDirty();
            PartitionDetailsPage.this.dirty = true;
        }
    };
    private ISelectionChangedListener indexedAttributesTableViewerListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            PartitionDetailsPage.this.indexedAttributeEditButton.setEnabled(!event.getSelection().isEmpty());
            PartitionDetailsPage.this.indexedAttributeDeleteButton.setEnabled(!event.getSelection().isEmpty());
        }
    };
    private IDoubleClickListener indexedAttributesTableViewerDoubleClickListener = new IDoubleClickListener(){

        public void doubleClick(DoubleClickEvent event) {
            PartitionDetailsPage.this.editSelectedIndexedAttribute();
        }
    };
    private SelectionListener indexedAttributeAddButtonListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            IndexedAttributeDialog dialog = new IndexedAttributeDialog(new IndexedAttribute("", 0));
            if (0 == dialog.open()) {
                PartitionDetailsPage.this.indexedAttributes.add(dialog.getIndexedAttribute());
                PartitionDetailsPage.this.indexedAttributesTableViewer.refresh();
                PartitionDetailsPage.this.masterDetailsBlock.setEditorDirty();
                PartitionDetailsPage.this.dirty = true;
            }
        }
    };
    private SelectionListener indexedAttributeEditButtonListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            PartitionDetailsPage.this.editSelectedIndexedAttribute();
        }
    };
    private SelectionListener indexedAttributeDeleteButtonListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            StructuredSelection selection = (StructuredSelection)PartitionDetailsPage.this.indexedAttributesTableViewer.getSelection();
            if (!selection.isEmpty()) {
                IndexedAttribute indexedAttribute = (IndexedAttribute)selection.getFirstElement();
                PartitionDetailsPage.this.indexedAttributes.remove(indexedAttribute);
                PartitionDetailsPage.this.indexedAttributesTableViewer.refresh();
                PartitionDetailsPage.this.masterDetailsBlock.setEditorDirty();
                PartitionDetailsPage.this.dirty = true;
            }
        }
    };

    public PartitionDetailsPage(PartitionsMasterDetailsBlock pmdb) {
        this.masterDetailsBlock = pmdb;
    }

    public void createContents(Composite parent) {
        FormToolkit toolkit = this.mform.getToolkit();
        TableWrapLayout layout = new TableWrapLayout();
        layout.topMargin = 5;
        layout.leftMargin = 5;
        layout.rightMargin = 2;
        layout.bottomMargin = 2;
        parent.setLayout((Layout)layout);
        this.createDetailsSection(parent, toolkit);
        this.createIndexedAttributesSection(parent, toolkit);
    }

    private void createDetailsSection(Composite parent, FormToolkit toolkit) {
        Section section = toolkit.createSection(parent, 384);
        section.marginWidth = 10;
        section.setText(Messages.getString("PartitionDetailsPage.PartitionDetails"));
        section.setDescription(Messages.getString("PartitionDetailsPage.PartitionsDetailsDescription"));
        TableWrapData td = new TableWrapData(128, 16);
        td.grabHorizontal = true;
        section.setLayoutData((Object)td);
        Composite client = toolkit.createComposite((Composite)section);
        toolkit.paintBordersFor(client);
        GridLayout glayout = new GridLayout(3, false);
        client.setLayout((Layout)glayout);
        section.setClient((Control)client);
        toolkit.createLabel(client, Messages.getString("PartitionDetailsPage.ID"));
        this.idText = toolkit.createText(client, "");
        this.idText.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
        toolkit.createLabel(client, Messages.getString("PartitionDetailsPage.CacheSize"));
        this.cacheSizeText = toolkit.createText(client, "");
        this.cacheSizeText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (!e.text.matches("[0-9]*")) {
                    e.doit = false;
                }
            }
        });
        this.cacheSizeText.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
        toolkit.createLabel(client, Messages.getString("PartitionDetailsPage.Suffix"));
        this.suffixText = toolkit.createText(client, "");
        this.suffixText.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
        this.enableOptimizerCheckbox = toolkit.createButton(client, Messages.getString("PartitionDetailsPage.EnableOptimizer"), 32);
        this.enableOptimizerCheckbox.setLayoutData((Object)new GridData(4, 0, true, false, 3, 1));
        this.synchOnWriteCheckbox = toolkit.createButton(client, Messages.getString("PartitionDetailsPage.SynchronizationOnWrite"), 32);
        this.synchOnWriteCheckbox.setLayoutData((Object)new GridData(4, 0, true, false, 3, 1));
    }

    private void createIndexedAttributesSection(Composite parent, FormToolkit toolkit) {
        Section indexedAttributesSection = toolkit.createSection(parent, 384);
        indexedAttributesSection.marginWidth = 10;
        indexedAttributesSection.setText(Messages.getString("PartitionDetailsPage.IndexedAttributes"));
        indexedAttributesSection.setDescription(Messages.getString("PartitionDetailsPage.IndexedAttributesDescription"));
        indexedAttributesSection.setLayoutData((Object)new TableWrapData(128));
        Composite indexedAttributesClient = toolkit.createComposite((Composite)indexedAttributesSection);
        toolkit.paintBordersFor(indexedAttributesClient);
        indexedAttributesClient.setLayout((Layout)new GridLayout(2, false));
        indexedAttributesSection.setClient((Control)indexedAttributesClient);
        Table indexedAttributesTable = toolkit.createTable(indexedAttributesClient, 0);
        GridData gd = new GridData(4, 0, true, false, 1, 3);
        gd.heightHint = 80;
        indexedAttributesTable.setLayoutData((Object)gd);
        this.indexedAttributesTableViewer = new TableViewer(indexedAttributesTable);
        this.indexedAttributesTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.indexedAttributesTableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        GridData buttonsGD = new GridData(4, 1, false, false);
        buttonsGD.widthHint = 61;
        this.indexedAttributeAddButton = toolkit.createButton(indexedAttributesClient, Messages.getString("PartitionDetailsPage.Add"), 8);
        this.indexedAttributeAddButton.setLayoutData((Object)buttonsGD);
        this.indexedAttributeEditButton = toolkit.createButton(indexedAttributesClient, Messages.getString("PartitionDetailsPage.Edit"), 8);
        this.indexedAttributeEditButton.setEnabled(false);
        this.indexedAttributeEditButton.setLayoutData((Object)buttonsGD);
        this.indexedAttributeDeleteButton = toolkit.createButton(indexedAttributesClient, Messages.getString("PartitionDetailsPage.Delete"), 8);
        this.indexedAttributeDeleteButton.setEnabled(false);
        this.indexedAttributeDeleteButton.setLayoutData((Object)buttonsGD);
    }

    private void addListeners() {
        this.idText.addModifyListener(this.textModifyListener);
        this.cacheSizeText.addModifyListener(this.textModifyListener);
        this.suffixText.addModifyListener(this.textModifyListener);
        this.enableOptimizerCheckbox.addSelectionListener(this.checkboxSelectionListener);
        this.synchOnWriteCheckbox.addSelectionListener(this.checkboxSelectionListener);
        this.indexedAttributesTableViewer.addSelectionChangedListener(this.indexedAttributesTableViewerListener);
        this.indexedAttributesTableViewer.addDoubleClickListener(this.indexedAttributesTableViewerDoubleClickListener);
        this.indexedAttributeAddButton.addSelectionListener(this.indexedAttributeAddButtonListener);
        this.indexedAttributeEditButton.addSelectionListener(this.indexedAttributeEditButtonListener);
        this.indexedAttributeDeleteButton.addSelectionListener(this.indexedAttributeDeleteButtonListener);
    }

    private void removeListeners() {
        this.idText.removeModifyListener(this.textModifyListener);
        this.cacheSizeText.removeModifyListener(this.textModifyListener);
        this.suffixText.removeModifyListener(this.textModifyListener);
        this.enableOptimizerCheckbox.removeSelectionListener(this.checkboxSelectionListener);
        this.synchOnWriteCheckbox.removeSelectionListener(this.checkboxSelectionListener);
        this.indexedAttributesTableViewer.removeSelectionChangedListener(this.indexedAttributesTableViewerListener);
        this.indexedAttributesTableViewer.removeDoubleClickListener(this.indexedAttributesTableViewerDoubleClickListener);
        this.indexedAttributeAddButton.removeSelectionListener(this.indexedAttributeAddButtonListener);
        this.indexedAttributeEditButton.removeSelectionListener(this.indexedAttributeEditButtonListener);
        this.indexedAttributeDeleteButton.removeSelectionListener(this.indexedAttributeDeleteButtonListener);
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
        IStructuredSelection ssel = (IStructuredSelection)selection;
        this.input = ssel.size() == 1 ? (Partition)ssel.getFirstElement() : null;
        this.refresh();
    }

    public void commit(boolean onSave) {
        if (this.input != null) {
            this.input.setId(this.idText.getText());
            this.input.setCacheSize(Integer.parseInt(this.cacheSizeText.getText()));
            this.input.setSuffix(this.suffixText.getText());
            this.input.setEnableOptimizer(this.enableOptimizerCheckbox.getSelection());
            this.input.setSynchronizationOnWrite(this.synchOnWriteCheckbox.getSelection());
        }
    }

    public void dispose() {
    }

    public void initialize(IManagedForm form) {
        this.mform = form;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isStale() {
        return false;
    }

    public void refresh() {
        this.removeListeners();
        String id = this.input.getId();
        this.idText.setText(id == null ? "" : id);
        this.cacheSizeText.setText("" + this.input.getCacheSize());
        String suffix = this.input.getSuffix();
        this.suffixText.setText(suffix == null ? "" : suffix);
        this.enableOptimizerCheckbox.setSelection(this.input.isEnableOptimizer());
        this.synchOnWriteCheckbox.setSelection(this.input.isSynchronizationOnWrite());
        this.indexedAttributes = this.input.getIndexedAttributes();
        this.indexedAttributesTableViewer.setInput(this.indexedAttributes);
        this.addListeners();
    }

    public void setFocus() {
        this.idText.setFocus();
    }

    public boolean setFormInput(Object input) {
        return false;
    }

    private void editSelectedIndexedAttribute() {
        IndexedAttribute indexedAttribute;
        IndexedAttributeDialog dialog;
        StructuredSelection selection = (StructuredSelection)this.indexedAttributesTableViewer.getSelection();
        if (!selection.isEmpty() && 0 == (dialog = new IndexedAttributeDialog(indexedAttribute = (IndexedAttribute)selection.getFirstElement())).open() && dialog.isDirty()) {
            this.indexedAttributesTableViewer.refresh();
            this.masterDetailsBlock.setEditorDirty();
            this.dirty = true;
        }
    }
}

