/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.apacheds.configuration.editor.v155;

import java.util.ArrayList;
import java.util.List;
import org.apache.directory.studio.apacheds.configuration.ApacheDSConfigurationPluginConstants;
import org.apache.directory.studio.apacheds.configuration.editor.ServerConfigurationEditor;
import org.apache.directory.studio.apacheds.configuration.editor.v155.Messages;
import org.apache.directory.studio.apacheds.configuration.editor.v155.dialogs.NtlmProviderDialog;
import org.apache.directory.studio.apacheds.configuration.editor.v155.dialogs.SaslRealmDialog;
import org.apache.directory.studio.apacheds.configuration.model.v155.ServerConfigurationV155;
import org.apache.directory.studio.apacheds.configuration.model.v155.SupportedMechanismEnum;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class AuthenticationPage
extends FormPage {
    public static final String ID = ServerConfigurationEditor.ID + ".V155.AuthenticationPage";
    private static final String TITLE = Messages.getString("AuthenticationPage.Authentication");
    private List<String> saslRealms = new ArrayList<String>();
    private CheckboxTableViewer supportedMechanismsTableViewer;
    private Button selectAllSupportedMechanismsButton;
    private Button deselectAllSupportedMechanismsButton;
    private Button editSupportedMechanismButton;
    private Text saslHostText;
    private Text saslPrincipalText;
    private Text searchBaseDnText;
    private CheckboxTableViewer saslRealmsTableViewer;
    private Button addSaslRealmButton;
    private Button editSaslRealmsButton;
    private Button deleteSaslRealmButton;

    public AuthenticationPage(FormEditor editor) {
        super(editor, ID, TITLE);
    }

    protected void createFormContent(IManagedForm managedForm) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getPartControl(), ApacheDSConfigurationPluginConstants.PLUGIN_ID + "." + "configuration_editor_155");
        ScrolledForm form = managedForm.getForm();
        form.setText(Messages.getString("AuthenticationPage.Authentication"));
        Composite parent = form.getBody();
        parent.setLayout((Layout)new TableWrapLayout());
        FormToolkit toolkit = managedForm.getToolkit();
        Composite composite = toolkit.createComposite(parent);
        composite.setLayout((Layout)new GridLayout());
        TableWrapData compositeTableWrapData = new TableWrapData(128, 16);
        compositeTableWrapData.grabHorizontal = true;
        composite.setLayoutData((Object)compositeTableWrapData);
        this.createSupportedAuthenticationMechanismsSection(composite, toolkit);
        this.createSaslSettingsSection(composite, toolkit);
        this.createSaslRealmsSection(composite, toolkit);
        this.initFromInput();
        this.addListeners();
    }

    private void createSupportedAuthenticationMechanismsSection(Composite parent, FormToolkit toolkit) {
        Section section = toolkit.createSection(parent, 256);
        section.setText(Messages.getString("AuthenticationPage.SupportedAuthenticationMechanisms"));
        section.setLayoutData((Object)new GridData(4, 0, true, false));
        Composite client = toolkit.createComposite((Composite)section);
        toolkit.paintBordersFor(client);
        GridLayout glayout = new GridLayout(2, false);
        client.setLayout((Layout)glayout);
        section.setClient((Control)client);
        Table supportedMechanismsTable = toolkit.createTable(client, 32);
        GridData gd = new GridData(4, 0, true, false, 1, 3);
        gd.heightHint = 110;
        supportedMechanismsTable.setLayoutData((Object)gd);
        this.supportedMechanismsTableViewer = new CheckboxTableViewer(supportedMechanismsTable);
        this.supportedMechanismsTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.supportedMechanismsTableViewer.setInput((Object)new SupportedMechanismEnum[]{SupportedMechanismEnum.SIMPLE, SupportedMechanismEnum.CRAM_MD5, SupportedMechanismEnum.DIGEST_MD5, SupportedMechanismEnum.GSSAPI, SupportedMechanismEnum.NTLM, SupportedMechanismEnum.GSS_SPNEGO});
        this.editSupportedMechanismButton = toolkit.createButton(client, Messages.getString("AuthenticationPage.Edit"), 8);
        this.editSupportedMechanismButton.setLayoutData((Object)new GridData(4, 1, false, false));
        this.editSupportedMechanismButton.setEnabled(false);
        this.selectAllSupportedMechanismsButton = toolkit.createButton(client, Messages.getString("AuthenticationPage.SelectAll"), 8);
        this.selectAllSupportedMechanismsButton.setLayoutData((Object)new GridData(4, 1, false, false));
        this.deselectAllSupportedMechanismsButton = toolkit.createButton(client, Messages.getString("AuthenticationPage.DeselectAll"), 8);
        this.deselectAllSupportedMechanismsButton.setLayoutData((Object)new GridData(4, 1, false, false));
    }

    private void createSaslSettingsSection(Composite parent, FormToolkit toolkit) {
        Section section = toolkit.createSection(parent, 256);
        section.setText(Messages.getString("AuthenticationPage.SaslSettings"));
        section.setLayoutData((Object)new GridData(4, 0, true, false));
        Composite client = toolkit.createComposite((Composite)section);
        toolkit.paintBordersFor(client);
        GridLayout glayout = new GridLayout(2, false);
        client.setLayout((Layout)glayout);
        section.setClient((Control)client);
        toolkit.createLabel(client, Messages.getString("AuthenticationPage.SaslHost"));
        this.saslHostText = toolkit.createText(client, "");
        this.saslHostText.setLayoutData((Object)new GridData(4, 0, true, false));
        toolkit.createLabel(client, Messages.getString("AuthenticationPage.SaslPrincipal"));
        this.saslPrincipalText = toolkit.createText(client, "");
        this.saslPrincipalText.setLayoutData((Object)new GridData(4, 0, true, false));
        toolkit.createLabel(client, Messages.getString("AuthenticationPage.SearchBaseDN"));
        this.searchBaseDnText = toolkit.createText(client, "");
        this.searchBaseDnText.setLayoutData((Object)new GridData(4, 0, true, false));
    }

    private void createSaslRealmsSection(Composite parent, FormToolkit toolkit) {
        Section section = toolkit.createSection(parent, 256);
        section.setText(Messages.getString("AuthenticationPage.SaslRealms"));
        section.setLayoutData((Object)new GridData(4, 0, true, false));
        Composite client = toolkit.createComposite((Composite)section);
        toolkit.paintBordersFor(client);
        GridLayout glayout = new GridLayout(2, false);
        client.setLayout((Layout)glayout);
        section.setClient((Control)client);
        Table saslRealmsTable = toolkit.createTable(client, 0);
        GridData gd = new GridData(4, 0, true, false, 1, 3);
        gd.heightHint = 82;
        saslRealmsTable.setLayoutData((Object)gd);
        this.saslRealmsTableViewer = new CheckboxTableViewer(saslRealmsTable);
        this.saslRealmsTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.addSaslRealmButton = toolkit.createButton(client, Messages.getString("AuthenticationPage.Add"), 8);
        this.addSaslRealmButton.setLayoutData((Object)new GridData(4, 1, false, false));
        this.editSaslRealmsButton = toolkit.createButton(client, Messages.getString("AuthenticationPage.Edit"), 8);
        this.editSaslRealmsButton.setLayoutData((Object)new GridData(4, 1, false, false));
        this.editSaslRealmsButton.setEnabled(false);
        this.deleteSaslRealmButton = toolkit.createButton(client, Messages.getString("AuthenticationPage.Delete"), 8);
        this.deleteSaslRealmButton.setLayoutData((Object)new GridData(4, 1, false, false));
        this.deleteSaslRealmButton.setEnabled(false);
    }

    private void initFromInput() {
        ServerConfigurationV155 configuration = (ServerConfigurationV155)((ServerConfigurationEditor)this.getEditor()).getServerConfiguration();
        this.supportedMechanismsTableViewer.setCheckedElements(configuration.getSupportedMechanisms().toArray());
        this.saslHostText.setText(configuration.getSaslHost());
        this.saslPrincipalText.setText(configuration.getSaslPrincipal());
        this.searchBaseDnText.setText(configuration.getSearchBaseDn());
        this.saslRealms.addAll(configuration.getSaslRealms());
        this.saslRealmsTableViewer.setInput(this.saslRealms);
    }

    private void addListeners() {
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AuthenticationPage.this.setEditorDirty();
            }
        };
        this.supportedMechanismsTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection = (StructuredSelection)AuthenticationPage.this.supportedMechanismsTableViewer.getSelection();
                if (!selection.isEmpty()) {
                    SupportedMechanismEnum selected = (SupportedMechanismEnum)((Object)selection.getFirstElement());
                    AuthenticationPage.this.editSupportedMechanismButton.setEnabled(SupportedMechanismEnum.NTLM.equals((Object)selected) || SupportedMechanismEnum.GSS_SPNEGO.equals((Object)selected));
                } else {
                    AuthenticationPage.this.editSupportedMechanismButton.setEnabled(false);
                }
            }
        });
        this.supportedMechanismsTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                AuthenticationPage.this.editSelectedSupportedMechanism();
            }
        });
        this.editSupportedMechanismButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AuthenticationPage.this.editSelectedSupportedMechanism();
            }
        });
        this.selectAllSupportedMechanismsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AuthenticationPage.this.supportedMechanismsTableViewer.setAllChecked(true);
                AuthenticationPage.this.setEditorDirty();
            }
        });
        this.deselectAllSupportedMechanismsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AuthenticationPage.this.supportedMechanismsTableViewer.setAllChecked(false);
                AuthenticationPage.this.setEditorDirty();
            }
        });
        this.supportedMechanismsTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                AuthenticationPage.this.setEditorDirty();
            }
        });
        this.saslHostText.addModifyListener(modifyListener);
        this.saslPrincipalText.addModifyListener(modifyListener);
        this.searchBaseDnText.addModifyListener(modifyListener);
        this.saslRealmsTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AuthenticationPage.this.editSaslRealmsButton.setEnabled(!event.getSelection().isEmpty());
                AuthenticationPage.this.deleteSaslRealmButton.setEnabled(!event.getSelection().isEmpty());
            }
        });
        this.saslRealmsTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                AuthenticationPage.this.editSelectedSaslRealm();
            }
        });
        this.addSaslRealmButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String newSaslRealm;
                SaslRealmDialog dialog = new SaslRealmDialog("");
                if (0 == dialog.open() && dialog.isDirty() && (newSaslRealm = dialog.getSaslRealm()) != null && !"".equals(newSaslRealm) && !AuthenticationPage.this.saslRealms.contains(newSaslRealm)) {
                    AuthenticationPage.this.saslRealms.add(newSaslRealm);
                    AuthenticationPage.this.saslRealmsTableViewer.refresh();
                    AuthenticationPage.this.setEditorDirty();
                }
            }
        });
        this.editSaslRealmsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AuthenticationPage.this.editSelectedSaslRealm();
            }
        });
        this.deleteSaslRealmButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StructuredSelection selection = (StructuredSelection)AuthenticationPage.this.saslRealmsTableViewer.getSelection();
                if (!selection.isEmpty()) {
                    String saslRealm = (String)selection.getFirstElement();
                    AuthenticationPage.this.saslRealms.remove(saslRealm);
                    AuthenticationPage.this.saslRealmsTableViewer.refresh();
                    AuthenticationPage.this.setEditorDirty();
                }
            }
        });
    }

    private void editSelectedSupportedMechanism() {
        String oldNtlmProvider;
        NtlmProviderDialog dialog;
        SupportedMechanismEnum selected;
        StructuredSelection selection = (StructuredSelection)this.supportedMechanismsTableViewer.getSelection();
        if (!selection.isEmpty() && (SupportedMechanismEnum.NTLM.equals((Object)(selected = (SupportedMechanismEnum)((Object)selection.getFirstElement()))) || SupportedMechanismEnum.GSS_SPNEGO.equals((Object)selected)) && 0 == (dialog = new NtlmProviderDialog(oldNtlmProvider = selected.getNtlmProviderFqcn())).open() && dialog.isDirty()) {
            selected.setNtlmProviderFqcn(dialog.getNtlmProvider());
            this.supportedMechanismsTableViewer.refresh();
            this.setEditorDirty();
        }
    }

    private void editSelectedSaslRealm() {
        String oldSaslRealm;
        SaslRealmDialog dialog;
        StructuredSelection selection = (StructuredSelection)this.saslRealmsTableViewer.getSelection();
        if (!selection.isEmpty() && 0 == (dialog = new SaslRealmDialog(oldSaslRealm = (String)selection.getFirstElement())).open() && dialog.isDirty()) {
            this.saslRealms.remove(oldSaslRealm);
            String newSaslRealm = dialog.getSaslRealm();
            if (newSaslRealm != null && !"".equals(newSaslRealm) && !this.saslRealms.contains(newSaslRealm)) {
                this.saslRealms.add(newSaslRealm);
            }
            this.saslRealmsTableViewer.refresh();
            this.setEditorDirty();
        }
    }

    private void setEditorDirty() {
        ((ServerConfigurationEditor)this.getEditor()).setDirty(true);
    }

    public void doSave(IProgressMonitor monitor) {
        ServerConfigurationV155 configuration = (ServerConfigurationV155)((ServerConfigurationEditor)this.getEditor()).getServerConfiguration();
        if (this.supportedMechanismsTableViewer != null && this.supportedMechanismsTableViewer.getTable() != null && !this.supportedMechanismsTableViewer.getTable().isDisposed()) {
            ArrayList<SupportedMechanismEnum> supportedMechanismsList = new ArrayList<SupportedMechanismEnum>();
            for (Object supportedMechanism : this.supportedMechanismsTableViewer.getCheckedElements()) {
                supportedMechanismsList.add((SupportedMechanismEnum)((Object)supportedMechanism));
            }
            configuration.setSupportedMechanisms(supportedMechanismsList);
        }
        if (this.saslHostText != null && !this.saslHostText.isDisposed()) {
            configuration.setSaslHost(this.saslHostText.getText());
        }
        if (this.saslPrincipalText != null && !this.saslPrincipalText.isDisposed()) {
            configuration.setSaslPrincipal(this.saslPrincipalText.getText());
        }
        if (this.searchBaseDnText != null && !this.searchBaseDnText.isDisposed()) {
            configuration.setSearchBaseDn(this.searchBaseDnText.getText());
        }
        if (this.saslRealmsTableViewer != null && this.saslRealmsTableViewer.getTable() != null && !this.saslRealmsTableViewer.getTable().isDisposed()) {
            configuration.setSaslRealms(this.saslRealms);
        }
    }
}

