/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.converter.schema;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.text.ParseException;
import java.util.List;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.directory.api.converter.schema.SchemaElement;
import org.apache.directory.api.converter.schema.antlrSchemaConverterLexer;
import org.apache.directory.api.converter.schema.antlrSchemaConverterParser;
import org.apache.directory.api.i18n.I18n;

public class SchemaParser {
    private antlrSchemaConverterParser parser = null;
    private PipedOutputStream parserIn = null;
    private byte[] buf = new byte[128];
    private InputStream schemaIn;
    private Thread producerThread;

    public SchemaParser() throws IOException {
        this.init();
    }

    public synchronized void init() throws IOException {
        this.parserIn = new PipedOutputStream();
        PipedInputStream in = new PipedInputStream();
        this.parserIn.connect(in);
        antlrSchemaConverterLexer lexer = new antlrSchemaConverterLexer(in);
        this.parser = new antlrSchemaConverterParser(lexer);
    }

    public synchronized void clear() {
        this.parser.clear();
    }

    public synchronized List<SchemaElement> parse(String schemaObject) throws IOException, ParseException {
        if (schemaObject == null || schemaObject.trim().equals("")) {
            throw new ParseException(I18n.err((I18n)I18n.ERR_06001_EMPTY_OR_NULL_SCHEMA_OBJECT, (Object[])new Object[0]), 0);
        }
        this.schemaIn = new ByteArrayInputStream(schemaObject.getBytes());
        if (this.producerThread == null) {
            this.producerThread = new Thread(new DataProducer());
        }
        this.producerThread.start();
        return this.invokeParser(schemaObject);
    }

    private List<SchemaElement> invokeParser(String schemaName) throws IOException, ParseException {
        try {
            this.parser.parseSchema();
            return this.parser.getSchemaElements();
        }
        catch (RecognitionException re) {
            String msg = I18n.err((I18n)I18n.ERR_06002_PARSER_FAILURE, (Object[])new Object[]{schemaName, ExceptionUtils.getFullStackTrace((Throwable)re)});
            this.init();
            throw new ParseException(msg, re.getColumn());
        }
        catch (TokenStreamException tse) {
            String msg = I18n.err((I18n)I18n.ERR_06002_PARSER_FAILURE, (Object[])new Object[]{schemaName, ExceptionUtils.getFullStackTrace((Throwable)tse)});
            this.init();
            throw new ParseException(msg, 0);
        }
    }

    public synchronized List<SchemaElement> parse(InputStream schemaIn) throws IOException, ParseException {
        this.schemaIn = schemaIn;
        if (this.producerThread == null) {
            this.producerThread = new Thread(new DataProducer());
        }
        this.producerThread.start();
        return this.invokeParser("schema input stream ==> " + schemaIn.toString());
    }

    public synchronized void parse(File schemaFile) throws IOException, ParseException {
        this.schemaIn = new FileInputStream(schemaFile);
        if (this.producerThread == null) {
            this.producerThread = new Thread(new DataProducer());
        }
        this.producerThread.start();
        this.invokeParser("schema file ==> " + schemaFile.getAbsolutePath());
    }

    private class DataProducer
    implements Runnable {
        private DataProducer() {
        }

        @Override
        public void run() {
            int count = -1;
            try {
                while ((count = SchemaParser.this.schemaIn.read(SchemaParser.this.buf)) != -1) {
                    SchemaParser.this.parserIn.write(SchemaParser.this.buf, 0, count);
                    SchemaParser.this.parserIn.flush();
                }
                SchemaParser.this.parserIn.write("END ".getBytes());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

