/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.dialogs.preferences;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.directory.api.ldap.model.schema.AbstractSchemaObject;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.LdapSyntax;
import org.apache.directory.studio.common.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.connection.core.Utils;
import org.apache.directory.studio.ldapbrowser.common.dialogs.preferences.AttributeDialog;
import org.apache.directory.studio.ldapbrowser.common.dialogs.preferences.Messages;
import org.apache.directory.studio.ldapbrowser.common.dialogs.preferences.SyntaxDialog;
import org.apache.directory.studio.ldapbrowser.core.BrowserConnectionManager;
import org.apache.directory.studio.ldapbrowser.core.BrowserCorePlugin;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.schema.BinaryAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.schema.BinarySyntax;
import org.apache.directory.studio.ldapbrowser.core.model.schema.Schema;
import org.apache.directory.studio.ldapbrowser.core.model.schema.SchemaUtils;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class BinaryAttributesAndSyntaxesPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private SortedMap<String, AttributeType> attributeOid2AtdMap;
    private SortedMap<String, AttributeType> attributeNames2AtdMap;
    private String[] attributeNamesAndOids;
    private SortedMap<String, LdapSyntax> syntaxOid2LsdMap;
    private SortedMap<String, LdapSyntax> syntaxDesc2LsdMap;
    private String[] syntaxOids;
    private List<BinaryAttribute> attributeList;
    private TableViewer attributeViewer;
    private Button attributeAddButton;
    private Button attributeEditButton;
    private Button attributeRemoveButton;
    private List<BinarySyntax> syntaxList;
    private TableViewer syntaxViewer;
    private Button syntaxAddButton;
    private Button syntaxEditButton;
    private Button syntaxRemoveButton;

    public BinaryAttributesAndSyntaxesPreferencePage() {
        super(Messages.getString("BinaryAttributesAndSyntaxesPreferencePage.BinaryAttributes"));
        super.setDescription(Messages.getString("BinaryAttributesAndSyntaxesPreferencePage.BinaryAttributesDescription"));
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Schema schema;
        IBrowserConnection[] connections;
        Composite composite = BaseWidgetUtils.createColumnContainer((Composite)parent, (int)1, (int)1);
        composite.setLayoutData((Object)new GridData(1808));
        this.attributeNames2AtdMap = new TreeMap<String, AttributeType>();
        this.attributeOid2AtdMap = new TreeMap<String, AttributeType>();
        BrowserConnectionManager cm = BrowserCorePlugin.getDefault().getConnectionManager();
        for (IBrowserConnection browserConnection : connections = cm.getBrowserConnections()) {
            schema = browserConnection.getSchema();
            this.createAttributeMaps(schema);
        }
        this.createAttributeMaps(Schema.DEFAULT_SCHEMA);
        this.attributeNamesAndOids = new String[this.attributeNames2AtdMap.size() + this.attributeOid2AtdMap.size()];
        System.arraycopy(this.attributeNames2AtdMap.keySet().toArray(), 0, this.attributeNamesAndOids, 0, this.attributeNames2AtdMap.size());
        System.arraycopy(this.attributeOid2AtdMap.keySet().toArray(), 0, this.attributeNamesAndOids, this.attributeNames2AtdMap.size(), this.attributeOid2AtdMap.size());
        this.syntaxOid2LsdMap = new TreeMap<String, LdapSyntax>();
        this.syntaxDesc2LsdMap = new TreeMap<String, LdapSyntax>();
        for (IBrowserConnection browserConnection : connections) {
            schema = browserConnection.getSchema();
            this.createSyntaxMaps(schema);
        }
        this.createSyntaxMaps(Schema.DEFAULT_SCHEMA);
        this.syntaxOids = new String[this.syntaxOid2LsdMap.size()];
        System.arraycopy(this.syntaxOid2LsdMap.keySet().toArray(), 0, this.syntaxOids, 0, this.syntaxOid2LsdMap.size());
        BaseWidgetUtils.createSpacer((Composite)composite, (int)1);
        BaseWidgetUtils.createSpacer((Composite)composite, (int)1);
        this.createAttributeContents(composite);
        this.attributeList = new ArrayList<BinaryAttribute>(Arrays.asList(BrowserCorePlugin.getDefault().getCorePreferences().getBinaryAttributes()));
        this.attributeViewer.setInput(this.attributeList);
        this.attributeViewer.getTable().getColumn(0).pack();
        BaseWidgetUtils.createSpacer((Composite)composite, (int)1);
        BaseWidgetUtils.createSpacer((Composite)composite, (int)1);
        this.createSyntaxContents(composite);
        this.syntaxList = new ArrayList<BinarySyntax>(Arrays.asList(BrowserCorePlugin.getDefault().getCorePreferences().getBinarySyntaxes()));
        this.syntaxViewer.setInput(this.syntaxList);
        this.syntaxViewer.getTable().getColumn(0).pack();
        this.syntaxViewer.getTable().pack();
        return composite;
    }

    private void createAttributeMaps(Schema schema) {
        Collection atds = schema.getAttributeTypeDescriptions();
        for (AttributeType atd : atds) {
            this.attributeOid2AtdMap.put(atd.getOid(), atd);
            for (String name : atd.getNames()) {
                this.attributeNames2AtdMap.put(name, atd);
            }
        }
    }

    private void createSyntaxMaps(Schema schema) {
        Collection lsds = schema.getLdapSyntaxDescriptions();
        for (LdapSyntax lsd : lsds) {
            this.syntaxOid2LsdMap.put(lsd.getOid(), lsd);
            if (lsd.getDescription() == null) continue;
            this.syntaxDesc2LsdMap.put(lsd.getDescription(), lsd);
        }
    }

    private void createAttributeContents(Composite parent) {
        BaseWidgetUtils.createLabel((Composite)parent, (String)Messages.getString("BinaryAttributesAndSyntaxesPreferencePage.BinaryAttributes"), (int)1);
        Composite composite = BaseWidgetUtils.createColumnContainer((Composite)parent, (int)2, (int)1);
        composite.setLayoutData((Object)new GridData(1808));
        Composite listComposite = BaseWidgetUtils.createColumnContainer((Composite)composite, (int)1, (int)1);
        listComposite.setLayoutData((Object)new GridData(1808));
        Composite buttonComposite = BaseWidgetUtils.createColumnContainer((Composite)composite, (int)1, (int)1);
        buttonComposite.setLayoutData((Object)new GridData(2));
        Table table = new Table(listComposite, 67844);
        GridData data = new GridData(1808);
        data.widthHint = 360;
        data.heightHint = this.convertHeightInCharsToPixels(10);
        table.setLayoutData((Object)data);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.attributeViewer = new TableViewer(table);
        TableColumn c1 = new TableColumn(table, 0);
        c1.setText(Messages.getString("BinaryAttributesAndSyntaxesPreferencePage.Attribute"));
        c1.setWidth(300);
        TableColumn c2 = new TableColumn(table, 0);
        c2.setText(Messages.getString("BinaryAttributesAndSyntaxesPreferencePage.Alias"));
        c2.setWidth(60);
        this.attributeViewer.setColumnProperties(new String[]{Messages.getString("BinaryAttributesAndSyntaxesPreferencePage.Attribute")});
        this.attributeViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.attributeViewer.setLabelProvider((IBaseLabelProvider)new AttributeLabelProvider());
        this.attributeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                BinaryAttributesAndSyntaxesPreferencePage.this.editAttribute();
            }
        });
        this.attributeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                BinaryAttributesAndSyntaxesPreferencePage.this.attributeEditButton.setEnabled(!BinaryAttributesAndSyntaxesPreferencePage.this.attributeViewer.getSelection().isEmpty());
                BinaryAttributesAndSyntaxesPreferencePage.this.attributeRemoveButton.setEnabled(!BinaryAttributesAndSyntaxesPreferencePage.this.attributeViewer.getSelection().isEmpty());
            }
        });
        this.attributeAddButton = BaseWidgetUtils.createButton((Composite)buttonComposite, (String)Messages.getString("BinaryAttributesAndSyntaxesPreferencePage.Add"), (int)1);
        this.attributeAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BinaryAttributesAndSyntaxesPreferencePage.this.addAttribute();
            }
        });
        this.attributeEditButton = BaseWidgetUtils.createButton((Composite)buttonComposite, (String)Messages.getString("BinaryAttributesAndSyntaxesPreferencePage.Edit"), (int)1);
        this.attributeEditButton.setEnabled(false);
        this.attributeEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BinaryAttributesAndSyntaxesPreferencePage.this.editAttribute();
            }
        });
        this.attributeRemoveButton = BaseWidgetUtils.createButton((Composite)buttonComposite, (String)Messages.getString("BinaryAttributesAndSyntaxesPreferencePage.Remove"), (int)1);
        this.attributeRemoveButton.setEnabled(false);
        this.attributeRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BinaryAttributesAndSyntaxesPreferencePage.this.removeAttribute();
            }
        });
    }

    private void createSyntaxContents(Composite parent) {
        BaseWidgetUtils.createLabel((Composite)parent, (String)Messages.getString("BinaryAttributesAndSyntaxesPreferencePage.BinarySyntaxes"), (int)1);
        Composite composite = BaseWidgetUtils.createColumnContainer((Composite)parent, (int)2, (int)1);
        composite.setLayoutData((Object)new GridData(1808));
        Composite listComposite = BaseWidgetUtils.createColumnContainer((Composite)composite, (int)1, (int)1);
        listComposite.setLayoutData((Object)new GridData(1808));
        Composite buttonComposite = BaseWidgetUtils.createColumnContainer((Composite)composite, (int)1, (int)1);
        buttonComposite.setLayoutData((Object)new GridData(2));
        Table table = new Table(listComposite, 67844);
        GridData data = new GridData(1808);
        data.widthHint = 360;
        data.heightHint = this.convertHeightInCharsToPixels(10);
        table.setLayoutData((Object)data);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.syntaxViewer = new TableViewer(table);
        TableColumn c1 = new TableColumn(table, 0);
        c1.setText(Messages.getString("BinaryAttributesAndSyntaxesPreferencePage.Syntax"));
        c1.setWidth(300);
        TableColumn c2 = new TableColumn(table, 0);
        c2.setText(Messages.getString("BinaryAttributesAndSyntaxesPreferencePage.Desc"));
        c2.setWidth(60);
        this.syntaxViewer.setColumnProperties(new String[]{Messages.getString("BinaryAttributesAndSyntaxesPreferencePage.Syntax")});
        this.syntaxViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.syntaxViewer.setLabelProvider((IBaseLabelProvider)new SyntaxLabelProvider());
        this.syntaxViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                BinaryAttributesAndSyntaxesPreferencePage.this.editSyntax();
            }
        });
        this.syntaxViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                BinaryAttributesAndSyntaxesPreferencePage.this.syntaxEditButton.setEnabled(!BinaryAttributesAndSyntaxesPreferencePage.this.syntaxViewer.getSelection().isEmpty());
                BinaryAttributesAndSyntaxesPreferencePage.this.syntaxRemoveButton.setEnabled(!BinaryAttributesAndSyntaxesPreferencePage.this.syntaxViewer.getSelection().isEmpty());
            }
        });
        this.syntaxAddButton = BaseWidgetUtils.createButton((Composite)buttonComposite, (String)Messages.getString("BinaryAttributesAndSyntaxesPreferencePage.Add"), (int)1);
        this.syntaxAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BinaryAttributesAndSyntaxesPreferencePage.this.addSyntax();
            }
        });
        this.syntaxEditButton = BaseWidgetUtils.createButton((Composite)buttonComposite, (String)Messages.getString("BinaryAttributesAndSyntaxesPreferencePage.Edit"), (int)1);
        this.syntaxEditButton.setEnabled(false);
        this.syntaxEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BinaryAttributesAndSyntaxesPreferencePage.this.editSyntax();
            }
        });
        this.syntaxRemoveButton = BaseWidgetUtils.createButton((Composite)buttonComposite, (String)Messages.getString("BinaryAttributesAndSyntaxesPreferencePage.Remove"), (int)1);
        this.syntaxRemoveButton.setEnabled(false);
        this.syntaxRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BinaryAttributesAndSyntaxesPreferencePage.this.removeSyntax();
            }
        });
    }

    private void addAttribute() {
        AttributeDialog dialog = new AttributeDialog(this.getShell(), null, this.attributeNamesAndOids);
        if (dialog.open() == 0) {
            BinaryAttribute attribute = dialog.getAttribute();
            if (this.attributeNames2AtdMap.containsKey(attribute.getAttributeNumericOidOrName())) {
                attribute = new BinaryAttribute(((AttributeType)this.attributeNames2AtdMap.get(attribute.getAttributeNumericOidOrName())).getOid());
            } else if (this.attributeOid2AtdMap.containsKey(attribute.getAttributeNumericOidOrName())) {
                attribute = new BinaryAttribute(((AttributeType)this.attributeOid2AtdMap.get(attribute.getAttributeNumericOidOrName())).getOid());
            }
            this.attributeList.add(attribute);
            this.attributeViewer.refresh();
        }
    }

    private void removeAttribute() {
        Object o = ((StructuredSelection)this.attributeViewer.getSelection()).getFirstElement();
        this.attributeList.remove(o);
        this.attributeViewer.refresh();
    }

    private void editAttribute() {
        StructuredSelection sel = (StructuredSelection)this.attributeViewer.getSelection();
        if (!sel.isEmpty()) {
            BinaryAttribute attribute = (BinaryAttribute)sel.getFirstElement();
            AttributeDialog dialog = new AttributeDialog(this.getShell(), attribute, this.attributeNamesAndOids);
            if (dialog.open() == 0) {
                int index = this.attributeList.indexOf(attribute);
                this.attributeList.set(index, dialog.getAttribute());
                this.attributeViewer.refresh();
            }
        }
    }

    private void addSyntax() {
        SyntaxDialog dialog = new SyntaxDialog(this.getShell(), null, this.syntaxOids);
        if (dialog.open() == 0) {
            this.syntaxList.add(dialog.getSyntax());
            this.syntaxViewer.refresh();
        }
    }

    private void removeSyntax() {
        Object o = ((StructuredSelection)this.syntaxViewer.getSelection()).getFirstElement();
        this.syntaxList.remove(o);
        this.syntaxViewer.refresh();
    }

    private void editSyntax() {
        StructuredSelection sel = (StructuredSelection)this.syntaxViewer.getSelection();
        if (!sel.isEmpty()) {
            BinarySyntax syntax = (BinarySyntax)sel.getFirstElement();
            SyntaxDialog dialog = new SyntaxDialog(this.getShell(), syntax, this.syntaxOids);
            if (dialog.open() == 0) {
                int index = this.syntaxList.indexOf(syntax);
                this.syntaxList.set(index, dialog.getSyntax());
                this.syntaxViewer.refresh();
            }
        }
    }

    public boolean performOk() {
        BinaryAttribute[] attributes = this.attributeList.toArray(new BinaryAttribute[this.attributeList.size()]);
        BrowserCorePlugin.getDefault().getCorePreferences().setBinaryAttributes(attributes);
        BinarySyntax[] syntaxes = this.syntaxList.toArray(new BinarySyntax[this.syntaxList.size()]);
        BrowserCorePlugin.getDefault().getCorePreferences().setBinarySyntaxes(syntaxes);
        return true;
    }

    protected void performDefaults() {
        this.attributeList.clear();
        this.attributeList.addAll(Arrays.asList(BrowserCorePlugin.getDefault().getCorePreferences().getDefaultBinaryAttributes()));
        this.attributeViewer.refresh();
        this.syntaxList.clear();
        this.syntaxList.addAll(Arrays.asList(BrowserCorePlugin.getDefault().getCorePreferences().getDefaultBinarySyntaxes()));
        this.syntaxViewer.refresh();
        super.performDefaults();
    }

    class SyntaxLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        SyntaxLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            if (obj instanceof BinarySyntax) {
                BinarySyntax syntax = (BinarySyntax)obj;
                if (index == 0) {
                    return syntax.getSyntaxNumericOid();
                }
                if (index == 1 && syntax.getSyntaxNumericOid() != null) {
                    if (BinaryAttributesAndSyntaxesPreferencePage.this.syntaxOid2LsdMap.containsKey(syntax.getSyntaxNumericOid())) {
                        LdapSyntax lsd = (LdapSyntax)BinaryAttributesAndSyntaxesPreferencePage.this.syntaxOid2LsdMap.get(syntax.getSyntaxNumericOid());
                        return SchemaUtils.toString((AbstractSchemaObject)lsd);
                    }
                    if (Utils.getOidDescription((String)syntax.getSyntaxNumericOid()) != null) {
                        return Utils.getOidDescription((String)syntax.getSyntaxNumericOid());
                    }
                }
            }
            return null;
        }

        public Image getColumnImage(Object obj, int index) {
            return null;
        }
    }

    class AttributeLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        AttributeLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            if (obj instanceof BinaryAttribute) {
                BinaryAttribute attribute = (BinaryAttribute)obj;
                if (index == 0) {
                    return attribute.getAttributeNumericOidOrName();
                }
                if (index == 1 && attribute.getAttributeNumericOidOrName() != null) {
                    if (BinaryAttributesAndSyntaxesPreferencePage.this.attributeNames2AtdMap.containsKey(attribute.getAttributeNumericOidOrName())) {
                        AttributeType atd = (AttributeType)BinaryAttributesAndSyntaxesPreferencePage.this.attributeNames2AtdMap.get(attribute.getAttributeNumericOidOrName());
                        String s = atd.getOid();
                        for (String attributeName : atd.getNames()) {
                            if (attribute.getAttributeNumericOidOrName().equals(attributeName)) continue;
                            s = s + ", " + attributeName;
                        }
                        return s;
                    }
                    if (BinaryAttributesAndSyntaxesPreferencePage.this.attributeOid2AtdMap.containsKey(attribute.getAttributeNumericOidOrName())) {
                        AttributeType atd = (AttributeType)BinaryAttributesAndSyntaxesPreferencePage.this.attributeOid2AtdMap.get(attribute.getAttributeNumericOidOrName());
                        return SchemaUtils.toString((AbstractSchemaObject)atd);
                    }
                    if (Utils.getOidDescription((String)attribute.getAttributeNumericOidOrName()) != null) {
                        return Utils.getOidDescription((String)attribute.getAttributeNumericOidOrName());
                    }
                }
            }
            return null;
        }

        public Image getColumnImage(Object obj, int index) {
            return null;
        }
    }
}

